/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateInstanceIdentifier;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.IdentifierIdVersionFamilyLabel;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;

class LoadLocationInstances {
    private static CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private final File instancePathFile;

    static LoadLocationInstances getInstance(OHAbsolute oracleHome, String instanceBase) {
        CfmUtil.myAssert(oracleHome != null);
        CfmUtil.myAssert(instanceBase != null);
        return LoadLocationInstances.getInstance(oracleHome + File.separator + instanceBase);
    }

    static LoadLocationInstances getInstance(String path) {
        CfmUtil.myAssert(path != null);
        File pathFile = new File(path);
        return LoadLocationInstances.getInstance(pathFile);
    }

    private static LoadLocationInstances getInstance(File path) {
        CfmUtil.myAssert(path != null);
        LoadLocationInstances newLocation = new LoadLocationInstances(path);
        return newLocation;
    }

    private LoadLocationInstances(File path) {
        this.instancePathFile = path;
    }

    String getInstancePath() {
        return this.instancePathFile.getAbsolutePath();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LoadLocationInstances)) {
            CfmUtil.myAssert(false);
            return false;
        }
        LoadLocationInstances l = (LoadLocationInstances)o;
        return this.getInstancePath().equals(l.getInstancePath());
    }

    public File getAggregateInstanceFilePath(AggregateInstanceIdentifier instanceID) {
        File possibleFile = new File(this.getInstancePath(), instanceID.toFilenameString());
        if (possibleFile.exists()) {
            return possibleFile;
        }
        cfmLogger.log(Level.FINER, "getAggregateInstanceFilePath: " + possibleFile.getAbsolutePath() + " does not exist");
        return null;
    }

    public String[] getFilenamesInInstancePath() {
        String[] filenamesInInstPath;
        try {
            filenamesInInstPath = this.instancePathFile.list();
            if (filenamesInInstPath == null) {
                cfmLogger.log(Level.INFO, "Aggregate instance path: " + this.getInstancePath() + " is not a valid directory");
                return null;
            }
        }
        catch (SecurityException e) {
            cfmLogger.log(Level.INFO, "Read access denied for aggregate instance path: " + this.getInstancePath());
            return null;
        }
        return filenamesInInstPath;
    }

    public Hashtable getAggregateInstanceFamilies(AggregateDescriptionIdentifier ident) {
        String[] filenamesInInstPath = this.getFilenamesInInstancePath();
        if (filenamesInInstPath == null) {
            return null;
        }
        Hashtable<String, Vector<Long>> familiesToLabelLists = new Hashtable<String, Vector<Long>>();
        for (int i = 0; i < filenamesInInstPath.length; ++i) {
            IdentifierIdVersionFamilyLabel result = this.createInstanceIdentifierFromFilename(this.instancePathFile, filenamesInInstPath[i]);
            if (result == null || !ident.getSelfID().equals(result.getSelfID()) || !ident.getVersion().equals(result.getVersion())) continue;
            String family = result.getFamily();
            long label = result.getLabel();
            Vector<Long> labelsInFamily = (Vector<Long>)familiesToLabelLists.get(family);
            if (labelsInFamily == null) {
                labelsInFamily = new Vector<Long>();
                familiesToLabelLists.put(family, labelsInFamily);
            }
            labelsInFamily.add(new Long(label));
        }
        Enumeration f = familiesToLabelLists.elements();
        while (f.hasMoreElements()) {
            List familyLabels = (List)f.nextElement();
            Collections.sort(familyLabels, CfmUtil.getLongComparator());
        }
        if (familiesToLabelLists.size() == 0) {
            if (Cfm.isDebug()) {
                cfmLogger.log(Level.FINER, "getAggregateInstanceFamilies: aggregate " + ident + " does not correspond to any file in " + this.getInstancePath());
            }
            return null;
        }
        if (Cfm.isDebug()) {
            cfmLogger.log(Level.FINER, "getAggregateInstanceFamilies: aggregate " + ident + " corresponds to " + familiesToLabelLists.size() + " families");
        }
        return familiesToLabelLists;
    }

    private IdentifierIdVersionFamilyLabel createInstanceIdentifierFromFilename(File dir, String fileName) {
        long labelValue;
        AggregateVersion aggVersion;
        CfmUtil.myAssert(fileName == fileName.trim());
        if (Cfm.isDebug()) {
            cfmLogger.log(Level.FINER, "createInstanceIdentifierFromFilename(dir=\"" + dir + "\", fileName=\"" + fileName + "\")");
        }
        if (!fileName.endsWith(".inst.xml")) {
            this.logRejectedFile(fileName, "File doesn't have .inst.xml extension");
            return null;
        }
        int indexBeginExtension = fileName.length() - ".inst.xml".length();
        String DELIM = ".";
        int indexBeginLabel = fileName.lastIndexOf(".", indexBeginExtension - 1);
        int indexBeginFamily = fileName.lastIndexOf(".", indexBeginLabel - 1);
        int indexBeginVersion = fileName.lastIndexOf(".", indexBeginFamily - 1);
        if (indexBeginVersion < 0) {
            this.logRejectedFile(fileName, "Not of the form: <id>.<version>.<family>.<label>.<extension>");
            return null;
        }
        String fileVersion = fileName.substring(indexBeginVersion + 1, indexBeginFamily);
        try {
            aggVersion = AggregateVersion.versionFromFilename(fileVersion);
        }
        catch (CfwException e) {
            this.logRejectedFile(fileName, "Parsed version (" + fileVersion + ") is not valid: " + e.toString());
            return null;
        }
        String fileLabel = fileName.substring(indexBeginLabel + 1, indexBeginExtension);
        try {
            labelValue = Long.parseLong(fileLabel);
        }
        catch (NumberFormatException nfe2) {
            this.logRejectedFile(fileName, "Parsed label (" + fileLabel + ") is not a valid numeric value");
            return null;
        }
        String aggID = fileName.substring(0, indexBeginVersion);
        String family = fileName.substring(indexBeginFamily + 1, indexBeginLabel);
        if (Cfm.isDebug()) {
            cfmLogger.log(Level.FINER, "Accepting as valid instance file: " + fileName);
        }
        return new IdentifierIdVersionFamilyLabel(aggID, aggVersion, family, labelValue);
    }

    private void logRejectedFile(String filename, String reason) {
        if (Cfm.isDebug()) {
            cfmLogger.log(Level.FINER, "Rejecting " + filename + ": " + reason);
        }
    }

    public List deleteAllInstances(CfwIdentifier aggregateIdentifier) throws CfwException {
        String[] filenamesInInstPath = this.getFilenamesInInstancePath();
        if (filenamesInInstPath == null) {
            throw new CfwException("Couldn't read from the specified directory: " + this.getInstancePath());
        }
        Vector<String> removedFiles = new Vector<String>();
        String selfId = aggregateIdentifier.getSelfID();
        for (int i = 0; i < filenamesInInstPath.length; ++i) {
            String currFilename = filenamesInInstPath[i];
            IdentifierIdVersionFamilyLabel result = this.createInstanceIdentifierFromFilename(this.instancePathFile, currFilename);
            if (result == null || !selfId.equals(result.getSelfID())) continue;
            File fileToRemove = new File(this.instancePathFile, currFilename);
            if (fileToRemove.delete()) {
                cfmLogger.log(Level.INFO, "Deleted " + fileToRemove.getAbsolutePath());
                removedFiles.add(fileToRemove.getAbsolutePath());
                continue;
            }
            cfmLogger.log(Level.WARNING, "Couldn't delete " + fileToRemove.getAbsolutePath());
        }
        return removedFiles;
    }

    public void ensureUsable() throws CfwException {
        this.ensureExists();
        this.ensureReadable();
        this.ensureWriteable();
    }

    public void ensureExists() throws CfwException {
        if (this.instancePathFile.exists()) {
            if (this.instancePathFile.isDirectory()) {
                return;
            }
            throw new CfwException("The instance path " + this.instancePathFile.getAbsolutePath() + " already exists, but is not a directory.");
        }
        cfmLogger.log(Level.INFO, "Aggregate instance path: " + this.getInstancePath() + " is not a valid directory");
        throw new CfwException("The instance directory " + this.instancePathFile.getAbsolutePath() + " is not a valid directory.");
    }

    public void ensureReadable() throws CfwException {
        if (!this.instancePathFile.canRead()) {
            throw new CfwException("The instance directory " + this.instancePathFile.getAbsolutePath() + " is not readable");
        }
    }

    public void ensureWriteable() throws CfwException {
        if (!this.instancePathFile.canWrite()) {
            throw new CfwException("The instance directory " + this.instancePathFile.getAbsolutePath() + " is not writeable");
        }
    }
}

