/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregateVersions;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;

class LoadLocationDescriptions {
    private static CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private final File descriptionPathFile;
    private transient Hashtable _aggregateVersionsHash = null;

    static LoadLocationDescriptions getInstance(OHAbsolute oracleHome, String descriptionsBase) {
        CfmUtil.myAssert(oracleHome != null);
        CfmUtil.myAssert(descriptionsBase != null);
        return LoadLocationDescriptions.getInstance(oracleHome + File.separator + descriptionsBase);
    }

    static LoadLocationDescriptions getInstance(String path) {
        CfmUtil.myAssert(path != null);
        File descriptionsPathFile = new File(path);
        return LoadLocationDescriptions.getInstance(descriptionsPathFile);
    }

    static LoadLocationDescriptions getInstance(File path) {
        CfmUtil.myAssert(path != null);
        LoadLocationDescriptions newLocation = new LoadLocationDescriptions(path);
        return newLocation;
    }

    private LoadLocationDescriptions(File path) {
        this.descriptionPathFile = path;
    }

    String getDescriptionsPath() {
        return this.descriptionPathFile.getAbsolutePath();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LoadLocationDescriptions)) {
            CfmUtil.myAssert(false);
            return false;
        }
        LoadLocationDescriptions l = (LoadLocationDescriptions)o;
        return this.getDescriptionsPath().equals(l.getDescriptionsPath());
    }

    public String getAggregateDescriptionFile(AggregateDescriptionIdentifier aggIdent) {
        CfmUtil.myAssert(aggIdent.getVersion() != AggregateVersion.LATEST);
        File possibleFile = new File(this.getDescriptionsPath(), aggIdent.getFilename());
        if (possibleFile.exists()) {
            return CfmUtil.getCanonicalOrAbsolute(possibleFile, cfmLogger);
        }
        cfmLogger.log(Level.FINER, "getAggregateDescriptionFile: " + possibleFile.getAbsolutePath() + " does not exist");
        return null;
    }

    public AggregateDescriptionIdentifier getAggregateDescriptionsPrevious(AggregateDescriptionIdentifier ident) throws CfwException {
        AggregateVersion prevVersion = this.getAggregateDescriptionsVersionPrevious(ident);
        if (prevVersion == null) {
            return null;
        }
        return new AggregateDescriptionIdentifier(ident.getSelfID(), prevVersion, ident.getNamespace());
    }

    public AggregateVersion getAggregateDescriptionsVersionPrevious(AggregateDescriptionIdentifier ident) throws CfwException {
        String aggId = ident.getSelfID();
        CfmAggregateVersions versions = (CfmAggregateVersions)this.getAggregateVersionsHash().get(aggId);
        if (versions == null) {
            return null;
        }
        AggregateVersion previousVersion = versions.getPrevious(ident.getVersion());
        return previousVersion;
    }

    private Hashtable getAggregateVersionsHash() throws CfwException {
        if (this._aggregateVersionsHash == null) {
            this.inventoryDescriptions();
        }
        return this._aggregateVersionsHash;
    }

    void invalidateInventory() {
        this._aggregateVersionsHash = null;
    }

    private void inventoryDescriptions() throws CfwException {
        String[] filenamesInDescPath;
        if (this._aggregateVersionsHash != null) {
            return;
        }
        this._aggregateVersionsHash = new Hashtable();
        try {
            filenamesInDescPath = this.descriptionPathFile.list();
            if (filenamesInDescPath == null) {
                throw new CfwException("Aggregate description path: " + this.getDescriptionsPath() + " is not a valid directory");
            }
        }
        catch (SecurityException e) {
            throw new CfwException("Read access denied for aggregate description path: " + this.getDescriptionsPath(), e);
        }
        for (int i = 0; i < filenamesInDescPath.length; ++i) {
            AggregateDescriptionIdentifier descIdent = this.createDescriptionIdentifierFromFilename(this.descriptionPathFile, filenamesInDescPath[i]);
            if (descIdent == null) continue;
            String aggId = descIdent.getSelfID();
            CfmAggregateVersions versions = (CfmAggregateVersions)this._aggregateVersionsHash.get(aggId);
            if (versions == null) {
                versions = new CfmAggregateVersions();
                this._aggregateVersionsHash.put(aggId, versions);
            }
            versions.add(descIdent.getVersion());
        }
    }

    private AggregateDescriptionIdentifier createDescriptionIdentifierFromFilename(File dir, String fileName) {
        AggregateVersion aggVersion;
        CfmUtil.myAssert(fileName == fileName.trim());
        if (Cfm.isDebug()) {
            cfmLogger.log(Level.FINER, "createDescriptionIdentifierFromFilename(dir=\"" + dir + "\", fileName=\"" + fileName + "\")");
        }
        if (!fileName.endsWith(".xml")) {
            this.logRejectedFile(fileName, "File doesn't have .xml extension");
            return null;
        }
        int indexBeginExtension = fileName.length() - ".xml".length();
        String DELIM = ".";
        int indexBeginVersion = fileName.lastIndexOf(".", indexBeginExtension - 1);
        if (indexBeginVersion < 0) {
            this.logRejectedFile(fileName, "Not of the form: <id>.<version>.<extension>");
            return null;
        }
        String fileVersion = fileName.substring(indexBeginVersion + 1, indexBeginExtension);
        try {
            aggVersion = AggregateVersion.versionFromFilename(fileVersion);
        }
        catch (CfwException e) {
            this.logRejectedFile(fileName, "Parsed version (" + fileVersion + ") is not valid: " + e.getMessage());
            return null;
        }
        String aggID = fileName.substring(0, indexBeginVersion);
        if (Cfm.isDebug()) {
            cfmLogger.log(Level.FINER, "Accepting as valid description file: " + fileName);
        }
        return new AggregateDescriptionIdentifier(aggID, aggVersion, "common");
    }

    AggregateDescriptionIdentifier getAggregateDescriptionLatestIdentifier(CfwIdentifier ident) {
        AggregateVersion version = this.getAggregateDescriptionLatestVersion(ident.getSelfID());
        if (version == null) {
            return null;
        }
        return new AggregateDescriptionIdentifier(ident.getSelfID(), version, ident.getNamespace());
    }

    private AggregateVersion getAggregateDescriptionLatestVersion(String aggregateID) {
        CfmAggregateVersions versionList;
        if (aggregateID == null) {
            cfmLogger.log(Level.FINER, "getAggregateDescriptionsFileNameLatest: invalid aggregateID (it was null)");
            return null;
        }
        if ((aggregateID = aggregateID.trim()).length() == 0) {
            cfmLogger.log(Level.FINER, "getAggregateDescriptionsFileNameLatest: invalid aggregateID (it was empty)");
            return null;
        }
        try {
            versionList = (CfmAggregateVersions)this.getAggregateVersionsHash().get(aggregateID);
        }
        catch (CfwException e) {
            cfmLogger.log(Level.WARNING, "Unable to inventory " + this.getDescriptionsPath() + ": " + e);
            return null;
        }
        if (versionList == null) {
            cfmLogger.log(Level.INFO, "No description found in " + this.getDescriptionsPath() + " for aggregate=" + aggregateID);
            return null;
        }
        return versionList.getLatest();
    }

    private void logRejectedFile(String filename, String reason) {
        if (Cfm.isDebug()) {
            cfmLogger.log(Level.FINER, "Rejecting " + filename + ": " + reason);
        }
    }
}

