/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.LoadLocationDescriptions;
import oracle.sysman.emCfg.core.LoadLocationInstances;
import oracle.sysman.emCfg.core.LoadLocationTag;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;

class LoadLocation {
    private final LoadLocationTag tag;
    private final LoadLocationDescriptions loadLocationDescriptions;
    private final LoadLocationInstances loadLocationInstances;

    static LoadLocation getInstance(String oracleHome, String descriptionsBase, String instanceBase, CfmLogger logger) {
        CfmUtil.myAssert(oracleHome != null);
        CfmUtil.myAssert(descriptionsBase != null);
        CfmUtil.myAssert(instanceBase != null);
        OHAbsolute oracleHomeAbs = new OHAbsolute(oracleHome, logger);
        LoadLocationDescriptions desc = LoadLocationDescriptions.getInstance(oracleHomeAbs, descriptionsBase);
        LoadLocationInstances inst = LoadLocationInstances.getInstance(oracleHomeAbs, instanceBase);
        LoadLocationTag tag = new LoadLocationTag(oracleHomeAbs, descriptionsBase, instanceBase);
        return new LoadLocation(desc, inst, tag);
    }

    private LoadLocation(LoadLocationDescriptions desc, LoadLocationInstances inst, LoadLocationTag tag) {
        this.loadLocationDescriptions = desc;
        this.loadLocationInstances = inst;
        this.tag = tag;
    }

    OHAbsolute getOracleHome() {
        return this.tag.oracleHome;
    }

    String getDescriptionsBase() {
        return this.tag.descriptionsBase;
    }

    String getInstanceBase() {
        return this.tag.instanceBase;
    }

    LoadLocationDescriptions getDescriptionsLoadLocation() {
        return this.loadLocationDescriptions;
    }

    LoadLocationInstances getInstancesLoadLocation() {
        return this.loadLocationInstances;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LoadLocation)) {
            throw new Error("Invalid object in equals of LoadLocation!");
        }
        LoadLocation l = (LoadLocation)o;
        if (!this.getDescriptionsLoadLocation().equals(l.getDescriptionsLoadLocation())) {
            return false;
        }
        return this.getInstancesLoadLocation().equals(l.getInstancesLoadLocation());
    }
}

