/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmActionState;
import oracle.sysman.emCfg.core.CfmActionStepState;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamily;
import oracle.sysman.emCfg.core.CfmAggregateRefState;
import oracle.sysman.emCfg.core.CfmAggregateState;
import oracle.sysman.emCfg.core.CfmConditionState;
import oracle.sysman.emCfg.core.CfmMicroStepState;
import oracle.sysman.emCfg.core.CfmObjectState;
import oracle.sysman.emCfg.core.CfmParameterState;
import oracle.sysman.emCfg.core.CfmPlugInState;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.instance.ActionInvocationT;
import oracle.sysman.emCfg.schema.instance.ActionStepT;
import oracle.sysman.emCfg.schema.instance.ActionT;
import oracle.sysman.emCfg.schema.instance.AggregateActionInvocationT;
import oracle.sysman.emCfg.schema.instance.AggregateInstanceT;
import oracle.sysman.emCfg.schema.instance.AggregateRefT;
import oracle.sysman.emCfg.schema.instance.AggregateT;
import oracle.sysman.emCfg.schema.instance.ConditionT;
import oracle.sysman.emCfg.schema.instance.ExternalJavaInvocationT;
import oracle.sysman.emCfg.schema.instance.ExternalProgramInvocationT;
import oracle.sysman.emCfg.schema.instance.InternalInvocationT;
import oracle.sysman.emCfg.schema.instance.ParameterT;
import oracle.sysman.emCfg.schema.instance.PlugInT;
import oracle.sysman.emCfg.support.CfmUtil;

class InstanceLoader
implements Serializable {
    private static final CfmLogger cfmLogger = Cfm.getLogger();
    private final Cfm cfm;
    private boolean debugB = Cfm.isDebug();
    transient OutputStream output;
    transient Marshaller m;
    private String currentActionID;
    private long currentStepIndex = -1L;
    private int currentMicroStepIndex = -1;
    private CfmAggregateInstance currentAggregateInstance;

    InstanceLoader(Cfm cfm) {
        this.cfm = cfm;
        this.debugB = cfm.isDebug();
        if (this.debugB) {
            this.output = System.out;
        }
    }

    void setMarshaller(Marshaller m) {
        this.m = m;
    }

    private void setCurrentActionID(String actionID) {
        this.currentActionID = actionID;
    }

    private String getCurrentActionID() {
        return this.currentActionID;
    }

    private void setCurrentStepIndex(long stepIndex) {
        this.currentStepIndex = stepIndex;
        this.currentMicroStepIndex = 0;
    }

    private long getCurrentStepIndex() {
        CfmUtil.myAssert(this.currentStepIndex >= 0L);
        return this.currentStepIndex;
    }

    private int nextMicroStepIndex() {
        int result = this.currentMicroStepIndex;
        CfmUtil.myAssert(result >= 0);
        ++this.currentMicroStepIndex;
        return result;
    }

    private void setCurrentAggregateInstance(CfmAggregateInstance aggregateInstance) {
        this.currentAggregateInstance = aggregateInstance;
    }

    private CfmAggregateInstance getCurrentAggregateInstance() {
        return this.currentAggregateInstance;
    }

    CfmAggregateInstance createAggregateInstance(LoadLocation descriptionFrom, CfmAggregateInstanceFamily aggregateInstanceFamily, String fileName, Object obj) throws CfwException {
        List aggRefList;
        List actionList;
        List conditionList;
        List paramterList;
        if (obj == null) {
            throw new CfwException("InstanceLoader.createAggregateInstance: invalid (null) obj");
        }
        if (!(obj instanceof AggregateInstanceT)) {
            return null;
        }
        AggregateInstanceT aggregateInstanceT = (AggregateInstanceT)obj;
        long label = aggregateInstanceT.getLabel();
        long timestamp = aggregateInstanceT.getTimestamp();
        CfmAggregateInstance aggregateInstance = new CfmAggregateInstance(descriptionFrom, aggregateInstanceFamily, label, fileName, timestamp);
        this.setCurrentAggregateInstance(aggregateInstance);
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createAggregateInstance: AggregateInstance is instantiated");
        }
        this.createAggregateState(aggregateInstanceT.getAggregate());
        List plugInList = aggregateInstanceT.getPlugIn();
        if (plugInList != null) {
            for (Object o : plugInList) {
                this.inspectAndAdd(aggregateInstance, "AggregateInstance", o, "some PlugInState");
            }
        }
        if ((paramterList = aggregateInstanceT.getParameter()) != null) {
            for (Object o : paramterList) {
                this.inspectAndAdd(aggregateInstance, "AggregateInstance", o, "some ParameterState");
            }
        }
        if ((conditionList = aggregateInstanceT.getCondition()) != null) {
            for (Object o : conditionList) {
                this.inspectAndAdd(aggregateInstance, "AggregateInstance", o, "some ConditionState");
            }
        }
        if ((actionList = aggregateInstanceT.getAction()) != null) {
            for (Object o : actionList) {
                this.inspectAndAdd(aggregateInstance, "AggregateInstance", o, "some ActionState");
            }
        }
        if ((aggRefList = aggregateInstanceT.getAggregateRef()) != null) {
            for (Object o : aggRefList) {
                this.inspectAndAdd(aggregateInstance, "AggregateInstance", o, "some AggregateRefState");
            }
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createAggregateInstance: Done with " + aggregateInstance);
        }
        return aggregateInstance;
    }

    private void createAggregateState(AggregateT aggregateT) throws CfwException {
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createAggregateState:");
        }
        if (aggregateT == null) {
            throw new CfwException("InstanceLoader.createAggregateState: invalid (null) obj");
        }
        new CfmAggregateState(this.getCurrentAggregateInstance(), aggregateT);
    }

    private CfmObjectState createPlugInState(Object obj) throws CfwException {
        if (!(obj instanceof PlugInT)) {
            return null;
        }
        PlugInT plugInT = (PlugInT)obj;
        String selfID = plugInT.getId();
        CfmPlugInState plugInState = new CfmPlugInState(this.getCurrentAggregateInstance(), plugInT, selfID);
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createParameterState: Done with " + plugInState);
        }
        return plugInState;
    }

    private CfmObjectState createParameterState(Object obj) throws CfwException {
        if (!(obj instanceof ParameterT)) {
            return null;
        }
        ParameterT parameterT = (ParameterT)obj;
        CfmParameterState parameterState = new CfmParameterState(this.getCurrentAggregateInstance(), parameterT);
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createParameterState: Done with " + parameterState);
        }
        return parameterState;
    }

    private CfmObjectState createConditionState(Object obj) throws CfwException {
        if (!(obj instanceof ConditionT)) {
            return null;
        }
        ConditionT conditionT = (ConditionT)obj;
        String selfID = conditionT.getId();
        CfmConditionState conditionState = new CfmConditionState(this.getCurrentAggregateInstance(), conditionT, selfID);
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createConditionState: ConditionState is instantiated");
            cfmLogger.log(Level.INFO, "InstanceLoader.createConditionState: Done with " + conditionState);
        }
        return conditionState;
    }

    private CfmObjectState createActionState(Object obj) throws CfwException {
        List actionStepList;
        if (!(obj instanceof ActionT)) {
            return null;
        }
        ActionT actionT = (ActionT)obj;
        String selfID = actionT.getId();
        this.setCurrentActionID(selfID);
        CfmActionState actionState = new CfmActionState(this.getCurrentAggregateInstance(), actionT, this.getCurrentActionID());
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createActionState: ActionState is instantiated");
        }
        if ((actionStepList = actionT.getActionStep()) != null) {
            int order = 0;
            for (Object o : actionStepList) {
                CfmObjectState actionStepState;
                if (o == null) continue;
                if (this.debugB) {
                    cfmLogger.log(Level.INFO, "InstanceLoader.createActionState: about to inspect ActionStepState...");
                }
                if ((actionStepState = this.inspect(o)) == null) continue;
                ((CfmActionStepState)actionStepState).setOrder(order++);
                if (!this.debugB) continue;
                cfmLogger.log(Level.INFO, "InstanceLoader.createActionState: " + actionStepState.getClass().getName() + " is added to AggregateInstance");
            }
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createActionState: Done with " + actionState);
        }
        return actionState;
    }

    private CfmObjectState createActionStepState(Object obj) throws CfwException {
        List list;
        if (!(obj instanceof ActionStepT)) {
            return null;
        }
        ActionStepT actionStepT = (ActionStepT)obj;
        long selfIndex = actionStepT.getIndex();
        this.setCurrentStepIndex(selfIndex);
        CfmActionStepState actionStepState = new CfmActionStepState(this.getCurrentAggregateInstance(), actionStepT, this.getCurrentStepIndex(), this.getCurrentActionID());
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createActionStepState: ActionStepState is instantiated");
        }
        if ((list = actionStepT.getExternalJavaInvocationOrExternalProgramInvocationOrInternalInvocation()) != null) {
            int order = 0;
            for (Object o : list) {
                CfmObjectState microStepState;
                if (o == null) continue;
                if (this.debugB) {
                    cfmLogger.log(Level.INFO, "InstanceLoader.createActionStepState: about to inspect MicroStepState...");
                }
                if ((microStepState = this.inspect(o)) == null) continue;
                ((CfmMicroStepState)microStepState).setOrder(order++);
                if (!this.debugB) continue;
                cfmLogger.log(Level.INFO, "InstanceLoader.createActionState: " + microStepState.getClass().getName() + " is added to AggregateInstance");
            }
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createActionStepState: Done with " + actionStepState);
        }
        return actionStepState;
    }

    private CfmObjectState createMicroStepState(Object obj) throws CfwException {
        if (obj instanceof ExternalJavaInvocationT || obj instanceof ExternalProgramInvocationT || obj instanceof InternalInvocationT || obj instanceof ActionInvocationT || obj instanceof AggregateActionInvocationT) {
            return CfmMicroStepState.newCfmMicroStepState(this.getCurrentAggregateInstance(), obj, this.getCurrentActionID(), this.getCurrentStepIndex(), this.nextMicroStepIndex());
        }
        return null;
    }

    private CfmObjectState createAggregateRefState(Object obj) throws CfwException {
        if (!(obj instanceof AggregateRefT)) {
            return null;
        }
        AggregateRefT aggregateRefT = (AggregateRefT)obj;
        CfmAggregateRefState aggregateRefState = new CfmAggregateRefState(this.cfm, this.getCurrentAggregateInstance(), aggregateRefT);
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.createAggregateRefState: AggregateRefState is instantiated");
            cfmLogger.log(Level.INFO, "InstanceLoader.createAggregateRefState: Done with " + aggregateRefState);
        }
        return aggregateRefState;
    }

    CfmObjectState inspect(Object obj) throws CfwException {
        if (obj == null) {
            if (this.debugB) {
                cfmLogger.log(Level.INFO, "InstanceLoader.inspect: null object");
            }
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "InstanceLoader.inspect: object of  = " + obj.getClass().getName());
            try {
                this.m.marshal(obj, this.output);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            cfmLogger.log(Level.INFO, "");
        }
        CfmObjectState o = null;
        o = this.createPlugInState(obj);
        if (o != null) {
            return o;
        }
        o = this.createParameterState(obj);
        if (o != null) {
            return o;
        }
        o = this.createConditionState(obj);
        if (o != null) {
            return o;
        }
        o = this.createActionState(obj);
        if (o != null) {
            return o;
        }
        o = this.createActionStepState(obj);
        if (o != null) {
            return o;
        }
        o = this.createMicroStepState(obj);
        if (o != null) {
            return o;
        }
        o = this.createAggregateRefState(obj);
        if (o != null) {
            return o;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "\n +++ InstanceLoader.inspect: object of " + obj.getClass().getName() + " class is not implemented yet");
        }
        return null;
    }

    void inspectAndAdd(CfmAggregateInstance owner, String ownerType, Object obj, String objType) throws CfwException {
        if (obj != null) {
            CfmObjectState o;
            if (this.debugB) {
                cfmLogger.log(Level.INFO, "InstanceLoader.inspectAndAdd: about to inspect " + objType + "...");
            }
            if ((o = this.inspect(obj)) != null && this.debugB) {
                cfmLogger.log(Level.INFO, "InstanceLoader.inspectAndAdd: " + o.getClass().getName() + " is added to " + ownerType);
            }
        }
    }
}

