/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.support.CfmUtil;

class IdentifierIdNsLocation {
    private final String selfID;
    private final String namespace;
    private final OHAbsolute location;

    public IdentifierIdNsLocation(String aggID, String namespace, OHAbsolute location) {
        this.selfID = aggID;
        this.namespace = namespace != null ? namespace : "common";
        this.location = location;
    }

    public IdentifierIdNsLocation(AggregateDescriptionIdentifierWithLocation identifier) {
        this(identifier.getSelfID(), identifier.getNamespace(), identifier.getOH());
    }

    public IdentifierIdNsLocation(CfwIdentifier identifier, OHAbsolute location) {
        this(identifier.getSelfID(), identifier.getNamespace(), location);
    }

    public String getSelfID() {
        return this.selfID;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public OHAbsolute getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        IdentifierIdNsLocation rhs = (IdentifierIdNsLocation)o;
        return CfmUtil.nullOrEqual(this.getSelfID(), rhs.getSelfID()) && this.getNamespace().equals(rhs.getNamespace()) && CfmUtil.nullOrEqual(this.getLocation(), rhs.getLocation());
    }

    public int hashCode() {
        int result = CfmUtil.hashCode(this.getSelfID());
        result = 31 * result + this.getNamespace().hashCode();
        result = 31 * result + CfmUtil.hashCode(this.getLocation());
        return result;
    }

    public String toString() {
        return this.getLocation() + ":" + this.getNamespace() + ":" + this.getSelfID();
    }

    public AggregateDescriptionIdentifierWithLocation asAggregateDescriptionIdentifierWithLocation(AggregateVersion version) {
        return new AggregateDescriptionIdentifierWithLocation(this.getSelfID(), version, this.getNamespace(), this.getLocation());
    }
}

