/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAction;
import oracle.sysman.emCfg.core.CfmActionRef;
import oracle.sysman.emCfg.core.CfmActionStep;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateDescription;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmCondition;
import oracle.sysman.emCfg.core.CfmConditionRef;
import oracle.sysman.emCfg.core.CfmDescriptions;
import oracle.sysman.emCfg.core.CfmExternalPlugInModel;
import oracle.sysman.emCfg.core.CfmInternalPlugInModel;
import oracle.sysman.emCfg.core.CfmMicroStep;
import oracle.sysman.emCfg.core.CfmOwnedAggregateActionRef;
import oracle.sysman.emCfg.core.CfmOwnedParameterModelRef;
import oracle.sysman.emCfg.core.CfmParamArray;
import oracle.sysman.emCfg.core.CfmParamComplex;
import oracle.sysman.emCfg.core.CfmParamModel;
import oracle.sysman.emCfg.core.CfmParamModelArray;
import oracle.sysman.emCfg.core.CfmParamModelComplex;
import oracle.sysman.emCfg.core.CfmParamModelSimple;
import oracle.sysman.emCfg.core.CfmParamModelSimpleArray;
import oracle.sysman.emCfg.core.CfmParamModelSimplest;
import oracle.sysman.emCfg.core.CfmParamModelSimplestArray;
import oracle.sysman.emCfg.core.CfmParamSimple;
import oracle.sysman.emCfg.core.CfmParamSimpleArray;
import oracle.sysman.emCfg.core.CfmParamSimplest;
import oracle.sysman.emCfg.core.CfmParamSimplestArray;
import oracle.sysman.emCfg.core.CfmParamValueDataType;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParameterModelRef;
import oracle.sysman.emCfg.core.CfmParentObject;
import oracle.sysman.emCfg.core.CfmPlugIn;
import oracle.sysman.emCfg.core.CfmPlugInInvocation;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.CfmTaggedObjectFactory;
import oracle.sysman.emCfg.core.CfmVirtualParameter;
import oracle.sysman.emCfg.core.CfmWrapper;
import oracle.sysman.emCfg.core.CfwOwnerWithLocation;
import oracle.sysman.emCfg.core.ICfmWrapper;
import oracle.sysman.emCfg.core.IParameterType;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.core.Resolver;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.descriptions.Action;
import oracle.sysman.emCfg.schema.descriptions.ActionRefT;
import oracle.sysman.emCfg.schema.descriptions.ActionStepT;
import oracle.sysman.emCfg.schema.descriptions.AggregateActionRefT;
import oracle.sysman.emCfg.schema.descriptions.AggregateRefT;
import oracle.sysman.emCfg.schema.descriptions.ArrayAggregateT;
import oracle.sysman.emCfg.schema.descriptions.ArrayParamModelT;
import oracle.sysman.emCfg.schema.descriptions.ArrayParamT;
import oracle.sysman.emCfg.schema.descriptions.ComplexAggregateT;
import oracle.sysman.emCfg.schema.descriptions.ComplexParamModelT;
import oracle.sysman.emCfg.schema.descriptions.ComplexParamT;
import oracle.sysman.emCfg.schema.descriptions.ConditionRefT;
import oracle.sysman.emCfg.schema.descriptions.ConditionT;
import oracle.sysman.emCfg.schema.descriptions.DescriptionsT;
import oracle.sysman.emCfg.schema.descriptions.ExternalPlugInModel;
import oracle.sysman.emCfg.schema.descriptions.InternalPlugInModel;
import oracle.sysman.emCfg.schema.descriptions.ParamValueDataTypeT;
import oracle.sysman.emCfg.schema.descriptions.ParameterModelRefT;
import oracle.sysman.emCfg.schema.descriptions.ParameterT;
import oracle.sysman.emCfg.schema.descriptions.PlugInInvocationT;
import oracle.sysman.emCfg.schema.descriptions.PlugInT;
import oracle.sysman.emCfg.schema.descriptions.SimpleAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimpleArrayAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimpleArrayParamModelT;
import oracle.sysman.emCfg.schema.descriptions.SimpleArrayParamT;
import oracle.sysman.emCfg.schema.descriptions.SimpleParamModelT;
import oracle.sysman.emCfg.schema.descriptions.SimpleParamT;
import oracle.sysman.emCfg.schema.descriptions.SimplestAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimplestArrayAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimplestArrayParamModelT;
import oracle.sysman.emCfg.schema.descriptions.SimplestArrayParamT;
import oracle.sysman.emCfg.schema.descriptions.SimplestParamModelT;
import oracle.sysman.emCfg.schema.descriptions.SimplestParamT;
import oracle.sysman.emCfg.schema.descriptions.VirtualParameterT;
import oracle.sysman.emCfg.support.CfmUtil;

class DescriptionsLoader
implements Serializable {
    private boolean debugB = Cfm.isDebug();
    private static final CfmLogger cfmLogger = Cfm.getLogger();
    private final CfmTaggedObjectFactory cfmTaggedObjectFactory;
    private final Cfm cfm;
    private transient OutputStream output;
    private transient Marshaller m;
    private boolean newAggregateFound = false;
    private String currentlyLoadingFrom;
    private LoadLocation currentLoadLocation;
    private CfmAggregate currentAggregate = null;
    private Stack owners = new Stack();
    private static final String[] supportedVersions = new String[]{"1.0.0", "1.0"};

    DescriptionsLoader(Cfm cfm, CfmTaggedObjectFactory cfmTaggedObjectFactory) {
        this.cfm = cfm;
        this.debugB = cfm.isDebug();
        if (this.debugB) {
            this.output = System.out;
        }
        this.cfmTaggedObjectFactory = cfmTaggedObjectFactory;
    }

    public Cfm getCfm() {
        return this.cfm;
    }

    public CfmTaggedObjectFactory getObjectFactory() {
        return this.cfmTaggedObjectFactory;
    }

    void setMarshaller(Marshaller m) {
        this.m = m;
    }

    public void startLoadingPass() {
        this.newAggregateFound = false;
    }

    public boolean isNewAggregateFound() {
        return this.newAggregateFound;
    }

    String getCurrentOwnerID() {
        if (this.getCurrentAggregate() == null) {
            return null;
        }
        return this.getCurrentAggregate().getSelfID();
    }

    CfmAggregate getCurrentAggregate() {
        return this.currentAggregate;
    }

    private void setCurrentAggregate(CfmAggregate currAgg) {
        this.currentAggregate = currAgg;
        this.beginOwner(currAgg);
    }

    private void unsetCurrentAggregate() {
        this.currentAggregate = null;
        this.endOwner();
    }

    AggregateVersion getCurrentVersion() {
        return this.getCurrentOwner().getVersion();
    }

    String getCurrentNS() {
        return this.getCurrentOwner().getNamespace();
    }

    String getCurrentFileLocation() {
        return this.currentlyLoadingFrom;
    }

    LoadLocation getCurrentLoadLocation() {
        return this.currentLoadLocation;
    }

    private CfmParentObject getCurrentOwner() {
        return (CfmParentObject)this.owners.peek();
    }

    private void beginOwner(CfmParentObject newOwner) {
        this.owners.push(newOwner);
    }

    private void endOwner() {
        this.owners.pop();
    }

    CfmDescriptions createDescriptions(DescriptionsT descriptionsT, String locationLoadedFrom, LoadLocation currentLoadLocation) throws CfwException {
        this.currentlyLoadingFrom = locationLoadedFrom;
        this.currentLoadLocation = currentLoadLocation;
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createDescriptions: Descriptions:");
        }
        CfmDescriptions cfmDescriptions = CfmDescriptions.getInstance(this, descriptionsT);
        this.beginOwner(cfmDescriptions);
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createDescriptions: Descriptions is instantiated");
        }
        List paramModelList = descriptionsT.getSimplestParamModelOrSimplestArrayParamModelOrSimpleParamModel();
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createDescriptions: ParamModel list size = " + paramModelList.size());
        }
        if (paramModelList != null) {
            for (Object paramModelObj : paramModelList) {
                if (paramModelObj != null) {
                    ICfmWrapper o = this.inspect(paramModelObj);
                    if (o == null) continue;
                    cfmDescriptions.addParameterModel(o);
                    continue;
                }
                CfmUtil.myAssert(false);
            }
        }
        List aggregateList = descriptionsT.getSimplestAggregateOrSimplestArrayAggregateOrSimpleAggregate();
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createDescriptions: Aggregates list size = " + aggregateList.size());
        }
        if (aggregateList != null) {
            for (Object aggregateObj : aggregateList) {
                this.addAndInspect(cfmDescriptions, "Descriptions", aggregateObj, "some Aggregate");
            }
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createDescriptions: Done with " + cfmDescriptions);
        }
        this.endOwner();
        return cfmDescriptions;
    }

    void createAggregateDescriptions() throws CfwException {
        for (CfmDescriptions aggregateDescriptions : this.cfmTaggedObjectFactory.getDescriptions()) {
            for (CfmAggregate aggregate : aggregateDescriptions.getAggregates()) {
                CfmUtil.myAssert(aggregateDescriptions.getVersion().equals(aggregate.getVersion()));
                CfmUtil.myAssert(aggregateDescriptions.getNS().equals(aggregate.getNamespace()));
                CfmAggregateDescription aggregateDescription = new CfmAggregateDescription(this.cfm, aggregate);
                Iterator aggregateIterator = aggregate.memberIterator();
                while (aggregateIterator.hasNext()) {
                    Object aggregateMember = aggregateIterator.next();
                    if (aggregateMember instanceof CfmAggregateRef) {
                        CfmAggregateRef reference = (CfmAggregateRef)aggregateMember;
                        aggregateDescription.addAggregateRef(reference);
                        continue;
                    }
                    if (aggregateMember instanceof CfmParameter) {
                        CfmParameter cfmParameter = (CfmParameter)aggregateMember;
                        aggregateDescription.addMember(cfmParameter);
                        continue;
                    }
                    if (aggregateMember instanceof CfmCondition) {
                        CfmCondition cfmCondition = (CfmCondition)aggregateMember;
                        aggregateDescription.addMember(cfmCondition);
                        continue;
                    }
                    if (aggregateMember instanceof CfmAction) {
                        CfmAction cfmAction = (CfmAction)aggregateMember;
                        aggregateDescription.addMember(cfmAction);
                        continue;
                    }
                    if (aggregateMember instanceof CfmPlugIn) {
                        CfmPlugIn cfmPlugIn = (CfmPlugIn)aggregateMember;
                        aggregateDescription.addMember(cfmPlugIn);
                        continue;
                    }
                    if (!this.debugB) continue;
                    cfmLogger.log(Level.INFO, "DescriptionsLoader.createAggregateDescriptions: skipping " + aggregateMember.toString());
                }
            }
        }
    }

    ICfmWrapper inspect(Object obj) throws CfwException {
        if (obj == null) {
            if (this.debugB) {
                cfmLogger.log(Level.INFO, "DescriptionsLoader.inspect: null object");
            }
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.inspect: object of  = " + obj.getClass().getName());
            try {
                this.m.marshal(obj, this.output);
            }
            catch (JAXBException e) {
                CfmUtil.myAssert(false);
            }
            cfmLogger.log(Level.INFO, "");
        }
        CfmUtil.myAssert(!(obj instanceof DescriptionsT));
        ICfmWrapper result = this.createParam(obj);
        if (result != null) {
            return result;
        }
        result = this.createParameter(obj);
        if (result != null) {
            return result;
        }
        result = this.createVirtualParameter(obj);
        if (result != null) {
            return result;
        }
        result = this.createParamValueDataType(obj);
        if (result != null) {
            return result;
        }
        result = this.createAction(obj);
        if (result != null) {
            return result;
        }
        result = this.createCondition(obj);
        if (result != null) {
            return result;
        }
        result = this.createInternalPlugInModel(obj);
        if (result != null) {
            return result;
        }
        result = this.createExternalPlugInModel(obj);
        if (result != null) {
            return result;
        }
        result = this.createPlugIn(obj);
        if (result != null) {
            return result;
        }
        result = this.createParamModel(obj);
        if (result != null) {
            return result;
        }
        result = this.createAggregates(obj);
        if (result != null) {
            return result;
        }
        if (this.debugB) {
            cfmLogger.log(Level.WARNING, "\n +++ DescriptionsLoader.inspect: object of " + obj.getClass().getName() + " class is not implemented yet");
        }
        return null;
    }

    void addAndInspect(CfmParentObject owner, Object obj) throws CfwException {
        ICfmWrapper o;
        if (obj != null && (o = this.inspect(obj)) != null) {
            owner.addMember(o);
        }
    }

    IParameterType newParameterModelRef(ParameterModelRefT parameterModelRefT) throws CfwException {
        CfmWrapper refAsParameterType;
        String rawOwnerRef = parameterModelRefT.getOwner();
        boolean impliedOwner = rawOwnerRef == null;
        String ownerRef = CfmUtil.noNull(rawOwnerRef, this.getCurrentOwnerID());
        String nsRef = CfmUtil.noNull(parameterModelRefT.getNs(), this.getCurrentNS());
        CfwIdentifier ownerAggRef = new CfwIdentifier(ownerRef, nsRef);
        if (this.getCurrentAggregate() != null) {
            refAsParameterType = new CfmOwnedParameterModelRef(this, parameterModelRefT, ownerAggRef, this.getCurrentAggregate(), impliedOwner);
        } else {
            CfmParameterModelRef ref = new CfmParameterModelRef(this, parameterModelRefT.getIdref(), new CfwOwnerWithLocation(ownerRef, this.getCurrentVersion(), nsRef, this.getCurrentLoadLocation().getOracleHome()), impliedOwner);
            this.cfm.getDescriptionResolver().addUnresolved(ref);
            refAsParameterType = ref;
        }
        return refAsParameterType;
    }

    private ICfmWrapper createAction(Object obj) throws CfwException {
        if (!(obj instanceof Action)) {
            return null;
        }
        Action actionT = (Action)obj;
        CfmAction action = new CfmAction(this, actionT, this.getCurrentAggregate());
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createAction: Action is instantiated");
        }
        Vector<CfmActionStep> actionSteps = new Vector<CfmActionStep>();
        List actionStepList = actionT.getActionStep();
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createAction: ActionStep list size = " + actionStepList.size());
        }
        int actionStepIndex = 0;
        for (Object s : actionStepList) {
            if (!(s instanceof ActionStepT)) continue;
            ActionStepT actionStepT = (ActionStepT)s;
            CfmActionStep actionStep = new CfmActionStep(this, action, actionStepT, actionStepIndex++);
            ConditionRefT stepConditionRefT = actionStepT.getConditionRef();
            if (stepConditionRefT != null) {
                CfmConditionRef stepConditionRef = CfmConditionRef.getInstance(this, stepConditionRefT, this.getCurrentAggregate());
                actionStep.setConditionRef(stepConditionRef);
                this.cfm.getDescriptionResolver().addUnresolved(stepConditionRef);
            }
            Vector<CfmMicroStep> microSteps = new Vector<CfmMicroStep>();
            List microStepList = actionStepT.getAggregateActionRefOrPlugInInvocationOrActionRef();
            if (this.debugB) {
                cfmLogger.log(Level.INFO, "DescriptionsLoader.createAction: ActionStep list size = " + microStepList.size());
            }
            int microStepIndex = 0;
            for (Object p : microStepList) {
                CfmMicroStep microStep;
                if (p instanceof PlugInInvocationT) {
                    PlugInInvocationT plugInInvocationT = (PlugInInvocationT)p;
                    CfmPlugInInvocation plugInInvocation = new CfmPlugInInvocation(this, plugInInvocationT, actionStep, this.getCurrentAggregate());
                    microStep = new CfmMicroStep(this, actionStep, plugInInvocation, microStepIndex++);
                } else if (p instanceof ActionRefT) {
                    ActionRefT actionRefT = (ActionRefT)p;
                    CfmActionRef actionRef = new CfmActionRef(this, actionRefT, (CfmTaggedObject)this.getCurrentOwner());
                    this.cfm.getDescriptionResolver().addUnresolved(actionRef);
                    microStep = new CfmMicroStep(this, actionStep, actionRef, microStepIndex++);
                } else if (p instanceof AggregateActionRefT) {
                    String nsRef;
                    AggregateActionRefT aggregateActionRefT = (AggregateActionRefT)p;
                    String idRef = aggregateActionRefT.getIdref();
                    String ownerRef = aggregateActionRefT.getOwner();
                    if (ownerRef == null) {
                        ownerRef = this.getCurrentOwnerID();
                    }
                    if ((nsRef = aggregateActionRefT.getNs()) == null) {
                        nsRef = this.getCurrentNS();
                    }
                    CfwIdentifier ownerAggRef = new CfwIdentifier(ownerRef, nsRef);
                    CfmOwnedAggregateActionRef aggregateActionRef = new CfmOwnedAggregateActionRef(this, aggregateActionRefT, idRef, ownerAggRef, this.getCurrentAggregate());
                    if (this.debugB) {
                        cfmLogger.log(Level.INFO, "DescriptionsLoader.createAction: MicroStep creation aggregateActionRef=" + aggregateActionRef + ", microStepIndex=" + microStepIndex);
                    }
                    microStep = new CfmMicroStep(this, actionStep, aggregateActionRef, microStepIndex++);
                } else {
                    throw new CfwException("An invalid element was encountered within ActionStep " + actionStep);
                }
                microSteps.add(microStep);
            }
            actionStep.setMicroSteps(microSteps);
            actionSteps.add(actionStep);
        }
        action.setActionSteps(actionSteps);
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createAction: Done with " + action);
        }
        return action;
    }

    private ICfmWrapper createAggregates(Object obj) throws CfwException {
        CfmAggregate aggregate;
        Object aggT;
        List list = null;
        List<AggregateRefT> refs = null;
        if (obj instanceof SimplestAggregateT) {
            aggT = (SimplestAggregateT)obj;
            aggregate = CfmAggregate.getInstance(this, (SimplestAggregateT)aggT, this.getCurrentOwner());
            list = aggT.getParameterOrSimplestParamModelOrSimplestArrayParamModel();
        } else if (obj instanceof SimplestArrayAggregateT) {
            aggT = (SimplestArrayAggregateT)obj;
            aggregate = CfmAggregate.getInstance(this, (SimplestArrayAggregateT)aggT, this.getCurrentOwner());
            list = aggT.getVirtualParameterOrSimplestParamModelOrSimplestArrayParamModel();
            refs = new Vector<AggregateRefT>();
            refs.add(aggT.getSimplestAggregateRef());
        } else if (obj instanceof SimpleAggregateT) {
            aggT = (SimpleAggregateT)obj;
            aggregate = CfmAggregate.getInstance(this, (SimpleAggregateT)aggT, this.getCurrentOwner());
            list = aggT.getVirtualParameterOrSimplestParamModelOrSimplestArrayParamModel();
            refs = aggT.getSimplestAggregateRef();
        } else if (obj instanceof SimpleArrayAggregateT) {
            aggT = (SimpleArrayAggregateT)obj;
            aggregate = CfmAggregate.getInstance(this, (SimpleArrayAggregateT)aggT, this.getCurrentOwner());
            list = aggT.getVirtualParameterOrSimplestParamModelOrSimplestArrayParamModel();
            refs = new Vector();
            refs.add(aggT.getSimpleAggregateRef());
        } else if (obj instanceof ComplexAggregateT) {
            aggT = (ComplexAggregateT)obj;
            aggregate = CfmAggregate.getInstance(this, (ComplexAggregateT)aggT, this.getCurrentOwner());
            list = aggT.getVirtualParameterOrSimplestParamModelOrSimplestArrayParamModel();
            refs = aggT.getSimplestAggregateRefOrSimplestArrayAggregateRefOrSimpleAggregateRef();
        } else if (obj instanceof ArrayAggregateT) {
            AggregateRefT aggregateRefT;
            AggregateRefT aggregateRefT2;
            AggregateRefT aggregateRefT3;
            AggregateRefT aggregateRefT4;
            AggregateRefT aggregateRefT5;
            aggT = (ArrayAggregateT)obj;
            aggregate = CfmAggregate.getInstance(this, (ArrayAggregateT)aggT, this.getCurrentOwner());
            list = aggT.getSimplestParamModelOrSimplestArrayParamModelOrSimpleParamModel();
            refs = new Vector();
            AggregateRefT aggregateRefT6 = aggT.getSimplestAggregateRef();
            if (aggregateRefT6 != null) {
                refs.add(aggregateRefT6);
            }
            if ((aggregateRefT5 = aggT.getSimplestArrayAggregateRef()) != null) {
                refs.add(aggregateRefT5);
            }
            if ((aggregateRefT4 = aggT.getSimpleAggregateRef()) != null) {
                refs.add(aggregateRefT4);
            }
            if ((aggregateRefT3 = aggT.getSimpleArrayAggregateRef()) != null) {
                refs.add(aggregateRefT3);
            }
            if ((aggregateRefT2 = aggT.getComplexAggregateRef()) != null) {
                refs.add(aggregateRefT2);
            }
            if ((aggregateRefT = aggT.getArrayAggregateRef()) != null) {
                refs.add(aggregateRefT);
            }
        } else {
            return null;
        }
        this.newAggregateFound = true;
        if (this.debugB) {
            cfmLogger.log(Level.FINEST, "Found new aggregate " + aggregate.getCfmIdentity());
        }
        this.setCurrentAggregate(aggregate);
        if (refs != null) {
            for (Object e : refs) {
                AggregateVersion versionRef;
                AggregateRefT aggregateRefT = (AggregateRefT)e;
                if (aggregateRefT == null) continue;
                String idRef = aggregateRefT.getIdref();
                String fixedVersion = aggregateRefT.getFixedVersion();
                if (fixedVersion == null) {
                    versionRef = AggregateVersion.LATEST;
                } else {
                    try {
                        versionRef = AggregateVersion.versionFromString(fixedVersion);
                    }
                    catch (CfwException e2) {
                        throw new CfwException("Invalid value for fixed version attribute", e2);
                    }
                }
                String namespaceRef = CfmUtil.noNull(aggregateRefT.getNs(), this.getCurrentNS());
                AggregateDescriptionIdentifier ident = new AggregateDescriptionIdentifier(idRef, versionRef, namespaceRef);
                CfmAggregateRef aggregateRef = new CfmAggregateRef(this, aggregateRefT, ident);
                aggregate.addAggregateRef(aggregateRef);
                if (this.debugB) {
                    cfmLogger.log(Level.INFO, "DescriptionsLoader.createAggregates: object of " + aggregateRef + " is added as member to " + aggregate);
                }
                this.cfm.getDescriptionResolver().addAggregateReference(aggregateRef);
                this.cfm.getDescriptionResolver().addUnresolved(aggregateRef);
            }
        }
        if (list != null) {
            for (Object e : list) {
                this.addAndInspect(aggregate, "Aggregate", e, "some Member");
            }
        }
        this.unsetCurrentAggregate();
        if (this.debugB) {
            cfmLogger.log(Level.FINEST, "DescriptionsLoader.createAggregates: Done with " + aggregate);
        }
        return aggregate;
    }

    private ICfmWrapper createParamValueDataType(Object obj) throws CfwException {
        if (!(obj instanceof ParamValueDataTypeT)) {
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createParamValueDataType: ParamValueDataType:");
        }
        CfmUtil.myAssert(false);
        ParamValueDataTypeT paramValueDataTypeT = (ParamValueDataTypeT)obj;
        return new CfmParamValueDataType(this, paramValueDataTypeT);
    }

    private ICfmWrapper createParameter(Object obj) throws CfwException {
        if (!(obj instanceof ParameterT)) {
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createParameter: Parameter:");
        }
        ParameterT parameterT = (ParameterT)obj;
        return new CfmParameter(this, parameterT, this.getCurrentAggregate());
    }

    private ICfmWrapper createVirtualParameter(Object obj) throws CfwException {
        if (!(obj instanceof VirtualParameterT)) {
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createVirtualParameter: VirtualParameter:");
        }
        VirtualParameterT parameterT = (VirtualParameterT)obj;
        return new CfmVirtualParameter(this, parameterT, this.getCurrentOwner());
    }

    private ICfmWrapper createPlugIn(Object obj) throws CfwException {
        if (!(obj instanceof PlugInT)) {
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createPlugIn: PlugInT:");
        }
        PlugInT plugInT = (PlugInT)obj;
        CfmPlugIn plugIn = new CfmPlugIn(this, plugInT, this.getCurrentAggregate());
        if (this.debugB) {
            cfmLogger.log(Level.FINEST, "DescriptionsLoader.createPlugIn: Done with " + plugIn);
        }
        return plugIn;
    }

    private ICfmWrapper createExternalPlugInModel(Object obj) throws CfwException {
        if (!(obj instanceof ExternalPlugInModel)) {
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.INFO, "DescriptionsLoader.createExternalPlugInModel: ExternalPlugInModelT:");
            try {
                this.m.marshal(obj, this.output);
            }
            catch (JAXBException e) {
                CfmUtil.myAssert(false);
            }
            cfmLogger.log(Level.INFO, "");
        }
        ExternalPlugInModel externalPlugInModelT = (ExternalPlugInModel)obj;
        CfmExternalPlugInModel externalPlugInModel = new CfmExternalPlugInModel(this, externalPlugInModelT, this.getCurrentAggregate());
        return externalPlugInModel;
    }

    private ICfmWrapper createInternalPlugInModel(Object obj) throws CfwException {
        if (!(obj instanceof InternalPlugInModel)) {
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.FINEST, "DescriptionsLoader.createInternalPlugInModel: InternalPlugInModelT:");
        }
        InternalPlugInModel internalPlugInModelT = (InternalPlugInModel)obj;
        CfmInternalPlugInModel internalPlugInModel = new CfmInternalPlugInModel(this, internalPlugInModelT, this.getCurrentAggregate());
        return internalPlugInModel;
    }

    private ICfmWrapper createCondition(Object obj) throws CfwException {
        if (!(obj instanceof ConditionT)) {
            return null;
        }
        if (this.debugB) {
            cfmLogger.log(Level.FINEST, "DescriptionsLoader.createCondition: ConditionT:");
        }
        ConditionT conditionT = (ConditionT)obj;
        CfmCondition condition = new CfmCondition(this, conditionT, this.getCurrentAggregate());
        if (this.debugB) {
            cfmLogger.log(Level.FINEST, "DescriptionsLoader.createCondition: Condition is instantiated");
        }
        return condition;
    }

    private ICfmWrapper createParamModel(Object obj) throws CfwException {
        CfmParamModel paramModel;
        Object paramModelT;
        List<SimplestArrayParamT> list = null;
        if (obj instanceof SimplestParamModelT) {
            paramModelT = (SimplestParamModelT)obj;
            paramModel = new CfmParamModelSimplest(this, (SimplestParamModelT)paramModelT, this.getCurrentOwner());
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModel: ParamModel is instantiated");
            }
        } else if (obj instanceof SimplestArrayParamModelT) {
            paramModelT = (SimplestArrayParamModelT)obj;
            paramModel = new CfmParamModelSimplestArray(this, (SimplestArrayParamModelT)paramModelT, this.getCurrentOwner());
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModel: SimplestArrayAggregate count=" + paramModel.getCount());
            }
            list = new Vector<SimplestParamT>();
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimplestParam()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimplestParameterModelRef()));
        } else if (obj instanceof SimpleParamModelT) {
            paramModelT = (SimpleParamModelT)obj;
            paramModel = new CfmParamModelSimple(this, (SimpleParamModelT)paramModelT, this.getCurrentOwner());
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModel: ParamModel is instantiated");
            }
            list = paramModelT.getSimplestParamOrSimplestParameterModelRef();
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModel: SimplestParamOrParameterModelRef list size = " + list.size());
            }
        } else if (obj instanceof SimpleArrayParamModelT) {
            paramModelT = (SimpleArrayParamModelT)obj;
            paramModel = new CfmParamModelSimpleArray(this, (SimpleArrayParamModelT)paramModelT, this.getCurrentOwner());
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModels: SimplestArrayAggregate count=" + paramModel.getCount());
            }
            list = new Vector();
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimpleParam()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimpleParameterModelRef()));
        } else if (obj instanceof ComplexParamModelT) {
            paramModelT = (ComplexParamModelT)obj;
            paramModel = new CfmParamModelComplex(this, (ComplexParamModelT)paramModelT, this.getCurrentOwner());
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModel: ParamModel is instantiated");
            }
            list = paramModelT.getSimplestParamOrSimplestArrayParamOrSimpleParam();
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModel: SimplestParamOrSimplestArrayParamOrSimpleParam list size = " + list.size());
            }
        } else if (obj instanceof ArrayParamModelT) {
            paramModelT = (ArrayParamModelT)obj;
            paramModel = new CfmParamModelArray(this, (ArrayParamModelT)paramModelT, this.getCurrentOwner());
            if (this.debugB) {
                cfmLogger.log(Level.FINEST, "DescriptionsLoader.createParamModels: SimplestArrayAggregate count=" + paramModel.getCount());
            }
            list = new Vector();
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimplestParam()));
            list.add(paramModelT.getSimplestArrayParam());
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimpleParam()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimpleArrayParam()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getComplexParam()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getArrayParam()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimplestParameterModelRef()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimplestArrayParameterModelRef()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimpleParameterModelRef()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getSimpleArrayParameterModelRef()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getComplexParameterModelRef()));
            list.add((SimplestArrayParamT)((Object)paramModelT.getArrayParameterModelRef()));
        } else {
            return null;
        }
        if (list != null) {
            for (Object e : list) {
                if (e != null && e instanceof ParameterModelRefT) {
                    ParameterModelRefT parameterModelRefT = (ParameterModelRefT)e;
                    IParameterType ref = this.newParameterModelRef(parameterModelRefT);
                    paramModel.addParameterType(ref);
                    continue;
                }
                ICfmWrapper result = this.inspect(e);
                if (e == null) continue;
                paramModel.addMember(result);
                if (!(result instanceof IParameterType)) continue;
                paramModel.addParameterType((IParameterType)result);
            }
        }
        return paramModel;
    }

    private void addAndInspect(CfmParentObject owner, String ownerType, Object obj, String objType) throws CfwException {
        this.addAndInspect(owner, obj);
    }

    private ICfmWrapper createParam(Object obj) throws CfwException {
        if (obj instanceof SimplestParamT) {
            SimplestParamT paramT = (SimplestParamT)obj;
            return CfmParamSimplest.getInstance(this, paramT, this.getCurrentOwner());
        }
        if (obj instanceof SimplestArrayParamT) {
            SimplestArrayParamT paramT = (SimplestArrayParamT)obj;
            return CfmParamSimplestArray.getInstance(this, paramT, this.getCurrentOwner());
        }
        if (obj instanceof SimpleParamT) {
            SimpleParamT paramT = (SimpleParamT)obj;
            return CfmParamSimple.getInstance(this, paramT, this.getCurrentOwner());
        }
        if (obj instanceof SimpleArrayParamT) {
            SimpleArrayParamT paramT = (SimpleArrayParamT)obj;
            return CfmParamSimpleArray.getInstance(this, paramT, this.getCurrentOwner());
        }
        if (obj instanceof ComplexParamT) {
            ComplexParamT paramT = (ComplexParamT)obj;
            return CfmParamComplex.getInstance(this, paramT, this.getCurrentOwner());
        }
        if (obj instanceof ArrayParamT) {
            ArrayParamT paramT = (ArrayParamT)obj;
            return CfmParamArray.getInstance(this, paramT, this.getCurrentOwner());
        }
        return null;
    }

    static void invalidAttributeEncountered(String attributeName, String invalidValue, Collection validValues) throws CfwException {
        throw new CfwException("\"" + invalidValue + "\" is an invalid value for attribute " + attributeName + "; values must come from the list [" + CfmUtil.collectionToString(validValues, ", ") + "]");
    }

    static boolean isSchemaVersionSupported(String schemaVersion) {
        for (int i = 0; i < supportedVersions.length; ++i) {
            if (!supportedVersions[i].equals(schemaVersion)) continue;
            return true;
        }
        return false;
    }

    public Resolver getDescriptionResolver() {
        return this.getCfm().getDescriptionResolver();
    }
}

