/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateVersions;
import oracle.sysman.emCfg.core.CfmDescriptions;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmIdentity;
import oracle.sysman.emCfg.core.CfmParamModel;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.CfwOwnerWithLocation;
import oracle.sysman.emCfg.core.IdentifierIdNsLocation;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmTaggedObjectFactory
implements Serializable {
    private Hashtable cfmTaggedObjects = new Hashtable();
    private Hashtable aggregateLocationsHash = new Hashtable();
    private Hashtable aggregateVersionsHash = new Hashtable();
    private Hashtable latestParamModels = new Hashtable();
    private final List cfmDescriptions = new Vector();

    CfmTaggedObjectFactory() {
    }

    List getDescriptions() {
        return this.cfmDescriptions;
    }

    public CfmTaggedObject getFromHash(CfmElementType type, String selfID, CfwOwnerWithLocation owner) throws CfwException {
        return this.getFromHash(new CfmElementKey(type, selfID, owner), owner.getOH());
    }

    private CfmTaggedObject getFromHash(CfmElementKey key, OHAbsolute currOH) throws CfwException {
        ElementEntriesCfmTaggedObject entries = (ElementEntriesCfmTaggedObject)this.cfmTaggedObjects.get(key);
        if (entries == null) {
            throw new CfwException("Element not found");
        }
        if (currOH == null) {
            return entries.getUnique();
        }
        return entries.getFrom(currOH);
    }

    void add(CfmTaggedObject cfmObject) {
        CfmElementKey key = new CfmElementKey(cfmObject.getCfmIdentity());
        ElementEntriesCfmTaggedObject entries = (ElementEntriesCfmTaggedObject)this.cfmTaggedObjects.get(key);
        if (entries == null) {
            entries = new ElementEntriesCfmTaggedObject();
            this.cfmTaggedObjects.put(key, entries);
        }
        entries.add(cfmObject);
    }

    void addDescriptions(CfmDescriptions newDescriptions) {
        this.cfmDescriptions.add(newDescriptions);
    }

    void addAggregate(CfmAggregate cfmAggregate) {
        this.addToLocationsHash(cfmAggregate.getVersionlessIdentifier(), cfmAggregate.getOHAbs());
        IdentifierIdNsLocation ident = cfmAggregate.getVersionlessIdentifierWithLocation();
        CfmAggregateVersions versions = (CfmAggregateVersions)this.aggregateVersionsHash.get(ident);
        if (versions == null) {
            versions = new CfmAggregateVersions();
            this.aggregateVersionsHash.put(ident, versions);
        }
        versions.add(cfmAggregate.getVersion());
    }

    private void addToLocationsHash(CfwIdentifier versionlessIdentifier, OHAbsolute oracleHome) {
        OHAbsoluteSet ohs;
        Object obj = this.aggregateLocationsHash.get(versionlessIdentifier);
        if (obj != null) {
            ohs = (OHAbsoluteSet)obj;
        } else {
            ohs = new OHAbsoluteSet();
            this.aggregateLocationsHash.put(versionlessIdentifier, ohs);
        }
        ohs.add(oracleHome);
    }

    public AggregateVersion getVersionOfAggregateLatestVersion(IdentifierIdNsLocation ident) {
        CfmAggregateVersions versionList = (CfmAggregateVersions)this.aggregateVersionsHash.get(ident);
        if (versionList == null) {
            return null;
        }
        return versionList.getLatest();
    }

    void addStandaloneParamModel(CfmParamModel paramModel) {
        CfwIdentifier tag = new CfwIdentifier(paramModel.getSelfID(), paramModel.getNamespace());
        Object latestVersion = this.latestParamModels.get(tag);
        if (latestVersion == null || ((CfmParamModel)latestVersion).getVersion().compareTo(paramModel.getVersion()) < 0) {
            this.latestParamModels.put(tag, paramModel);
        }
    }

    CfmParamModel getLatestVersionOfParamModel(CfwIdentifier identifier) {
        CfmParamModel paramModel = (CfmParamModel)this.latestParamModels.get(identifier);
        return paramModel;
    }

    public boolean aggregateExistsInLocation(CfwIdentifier ident, OHAbsolute location) {
        OHAbsoluteSet ohs = (OHAbsoluteSet)this.aggregateLocationsHash.get(ident);
        if (ohs == null) {
            return false;
        }
        return ohs.contains(location);
    }

    public OHAbsolute getUniqueAggregateLocation(CfwIdentifier ident) throws CfwException {
        OHAbsoluteSet ohs = (OHAbsoluteSet)this.aggregateLocationsHash.get(ident);
        if (ohs == null) {
            throw new CfwException("There are no loaded aggregates for " + ident);
        }
        try {
            return ohs.getUnique();
        }
        catch (CfwException e) {
            throw new CfwException("The aggregate " + ident + " exists in multiple locations: " + e.getMessage(), e);
        }
    }

    class CfmElementKey {
        private final CfmElementType type;
        private final String selfID;
        private final String aggID;
        private final AggregateVersion version;
        private final String namespace;

        public CfmElementKey(CfmIdentity identity) {
            this.type = identity.getType();
            this.selfID = identity.getSelfID();
            this.aggID = identity.getAggregateID();
            this.version = identity.getVersion();
            this.namespace = identity.getNamespace();
        }

        public CfmElementKey(CfmElementType type, String selfID, CfwOwnerWithLocation owner) {
            this.type = type;
            this.selfID = CfmUtil.noNull(selfID, "*");
            this.aggID = type == CfmElementType.AGGREGATE ? selfID : CfmUtil.noNull(owner.getSelfID(), "*");
            this.version = owner.getVersion();
            this.namespace = owner.getNamespace();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CfmElementKey)) {
                return false;
            }
            CfmElementKey rhs = (CfmElementKey)o;
            return this.type == rhs.type && CfmUtil.nullOrEqual(this.selfID, rhs.selfID) && CfmUtil.nullOrEqual(this.aggID, rhs.aggID) && CfmUtil.nullOrEqual(this.version, rhs.version) && CfmUtil.nullOrEqual(this.namespace, rhs.namespace);
        }

        public int hashCode() {
            int result = this.type.toString().hashCode();
            result = 31 * result + CfmUtil.hashCode(this.selfID);
            result = 31 * result + CfmUtil.hashCode(this.aggID);
            result = 31 * result + CfmUtil.hashCode(this.version);
            result = 31 * result + CfmUtil.hashCode(this.namespace);
            return result;
        }
    }

    class OHAbsoluteSet {
        private final Set locations = new HashSet();

        OHAbsoluteSet() {
        }

        void add(OHAbsolute oh) {
            this.locations.add(oh);
        }

        OHAbsolute getUnique() throws CfwException {
            if (this.locations.size() != 1) {
                throw new CfwException(this.locations.size() + " elements have this identification; needs to be exactly 1");
            }
            return (OHAbsolute)this.locations.iterator().next();
        }

        boolean contains(OHAbsolute location) {
            return this.locations.contains(location);
        }
    }

    class ElementEntriesCfmTaggedObject {
        private final Hashtable taggedObjects = new Hashtable();

        ElementEntriesCfmTaggedObject() {
        }

        void add(CfmTaggedObject cfmObject) {
            OHAbsolute location = cfmObject.getOHAbs();
            CfmTaggedObject previous = this.taggedObjects.put(location, cfmObject);
            if (previous != null) {
                // empty if block
            }
        }

        CfmTaggedObject getUnique() throws CfwException {
            Collection objects = this.taggedObjects.values();
            if (objects.size() != 1) {
                throw new CfwException(objects.size() + " elements have this identification; needs to be exactly 1");
            }
            return (CfmTaggedObject)objects.iterator().next();
        }

        CfmTaggedObject getFrom(OHAbsolute oh) throws CfwException {
            Object result = this.taggedObjects.get(oh);
            if (result == null) {
                throw new CfwException("Nothing found");
            }
            return (CfmTaggedObject)result;
        }
    }
}

