/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.logging.Level;
import oracle.sysman.emCfg.client.ICommand2;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.Command;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IActionStateReference;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.ICommand;
import oracle.sysman.emCfg.common.IConditionReference;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugInReference;
import oracle.sysman.emCfg.common.IProgressMonitor;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.common.IStateReference;
import oracle.sysman.emCfg.core.ActionStateReference;
import oracle.sysman.emCfg.core.ActionStepStateReference;
import oracle.sysman.emCfg.core.AggregateReference;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmActionPair;
import oracle.sysman.emCfg.core.CfmActionState;
import oracle.sysman.emCfg.core.CfmActionStepPair;
import oracle.sysman.emCfg.core.CfmActionStepState;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmCondition;
import oracle.sysman.emCfg.core.CfmConditionPair;
import oracle.sysman.emCfg.core.CfmConditionState;
import oracle.sysman.emCfg.core.CfmFactory;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.CfmParameterPair;
import oracle.sysman.emCfg.core.CfmPlugIn;
import oracle.sysman.emCfg.core.ConditionReference;
import oracle.sysman.emCfg.core.MicroStepStateReference;
import oracle.sysman.emCfg.core.PlugInReference;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.AggregatePhase;
import oracle.sysman.emCfg.types.AggregateType;
import oracle.sysman.emCfg.types.CustomizableType;
import oracle.sysman.emCfg.types.MicroStepStatus;
import oracle.sysman.emCfg.types.OperationType;
import oracle.sysman.emCfg.types.ParameterStatus;
import oracle.sysman.emCfg.types.ParameterType;
import oracle.sysman.emCfg.types.PlugInType;
import oracle.xml.parser.v2.XMLDocument;

public class CfmSession {
    private static final Hashtable sessionHash = new Hashtable();
    private static final boolean debug = Cfm.isDebug();
    private static final CfmLogger cfmLogger = Cfm.getLogger();
    private String sessionID = CfmUtil.getNumericUniqueId();
    private final Cfm cfm;

    private String getSessionID() {
        return this.sessionID;
    }

    private CfmSession(Cfm cfm) throws CfwException {
        this.cfm = cfm;
    }

    protected void finalize() {
        if (this.getSessionID() != null) {
            cfmLogger.log(Level.WARNING, "Session " + this.getSessionID() + " was destroyed without a proper call to endSession");
            sessionHash.remove(this.sessionID);
        }
    }

    static String newSession(Cfm cfm) throws CfwException {
        CfmSession session = new CfmSession(cfm);
        String newID = session.getSessionID();
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmSession.newSession: newID = " + newID);
        }
        sessionHash.put(newID, session);
        return session.getSessionID();
    }

    public static String newSession(CfmFactory cfmFactory) throws CfwException {
        return CfmSession.newSession(cfmFactory.getCfm());
    }

    public static void endSession(String sessionID) {
        CfmSession s;
        if (sessionID != null && (s = (CfmSession)sessionHash.remove(sessionID)) != null) {
            s.sessionID = null;
        }
    }

    static CfmSession getSession(String sessionID) throws CfwException {
        if (sessionID == null) {
            throw new CfwException("This session has already been ended");
        }
        return (CfmSession)sessionHash.get(sessionID);
    }

    public static void cmd(String sessionID, IReference ref, ICommand cmd) throws CfwException {
        CfmSession session;
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmSession.cmd: requested " + sessionID);
        }
        if ((session = CfmSession.getSession(sessionID)) == null) {
            throw new CfwException("invalid session ID = " + sessionID);
        }
        session.command(ref, cmd);
    }

    public static void cmd2(String sessionID, ICommand2 cmd) throws CfwException {
        CfmSession session = CfmSession.getSession(sessionID);
        if (session == null) {
            throw new CfwException("invalid session ID= " + sessionID);
        }
        cmd.processCommand(session.cfm);
    }

    public static void cmd(String sessionID, IStateReference ref, ICommand cmd) throws CfwException {
        CfmSession session;
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmSession.cmd: requested " + sessionID);
        }
        if ((session = CfmSession.getSession(sessionID)) == null) {
            throw new CfwException("invalid session ID = " + sessionID);
        }
        session.command(ref, cmd);
    }

    private void command(IReference ref, ICommand cmd) throws CfwException {
        if (cmd == null) {
            throw new CfwException("invalid (null) cmd");
        }
        if (ref == null) {
            throw new CfwException("invalid (null) ref");
        }
        if (ref instanceof IAggregateReference) {
            this.processAggregateCommands(this.cfm, (IAggregateReference)ref, cmd);
            return;
        }
        if (ref instanceof IConditionReference) {
            this.processConditionCommands(this.cfm, (IConditionReference)ref, cmd);
            return;
        }
        if (ref instanceof IParameterReference) {
            this.processParameterCommands(this.cfm, (IParameterReference)ref, cmd);
            return;
        }
        if (ref instanceof IActionReference) {
            this.processActionCommands(this.cfm, (IActionReference)ref, cmd);
            return;
        }
        if (ref instanceof IPlugInReference) {
            this.processPlugInCommands(this.cfm, (IPlugInReference)ref, cmd);
            return;
        }
        throw new CfwException("command with IReference parameter: invalid or unimplemented (unknown type) reference = " + ref);
    }

    private void processAggregateCommands(Cfm cfm, IAggregateReference aggregateReference, ICommand cmd) throws CfwException {
        CfmAggregateHolder aggregateHolder;
        if (debug) {
            cfmLogger.log(Level.INFO, "IAggregateReference type command is being processed=" + cmd.getName());
        }
        if ((aggregateHolder = cfm.getAggregateHolderLatestLabel(aggregateReference.getOwnerFamily())) == null) {
            throw new CfwException("Invalid IAggregateReference specified = " + aggregateReference + " for command = " + cmd.getName());
        }
        if (cmd.getName().equals(Command.getDesc().getName())) {
            cmd.setReturnValue(aggregateHolder.getDesc());
            return;
        }
        if (cmd.getName().equals(Command.getReference().getName())) {
            cmd.setReturnValue(aggregateHolder.getReference());
            return;
        }
        if (cmd.getName().equals(Command.getSelfID().getName())) {
            cmd.setReturnValue(aggregateHolder.getSelfID());
            return;
        }
        if (cmd.getName().equals(Command.getParent().getName())) {
            cmd.setReturnValue(aggregateHolder.getParent());
            return;
        }
        if (cmd.getName().equals(Command.getActionReferenceByName().getName())) {
            String actionID = (String)cmd.getFirstParam();
            cmd.setReturnValue(aggregateHolder.getActionReference(actionID));
            return;
        }
        if (cmd.getName().equals(Command.getActionReferences().getName())) {
            cmd.setReturnValue(aggregateHolder.getActionReferences());
            return;
        }
        if (cmd.getName().equals(Command.getActionReferencesByType().getName())) {
            ActionType actionType = (ActionType)cmd.getFirstParam();
            cmd.setReturnValue(aggregateHolder.getActionReferences(actionType));
            return;
        }
        if (cmd.getName().equals(Command.getParameterReferences().getName())) {
            cmd.setReturnValue(aggregateHolder.getParameterReferences());
            return;
        }
        if (cmd.getName().equals(Command.getParameterReferenceByName().getName())) {
            String id = (String)cmd.getFirstParam();
            cmd.setReturnValue(aggregateHolder.getParameterReference(id));
            return;
        }
        if (cmd.getName().equals(Command.getPlugInReferences().getName())) {
            cmd.setReturnValue(aggregateHolder.getPlugInReferences());
            return;
        }
        if (cmd.getName().equals(Command.getConditionReferences().getName())) {
            cmd.setReturnValue(aggregateHolder.getConditionReferences());
            return;
        }
        if (cmd.getName().equals(Command.getReferredAggregateReferences().getName())) {
            cmd.setReturnValue(aggregateHolder.getReferredAggregateReferences());
            return;
        }
        if (cmd.getName().equals(Command.getAllReferredAggregateReferences().getName())) {
            cmd.setReturnValue(aggregateHolder.getAllReferredAggregateReferences());
            return;
        }
        if (cmd.getName().equals(Command.getUnavailableReferredAggregateReferences().getName())) {
            cmd.setReturnValue(aggregateHolder.getUnavailableReferredAggregateReferences());
            return;
        }
        if (cmd.getName().equals(Command.getReferredAggregate().getName())) {
            IAggregateReference aggRef = (IAggregateReference)cmd.getFirstParam();
            cmd.setReturnValue(aggregateHolder.getReferredAggregate(aggRef));
            return;
        }
        if (cmd.getName().equals(Command.isActive().getName())) {
            IAggregateReference desired = (IAggregateReference)cmd.getFirstParam();
            cmd.setReturnValue(aggregateHolder.isActive(desired));
            return;
        }
        if (cmd.getName().equals(Command.setActive().getName())) {
            IAggregateReference desired = (IAggregateReference)cmd.getFirstParam();
            Boolean active = (Boolean)cmd.getSecondParam();
            aggregateHolder.setActive(active, desired);
            return;
        }
        if (cmd.getName().equals(Command.addProgressListener().getName())) {
            IProgressMonitor mon = (IProgressMonitor)cmd.getFirstParam();
            aggregateHolder.addProgressListener(mon);
            return;
        }
        if (cmd.getName().equals(Command.removeProgressListener().getName())) {
            IProgressMonitor mon = (IProgressMonitor)cmd.getFirstParam();
            aggregateHolder.removeProgressListener(mon);
            return;
        }
        if (cmd.getName().equals(Command.getTypeOfAggregate().getName())) {
            cmd.setReturnValue(aggregateHolder.getType());
            return;
        }
        if (cmd.getName().equals(Command.isTypeOfAggregate().getName())) {
            AggregateType type = (AggregateType)cmd.getFirstParam();
            cmd.setReturnValue(aggregateHolder.isType(type));
            return;
        }
        if (cmd.getName().equals(Command.saveAggregate().getName())) {
            String fileName = aggregateHolder.save();
            cmd.setReturnValue(fileName);
            return;
        }
        if (cmd.getName().equals(Command.aggregatePerform().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            IMicroStepStateReference[] selectedMSRefs = (IMicroStepStateReference[])cmd.getFifthParam();
            ActionType actionType = (ActionType)cmd.getSixthParam();
            aggregateHolder.performAction(blocking, isSilently, retry, skipDetached, selectedMSRefs, actionType);
            return;
        }
        if (cmd.getName().equals(Command.aggregatePerformRecommended().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            boolean skipOptional = (Boolean)cmd.getFifthParam();
            ActionType actionType = (ActionType)cmd.getSixthParam();
            aggregateHolder.performActionRecommended(blocking, isSilently, retry, skipDetached, skipOptional, actionType);
            return;
        }
        if (cmd.getName().equals(Command.aggregatePerformOptional().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            ActionType actionType = (ActionType)cmd.getFifthParam();
            aggregateHolder.performActionOptional(blocking, isSilently, retry, skipDetached, actionType);
            return;
        }
        if (cmd.getName().equals(Command.aggregatePerformDetached().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            ActionType actionType = (ActionType)cmd.getFourthParam();
            aggregateHolder.performActionDetached(blocking, isSilently, retry, actionType);
            return;
        }
        if (cmd.getName().equals(Command.aggregateListTools().getName())) {
            boolean recommended = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            ActionType type = (ActionType)cmd.getFifthParam();
            cmd.setReturnValue(aggregateHolder.listTools(recommended, isSilently, retry, skipDetached, type));
            return;
        }
        if (cmd.getName().equals(Command.aggregateListOptionalTools().getName())) {
            boolean isSilently = (Boolean)cmd.getFirstParam();
            boolean retry = (Boolean)cmd.getSecondParam();
            boolean skipDetached = (Boolean)cmd.getThirdParam();
            boolean includenActive = (Boolean)cmd.getFourthParam();
            ActionType type = (ActionType)cmd.getFifthParam();
            cmd.setReturnValue(aggregateHolder.listOptionalTools(isSilently, retry, skipDetached, includenActive, type));
            return;
        }
        if (cmd.getName().equals(Command.aggregateListDetachedTools().getName())) {
            boolean isSilently = (Boolean)cmd.getFirstParam();
            boolean retry = (Boolean)cmd.getSecondParam();
            ActionType type = (ActionType)cmd.getThirdParam();
            cmd.setReturnValue(aggregateHolder.listDetachedTools(isSilently, retry, type));
            return;
        }
        if (cmd.getName().equals(Command.getLastKnownInstanceLabel().getName())) {
            cmd.setReturnValue(aggregateHolder.getLastKnownInstanceLabel());
            return;
        }
        if (cmd.getName().equals(Command.getAvailableInstanceLabels().getName())) {
            cmd.setReturnValue(aggregateHolder.getAvailableInstanceLabels());
            return;
        }
        if (cmd.getName().equals(Command.getFirstKnownInstanceLabel().getName())) {
            cmd.setReturnValue(aggregateHolder.getFirstKnownInstanceLabel());
            return;
        }
        if (cmd.getName().equals(Command.getInstanceDate().getName())) {
            cmd.setReturnValue(aggregateHolder.getDate());
            return;
        }
        if (cmd.getName().equals(Command.getInstanceFirst().getName())) {
            cmd.setReturnValue(aggregateHolder.getFirstKnownInstanceLabel());
            return;
        }
        if (cmd.getName().equals(Command.getInstanceLast().getName())) {
            cmd.setReturnValue(aggregateHolder.getLastKnownInstanceLabel());
            return;
        }
        if (cmd.getName().equals(Command.getPhase().getName())) {
            cmd.setReturnValue(aggregateHolder.getPhase());
            return;
        }
        if (cmd.getName().equals(Command.setPhase().getName())) {
            AggregatePhase phase = (AggregatePhase)cmd.getFirstParam();
            aggregateHolder.setPhase(phase);
            return;
        }
        if (cmd.getName().equals(Command.getOracleHome().getName())) {
            cmd.setReturnValue(aggregateHolder.getOracleHome());
            return;
        }
        throw new CfwException("UnImplemented (Aggregate method) command = " + cmd);
    }

    void processConditionCommands(Cfm cfm, IConditionReference ref, ICommand cmd) throws CfwException {
        CfmAggregateHolder conditionHolder;
        if (debug) {
            cfmLogger.log(Level.INFO, "IConditionReference type command is being processed for command=" + cmd.getName());
        }
        if ((conditionHolder = cfm.getAggregateHolderLatestLabel(ref.getOwnerFamily())) == null) {
            throw new CfwException("Invalid IConditionReference specified = " + ref + " for command = " + cmd);
        }
        CfmConditionPair conditionPair = conditionHolder.getConditionPair(ref.getSelfID());
        CfmConditionState conditionState = conditionPair.getCfmConditionState();
        CfmCondition condition = conditionPair.getCfmCondition();
        if (cmd.getName().equals(Command.getDesc().getName())) {
            String res = condition.getDesc();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getReference().getName())) {
            ConditionReference res = new ConditionReference(condition.getSelfID(), conditionHolder.getFamilyIdentifier());
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getSelfID().getName())) {
            String res = conditionPair.getSelfID();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getParent().getName())) {
            cmd.setReturnValue(conditionHolder.getSelfReference());
            return;
        }
        if (cmd.getName().equals(Command.setValue().getName())) {
            conditionState.setValue((Boolean)cmd.getFirstParam());
            return;
        }
        if (cmd.getName().equals(Command.getValue().getName())) {
            cmd.setReturnValue(conditionState.getValue());
            return;
        }
        if (cmd.getName().equals(Command.getSummary().getName())) {
            String summary = conditionState.getSummary();
            cmd.setReturnValue(summary);
            return;
        }
        if (cmd.getName().equals(Command.getOracleHome().getName())) {
            String oh = conditionHolder.getOracleHome();
            cmd.setReturnValue(oh);
            return;
        }
        throw new CfwException("UnImplemented (Condition method) command = " + cmd.getName());
    }

    void processParameterCommands(Cfm cfm, IParameterReference ref, ICommand cmd) throws CfwException {
        CfmAggregateHolder parentParamHolder;
        if (debug) {
            cfmLogger.log(Level.INFO, "IParameterReference type command is being processed=" + cmd.getName());
        }
        if ((parentParamHolder = cfm.getAggregateHolderLatestLabel(ref.getOwnerFamily())) == null) {
            throw new CfwException("Invalid IConditionReference specified = " + ref + " for command = " + cmd);
        }
        CfmParameterPair parameter = parentParamHolder.getParameterPair(ref.getSelfID());
        if (cmd.getName().equals(Command.getDesc().getName())) {
            String res = parameter.getDesc();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getReference().getName())) {
            IReference res = parameter.getReference();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getSelfID().getName())) {
            String res = parameter.getSelfID();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getParent().getName())) {
            cmd.setReturnValue(parentParamHolder.getSelfReference());
            return;
        }
        if (cmd.getName().equals(Command.getOriginator().getName())) {
            cmd.setReturnValue(null);
            return;
        }
        if (cmd.getName().equals(Command.getOracleHome().getName())) {
            String oh = parentParamHolder.getOracleHome();
            cmd.setReturnValue(oh);
            return;
        }
        if (cmd.getName().equals(Command.getSummary().getName())) {
            String summary = parameter.getSummary();
            cmd.setReturnValue(summary);
            return;
        }
        if (cmd.getName().equals(Command.getStatus().getName()) || cmd.getName().equals(Command.getParameterStatus().getName())) {
            ParameterStatus status = parameter.getParameterStatus();
            cmd.setReturnValue(status);
            return;
        }
        if (cmd.getName().equals(Command.isValidValueAsXmlString().getName())) {
            return;
        }
        if (cmd.getName().equals(Command.isSettable().getName())) {
            boolean isValid = parameter.isSettable();
            cmd.setReturnValue(isValid);
            return;
        }
        if (cmd.getName().equals(Command.isEncrypted().getName())) {
            boolean isValid = parameter.isEncrypted();
            cmd.setReturnValue(isValid);
            return;
        }
        if (cmd.getName().equals(Command.getTypeOfParameter().getName())) {
            ParameterType type = parameter.getType();
            cmd.setReturnValue(type);
            return;
        }
        if (cmd.getName().equals(Command.isTypeOfParameter().getName())) {
            ParameterType type = (ParameterType)cmd.getFirstParam();
            cmd.setReturnValue(parameter.isType(type));
            return;
        }
        if (cmd.getName().equals(Command.getValueAsSerializable().getName())) {
            cmd.setReturnValue(parameter.getValueAsSerializable());
            return;
        }
        if (cmd.getName().equals(Command.setSimplestAsSerializable().getName())) {
            Serializable val = (Serializable)cmd.getFirstParam();
            parameter.setValueAsSerializable(val);
            return;
        }
        if (cmd.getName().equals(Command.setValueFromXmlString().getName())) {
            String valueAsXmlString = (String)cmd.getFirstParam();
            parameter.setValue(valueAsXmlString);
            return;
        }
        if (cmd.getName().equals(Command.getValueAsXmlString().getName())) {
            cmd.setReturnValue(parameter.getValue());
            return;
        }
        if (cmd.getName().equals(Command.setSimplestAsStringArray().getName())) {
            String[] val = (String[])cmd.getFirstParam();
            parameter.setSimplestAsStringArray(val);
            return;
        }
        if (cmd.getName().equals(Command.setSimplestAsString().getName())) {
            String val = (String)cmd.getFirstParam();
            parameter.setSimplestAsString(val);
            return;
        }
        if (cmd.getName().equals(Command.setSimplestAsInt().getName())) {
            int val = (Integer)cmd.getFirstParam();
            parameter.setSimplestAsInt(val);
            return;
        }
        if (cmd.getName().equals(Command.setSimplestAsBoolean().getName())) {
            boolean val = (Boolean)cmd.getFirstParam();
            parameter.setSimplestAsBoolean(val);
            return;
        }
        if (cmd.getName().equals(Command.getValueAsSimplestStringArray().getName())) {
            cmd.setReturnValue(parameter.getValueAsSimplestStringArray());
            return;
        }
        if (cmd.getName().equals(Command.getValueAsSimplestString().getName())) {
            cmd.setReturnValue(parameter.getValueAsSimplestString());
            return;
        }
        if (cmd.getName().equals(Command.getValueAsSimplestInt().getName())) {
            cmd.setReturnValue(new Integer(parameter.getValueAsSimplestInt()));
            return;
        }
        if (cmd.getName().equals(Command.getValueAsSimplestBoolean().getName())) {
            boolean res = parameter.getValueAsSimplestBoolean();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getHexedValue().getName())) {
            return;
        }
        if (cmd.getName().equals(Command.setValueFromXmlDocument().getName())) {
            XMLDocument document = (XMLDocument)cmd.getFirstParam();
            parameter.setValue(document);
            return;
        }
        if (cmd.getName().equals(Command.getValueAsXmlDocument().getName())) {
            cmd.setReturnValue(parameter.getValueAsXmlDocument());
            return;
        }
        throw new CfwException("UnImplemented (Parameter method) command = " + cmd);
    }

    void processActionCommands(Cfm cfm, IActionReference ref, ICommand cmd) throws CfwException {
        CfmAggregateHolder actionHolder = cfm.getAggregateHolderLatestLabel(ref.getOwnerFamily());
        if (actionHolder == null) {
            throw new CfwException("Invalid IActionReference specified = " + ref + " for command = " + cmd);
        }
        CfmActionPair pair = actionHolder.getActionPairById(ref.getSelfID());
        if (cmd.getName().equals(Command.getOracleHome().getName())) {
            cmd.setReturnValue(pair.getOracleHome());
            return;
        }
        if (cmd.getName().equals(Command.getDesc().getName())) {
            String res = pair.getDesc();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getReference().getName())) {
            IReference res = pair.getReference();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getSelfID().getName())) {
            String res = pair.getSelfID();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getParent().getName())) {
            cmd.setReturnValue(pair.getParent());
            return;
        }
        if (cmd.getName().equals(Command.getTypesOfAction().getName())) {
            ActionType[] types = pair.getTypes();
            cmd.setReturnValue(types);
            return;
        }
        if (cmd.getName().equals(Command.isTypeOfAction().getName())) {
            ActionType type = (ActionType)cmd.getFirstParam();
            cmd.setReturnValue(pair.isType(type));
            return;
        }
        if (cmd.getName().equals(Command.isWithinTypesOfAction().getName())) {
            ActionType[] type = (ActionType[])cmd.getFirstParam();
            cmd.setReturnValue(pair.isWithinTypes(type));
            return;
        }
        if (cmd.getName().equals(Command.perform().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            pair.perform(blocking, isSilently, retry, skipDetached);
            return;
        }
        if (cmd.getName().equals(Command.performWithType().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            ActionType type = (ActionType)cmd.getFifthParam();
            pair.perform(blocking, isSilently, retry, skipDetached, type);
            return;
        }
        if (cmd.getName().equals(Command.performRecommended().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            boolean skipOptional = (Boolean)cmd.getFifthParam();
            pair.performRecommended(blocking, isSilently, retry, skipDetached, skipOptional);
            return;
        }
        if (cmd.getName().equals(Command.performRecommendedWithType().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            boolean skipOptional = (Boolean)cmd.getFifthParam();
            ActionType type = (ActionType)cmd.getSixthParam();
            pair.performRecommended(blocking, isSilently, retry, skipDetached, skipOptional, type);
            return;
        }
        if (cmd.getName().equals(Command.performOptional().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            pair.performOptional(blocking, isSilently, retry, skipDetached);
            return;
        }
        if (cmd.getName().equals(Command.performOptionalWithType().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            ActionType type = (ActionType)cmd.getFifthParam();
            pair.performOptional(blocking, isSilently, retry, skipDetached, type);
            return;
        }
        if (cmd.getName().equals(Command.performDetached().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            pair.performDetached(blocking, isSilently, retry);
            return;
        }
        if (cmd.getName().equals(Command.performDetachedWithType().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            ActionType type = (ActionType)cmd.getFourthParam();
            pair.performDetached(blocking, isSilently, retry, type);
            return;
        }
        if (cmd.getName().equals(Command.performSelectedStep().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            int actionStepIndex = (Integer)cmd.getSecondParam();
            int microStepIndex = (Integer)cmd.getThirdParam();
            pair.performSelectedStep(blocking, actionStepIndex, microStepIndex);
            return;
        }
        if (cmd.getName().equals(Command.listTools().getName())) {
            boolean recommended = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            cmd.setReturnValue(pair.listTools(recommended, isSilently, retry, skipDetached));
            return;
        }
        if (cmd.getName().equals(Command.listToolsInAggregate().getName())) {
            boolean recommended = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            cmd.setReturnValue(pair.listToolsInAggregate(recommended, isSilently, retry, skipDetached));
            return;
        }
        if (cmd.getName().equals(Command.listOptionalTools().getName())) {
            boolean isSilently = (Boolean)cmd.getFirstParam();
            boolean retry = (Boolean)cmd.getSecondParam();
            boolean skipDetached = (Boolean)cmd.getThirdParam();
            boolean includeInactive = (Boolean)cmd.getFourthParam();
            cmd.setReturnValue(pair.listOptionalTools(isSilently, retry, skipDetached, includeInactive));
            return;
        }
        if (cmd.getName().equals(Command.listDetachedTools().getName())) {
            boolean isSilently = (Boolean)cmd.getFirstParam();
            boolean retry = (Boolean)cmd.getSecondParam();
            cmd.setReturnValue(pair.listDetachedTools(isSilently, retry));
            return;
        }
        if (cmd.getName().equals(Command.listToolsWithType().getName())) {
            boolean recommended = (Boolean)cmd.getFirstParam();
            boolean isSilently = (Boolean)cmd.getSecondParam();
            boolean retry = (Boolean)cmd.getThirdParam();
            boolean skipDetached = (Boolean)cmd.getFourthParam();
            ActionType type = (ActionType)cmd.getFifthParam();
            cmd.setReturnValue(pair.listTools(recommended, isSilently, retry, skipDetached, type));
            return;
        }
        if (cmd.getName().equals(Command.listOptionalToolsWithType().getName())) {
            boolean isSilently = (Boolean)cmd.getFirstParam();
            boolean retry = (Boolean)cmd.getSecondParam();
            boolean skipDetached = (Boolean)cmd.getThirdParam();
            boolean includeInactive = (Boolean)cmd.getFourthParam();
            ActionType type = (ActionType)cmd.getFifthParam();
            cmd.setReturnValue(pair.listOptionalTools(isSilently, retry, skipDetached, includeInactive, type));
            return;
        }
        if (cmd.getName().equals(Command.listDetachedToolsWithType().getName())) {
            boolean isSilently = (Boolean)cmd.getFirstParam();
            boolean retry = (Boolean)cmd.getSecondParam();
            ActionType type = (ActionType)cmd.getThirdParam();
            cmd.setReturnValue(pair.listDetachedTools(isSilently, retry, type));
            return;
        }
        if (cmd.getName().equals(Command.cancel().getName())) {
            boolean blocking = (Boolean)cmd.getFirstParam();
            pair.cancel(blocking);
            return;
        }
        if (cmd.getName().equals(Command.setPriority().getName())) {
            int stepIdx = (Integer)cmd.getFirstParam();
            int pri = (Integer)cmd.getSecondParam();
            pair.setPriority(stepIdx, pri);
            return;
        }
        if (cmd.getName().equals(Command.getPriority().getName())) {
            int stepIdx = (Integer)cmd.getFirstParam();
            int pri = pair.getPriority(stepIdx);
            cmd.setReturnValue(new Integer(pri));
            return;
        }
        if (cmd.getName().equals(Command.getStepCount().getName())) {
            cmd.setReturnValue(new Integer(pair.getCfmAction().getStepCount()));
            return;
        }
        if (cmd.getName().equals(Command.getActionState().getName())) {
            cmd.setReturnValue(pair.getCfmActionStateReference());
            return;
        }
        if (cmd.getName().equals(Command.getConditionOfActionStep().getName())) {
            int stepIdx = (Integer)cmd.getFirstParam();
            cmd.setReturnValue(pair.getCfmActionStepConditionRef(stepIdx));
            return;
        }
        if (cmd.getName().equals(Command.getConditionOfAction().getName())) {
            cmd.setReturnValue(pair.getCfmActionConditionRef());
            return;
        }
        if (cmd.getName().equals(Command.setAllPlugIns().getName())) {
            boolean isActive = (Boolean)cmd.getFirstParam();
            pair.setActive(isActive);
            return;
        }
        throw new CfwException("Action UnImplemented command = " + cmd);
    }

    void processPlugInCommands(Cfm cfm, IPlugInReference ref, ICommand cmd) throws CfwException {
        CustomizableType[] types;
        Object res;
        CfmAggregateHolder holder = cfm.getAggregateHolderLatestLabel(ref.getOwnerFamily());
        if (holder == null) {
            throw new CfwException("Invalid IPlugInReference specified = " + ref + " for command = " + cmd);
        }
        CfmPlugIn plug = null;
        for (CfmPlugIn plugInToTest : holder.getCfmAggregate().getPlugIns()) {
            if (!plugInToTest.getSelfID().equals(ref.getSelfID())) continue;
            plug = plugInToTest;
            break;
        }
        if (plug == null) {
            throw new CfwException("Invalid IPlugInReference specified = " + ref + " for command = " + cmd);
        }
        if (cmd.getName().equals(Command.getDesc().getName())) {
            res = plug.getDesc();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getOracleHome().getName())) {
            String oh = holder.getOracleHome();
            cmd.setReturnValue(oh);
            return;
        }
        if (cmd.getName().equals(Command.getReference().getName())) {
            res = new PlugInReference(plug.getSelfID(), holder.getFamilyIdentifier());
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getSelfID().getName())) {
            res = plug.getSelfID();
            cmd.setReturnValue(res);
            return;
        }
        if (cmd.getName().equals(Command.getParent().getName())) {
            cmd.setReturnValue(holder.getSelfReference());
            return;
        }
        if (cmd.getName().equals(Command.setActiveOfPlugIn().getName())) {
            boolean newActive = (Boolean)cmd.getFirstParam();
            plug.setActive(newActive);
            return;
        }
        if (cmd.getName().equals(Command.isActiveOfPlugIn().getName())) {
            Boolean newActive = plug.isActive();
            cmd.setReturnValue(newActive);
            return;
        }
        if (cmd.getName().equals(Command.getDisplayName().getName())) {
            cmd.setReturnValue(plug.getDisplayName());
            return;
        }
        if (cmd.getName().equals(Command.getLocalizedDisplayName().getName())) {
            cmd.setReturnValue(plug.getLocalizedDisplayName());
            return;
        }
        if (cmd.getName().equals(Command.getDisplayId().getName())) {
            cmd.setReturnValue(plug.getDisplayId());
            return;
        }
        if (cmd.getName().equals(Command.getTypesOfPlugIn().getName())) {
            types = plug.getTypes();
            cmd.setReturnValue(types);
            return;
        }
        if (cmd.getName().equals(Command.isTypeOfPlugIn().getName())) {
            PlugInType type = (PlugInType)cmd.getFirstParam();
            cmd.setReturnValue(plug.isType(type));
            return;
        }
        if (cmd.getName().equals(Command.isWithinTypesVsAction().getName())) {
            types = (ActionType[])cmd.getFirstParam();
            cmd.setReturnValue(plug.isWithinTypes((ActionType[])types));
            return;
        }
        if (cmd.getName().equals(Command.isWithinTypesVsOperation().getName())) {
            types = (OperationType[])cmd.getFirstParam();
            cmd.setReturnValue(plug.isWithinOperations((OperationType[])types));
            return;
        }
        if (cmd.getName().equals(Command.replaceWith().getName())) {
            String pgm = (String)cmd.getFirstParam();
            String[] args = (String[])cmd.getSecondParam();
            plug.replaceWith(pgm, args);
            return;
        }
        throw new CfwException("invalid (PlugIn method) command = " + cmd);
    }

    void processMicroStepStateCommand(CfmAggregateHolder aggregateHolder, IMicroStepStateReference ref, ICommand cmd) throws CfwException {
        CfmMicroStepPair microPair = aggregateHolder.getMicroStepPair(ref.getActionID(), ref.getStepIndex(), ref.getMicroStepIndex());
        if (cmd.getName().equals(Command.getSelfID().getName())) {
            cmd.setReturnValue(microPair.getSelfID());
            return;
        }
        if (cmd.getName().equals(Command.getStatus().getName())) {
            MicroStepStatus stat = microPair.getMicroStepStatus();
            cmd.setReturnValue(stat);
            return;
        }
        if (cmd.getName().equals(Command.getPlugInInvocationState().getName())) {
            MicroStepStateReference msRef = new MicroStepStateReference(microPair);
            cmd.setReturnValue(msRef);
            return;
        }
        if (cmd.getName().equals(Command.getStatusDetails().getName())) {
            String result = microPair.getStatusDetails();
            cmd.setReturnValue(result);
            return;
        }
        if (cmd.getName().equals(Command.getActionStepStateOfMicroStep().getName())) {
            CfmActionStepPair stepPair = aggregateHolder.getActionStepPair(ref.getActionID(), ref.getStepIndex());
            ActionStepStateReference stepRef = new ActionStepStateReference(stepPair);
            cmd.setReturnValue(stepRef);
            return;
        }
        if (cmd.getName().equals(Command.getActionStateOfMicroStep().getName())) {
            CfmActionPair actionPair = aggregateHolder.getActionPairById(ref.getActionID());
            ActionStateReference actionRef = new ActionStateReference(actionPair);
            cmd.setReturnValue(actionRef);
            return;
        }
        if (cmd.getName().equals(Command.getPlugInIDOfMicroStepState().getName())) {
            cmd.setReturnValue(microPair.getPlugInInvocationStateNoNull().getPlugInID());
            return;
        }
        if (cmd.getName().equals(Command.getFlavorOfMicroStep().getName())) {
            cmd.setReturnValue(microPair.getFlavor());
            return;
        }
        if (cmd.getName().equals(Command.getSummary().getName())) {
            cmd.setReturnValue(microPair.getSummary());
            return;
        }
        if (cmd.getName().equals(Command.getCommand().getName())) {
            cmd.setReturnValue(microPair.getCommand());
            return;
        }
        if (cmd.getName().equals(Command.getArg().getName())) {
            cmd.setReturnValue(microPair.getArg());
            return;
        }
        if (cmd.getName().equals(Command.getNextInvocationArgs().getName())) {
            boolean silentPlugIns = (Boolean)cmd.getFirstParam();
            boolean replaceTransientWithName = (Boolean)cmd.getSecondParam();
            boolean replaceUninitializedWithName = (Boolean)cmd.getThirdParam();
            cmd.setReturnValue(microPair.getPlugInInvocationStateNoNull().getNextInvocationArgsTEMP(silentPlugIns, replaceTransientWithName, replaceUninitializedWithName));
            return;
        }
        if (cmd.getName().equals(Command.getException().getName())) {
            cmd.setReturnValue(microPair.getPlugInInvocationStateNoNull().getException());
            return;
        }
        if (cmd.getName().equals(Command.getStdout().getName())) {
            cmd.setReturnValue(microPair.getPlugInInvocationStateNoNull().getStdout());
            return;
        }
        if (cmd.getName().equals(Command.getStderr().getName())) {
            cmd.setReturnValue(microPair.getPlugInInvocationStateNoNull().getStderr());
            return;
        }
        if (cmd.getName().equals(Command.getExitCode().getName())) {
            cmd.setReturnValue(new Long(microPair.getPlugInInvocationStateNoNull().getExitCode()));
            return;
        }
        if (cmd.getName().equals(Command.getPlugInIDOfPlugInInvocationState().getName())) {
            cmd.setReturnValue(microPair.getPlugInInvocationStateNoNull().getPlugInID());
            return;
        }
        if (cmd.getName().equals(Command.setActiveOfPlugInInvocation().getName())) {
            boolean newActive = (Boolean)cmd.getFirstParam();
            microPair.getPlugInInvocationStateNoNull().setActive(newActive);
            return;
        }
        if (cmd.getName().equals(Command.isActiveOfPlugInInvocation().getName())) {
            cmd.setReturnValue(microPair.getPlugInInvocationStateNoNull().isActive());
            return;
        }
        throw new CfwException("UnImplements MicroStepState command = " + cmd.getName());
    }

    void processActionStepStateCommand(CfmAggregateHolder aggregateHolder, IActionStepStateReference ref, ICommand cmd) throws CfwException {
        CfmActionStepPair stepPair = aggregateHolder.getActionStepPair(ref.getActionID(), ref.getStepIndex());
        CfmActionStepState state = stepPair.getCfmActionStepState();
        if (cmd.getName().equals(Command.getStatus().getName())) {
            cmd.setReturnValue(stepPair.getStatus());
            return;
        }
        if (cmd.getName().equals(Command.getMicroStepStates().getName())) {
            cmd.setReturnValue(stepPair.getCfmMicroStepStateReferences());
            return;
        }
        if (cmd.getName().equals(Command.getMicroStepState().getName())) {
            int idx = (Integer)cmd.getFirstParam();
            cmd.setReturnValue(stepPair.getCfmMicroStepStateReference(idx));
            return;
        }
        if (cmd.getName().equals(Command.getFailedMicroStepState().getName())) {
            cmd.setReturnValue(stepPair.getCfmMicroStepStateReference(state.getFailedMicroStepIndex()));
            return;
        }
        if (cmd.getName().equals(Command.getWeightOfStep().getName())) {
            cmd.setReturnValue(new Integer(stepPair.getWeight()));
            return;
        }
        if (cmd.getName().equals(Command.isRequiredOfStep().getName())) {
            cmd.setReturnValue(new Boolean(stepPair.isRequired()));
            return;
        }
        throw new CfwException("invalid ActionStepState Ref=" + ref + " for command=" + cmd.getName());
    }

    void processActionStateCommand(CfmAggregateHolder aggregateHolder, IActionStateReference ref, ICommand cmd) throws CfwException {
        CfmActionPair actionPair = aggregateHolder.getActionPairById(ref.getSelfID());
        CfmActionState state = actionPair.getCfmActionState();
        if (cmd.getName().equals(Command.getStatus().getName())) {
            ActionStatus stat = state.getActionStatus();
            cmd.setReturnValue(stat);
            return;
        }
        if (cmd.getName().equals(Command.getActionStepStates().getName())) {
            cmd.setReturnValue(state.getActionStepStateReferences2(aggregateHolder));
            return;
        }
        if (cmd.getName().equals(Command.getActionStepState().getName())) {
            int idx = (Integer)cmd.getFirstParam();
            cmd.setReturnValue(state.getCfmActionStepStateReference2(idx, aggregateHolder));
            return;
        }
        if (cmd.getName().equals(Command.getFailedStepStateIndex().getName())) {
            Integer failedIdx = new Integer(state.getFailedStepStateIndex());
            cmd.setReturnValue(failedIdx);
            return;
        }
        if (cmd.getName().equals(Command.getOriginator().getName())) {
            AggregateReference aref = new AggregateReference(aggregateHolder.getFamilyIdentifier(), true);
            cmd.setReturnValue(aref);
            return;
        }
        throw new CfwException("invalid (ActionState method) command = " + cmd);
    }

    void command(IStateReference ref, ICommand cmd) throws CfwException {
        CfmAggregateHolder aggregateHolder;
        if (cmd == null || ref == null) {
            throw new CfwException("command with IStateReference parameter: invalid (null) cmd or reference!");
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "IStateReference type command is being processed=" + cmd.getName());
        }
        if ((aggregateHolder = this.cfm.getAggregateHolderLatestLabel(ref.getOwnerFamily())) == null) {
            throw new CfwException("Invalid IStateReference specified = " + ref + " for command = " + cmd.getName());
        }
        if (ref instanceof IMicroStepStateReference) {
            this.processMicroStepStateCommand(aggregateHolder, (IMicroStepStateReference)ref, cmd);
        } else if (ref instanceof IActionStateReference) {
            this.processActionStateCommand(aggregateHolder, (IActionStateReference)ref, cmd);
        } else if (ref instanceof IActionStepStateReference) {
            this.processActionStepStateCommand(aggregateHolder, (IActionStepStateReference)ref, cmd);
        } else {
            throw new CfwException("invalid (unknown type) reference = " + ref + " for command=" + cmd.getName());
        }
    }
}

