/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.core.CfmOwnedParameterRef;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParameterPair;
import oracle.sysman.emCfg.core.CfmSelfDependencyConcat;
import oracle.sysman.emCfg.core.CfmSelfDependencyCopyFrom;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.ParameterUsePolicy;
import oracle.sysman.emCfg.schema.descriptions.AnyParameterRefT;
import oracle.sysman.emCfg.schema.descriptions.SelfDependencyConcatType;
import oracle.sysman.emCfg.schema.descriptions.SelfDependencyCopyFromType;
import oracle.sysman.emCfg.schema.descriptions.SelfDependencyType;

abstract class CfmSelfDependency {
    CfmSelfDependency() {
    }

    public static CfmSelfDependency getInstance(DescriptionsLoader loader, SelfDependencyType sd1, SelfDependencyCopyFromType sd2, SelfDependencyConcatType sd3, CfmParameter owner) {
        if (sd1 != null) {
            return null;
        }
        if (sd2 != null) {
            return new CfmSelfDependencyCopyFrom(loader, sd2, owner);
        }
        if (sd3 != null) {
            return new CfmSelfDependencyConcat(loader, sd3, owner);
        }
        return null;
    }

    abstract String evaluate(CfmParameterPair var1) throws CfwException;

    CfmOwnedParameterRef getOwnedParameterRef(DescriptionsLoader loader, AnyParameterRefT ref, CfmParameter owner) {
        String nsRef;
        String ownerRef = ref.getOwner();
        if (ownerRef == null) {
            ownerRef = loader.getCurrentOwnerID();
        }
        if ((nsRef = ref.getNs()) == null) {
            nsRef = loader.getCurrentNS();
        }
        return new CfmOwnedParameterRef(loader, ref, new CfwIdentifier(ownerRef, nsRef), loader.getCurrentAggregate(), CfmSelfDependency.getPolicy(owner.isEncrypted()));
    }

    private static ParameterUsePolicy getPolicy(boolean isEncrypted) {
        if (isEncrypted) {
            return ParameterUsePolicy.SELF_DEPENDENCY_ENCRYPTED_POLICY;
        }
        return ParameterUsePolicy.SELF_DEPENDENCY_UNENCRYPTED_POLICY;
    }
}

