/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.logging.Level;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregateActionRef;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.CfmWrapper;
import oracle.sysman.emCfg.core.CfwOwner;
import oracle.sysman.emCfg.core.CfwOwnerWithLocation;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.IResolvable;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.descriptions.ActionRefT;
import oracle.sysman.emCfg.schema.descriptions.AggregateActionRefT;
import oracle.sysman.emCfg.schema.descriptions.AggregateOperationRefType;
import oracle.sysman.emCfg.schema.descriptions.AggregateRefT;
import oracle.sysman.emCfg.schema.descriptions.AnyRefT;
import oracle.sysman.emCfg.schema.descriptions.ConditionRefT;
import oracle.sysman.emCfg.schema.descriptions.DerivedParameterRef;
import oracle.sysman.emCfg.schema.descriptions.DerivedVirtualParameterRef;
import oracle.sysman.emCfg.schema.descriptions.OperationRefT;
import oracle.sysman.emCfg.schema.descriptions.ParameterArgumentRefType;
import oracle.sysman.emCfg.schema.descriptions.ParameterModelRefT;
import oracle.sysman.emCfg.schema.descriptions.ParameterRefType;
import oracle.sysman.emCfg.schema.descriptions.PlugInModelRef;
import oracle.sysman.emCfg.schema.descriptions.PlugInRef;
import oracle.sysman.emCfg.schema.descriptions.VirtualParameterRef;
import oracle.sysman.emCfg.support.CfmUtil;

abstract class CfmReference
extends CfmWrapper
implements IResolvable {
    private static final boolean debug = Cfm.isDebug();
    private static final CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private final String idRef;
    private final String ownerIdRef;
    private final AggregateVersion versionRef;
    private final String nsRef;
    private final OHAbsolute ohRef;
    private boolean overrideOwnerRefWithNull = false;
    protected CfmTaggedObject cfmTaggedObject = null;

    private CfmReference(DescriptionsLoader loader, Object jaxbOrigin, String idRef, String ownerIdRef, AggregateVersion versionRef, String nsRef, OHAbsolute ohRef) {
        super(loader, jaxbOrigin);
        this.idRef = idRef;
        this.ownerIdRef = ownerIdRef;
        this.versionRef = versionRef;
        this.nsRef = nsRef;
        this.ohRef = ohRef;
        CfmUtil.myAssert(ohRef != null && versionRef != AggregateVersion.LATEST || this instanceof CfmAggregateRef);
        if (!(idRef != null && idRef.trim().length() != 0 || this instanceof CfmAggregateActionRef)) {
            throw new IllegalArgumentException("The idRef cannot be empty");
        }
        if (debug) {
            this.debugVerify(jaxbOrigin);
        }
    }

    public CfmReference(DescriptionsLoader loader, String idRef, CfwOwnerWithLocation ownerRef) {
        this(loader, null, idRef, ownerRef.getSelfID(), ownerRef.getVersion(), ownerRef.getNamespace(), ownerRef.getOH());
    }

    public CfmReference(DescriptionsLoader loader, String idRef, CfmTaggedObject ownerRef) {
        this(loader, null, idRef, ownerRef.getSelfID(), ownerRef.getVersion(), ownerRef.getNamespace(), ownerRef.getOHAbs());
    }

    public CfmReference(DescriptionsLoader loader, Object jaxbOrigin, AggregateDescriptionIdentifier referredAggregate) {
        this(loader, jaxbOrigin, referredAggregate.getSelfID(), null, referredAggregate.getVersion(), referredAggregate.getNamespace(), null);
    }

    public CfmReference(DescriptionsLoader loader, Object jaxbOrigin, String idRef, CfmTaggedObject ownerRef) {
        this(loader, jaxbOrigin, idRef, ownerRef.getSelfID(), ownerRef.getVersion(), ownerRef.getNamespace(), ownerRef.getOHAbs());
    }

    protected abstract CfmElementType[] getPossibleReferredTypes();

    @Override
    public String getSelfID() {
        return null;
    }

    public CfmTaggedObject getCfmTaggedObject() {
        return this.cfmTaggedObject;
    }

    public String getIdref() {
        return this.idRef;
    }

    public String getOwnerRef() {
        if (this.overrideOwnerRefWithNull) {
            return null;
        }
        return this.ownerIdRef;
    }

    public AggregateVersion getVersionRef() {
        return this.versionRef;
    }

    public String getNsRef() {
        return this.nsRef;
    }

    public CfwOwner getOwnerIdent() {
        return new CfwOwner(this.getOwnerRef(), this.getVersionRef(), this.getNsRef());
    }

    public void tryNoOwner(boolean noOwner) {
        this.overrideOwnerRefWithNull = noOwner;
    }

    public String getDisplayName() {
        return "{" + this.getClass().getName() + " ref to " + this.getIdref() + ":" + this.getOwnerRef() + ":" + this.getVersionRef() + ":" + this.getNsRef() + "}";
    }

    public String toString() {
        return this.getDisplayName() + " ==> " + (this.cfmTaggedObject != null ? " resolved to " + this.cfmTaggedObject.getClass().getName() : "not resolved");
    }

    @Override
    public boolean resolve() {
        if (debug) {
            cfmLogger.log(Level.FINEST, "CfmReference.resolve(): attempting resolve a ref based on " + this.getDisplayName());
        }
        if (this.cfmTaggedObject != null) {
            return true;
        }
        CfwOwnerWithLocation actualOwner = this.getActualOwner();
        if (actualOwner == null) {
            return false;
        }
        return this.resolvePrivate(actualOwner);
    }

    protected boolean resolvePrivate(CfwOwnerWithLocation actualOwner) {
        CfmElementType[] jaxbPossibleClasses = this.getPossibleReferredTypes();
        for (int i = 0; i < jaxbPossibleClasses.length; ++i) {
            if (!this.resolvePrivate(jaxbPossibleClasses[i], actualOwner)) continue;
            return true;
        }
        if (debug) {
            cfmLogger.log(Level.FINEST, "CfmReference.resolve(): failed to resolve (on classes) a ref based on " + this.getDisplayName());
        }
        return false;
    }

    protected boolean resolvePrivate(CfmElementType referredJaxbClass, CfwOwnerWithLocation actualOwner) {
        if (debug) {
            cfmLogger.log(Level.FINEST, "CfmReference.resolvePrivate: attempting to resolve (on referred class) a ref based on " + this.getDisplayName() + " as " + referredJaxbClass);
        }
        CfmUtil.myAssert(referredJaxbClass != null);
        DescriptionsLoader loader = this.getLoader();
        if (loader == null) {
            throw new Error("CfmReference.resolvePrivate: there is no loader");
        }
        try {
            this.cfmTaggedObject = loader.getObjectFactory().getFromHash(referredJaxbClass, this.getIdref(), actualOwner);
        }
        catch (CfwException e) {
            if (debug) {
                cfmLogger.log(Level.FINEST, "CfmReference.resolvePrivate: failed to resolve (on referred class) a ref based on " + this.getDisplayName() + " as " + referredJaxbClass);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isResolved() {
        return this.cfmTaggedObject != null;
    }

    protected CfwIdentifier getVersionlessAggregateOwner() {
        return new CfwIdentifier(this.getOwnerRef(), this.getNsRef());
    }

    protected CfwOwnerWithLocation getActualOwner() {
        if (!(this instanceof CfmAggregateRef)) {
            return new CfwOwnerWithLocation(this.getOwnerIdent().getSelfID(), this.getOwnerIdent().getVersion(), this.getOwnerIdent().getNamespace(), this.ohRef);
        }
        CfmAggregateRef aggRef = (CfmAggregateRef)this;
        AggregateDescriptionIdentifierWithLocation actual = aggRef.getActualReferredAggregateIdentifierWithLocation(cfmLogger);
        if (actual == null) {
            return null;
        }
        return new CfwOwnerWithLocation(actual);
    }

    private void debugVerify(Object jaxbOrigin) {
        if (jaxbOrigin instanceof AnyRefT) {
            String ns;
            AnyRefT anyRefT = (AnyRefT)jaxbOrigin;
            String owner = anyRefT.getOwner();
            if (owner != null) {
                CfmUtil.myAssert(owner.equals(this.getOwnerRef()));
            }
            if ((ns = anyRefT.getNs()) == null) {
                CfmUtil.myAssert(this.nsRef.equals("common"));
            } else {
                CfmUtil.myAssert(this.nsRef.equals(ns));
            }
        }
        if (jaxbOrigin instanceof ParameterRefType || jaxbOrigin instanceof DerivedParameterRef || jaxbOrigin instanceof VirtualParameterRef || jaxbOrigin instanceof DerivedVirtualParameterRef || jaxbOrigin instanceof PlugInRef || jaxbOrigin instanceof PlugInModelRef || jaxbOrigin instanceof ParameterModelRefT || jaxbOrigin instanceof AggregateRefT || jaxbOrigin instanceof ActionRefT || jaxbOrigin instanceof OperationRefT || jaxbOrigin instanceof AggregateOperationRefType || jaxbOrigin instanceof AggregateActionRefT || jaxbOrigin instanceof ConditionRefT || jaxbOrigin instanceof ParameterArgumentRefType || jaxbOrigin instanceof AggregateRefT) {
            CfmUtil.myAssert(CfmUtil.nullOrEqual(this.idRef, CfmUtil.genericGet(String.class, jaxbOrigin, "Idref")));
        }
    }
}

