/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmActionStep;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmCmdExec;
import oracle.sysman.emCfg.core.CfmPlugIn;
import oracle.sysman.emCfg.core.CfmPlugInArguments;
import oracle.sysman.emCfg.core.CfmPlugInRef;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.CfmWrapper;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.schema.descriptions.NonSilentInvocationT;
import oracle.sysman.emCfg.schema.descriptions.PlugInInvocationT;
import oracle.sysman.emCfg.schema.descriptions.PlugInRefType;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmPlugInInvocation
extends CfmWrapper {
    private final CfmPlugInRef plugInRef;
    private final String classPath;
    private final boolean displayB;
    private final CfmPlugInArguments defaultInvocationArgs;
    private final CfmPlugInArguments nonSilentInvocationArgs;
    private final CfmAggregate parentAggregate;

    public CfmPlugInInvocation(DescriptionsLoader loader, PlugInInvocationT plugInInvocationT, CfmActionStep actionStep, CfmTaggedObject owner) throws CfwException {
        super(loader, plugInInvocationT);
        CfmPlugInRef plugInRef;
        PlugInRefType plugInRefT = plugInInvocationT.getPlugInRef();
        if (plugInRefT == null) {
            throw new CfwException("PlugInInvocation in " + actionStep + " is missing the required PlugInRef");
        }
        this.plugInRef = plugInRef = new CfmPlugInRef(loader, plugInRefT, owner);
        loader.getCfm().getDescriptionResolver().addUnresolved(plugInRef);
        this.parentAggregate = actionStep.getAction().getParentAggregate();
        this.classPath = CfmPlugInInvocation.processCp(this.getOracleHome(), plugInInvocationT.getCp());
        this.displayB = plugInInvocationT.isDisplay();
        this.defaultInvocationArgs = new CfmPlugInArguments(plugInInvocationT.getParameterArgumentRefOrOptionArgument(), loader, owner);
        NonSilentInvocationT nonSilentInvocationT = plugInInvocationT.getNonSilentInvocation();
        this.nonSilentInvocationArgs = nonSilentInvocationT != null ? new CfmPlugInArguments(nonSilentInvocationT.getParameterArgumentRefOrOptionArgument(), loader, owner) : null;
    }

    private static String processCp(String oraHome, String jarListS) {
        if (jarListS == null || jarListS.length() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        String[] jars = jarListS.split(";");
        if (jars.length > 0) {
            result.append(CfmUtil.evaluatePath(jars[0], oraHome));
            for (int i = 1; i < jars.length; ++i) {
                result.append(File.pathSeparator);
                result.append(CfmUtil.evaluatePath(jars[i], oraHome));
            }
        }
        return result.toString();
    }

    public String getOracleHome() {
        return this.parentAggregate.getOHAbs().toString();
    }

    public String evaluateClasspath(CfmAggregateHolder holder) throws CfwException {
        String basePluginClasspath = CfmPlugInInvocation.processCp(this.getOracleHome(), this.getPlugInNoNull().evaluateClasspath(holder));
        return CfmUtil.combinePaths(basePluginClasspath, this.classPath);
    }

    public boolean isDisplay() {
        return this.displayB;
    }

    public String getPlugInIdRef() {
        return this.plugInRef.getIdref();
    }

    public CfmPlugIn getPlugInNoNull() throws CfwException {
        CfmPlugIn plugIn = this.plugInRef.getPlugIn();
        if (plugIn == null) {
            throw new CfwException("The PlugInRef could not be resolved for " + this.toString());
        }
        return plugIn;
    }

    public boolean isAttached() throws CfwException {
        return this.getPlugInNoNull().isInvocationAttached();
    }

    public boolean isReRunnable() throws CfwException {
        return this.getPlugInNoNull().isReRunnable();
    }

    boolean isInternal(boolean nonSilent) throws CfwException {
        return this.getPlugInNoNull().isInternal(nonSilent);
    }

    boolean isJava(boolean nonSilent) throws CfwException {
        return this.getPlugInNoNull().isJava(nonSilent);
    }

    public boolean isUseCommandArray() throws CfwException {
        return this.getPlugInNoNull().isUseCommandArray();
    }

    CfmCmdExec getCmdExec(boolean nonSilent) throws CfwException {
        return this.getPlugInNoNull().getCmdExec(nonSilent);
    }

    String getJavaClass(boolean nonSilentB) throws CfwException {
        return this.getPlugInNoNull().getJavaClass(nonSilentB);
    }

    String getJavaClassMethod(boolean nonSilentB) throws CfwException {
        return this.getPlugInNoNull().getJavaClassMethod(nonSilentB);
    }

    boolean hasNonSilentInvocation() {
        return this.nonSilentInvocationArgs != null;
    }

    List getArg(boolean nonSilent) throws CfwException {
        List args = nonSilent && this.nonSilentInvocationArgs != null ? this.nonSilentInvocationArgs.getArgs() : this.defaultInvocationArgs.getArgs();
        List result = this.getPlugInNoNull().getArg(nonSilent);
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public String toString() {
        return "CfmPlugInInvocation: displayB=" + this.displayB + ",\n" + "plugInModelRef=" + this.plugInRef + ",\nEnd-of-CfmPlugInInvocation";
    }
}

