/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmAnyPlugInModel;
import oracle.sysman.emCfg.core.CfmCmdExec;
import oracle.sysman.emCfg.core.CfmPlugInArguments;
import oracle.sysman.emCfg.core.CfmPlugInModelRef;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.CfmWrapper;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.schema.descriptions.NonSilentT;
import oracle.sysman.emCfg.schema.descriptions.PlugInModelRefType;
import oracle.sysman.emCfg.schema.descriptions.PlugInT;

class CfmPlugInCore
extends CfmWrapper {
    private final boolean nonSilentB;
    private final CfmPlugInModelRef plugInModelRef;
    private final CfmPlugInArguments arguments;
    private List manualArgs = null;
    private CfmCmdExec cmdExec;
    private String javaClass;
    private String javaClassMethod;

    public CfmPlugInCore(DescriptionsLoader loader, NonSilentT nonSilentT, CfmTaggedObject owner) throws CfwException {
        super(loader, nonSilentT);
        this.nonSilentB = true;
        this.cmdExec = CfmCmdExec.getInstance(loader, nonSilentT.getCmdExec(), owner);
        this.setJavaClassMethod(nonSilentT.getJavaClassMethod());
        this.setJavaClass(nonSilentT.getJavaClass());
        this.plugInModelRef = CfmPlugInCore.processPlugInModelRef(nonSilentT.getPlugInModelRef(), loader, owner);
        this.arguments = new CfmPlugInArguments(nonSilentT.getParameterArgumentRefOrOptionArgument(), loader, owner);
    }

    public CfmPlugInCore(DescriptionsLoader loader, PlugInT plugInT, CfmTaggedObject owner) throws CfwException {
        super(loader, plugInT);
        this.nonSilentB = false;
        this.cmdExec = CfmCmdExec.getInstance(loader, plugInT.getCmdExec(), owner);
        this.setJavaClassMethod(plugInT.getJavaClassMethod());
        this.setJavaClass(plugInT.getJavaClass());
        this.plugInModelRef = CfmPlugInCore.processPlugInModelRef(plugInT.getPlugInModelRef(), loader, owner);
        this.arguments = new CfmPlugInArguments(plugInT.getParameterArgumentRefOrOptionArgument(), loader, owner);
    }

    private static CfmPlugInModelRef processPlugInModelRef(PlugInModelRefType plugInModelRefT, DescriptionsLoader loader, CfmTaggedObject owner) {
        if (plugInModelRefT == null) {
            return null;
        }
        CfmPlugInModelRef result = new CfmPlugInModelRef(loader, plugInModelRefT, owner);
        loader.getCfm().getDescriptionResolver().addUnresolved(result);
        return result;
    }

    public String toString() {
        return "CfmPlugInCore: cmdExec=>" + this.cmdExec + ", javaClass=>" + this.javaClass + ", javaClassMethod=>" + this.javaClassMethod + ",\n" + "plugInModelRef=>" + this.plugInModelRef + "\nEnd-of-CfmPlugInCore";
    }

    public void setManualArgs(List manualArgs) {
        this.manualArgs = manualArgs;
    }

    boolean isNonSilent() {
        return this.nonSilentB;
    }

    public void setCmdExec(String cmdExec) {
        this.cmdExec.replaceWith(cmdExec);
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }

    public void setJavaClassMethod(String javaClassMethod) {
        this.javaClassMethod = javaClassMethod;
    }

    public List getArg() throws CfwException {
        List result;
        if (this.manualArgs != null) {
            return new Vector(this.manualArgs);
        }
        if (this.plugInModelRef == null) {
            result = new Vector();
        } else {
            CfmTaggedObject o = this.plugInModelRef.getPlugInModel();
            if (o == null) {
                throw new CfwException("CfmPlugInCore.getArg: unresolved plugIn model reference " + this.plugInModelRef);
            }
            if (!(o instanceof CfmAnyPlugInModel)) {
                throw new CfwException("CfmPlugInCore.getArg: invalid plugIn model reference " + this.plugInModelRef);
            }
            CfmAnyPlugInModel plugInModel = (CfmAnyPlugInModel)o;
            result = plugInModel.getPlugInArgs();
        }
        Iterator iter = this.arguments.getArgs().iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public boolean isJava() throws CfwException {
        if (this.plugInModelRef != null) {
            CfmTaggedObject o = this.plugInModelRef.getPlugInModel();
            if (o == null) {
                throw new CfwException("CfmPlugInCore.isJava: unresolved plugIn model reference " + this.plugInModelRef);
            }
            if (!(o instanceof CfmAnyPlugInModel)) {
                throw new CfwException("CfmPlugInCore.isJava: invalid plugIn model reference " + this.plugInModelRef);
            }
            CfmAnyPlugInModel plugInModel = (CfmAnyPlugInModel)o;
            return plugInModel.isJava();
        }
        return this.javaClass != null || this.javaClassMethod != null;
    }

    public boolean isInternal() throws CfwException {
        if (this.plugInModelRef != null) {
            CfmTaggedObject o = this.plugInModelRef.getPlugInModel();
            if (o == null) {
                throw new CfwException("CfmPlugInCore.isInternal: unresolved plugIn model reference " + this.plugInModelRef);
            }
            if (!(o instanceof CfmAnyPlugInModel)) {
                throw new CfwException("CfmPlugInCore.isInternal: invalid plugIn model reference " + this.plugInModelRef);
            }
            CfmAnyPlugInModel plugInModel = (CfmAnyPlugInModel)o;
            return plugInModel.isInternal();
        }
        return this.javaClass != null;
    }

    public CfmCmdExec getCmdExec() throws CfwException {
        if (this.plugInModelRef != null) {
            CfmTaggedObject o = this.plugInModelRef.getPlugInModel();
            if (o == null) {
                throw new CfwException("CfmPlugInCore.getCmdExec: unresolved plugIn model reference " + this.plugInModelRef);
            }
            if (!(o instanceof CfmAnyPlugInModel)) {
                throw new CfwException("CfmPlugInCore.getCmdExec: invalid plugIn model reference " + this.plugInModelRef);
            }
            CfmAnyPlugInModel plugInModel = (CfmAnyPlugInModel)o;
            return plugInModel.getCmdExec();
        }
        return this.cmdExec;
    }

    public String getJavaClass() throws CfwException {
        if (this.plugInModelRef != null) {
            CfmTaggedObject o = this.plugInModelRef.getPlugInModel();
            if (o == null) {
                throw new CfwException("CfmPlugInCore.getJavaClass: unresolved plugIn model reference " + this.plugInModelRef);
            }
            if (!(o instanceof CfmAnyPlugInModel)) {
                throw new CfwException("CfmPlugInCore.getJavaClass: invalid plugIn model reference " + this.plugInModelRef);
            }
            CfmAnyPlugInModel plugInModel = (CfmAnyPlugInModel)o;
            return plugInModel.getJavaClass();
        }
        return this.javaClass;
    }

    public String getJavaClassMethod() throws CfwException {
        if (this.plugInModelRef != null) {
            CfmTaggedObject o = this.plugInModelRef.getPlugInModel();
            if (o == null) {
                throw new CfwException("CfmPlugInCore.getJavaClassMethod: unresolved plugIn model reference " + this.plugInModelRef);
            }
            if (!(o instanceof CfmAnyPlugInModel)) {
                throw new CfwException("CfmPlugInCore.getJavaClassMethod: invalid plugIn model reference " + this.plugInModelRef);
            }
            CfmAnyPlugInModel plugInModel = (CfmAnyPlugInModel)o;
            return plugInModel.getJavaClassMethod();
        }
        return this.javaClassMethod;
    }
}

