/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IPlugIn;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmCmdExec;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmExpandableString;
import oracle.sysman.emCfg.core.CfmPlugInCore;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.ParameterUsePolicy;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.descriptions.DisplayResourceJarType;
import oracle.sysman.emCfg.schema.descriptions.NonSilentT;
import oracle.sysman.emCfg.schema.descriptions.PlugInT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.JarClassLoader;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.OperationType;
import oracle.sysman.emCfg.types.PlugInInvocation;
import oracle.sysman.emCfg.types.PlugInMode;
import oracle.sysman.emCfg.types.PlugInType;
import oracle.sysman.emCfg.types.StatusOrType;

class CfmPlugIn
extends CfmTaggedObject
implements IPlugIn {
    public static final CfmElementType elementType = CfmElementType.PLUGIN;
    private final boolean displayB;
    private final boolean rerunnableMode;
    private final String description;
    private final String displayName;
    private final String displayId;
    private final String displayResourceJar;
    private final boolean invocationAttached;
    private final CfmPlugInCore nonSilentCore;
    private final CfmPlugInCore defaultCore;
    private final PlugInType[] supportedTypes;
    private final boolean useCommandArrayB;
    private final CfmExpandableString classPathUnexpanded;
    private boolean activeB = true;
    private static final boolean debug = Cfm.isDebug();
    private static final CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);

    public CfmPlugIn(DescriptionsLoader loader, PlugInT plugInT, CfmAggregate parent) throws CfwException {
        super(loader, plugInT, elementType, plugInT.getId(), parent);
        CfmPlugInCore nonSilentCore;
        CfmPlugInCore plugInCore;
        this.displayB = plugInT.isDisplay();
        this.supportedTypes = CfmPlugIn.parseTypes(plugInT.getTypes());
        this.invocationAttached = CfmPlugIn.parseInvocation(plugInT.getInvocation()) == PlugInInvocation.WAITFOR;
        this.rerunnableMode = CfmPlugIn.parseMode(plugInT.getMode()) == PlugInMode.RERUNNABLE;
        this.description = plugInT.getDesc();
        String rawDisplayName = plugInT.getDisplayname();
        this.displayName = CfmUtil.noNull(rawDisplayName, this.getSelfID());
        this.displayId = plugInT.getDisplayId();
        this.displayResourceJar = CfmPlugIn.parseResourceJar(plugInT.getDisplayResourceJar(), this.getOracleHome());
        this.useCommandArrayB = plugInT.isUseCommandArray();
        this.defaultCore = plugInCore = new CfmPlugInCore(loader, plugInT, (CfmTaggedObject)parent);
        this.classPathUnexpanded = CfmExpandableString.getInstance(loader, plugInT.getClassPath(), parent, ParameterUsePolicy.CLASSPATH_POLICY);
        NonSilentT nonSilentT = plugInT.getNonSilent();
        this.nonSilentCore = nonSilentT != null ? (nonSilentCore = new CfmPlugInCore(loader, nonSilentT, (CfmTaggedObject)parent)) : null;
    }

    private static String parseResourceJar(DisplayResourceJarType resourceJar, String parentOH) {
        String resourceJarPath;
        String string = resourceJarPath = resourceJar != null ? resourceJar.getPath() : null;
        if (resourceJarPath == null) {
            return null;
        }
        return CfmUtil.evaluatePath(resourceJarPath, parentOH);
    }

    public String evaluateClasspath(CfmAggregateHolder holder) throws CfwException {
        try {
            return this.classPathUnexpanded.evaluate(holder);
        }
        catch (CfwException e) {
            throw new CfwException("Unable to evaluate classpath: " + e, e);
        }
    }

    private static PlugInType[] parseTypes(String types) throws CfwException {
        Vector<PlugInType> supportedTypes = new Vector<PlugInType>();
        if (types != null) {
            String[] myTypes = types.split(" ");
            for (int i = 0; i < myTypes.length; ++i) {
                PlugInType thisType = PlugInType.getType(myTypes[i]);
                supportedTypes.add(thisType);
            }
        }
        if (supportedTypes.size() == 0) {
            supportedTypes.add(PlugInType.UNKNOWN);
        }
        return supportedTypes.toArray(new PlugInType[0]);
    }

    private static PlugInMode parseMode(String name) throws CfwException {
        PlugInMode value = PlugInMode.getInstance(name);
        if (value == null) {
            DescriptionsLoader.invalidAttributeEncountered("mode", name, PlugInMode.getAllMembers());
        }
        return value;
    }

    private static PlugInInvocation parseInvocation(String name) throws CfwException {
        PlugInInvocation value = PlugInInvocation.getInstance(name);
        if (value == null) {
            DescriptionsLoader.invalidAttributeEncountered("invocation", name, PlugInInvocation.getAllMembers());
        }
        return value;
    }

    public CfmAggregate getParentAggregate() {
        return (CfmAggregate)this.getParentObject();
    }

    public boolean isReRunnable() {
        return this.rerunnableMode;
    }

    @Override
    public String getDesc() {
        return this.description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayId() {
        return this.displayId;
    }

    public boolean isDisplay() {
        return this.displayB;
    }

    public boolean isUseCommandArray() {
        return this.useCommandArrayB;
    }

    @Override
    public boolean isActive() {
        return this.activeB;
    }

    @Override
    public void setActive(boolean activeB) {
        this.activeB = activeB;
    }

    @Override
    public String getLocalizedDisplayName() {
        if (this.getDisplayId() != null) {
            int index = this.getDisplayId().lastIndexOf(64);
            String resourceClass = this.getDisplayId().substring(index + 1);
            String resourceId = this.getDisplayId().substring(0, index);
            try {
                ResourceBundle rb;
                if (this.displayResourceJar != null) {
                    ClassLoader ourLoader = JarClassLoader.getClassLoaderForJar(this.displayResourceJar);
                    rb = ResourceBundle.getBundle(resourceClass, Locale.getDefault(), ourLoader);
                } else {
                    rb = ResourceBundle.getBundle(resourceClass);
                }
                return rb.getString(resourceId);
            }
            catch (MissingResourceException e) {
                cfmLogger.log(Level.WARNING, "getLocalizedDisplayName failed to find localized display name for " + this + ": " + e);
            }
            catch (IOException e) {
                cfmLogger.log(Level.WARNING, "getLocalizedDisplayName failed to find localized display name for " + this + ": " + e);
            }
        }
        return this.getDisplayName();
    }

    @Override
    public void replaceWith(String pgm, String[] optionArgument) throws CfwException {
        if (this.isInternal(true) || this.isJava(true)) {
            throw new Error("CfmPlugIn:replaceWith: Invalid PlugIn type specified for modifications. It must be of CmdExec type!" + this.toString());
        }
        this.defaultCore.setCmdExec(pgm);
        Vector<String> manualArgs = new Vector<String>();
        for (int i = 0; i < optionArgument.length; ++i) {
            manualArgs.add(optionArgument[i]);
        }
        this.defaultCore.setManualArgs(manualArgs);
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmPlugIn:replaceWith:Done!");
        }
    }

    @Override
    public PlugInType[] getTypes() throws CfwException {
        return this.supportedTypes;
    }

    @Override
    public boolean isType(PlugInType type) throws CfwException {
        return type.within(this.supportedTypes);
    }

    @Override
    public boolean isWithinTypes(ActionType[] actionTypes) throws CfwException {
        for (int i = 0; i < this.supportedTypes.length; ++i) {
            for (int j = 0; j < actionTypes.length; ++j) {
                if (!this.supportedTypes[i].correspondsTo(actionTypes[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isWithinOperations(OperationType[] operationTypes) throws CfwException {
        for (int i = 0; i < this.supportedTypes.length; ++i) {
            for (int j = 0; j < operationTypes.length; ++j) {
                if (!this.supportedTypes[i].correspondsTo(operationTypes[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInvocationAttached() {
        return this.invocationAttached;
    }

    public List getArg(boolean nonSilentB) throws CfwException {
        if (nonSilentB && this.nonSilentCore != null) {
            return this.nonSilentCore.getArg();
        }
        return this.defaultCore.getArg();
    }

    public boolean isJava(boolean nonSilentB) throws CfwException {
        if (nonSilentB && this.nonSilentCore != null) {
            return this.nonSilentCore.isJava();
        }
        return this.defaultCore.isJava();
    }

    public boolean isInternal(boolean nonSilentB) throws CfwException {
        if (nonSilentB && this.nonSilentCore != null) {
            return this.nonSilentCore.isInternal();
        }
        return this.defaultCore.isInternal();
    }

    public CfmCmdExec getCmdExec(boolean nonSilentB) throws CfwException {
        if (nonSilentB && this.nonSilentCore != null) {
            return this.nonSilentCore.getCmdExec();
        }
        return this.defaultCore.getCmdExec();
    }

    public String getJavaClass(boolean nonSilentB) throws CfwException {
        if (nonSilentB && this.nonSilentCore != null) {
            return this.nonSilentCore.getJavaClass();
        }
        return this.defaultCore.getJavaClass();
    }

    public String getJavaClassMethod(boolean nonSilentB) throws CfwException {
        if (nonSilentB && this.nonSilentCore != null) {
            return this.nonSilentCore.getJavaClassMethod();
        }
        return this.defaultCore.getJavaClassMethod();
    }

    @Override
    public IReference getReference() {
        return null;
    }

    @Override
    public String getSummary() throws CfwException {
        return "";
    }

    @Override
    public StatusOrType getStatus() throws CfwException {
        throw new CfwException("PlugIns don't currently have a status; try the specific PlugInInvocation instead");
    }

    @Override
    public IObject getParent() throws CfwException {
        return null;
    }

    @Override
    public IObject getOriginator() throws CfwException {
        return null;
    }

    @Override
    public String getOracleHome() throws CfwException {
        return this.getOHAbs().toString();
    }
}

