/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Stack;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.IParameterXmlNode;
import oracle.sysman.emCfg.support.CfmUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class CfmParameterXmlHandler2
extends DefaultHandler {
    final StringBuffer exceptions = new StringBuffer();
    private final Stack nodes = new Stack();
    private Locator locator;

    private IParameterXmlNode getCurrentNode() {
        return (IParameterXmlNode)this.nodes.peek();
    }

    private String locationString() {
        if (this.locator == null) {
            return "<location unavailable>";
        }
        return CfmUtil.locatorToString(this.locator);
    }

    private void appendException(Throwable e) {
        this.exceptions.append("Invalid XML representation of parameter: ").append(this.locationString()).append(": ").append(e.toString()).append("\n");
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        try {
            IParameterXmlNode newCurrent = this.getCurrentNode().addChild(name);
            this.nodes.push(newCurrent);
        }
        catch (CfwException e) {
            this.appendException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            this.getCurrentNode().doneSetting();
        }
        catch (CfwException e) {
            this.appendException(e);
        }
        this.nodes.pop();
    }

    @Override
    public void characters(char[] cbuf, int start, int len) {
        String data = new String(cbuf, start, len).trim();
        try {
            this.getCurrentNode().addData(data);
        }
        catch (CfwException e) {
            this.appendException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] cbuf, int start, int len) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    @Override
    public void warning(SAXParseException e) {
        e.printStackTrace();
        this.exceptions.append("Warning while parsing parameter as XML: " + e.toString() + "\n");
    }

    @Override
    public void error(SAXParseException e) {
        e.printStackTrace();
        this.exceptions.append("Error while parsing parameter as XML: " + e.toString() + "\n");
    }

    @Override
    public void fatalError(SAXParseException e) {
        e.printStackTrace();
        this.exceptions.append("Fatal Error while parsing parameter as XML: " + e.toString() + "\n");
    }
}

