/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmParameterState;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class CfmParameterXmlHandler
extends DefaultHandler {
    final StringBuffer exceptions = new StringBuffer();
    private static final boolean debug = Cfm.isDebug();
    private static final CfmLogger cfmLogger = Cfm.getLogger();
    List dimensions = new Vector();
    final StringBuffer datiSB = new StringBuffer();
    private boolean isNullDatum;
    final List dati = new Vector();
    String datiElement = "";
    String datumElement = "";
    String dimensionsElement = "";
    boolean firstB = false;
    Locator locator;

    public List getDimensions() {
        return this.dimensions;
    }

    public Object[] getDati() {
        return this.dati.toArray(new String[0]);
    }

    void check() throws CfwException {
        CfmUtil.myAssert(this.getDimensions() != null);
        if (this.exceptions.length() != 0) {
            throw new CfwException(this.exceptions.toString());
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (debug) {
            Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.setDocumentLocator:");
        }
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        if (debug) {
            Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.startDocument");
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (debug) {
            Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.endDocument");
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        boolean elementHasNullAttribute = false;
        if (debug) {
            Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.startElement:" + name);
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String aname = atts.getQName(i);
            String type = atts.getType(i);
            String value = atts.getValue(i);
            if ("null".equals(aname)) {
                elementHasNullAttribute = true;
            }
            if (!debug) continue;
            Cfm.getLogger().log(Level.INFO, "   " + aname + "(" + type + ")" + "=" + value);
        }
        this.firstB = true;
        if ("ParameterDati".equals(name)) {
            if (debug) {
                Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.startElement: recognized ParameterDati");
            }
            this.datiElement = "ParameterDati";
        } else if ("Dimensions".equals(name)) {
            if (debug) {
                Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.startElement: recognized Dimensions");
            }
            this.dimensionsElement = "Dimensions";
        } else if ("ParameterDatum".equals(name)) {
            if (debug) {
                Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.startElement: recognized ParameterDatum");
            }
            if (elementHasNullAttribute) {
                this.isNullDatum = true;
            } else {
                this.datiSB.setLength(0);
                this.isNullDatum = false;
            }
            this.datumElement = "ParameterDatum";
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (debug) {
            Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.endElement: " + name);
        }
        this.firstB = false;
        if ("ParameterDati".equals(name)) {
            if (debug) {
                Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.endElement: recognized ParameterDati");
            }
            this.datiElement = "";
        } else if ("Dimensions".equals(name)) {
            if (debug) {
                Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.endElement: recognized Dimensions");
            }
            this.dimensionsElement = "";
        } else if ("ParameterDatum".equals(name)) {
            if (debug) {
                Cfm.getLogger().log(Level.INFO, "CfmParameterXmlHandler.endElement: recognized ParameterDatum");
            }
            if (this.isNullDatum) {
                this.dati.add(null);
            } else {
                this.dati.add(this.datiSB.toString());
            }
            this.datumElement = "";
        }
    }

    @Override
    public void characters(char[] cbuf, int start, int len) {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.characters: ");
        }
        String data = new String(cbuf, start, len);
        if (debug) {
            cfmLogger.log(Level.INFO, "\"" + data + "\"");
        }
        if ("ParameterDatum".equals(this.datumElement)) {
            this.datiSB.append(data);
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.characters: adding to dati datum=\"" + data + "\"");
            }
        }
        if (this.firstB && data.length() == 0) {
            this.firstB = false;
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.characters: Done (skipping).");
            }
            return;
        }
        if ("Dimensions".equals(this.dimensionsElement)) {
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.characters: dealing with dimensions on a basis of " + data);
            }
            try {
                this.dimensions = CfmParameterState.parseDimensions(data);
            }
            catch (CfwException e) {
                Cfm.getLogger().info("CfmParameterXmlHandler.characters: " + CfmUtil.throwableToStackTrace(e));
                this.exceptions.append("\n" + e);
            }
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.characters: Done.");
        }
    }

    @Override
    public void ignorableWhitespace(char[] cbuf, int start, int len) {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.ignorableWhiteSpace");
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.processingInstruction:" + target + " " + data);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.resolveEntity:" + publicId + " " + systemId);
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "Locator:" + this.locator.getPublicId() + " " + this.locator.getSystemId() + " " + this.locator.getLineNumber() + " " + this.locator.getColumnNumber());
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.notationDecl:" + name + " " + publicId + " " + systemId);
        }
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameterXmlHandler.unparsedEntityDecl:" + name + " " + publicId + " " + systemId + " " + notationName);
        }
    }

    @Override
    public void warning(SAXParseException e) {
        Cfm.getLogger().info("CfmParameterXmlHandler.warning: " + CfmUtil.throwableToStackTrace(e));
        this.exceptions.append("\nCfmParameterXmlHandler.warning: " + e.toString());
    }

    @Override
    public void error(SAXParseException e) {
        Cfm.getLogger().info("CfmParameterXmlHandler.error: " + CfmUtil.throwableToStackTrace(e));
        this.exceptions.append("\nCfmParameterXmlHandler.error: " + e.toString());
    }

    @Override
    public void fatalError(SAXParseException e) {
        Cfm.getLogger().info("CfmParameterXmlHandler.fatalError: " + CfmUtil.throwableToStackTrace(e));
        this.exceptions.append("\nCfmParameterXmlHandler.fatalError: " + e.toString());
    }
}

