/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwExceptionUninitializedParameter;
import oracle.sysman.emCfg.common.macros.Parameter;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmObjectState;
import oracle.sysman.emCfg.core.CfmOwnedParameterModelRef;
import oracle.sysman.emCfg.core.CfmParam;
import oracle.sysman.emCfg.core.CfmParamBase;
import oracle.sysman.emCfg.core.CfmParamModel;
import oracle.sysman.emCfg.core.CfmParamValueDataType;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParameterModelRef;
import oracle.sysman.emCfg.core.CfmParameterPair;
import oracle.sysman.emCfg.core.CfmParameterXmlHandler;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.core.CfmWrapper;
import oracle.sysman.emCfg.core.ICfmWrapper;
import oracle.sysman.emCfg.core.SaxProcessor;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.instance.ParameterT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.ParameterStatus;
import oracle.sysman.emCfg.types.ParameterType;
import oracle.xml.parser.v2.XMLDocument;

class CfmParameterState
extends CfmObjectState {
    static final String DIMENSIONS_SEPARATOR = " ";
    private static boolean debug = Cfm.isDebug();
    private static CfmLogger cfmLogger = Cfm.getLogger();
    private final ParameterType type;
    private ParameterStatus status;
    private String hexedData;
    private List dimensions;
    private CfmParameterPair parameterPair = null;
    private CfmParameter cfmParameter = null;
    protected String cfmSelfDependencyTag;

    public CfmParameterState(CfmAggregateInstance aggregateInstance, ParameterT parameterT) throws CfwException {
        super(aggregateInstance, parameterT.getId());
        String typeString = parameterT.getType();
        this.type = ParameterType.getType(typeString);
        String statusS = parameterT.getStatus();
        this.setStatus(ParameterStatus.getStatus(statusS));
        this.setDimensions(CfmParameterState.parseDimensions(parameterT.getDimensions()));
        this.setHexedData(parameterT.getHexedData().getValue());
        this.verifyState();
    }

    public CfmParameterState(CfmAggregateInstance aggregateInstance, CfmParameter parameterDesc) throws CfwException {
        super(aggregateInstance, parameterDesc.getSelfID());
        this.type = parameterDesc.getParameterType();
        CfmUtil.myAssert(this.type != null);
        this.setCfmParameter(parameterDesc);
        this.setStatus(ParameterStatus.NO_DATA);
        String defaultValue = parameterDesc.getDefaultValue();
        if (defaultValue != null) {
            try {
                this.setValue(defaultValue);
            }
            catch (CfwException e) {
                throw new CfwException(this.getDisplayName() + ": Invalid default value: " + defaultValue, e);
            }
            this.setStatus(ParameterStatus.IS_DEFAULT);
        }
        this.verifyState();
    }

    public CfmParameterState(CfmAggregateInstance aggregateInstance, CfmParameter parameterDesc, CfmParameterPair previousPair) throws CfwException {
        super(aggregateInstance, parameterDesc.getSelfID());
        this.type = parameterDesc.getParameterType();
        CfmUtil.myAssert(this.type != null);
        this.setCfmParameter(parameterDesc);
        if (debug) {
            cfmLogger.log(Level.FINEST, "CfmParamter.initializeAggregateInstance: About to express dimensions as String\n");
        }
        CfmParameterState parameterState = previousPair.getCfmParameterState();
        this.setDimensions(parameterState.getDimensions());
        this.setHexedData(parameterState.getHexedData());
        this.setStatus(parameterState.getStatus());
        this.verifyState();
    }

    private void verifyState() throws CfwException {
        if (this.type == null) {
            throw new CfwException("Parameter type must not be null");
        }
        if (this.isSet() && this.hexedData == null) {
            throw new CfwException("The parameter instance must have data if it is set.");
        }
    }

    public boolean isEncrypted() {
        return this.getCfmParameter().isEncrypted();
    }

    public static List parseDimensions(String dimS) throws CfwException {
        Vector<Integer> dims = new Vector<Integer>();
        if (dimS == null) {
            return dims;
        }
        StringTokenizer st = new StringTokenizer(dimS);
        while (st.hasMoreTokens()) {
            String dS = st.nextToken();
            try {
                int d = Integer.parseInt(dS);
                dims.add(new Integer(d));
            }
            catch (NumberFormatException nfe) {
                throw new CfwException("CfmParameter.parseDimensions: invalid individual dimension " + dS);
            }
        }
        return dims;
    }

    static String getDimensionsAsString(List dimensions) {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.getDimensionsAsString: begin.\n");
        }
        if (dimensions == null || dimensions.isEmpty()) {
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameter.getDimensionsAsString: Done with null or empty internal dimensions list.\n");
            }
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator iterator = dimensions.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next() + DIMENSIONS_SEPARATOR);
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.getDimensionsAsString: Done.\n");
        }
        return sb.toString().trim();
    }

    private CfmParameter getCfmParameter() {
        return this.cfmParameter;
    }

    void setCfmParameter(CfmParameter cfmParameter) {
        this.cfmParameter = cfmParameter;
    }

    void setParameterPair(CfmParameterPair cfmParameterPair) {
        this.parameterPair = cfmParameterPair;
        this.cfmParameter = cfmParameterPair.getCfmParameter();
    }

    public void setHexedData(String hexedData) {
        this.hexedData = hexedData == null ? "" : ("null".equals(hexedData) ? null : hexedData);
    }

    public void setDimensions(List dimensions) {
        this.dimensions = dimensions;
    }

    public List getDimensions() {
        this.evaluateSelfDependency();
        return this.dimensions;
    }

    public String getDimensionsString() {
        return CfmParameterState.getDimensionsAsString(this.getDimensions());
    }

    public String getHexedData() {
        this.evaluateSelfDependency();
        return this.hexedData;
    }

    private void evaluateSelfDependency() {
        if (this.getCfmParameter().getSelfDependency() == null) {
            return;
        }
        try {
            String result = this.getCfmParameter().getSelfDependency().evaluate(this.parameterPair);
            this.setValue(result);
        }
        catch (CfwException e) {
            cfmLogger.log(Level.INFO, "Failed to compute SelfDependency for " + this.toString() + ": " + e.toString());
            this.hexedData = null;
            this.status = ParameterStatus.ASSIGN_FAILED;
        }
    }

    public boolean isSet() {
        return this.getStatus().equals(ParameterStatus.IS_ASSIGNED);
    }

    @Override
    public CfmStateType getStateType() {
        return CfmStateType.PARAMETER;
    }

    public ParameterType getType() {
        return this.type;
    }

    public boolean isType(ParameterType type) throws CfwException {
        return type.equals(this.getType());
    }

    public void setStatus(ParameterStatus status) {
        CfmUtil.myAssert(status != null);
        this.status = status;
    }

    public ParameterStatus getStatus() {
        return this.status;
    }

    public boolean isStatus(ParameterStatus status) {
        return status.equals(this.getStatus());
    }

    public void setSimplestAsStringArray(String[] valArray) throws CfwException {
        try {
            this.setValue(Parameter.toXmlRawDataArray("xsd:string", valArray));
        }
        catch (CfwException e) {
            throw new CfwException(this.getDisplayName() + ": Parameter data type is not compatible with the provided String Array.", e);
        }
    }

    public void setSimplestAsString(String val) throws CfwException {
        try {
            this.setValue(Parameter.toXmlRawData("xsd:string", val));
        }
        catch (CfwException e) {
            throw new CfwException(this.getDisplayName() + ": Parameter data type is not compatible with the provided simple String.", e);
        }
    }

    public void setSimplestAsInt(int val) throws CfwException {
        try {
            this.setValue(Parameter.toXmlRawData("xsd:int", Integer.toString(val)));
        }
        catch (CfwException e) {
            throw new CfwException(this.getDisplayName() + ": Parameter data type is not compatible with a simple int.", e);
        }
    }

    public void setSimplestAsBoolean(boolean val) throws CfwException {
        try {
            this.setValue(Parameter.toXmlRawData("xsd:boolean", Boolean.toString(val)));
        }
        catch (CfwException e) {
            throw new CfwException(this.getDisplayName() + ": Parameter data type is not compatible with a simple boolean.", e);
        }
    }

    public String getValueAsSimplestString() throws CfwException {
        String[] rawData = this.expressData(true);
        if (rawData.length == 0) {
            return "";
        }
        if (rawData.length != 1) {
            throw new CfwException(this.getDisplayName() + ": The data cannot be retrieved as SimplestString (it is an array).");
        }
        return rawData[0];
    }

    public int getValueAsSimplestInt() throws CfwException {
        String rawVal = this.getValueAsSimplestString();
        return Integer.parseInt(rawVal);
    }

    public boolean getValueAsSimplestBoolean() throws CfwException {
        String rawVal = this.getValueAsSimplestString();
        return Boolean.valueOf(rawVal);
    }

    private String getHexedDataNotEncrypted() throws NullPointerException, CfwException {
        if (this.isEncrypted()) {
            return Formatter.hexStringMD5ToHexString(this.getHexedData());
        }
        return this.getHexedData();
    }

    public Object getValueAsObject() throws CfwException {
        String hexString = this.getHexedDataNotEncrypted();
        byte[] rawBytes = Formatter.hexStringToRawBytes(hexString);
        ByteArrayInputStream is = new ByteArrayInputStream(rawBytes);
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new CfwException("Class being deserialized could not be found: " + e, e);
        }
        catch (IOException e) {
            throw new CfwException("Couldn't deserialize object: " + e, e);
        }
    }

    public void setValueAsObject(Object value) throws CfwException {
        StringWriter result = new StringWriter();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new Formatter.HexOutputStream(result));
            oos.writeObject(value);
        }
        catch (IOException e) {
            throw new CfwException("Unable to serialize object: " + e, e);
        }
        if (this.isEncrypted()) {
            try {
                this.setHexedData(Formatter.hexStringToHexStringMD5(result.toString()));
            }
            catch (Exception e) {
                throw new CfwException("Unexpected exception while encrypting " + this.getDisplayName() + ": " + e.toString(), e);
            }
        } else {
            this.setHexedData(result.toString());
        }
        this.setDimensions(new Vector());
    }

    public String getValueAsXmlDocument() throws CfwException {
        throw new CfwException("CfmParameter.getValueAsXmlDocument(): UNIMPLEMENTED YET");
    }

    private String makeIndentString(int indent) {
        StringBuffer indentBuffer = new StringBuffer("\t");
        for (int i = 1; i < indent; ++i) {
            indentBuffer.append("\t");
        }
        return indentBuffer.toString();
    }

    private int expressMemberAsXMLPrivate(Iterator dimensionIter, Iterator memberIter, StringBuffer sb, String[] dati, int datumIndex, int indent) {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.expressMemberAsXMLPrivate: begin: indent=" + indent + ", datumIndex=" + datumIndex);
        }
        int newDatumIndex = datumIndex;
        while (memberIter.hasNext()) {
            CfmWrapper modelRef;
            CfmParamBase paramBase;
            ICfmWrapper cfmWrapper = (ICfmWrapper)memberIter.next();
            if (cfmWrapper == null) {
                CfmUtil.myAssert(false);
                continue;
            }
            String indentS = this.makeIndentString(indent);
            if (cfmWrapper instanceof CfmParamValueDataType) {
                sb.append(indentS + "<" + "ParameterDatum" + " type=\"" + ((CfmParamValueDataType)cfmWrapper).getDataType() + "\">");
                String currDatum = newDatumIndex >= dati.length ? "" : dati[newDatumIndex];
                sb.append(currDatum).append("</").append("ParameterDatum").append(">\n");
                ++newDatumIndex;
                continue;
            }
            if (cfmWrapper instanceof CfmParamBase) {
                paramBase = (CfmParamBase)cfmWrapper;
            } else if (cfmWrapper instanceof CfmParameterModelRef) {
                modelRef = (CfmParameterModelRef)cfmWrapper;
                paramBase = ((CfmParameterModelRef)modelRef).getParameterModel();
            } else if (cfmWrapper instanceof CfmOwnedParameterModelRef) {
                modelRef = (CfmOwnedParameterModelRef)cfmWrapper;
                paramBase = ((CfmOwnedParameterModelRef)modelRef).getParameterModel();
            } else {
                throw new Error("unknown member " + cfmWrapper.getClass().getName());
            }
            String id = paramBase.getSelfID();
            sb.append(indentS + "<" + id + ">\n");
            ParameterType type = paramBase.getType();
            if (type.equals(ParameterType.SIMPLEST_ARRAY) || type.equals(ParameterType.SIMPLE_ARRAY) || type.equals(ParameterType.ARRAY)) {
                CfmUtil.myAssert(dimensionIter.hasNext());
                int dim = (Integer)dimensionIter.next();
                for (int d = 0; d < dim; ++d) {
                    newDatumIndex = this.expressMemberAsXMLPrivate(dimensionIter, paramBase.memberIterator(), sb, dati, newDatumIndex, indent + 1);
                }
            } else {
                newDatumIndex = this.expressMemberAsXMLPrivate(dimensionIter, paramBase.memberIterator(), sb, dati, newDatumIndex, indent + 1);
            }
            sb.append(indentS + "</" + id + ">\n");
        }
        return newDatumIndex;
    }

    public boolean isValidValue(String valueAsXmlString) throws CfwException {
        try {
            this.set(valueAsXmlString, false);
        }
        catch (PropertyVetoException e) {
            if (debug) {
                cfmLogger.log(Level.INFO, e.toString());
            }
            return false;
        }
        return true;
    }

    public String[] expressDataAsArgv() throws CfwException {
        String parameterPrefix;
        String[] dati = this.expressData(false);
        CfmUtil.myAssert(dati != null);
        String pref = "";
        int datumIndex = 0;
        Iterator dataValueTypesIterator = this.getCfmParameter().getAllDataValueTypes(this.getDimensions()).iterator();
        while (dataValueTypesIterator.hasNext() && dati.length != datumIndex) {
            String prefix;
            Object dataValueType = dataValueTypesIterator.next();
            if (dataValueType == null) {
                throw new Error("CfmParameter.expressDataAsArgv: invalid (null) data value type");
            }
            if (dataValueType instanceof CfmParam) {
                prefix = ((CfmParam)dataValueType).getPrefix();
                if (prefix == null) continue;
                pref = pref + prefix + DIMENSIONS_SEPARATOR;
                continue;
            }
            if (dataValueType instanceof CfmParamModel) {
                prefix = ((CfmParamModel)dataValueType).getPrefix();
                if (prefix == null) continue;
                pref = pref + prefix + DIMENSIONS_SEPARATOR;
                continue;
            }
            if (dataValueType instanceof CfmParamValueDataType) {
                prefix = ((CfmParamValueDataType)dataValueType).getPrefix();
                if (prefix != null) {
                    pref = pref + prefix + DIMENSIONS_SEPARATOR;
                }
                dati[datumIndex] = pref + dati[datumIndex++];
                pref = "";
                continue;
            }
            throw new Error("CfmParameter.expressDataAsArg: unknown member of data value types " + dataValueType.getClass().getName());
        }
        if (dati.length != 0 && (parameterPrefix = this.getCfmParameter().getPrefix()) != null) {
            dati[0] = parameterPrefix + DIMENSIONS_SEPARATOR + dati[0];
        }
        return dati;
    }

    private void impressXmlData(String xmlText) throws CfwException {
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.impressXmlData(): begin with:\n" + xmlText + "\n");
        }
        CfmParameterXmlHandler cfmParameterXmlHandler = new CfmParameterXmlHandler();
        try {
            new SaxProcessor();
            SaxProcessor.scan(cfmParameterXmlHandler, xmlText);
        }
        catch (Exception e) {
            throw new CfwException(this.getDisplayName() + ": SAX " + e.toString(), e);
        }
        cfmParameterXmlHandler.check();
        List dimensions = cfmParameterXmlHandler.getDimensions();
        Object[] dati = (String[])cfmParameterXmlHandler.getDati();
        if (dati == null) {
            CfmUtil.myAssert(false);
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameter.impressXmlData: dati obtained is null");
            }
        } else if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.impressXmlData: dati obtained, length=" + dati.length + ":");
            for (int i = 0; i < dati.length; ++i) {
                cfmLogger.log(Level.INFO, "PARAMETER_XML_DATI[" + i + "] = \"" + (String)dati[i] + "\"");
            }
            cfmLogger.log(Level.INFO, "\n");
        }
        this.impressData(dati, dimensions);
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.impressXmlData(): Done.");
        }
    }

    private void impressData(Object[] dati, List dimensions) throws CfwException {
        List paramValueDataTypesForTheseDimensions;
        int dataValueTypesCount;
        int datiLength;
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.impressData([]): begin");
        }
        if ((datiLength = dati.length) != (dataValueTypesCount = (paramValueDataTypesForTheseDimensions = this.getCfmParameter().getParamValueDataTypes(dimensions)).size())) {
            throw new CfwException(this.getDisplayName() + ": The XML parameter dati contained " + datiLength + " elements, but should have been " + dataValueTypesCount + ", for the given data type and dimensions.");
        }
        String[] dataValues = new String[datiLength];
        Iterator dataValueTypesIterator = paramValueDataTypesForTheseDimensions.iterator();
        for (int index = 0; index < datiLength; ++index) {
            CfmParamValueDataType dataValueType = (CfmParamValueDataType)dataValueTypesIterator.next();
            dataValues[index] = dataValueType.convertToString(dati[index]);
        }
        if (debug) {
            if (dataValues.length == 0) {
                cfmLogger.log(Level.INFO, "CfmParameter.impressData: obtained dataValues is zero length");
            } else {
                cfmLogger.log(Level.INFO, "CfmParameter.impressData: dataValues obtained as:");
                for (int i = 0; i < dataValues.length; ++i) {
                    cfmLogger.log(Level.INFO, "dataValues[" + i + "] = \"" + dataValues[i] + "\"");
                }
                cfmLogger.log(Level.INFO, "\n");
            }
        }
        try {
            if (this.getCfmParameter().isEncrypted()) {
                this.setHexedData(Formatter.normalStringArrayToHexArrayStringMD5(dataValues, "UTF8"));
            } else {
                this.setHexedData(Formatter.normalStringArrayToHexArrayString(dataValues, "UTF8"));
            }
        }
        catch (Exception e) {
            throw new CfwException("Unexpected exception while encoding " + this.getDisplayName() + ": " + e.toString(), e);
        }
        this.setDimensions(dimensions);
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.impressData([]): Done.\n");
        }
    }

    public boolean isUninitialized() {
        return !this.isSet() && this.getHexedData() == null;
    }

    public String[] expressData(boolean decrypt) throws CfwException, CfwExceptionUninitializedParameter {
        String hexedData = this.getHexedData();
        if (hexedData == null) {
            if (!this.isSet()) {
                throw new CfwExceptionUninitializedParameter(this.getDisplayName());
            }
            CfmUtil.myAssert(false);
            return new String[]{""};
        }
        try {
            if (this.getCfmParameter().isEncrypted()) {
                if (decrypt) {
                    return Formatter.hexArrayStringMD5ToNormalStringArray(hexedData, "UTF8");
                }
                CfmUtil.myAssert(false);
                return Formatter.tokenizeHexedDataArray(hexedData);
            }
            return Formatter.hexArrayStringToNormalStringArray(hexedData, "UTF8");
        }
        catch (Exception e) {
            throw new CfwException("Unexpected exception while decoding " + this.getDisplayName() + ": " + e.toString(), e);
        }
    }

    String expressDataAsXML() throws CfwException {
        String[] dati;
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.expressMemberAsXML: begin");
        }
        if ((dati = this.expressData(true)) == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameter.expressMemberAsXML: dati expressed as null");
            }
        } else if (dati.length == 0) {
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameter.expressMemberAsXML: dati expressed as zero length");
            }
        } else if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.expressMemberAsXML: dati expressed as:");
            for (int i = 0; i < dati.length; ++i) {
                cfmLogger.log(Level.INFO, "PARAMETER_XML_DATI[" + i + "] = \"" + dati[i] + "\"");
            }
            cfmLogger.log(Level.INFO, "\n");
        }
        if (dati == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "CfmParameter.expressMemberAsXML: Done (returning null).\n");
            }
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<ParameterDati>\n").append("\t<Dimensions>\n\t\t").append(this.getDimensionsString()).append("\n\t</Dimensions>\n");
        String id = this.getSelfID();
        sb.append("\t<" + id + ">\n");
        int datumIndex = this.expressMemberAsXMLPrivate(this.getDimensions().iterator(), this.getCfmParameter().dataTypeToIterator(), sb, dati, 0, 2);
        sb.append("\t</" + id + ">\n");
        sb.append("</ParameterDati>\n");
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.expressMemberAsXML: " + datumIndex + " dati items have been expressed; Done.");
        }
        return sb.toString();
    }

    public boolean isDefaultValue() throws CfwException {
        String dataAsXml = this.expressDataAsXML();
        if (this.getCfmParameter().getDefaultValue() == null) {
            return dataAsXml == null;
        }
        if (dataAsXml == null) {
            return false;
        }
        return dataAsXml.equalsIgnoreCase(this.getCfmParameter().getDefaultValue());
    }

    public String[] getValueAsSimplestStringArray() throws CfwException {
        if (this.getDimensions().size() > 0 && (Integer)this.getDimensions().get(0) == -1) {
            return null;
        }
        return this.expressData(true);
    }

    public void setValue(String valueAsXmlString) throws CfwException {
        try {
            this.set(valueAsXmlString, true);
            this.setStatus(ParameterStatus.IS_ASSIGNED);
        }
        catch (PropertyVetoException e) {
            throw new CfwException(e);
        }
    }

    public void setValue(XMLDocument valueAsXmlDocument) throws CfwException {
        throw new CfwException("CfmParameter.setValue(XMLDocument): UNIMPLEMENTED YET");
    }

    String getValueAsXmlString() throws CfwException {
        return this.expressDataAsXML();
    }

    public void set(String newValue, boolean commitB) throws PropertyVetoException, CfwException {
        if (commitB) {
            try {
                this.impressXmlData(newValue);
            }
            catch (CfwException e) {
                throw new CfwException("The provided XML was not valid for " + this.getDisplayName() + ": " + newValue, e);
            }
        }
    }

    private String getDisplayName() {
        return this.getCfmParameter().getCfmIdentity().toString();
    }

    public void saveHexedDataAttributes(StringBuffer sb) {
        sb.append(" isset=\"").append(this.isSet()).append("\"");
        if (this.getCfmParameter().isEncrypted()) {
            sb.append(" encrypt=\"true\"");
        }
    }
}

