/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Iterator;
import java.util.List;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmParamModel;
import oracle.sysman.emCfg.core.CfmReference;
import oracle.sysman.emCfg.core.CfwOwnerWithLocation;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.IParameterType;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.ParameterType;

class CfmParameterModelRef
extends CfmReference
implements IParameterType {
    private final boolean impliedOwner;
    private static final CfmElementType[] possibleReferredTypes = new CfmElementType[]{CfmElementType.PARAM_MODEL};

    public CfmParameterModelRef(DescriptionsLoader loader, String idRef, CfwOwnerWithLocation ownerRef, boolean impliedOwner) {
        super(loader, idRef, ownerRef);
        this.impliedOwner = impliedOwner;
    }

    public CfmParamModel getParameterModel() {
        if (!this.isResolved()) {
            return null;
        }
        return (CfmParamModel)this.getCfmTaggedObject();
    }

    @Override
    public boolean resolve() {
        if (super.resolve()) {
            return true;
        }
        if (this.impliedOwner) {
            this.tryNoOwner(true);
            if (super.resolve()) {
                return true;
            }
            this.cfmTaggedObject = this.getLoader().getObjectFactory().getLatestVersionOfParamModel(new CfwIdentifier(this.getIdref(), this.getNsRef()));
            if (this.cfmTaggedObject != null) {
                return true;
            }
            this.tryNoOwner(false);
        }
        return false;
    }

    @Override
    protected CfmElementType[] getPossibleReferredTypes() {
        return possibleReferredTypes;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public ParameterType getParameterType() {
        return this.getParameterModel().getType();
    }

    @Override
    public void appendDefaultDimensions(List dimensions) {
        CfmParamModel paramBase = this.getParameterModel();
        if (paramBase == null) {
            CfmUtil.myAssert(false);
            return;
        }
        paramBase.appendDefaultDimensions(dimensions);
    }

    @Override
    public void appendDataValueTypes(Iterator dimit, List dataValueTypes, List paramValueDataTypes) {
        this.getParameterModel().appendDataValueTypes(dimit, dataValueTypes, paramValueDataTypes);
    }
}

