/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.macros.Parameter;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmParam;
import oracle.sysman.emCfg.core.CfmParamArray;
import oracle.sysman.emCfg.core.CfmParamComplex;
import oracle.sysman.emCfg.core.CfmParamSimple;
import oracle.sysman.emCfg.core.CfmParamSimpleArray;
import oracle.sysman.emCfg.core.CfmParamSimplest;
import oracle.sysman.emCfg.core.CfmParamSimplestArray;
import oracle.sysman.emCfg.core.CfmParentObject;
import oracle.sysman.emCfg.core.CfmSelfDependency;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.IParameterType;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.descriptions.ArrayParamT;
import oracle.sysman.emCfg.schema.descriptions.ComplexParamT;
import oracle.sysman.emCfg.schema.descriptions.ParameterBaseT;
import oracle.sysman.emCfg.schema.descriptions.ParameterModelRefT;
import oracle.sysman.emCfg.schema.descriptions.SimpleArrayParamT;
import oracle.sysman.emCfg.schema.descriptions.SimpleParamT;
import oracle.sysman.emCfg.schema.descriptions.SimplestArrayParamT;
import oracle.sysman.emCfg.schema.descriptions.SimplestParamT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.ParameterMode;
import oracle.sysman.emCfg.types.ParameterScope;
import oracle.sysman.emCfg.types.ParameterType;

class CfmParameter
extends CfmParentObject {
    public static final CfmElementType elementType = CfmElementType.PARAMETER;
    private static boolean debug = Cfm.isDebug();
    private static CfmLogger cfmLogger = Cfm.getLogger();
    private final String defaultValue;
    private final boolean encryptedB;
    private boolean transientB;
    private final ParameterMode mode;
    private final ParameterScope scope;
    private final CfmSelfDependency selfDependency;
    private final String prefix;
    private final IParameterType dataType;

    public CfmParameter(DescriptionsLoader loader, ParameterBaseT jaxbOrigin, CfmParentObject parent) throws CfwException {
        super(loader, jaxbOrigin, elementType, jaxbOrigin.getId(), parent);
        this.defaultValue = CfmParameter.parseDefaultValue(jaxbOrigin);
        this.encryptedB = jaxbOrigin.isEncrypt();
        this.mode = CfmParameter.parseMode(jaxbOrigin.getMode());
        this.scope = CfmParameter.parseScope(jaxbOrigin.getScope());
        this.transientB = jaxbOrigin.isTransient();
        this.prefix = jaxbOrigin.getPrefix();
        this.dataType = this.parseType(jaxbOrigin, loader, parent);
        this.selfDependency = CfmSelfDependency.getInstance(loader, jaxbOrigin.getSelfDependency(), jaxbOrigin.getSelfDependencyCopyFrom(), jaxbOrigin.getSelfDependencyConcat(), this);
        CfmUtil.myAssert(this.verify());
    }

    static String parseDefaultValue(ParameterBaseT jaxbOrigin) throws CfwException {
        String defaultAsXml = jaxbOrigin.getDefault();
        String defaultAsString = jaxbOrigin.getDefaultAsString();
        if (defaultAsString != null) {
            if (defaultAsXml != null) {
                throw new CfwException("A Parameter cannot contain both \"default\" and \"defaultAsString\" attributes");
            }
            return Parameter.toXmlRawData("xsd:string", defaultAsString);
        }
        return defaultAsXml;
    }

    private static ParameterMode parseMode(String name) throws CfwException {
        ParameterMode value = ParameterMode.valueOf(name);
        if (value == null) {
            DescriptionsLoader.invalidAttributeEncountered("mode", name, ParameterMode.getAllMembers());
        }
        return value;
    }

    private static ParameterScope parseScope(String name) throws CfwException {
        ParameterScope value = ParameterScope.getInstance(name);
        if (value == null) {
            DescriptionsLoader.invalidAttributeEncountered("scope", name, ParameterScope.getAllMembers());
        }
        return value;
    }

    private boolean verify() {
        return this.dataType != null;
    }

    private IParameterType parseType(ParameterBaseT parameterT, DescriptionsLoader loader, CfmParentObject owner) throws CfwException {
        CfmParam param = this.parseParam(parameterT, loader, owner);
        if (param != null) {
            return param;
        }
        ParameterModelRefT parameterModelRefT = this.parseParameterModelRef(parameterT);
        IParameterType ref = loader.newParameterModelRef(parameterModelRefT);
        if (ref == null) {
            throw new CfwException("A Parameter must contain either a Param or ParameterModelRef");
        }
        return ref;
    }

    private CfmParam parseParam(ParameterBaseT parameterT, DescriptionsLoader loader, CfmParentObject owner) throws CfwException {
        Object p = parameterT.getSimplestParam();
        if (p != null) {
            return CfmParamSimplest.getInstance(loader, (SimplestParamT)p, owner);
        }
        p = parameterT.getSimplestArrayParam();
        if (p != null) {
            return CfmParamSimplestArray.getInstance(loader, (SimplestArrayParamT)p, owner);
        }
        p = parameterT.getSimpleParam();
        if (p != null) {
            return CfmParamSimple.getInstance(loader, (SimpleParamT)p, owner);
        }
        p = parameterT.getSimpleArrayParam();
        if (p != null) {
            return CfmParamSimpleArray.getInstance(loader, (SimpleArrayParamT)p, owner);
        }
        p = parameterT.getComplexParam();
        if (p != null) {
            return CfmParamComplex.getInstance(loader, (ComplexParamT)p, owner);
        }
        p = parameterT.getArrayParam();
        if (p != null) {
            return CfmParamArray.getInstance(loader, (ArrayParamT)p, owner);
        }
        return null;
    }

    private ParameterModelRefT parseParameterModelRef(ParameterBaseT parameterT) {
        ParameterModelRefT result = parameterT.getSimplestParameterModelRef();
        if (result != null) {
            return result;
        }
        result = parameterT.getSimplestArrayParameterModelRef();
        if (result != null) {
            return result;
        }
        result = parameterT.getSimpleParameterModelRef();
        if (result != null) {
            return result;
        }
        result = parameterT.getSimpleArrayParameterModelRef();
        if (result != null) {
            return result;
        }
        result = parameterT.getComplexParameterModelRef();
        if (result != null) {
            return result;
        }
        result = parameterT.getArrayParameterModelRef();
        return result;
    }

    public boolean isType(ParameterType isType) {
        return this.getParameterType().equals(isType);
    }

    public ParameterType getParameterType() {
        return this.dataType.getParameterType();
    }

    public boolean isEncrypted() {
        return this.encryptedB;
    }

    public boolean isTransient() {
        return this.transientB;
    }

    public ParameterScope getScope() {
        return this.scope;
    }

    public boolean isVisible() {
        return this.getScope() == ParameterScope.VISIBLE;
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public boolean isSettable() {
        return this.getMode() == ParameterMode.SETTABLE;
    }

    public boolean isDerived() {
        return this.getMode() == ParameterMode.DERIVED;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    List getParamValueDataTypes(List dimensions) throws CfwException {
        Vector paramValueDataTypes = new Vector();
        Iterator dimensionIterator = dimensions.iterator();
        try {
            Vector dummy = new Vector();
            this.dataType.appendDataValueTypes(dimensionIterator, dummy, paramValueDataTypes);
        }
        catch (NoSuchElementException e) {
            throw new CfwException("The number of dimensions provided (" + dimensions.size() + ") is too small for the data types.");
        }
        if (dimensionIterator.hasNext()) {
            throw new CfwException("The number of dimensions provided (" + dimensions.size() + ") exceeds the number expected by the data types.");
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.collectDataValueTypes: result is:");
            int k = 0;
            for (Object obj : paramValueDataTypes) {
                cfmLogger.log(Level.INFO, "dataValueType [" + k++ + "] is " + obj.getClass().getName());
            }
            cfmLogger.log(Level.INFO, "CfmParameter.collectDataValueTypes: done.\n");
        }
        return paramValueDataTypes;
    }

    List getAllDataValueTypes(List dimensions) throws CfwException {
        Vector dataValueTypes = new Vector();
        Iterator dimensionIterator = dimensions.iterator();
        try {
            Vector dummy = new Vector();
            this.dataType.appendDataValueTypes(dimensionIterator, dataValueTypes, dummy);
        }
        catch (NoSuchElementException e) {
            throw new CfwException("The number of dimensions provided (" + dimensions.size() + ") is too small for the data types.");
        }
        if (dimensionIterator.hasNext()) {
            throw new CfwException("The number of dimensions provided (" + dimensions.size() + ") exceeds the number expected by the data types (" + dataValueTypes.size() + ").");
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "CfmParameter.collectDataValueTypes: result is:");
            int k = 0;
            for (Object obj : dataValueTypes) {
                cfmLogger.log(Level.INFO, "dataValueType [" + k++ + "] is " + obj.getClass().getName());
            }
            cfmLogger.log(Level.INFO, "CfmParameter.collectDataValueTypes: done.\n");
        }
        return dataValueTypes;
    }

    Iterator dataTypeToIterator() {
        Vector<IParameterType> list = new Vector<IParameterType>();
        list.add(this.dataType);
        return list.iterator();
    }

    CfmSelfDependency getSelfDependency() {
        return this.selfDependency;
    }
}

