/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.IOException;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmWrapper;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.IParamDataType;
import oracle.sysman.emCfg.schema.descriptions.ParamValueDataTypeT;
import oracle.sysman.emCfg.support.Filer;

class CfmParamValueDataType
extends CfmWrapper
implements IParamDataType {
    static final String XSD_STRING = "xsd:string";
    static final String XSD_INT = "xsd:int";
    static final String XSD_BOOLEAN = "xsd:boolean";
    static final String AGG_FILE = "agg:file";
    static final String AGG_STRING_ARR = "agg:sarray";
    private final String dataType;
    private final String prefix;

    public CfmParamValueDataType(DescriptionsLoader loader, ParamValueDataTypeT jaxbOrigin) {
        super(loader, jaxbOrigin);
        this.dataType = jaxbOrigin.getValue();
        this.prefix = jaxbOrigin.getPrefix();
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String toString() {
        return "\nCfmParamValueDataType: prefix=>" + this.prefix + ", data type: \"" + this.dataType + "\". End-of-CfmParamValueDataType\n";
    }

    String convertToString(Object o) throws CfwException {
        if (o == null) {
            return null;
        }
        if (this.dataType.equals(XSD_STRING)) {
            return o.toString();
        }
        if (this.dataType.equals(XSD_INT)) {
            try {
                int i = Integer.parseInt(o.toString());
                return Integer.toString(i);
            }
            catch (NumberFormatException nfe) {
                throw new CfwException("CfmParamValueDataType.convertToString: invalid data (" + o.toString() + "), unconvertable to integer");
            }
        }
        if (this.dataType.equals(XSD_BOOLEAN)) {
            return new Boolean(o.toString()).toString();
        }
        if (this.dataType.equals(AGG_FILE)) {
            return o.toString();
        }
        if (this.dataType.equals(AGG_STRING_ARR)) {
            return o.toString();
        }
        return "NOT IMPLEMENTED YET";
    }

    Object convertFromString(String s) throws CfwException {
        if (s == null) {
            return null;
        }
        if (this.dataType.equals(XSD_STRING)) {
            return s;
        }
        if (this.dataType.equals(XSD_INT)) {
            try {
                return new Integer(Integer.parseInt(s));
            }
            catch (NumberFormatException nfe) {
                throw new CfwException("CfmParamValueDataType.convertFromString: invalid data (" + s + "), unconvertable to Integer");
            }
        }
        if (this.dataType.equals(XSD_BOOLEAN)) {
            return new Boolean(s);
        }
        if (this.dataType.equals(AGG_FILE)) {
            if (s.length() == 0) {
                throw new CfwException("CfmParamValueDataType.convertFromString: data of \"agg:file\" type is of zero length");
            }
            try {
                return Filer.readFile(s);
            }
            catch (IOException ioe) {
                throw new CfwException(ioe);
            }
        }
        if (this.dataType.equals(AGG_STRING_ARR)) {
            return s;
        }
        return s;
    }
}

