/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.AggregateInstanceIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.core.ICfmObjectState;

abstract class CfmObjectState
implements ICfmObjectState {
    private final String selfID;
    protected final CfmAggregateInstance aggregateInstance;
    private String summary;

    @Override
    public AggregateInstanceIdentifierWithLocation getOwningInstance() {
        return this.aggregateInstance.getInstanceIdentifier();
    }

    public CfmObjectState(CfmAggregateInstance aggregateInstance, String selfID) {
        this.aggregateInstance = aggregateInstance;
        this.selfID = selfID;
        try {
            this.aggregateInstance.add(this);
        }
        catch (CfwException e) {
            throw new Error(e);
        }
    }

    @Override
    public String getSelfID() {
        return this.selfID;
    }

    @Override
    public String getParentID() {
        return this.aggregateInstance.getAggID();
    }

    @Override
    public String getNamespace() {
        return this.aggregateInstance.getNS();
    }

    @Override
    public AggregateVersion getVersion() {
        return this.aggregateInstance.getVersion();
    }

    public String toString() {
        return "{" + this.getStateType().toString() + ":" + this.getSelfID() + " in " + this.aggregateInstance.toString() + "}";
    }

    @Override
    public String getSummary() {
        if (this.summary == null) {
            return "No summary available";
        }
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public abstract CfmStateType getStateType();
}

