/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.text.MessageFormat;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.ActionInvocationState;
import oracle.sysman.emCfg.core.ActionInvocationStateBase;
import oracle.sysman.emCfg.core.AggregateActionInvocationState;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmMicroStep;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.core.CfmStepState;
import oracle.sysman.emCfg.core.PlugInInvocationState;
import oracle.sysman.emCfg.core.PlugInInvocationStateExternalJava;
import oracle.sysman.emCfg.core.PlugInInvocationStateExternalProgram;
import oracle.sysman.emCfg.core.PlugInInvocationStateInternal;
import oracle.sysman.emCfg.schema.instance.ActionInvocationT;
import oracle.sysman.emCfg.schema.instance.AggregateActionInvocationT;
import oracle.sysman.emCfg.schema.instance.ArgumentT;
import oracle.sysman.emCfg.schema.instance.ExternalJavaInvocationT;
import oracle.sysman.emCfg.schema.instance.ExternalProgramInvocationT;
import oracle.sysman.emCfg.schema.instance.InternalInvocationT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

class CfmMicroStepState
extends CfmStepState {
    private final MicroStepFlavor flavor;
    private final int msIndex;
    private final PlugInInvocationState plugInInvocationState;
    private int expectedDuration = 0;
    private ActionInvocationStateBase actionInvocationState;
    private MicroStepStatus status;

    public static CfmMicroStepState newCfmMicroStepState(CfmAggregateInstance aggregateInstance, Object obj, String actionID, long stepIndex, int microStepIndex) throws CfwException {
        CfmMicroStepState microStepState;
        if (obj instanceof ExternalJavaInvocationT) {
            ExternalJavaInvocationT objT = (ExternalJavaInvocationT)obj;
            PlugInInvocationStateExternalJava plugInInvocationState = new PlugInInvocationStateExternalJava();
            plugInInvocationState.setJavaClassMethod(objT.getJavaClassMethod());
            plugInInvocationState.setExitCode(objT.getErrorcode());
            ArgumentT arg = objT.getArgument();
            if (arg != null) {
                plugInInvocationState.setArg(arg.getValue());
            }
            plugInInvocationState.setActive(objT.isIsActive());
            plugInInvocationState.setStderr(objT.getStderr());
            plugInInvocationState.setStdout(objT.getStdout());
            microStepState = new CfmMicroStepState(aggregateInstance, objT, microStepIndex, stepIndex, actionID, MicroStepFlavor.EXTERNAL_JAVA_INVOCATION, plugInInvocationState);
            microStepState.setStatus(MicroStepStatus.getStatus(objT.getStatus()));
            plugInInvocationState.setStatusDetails(objT.getStatusDetails());
        } else if (obj instanceof ExternalProgramInvocationT) {
            ExternalProgramInvocationT objT = (ExternalProgramInvocationT)obj;
            PlugInInvocationStateExternalProgram plugInInvocationState = new PlugInInvocationStateExternalProgram();
            plugInInvocationState.setExecutable(objT.getExecutable());
            plugInInvocationState.setExitCode(objT.getErrorcode());
            ArgumentT arg = objT.getArgument();
            if (arg != null) {
                plugInInvocationState.setArg(arg.getValue());
            }
            plugInInvocationState.setActive(objT.isIsActive());
            plugInInvocationState.setStderr(objT.getStderr());
            plugInInvocationState.setStdout(objT.getStdout());
            microStepState = new CfmMicroStepState(aggregateInstance, objT, microStepIndex, stepIndex, actionID, MicroStepFlavor.EXTERNAL_PROGRAM_INVOCATION, plugInInvocationState);
            microStepState.setStatus(MicroStepStatus.getStatus(objT.getStatus()));
            plugInInvocationState.setStatusDetails(objT.getStatusDetails());
        } else if (obj instanceof InternalInvocationT) {
            InternalInvocationT objT = (InternalInvocationT)obj;
            PlugInInvocationStateInternal plugInInvocationState = new PlugInInvocationStateInternal();
            plugInInvocationState.setJavaClass(objT.getJavaClass());
            plugInInvocationState.setException(objT.getException());
            ArgumentT arg = objT.getArgument();
            if (arg != null) {
                plugInInvocationState.setArg(arg.getValue());
            }
            plugInInvocationState.setActive(objT.isIsActive());
            microStepState = new CfmMicroStepState(aggregateInstance, objT, microStepIndex, stepIndex, actionID, MicroStepFlavor.INTERNAL_INVOCATION, plugInInvocationState);
            microStepState.setStatus(MicroStepStatus.getStatus(objT.getStatus()));
            plugInInvocationState.setStatusDetails(objT.getStatusDetails());
        } else if (obj instanceof ActionInvocationT) {
            ActionInvocationT objT = (ActionInvocationT)obj;
            ActionInvocationState actionInvocationState = new ActionInvocationState(objT);
            microStepState = new CfmMicroStepState(aggregateInstance, objT, microStepIndex, stepIndex, actionID, MicroStepFlavor.ACTION_REF, null);
            microStepState.setActionInvocationState(actionInvocationState);
            microStepState.setStatus(MicroStepStatus.getStatus(objT.getStatus()));
        } else if (obj instanceof AggregateActionInvocationT) {
            AggregateActionInvocationT objT = (AggregateActionInvocationT)obj;
            AggregateActionInvocationState actionInvocationState = new AggregateActionInvocationState(objT);
            microStepState = new CfmMicroStepState(aggregateInstance, objT, microStepIndex, stepIndex, actionID, MicroStepFlavor.AGGREGATE_ACTION_REF, null);
            microStepState.setActionInvocationState(actionInvocationState);
            microStepState.setStatus(MicroStepStatus.getStatus(objT.getStatus()));
        } else {
            return null;
        }
        return microStepState;
    }

    private CfmMicroStepState(CfmAggregateInstance aggregateInstance, Object jaxbOrigin, int msIndex, long stepIndex, String actionID, MicroStepFlavor flavor, PlugInInvocationState invocationState) {
        super(aggregateInstance, jaxbOrigin, msIndex, stepIndex, actionID);
        this.plugInInvocationState = invocationState;
        this.setStatus(MicroStepStatus.NOT_PERFORMED);
        this.setSummary("");
        this.flavor = flavor;
        this.msIndex = msIndex;
        CfmUtil.myAssert(flavor != null);
    }

    public CfmMicroStepState(CfmAggregateInstance aggregateInstance, CfmMicroStep microStep) throws CfwException {
        super(aggregateInstance, null, microStep.getIndex(), microStep.getStepIndex(), microStep.getActionStep().getActionID());
        this.plugInInvocationState = microStep.newPlugInInvocationState();
        this.setStatus(MicroStepStatus.NOT_PERFORMED);
        this.setSummary("");
        this.flavor = microStep.getFlavor();
        this.msIndex = microStep.getIndex();
        CfmUtil.myAssert(this.flavor != null);
    }

    public int getMsIndex() {
        return this.msIndex;
    }

    public MicroStepFlavor getFlavor() {
        return this.flavor;
    }

    public boolean isFlavor(MicroStepFlavor flavor) {
        return flavor.equals(this.getFlavor());
    }

    @Override
    public CfmStateType getStateType() {
        return CfmStateType.MICRO;
    }

    public void setDuration(int duration) {
        this.expectedDuration = duration;
    }

    public String getDuration() {
        return new String("" + this.expectedDuration);
    }

    public String getPlugInID() {
        return this.getPlugInInvocationState().getPlugInID();
    }

    public void setActionInvocationState(ActionInvocationStateBase actionInvocationState) {
        this.actionInvocationState = actionInvocationState;
    }

    public AggregateActionInvocationState getAggregateActionInvocationState() {
        return (AggregateActionInvocationState)this.actionInvocationState;
    }

    public PlugInInvocationState getPlugInInvocationState() {
        return this.plugInInvocationState;
    }

    public String getActionRef() {
        if (this.actionInvocationState == null) {
            throw new Error("MicroStepState.getActionRef: invalid actionInvocationState for " + this.getFlavor());
        }
        return this.actionInvocationState.getActionRef();
    }

    public void setStatus(MicroStepStatus status) {
        this.setStatus(status, null);
    }

    public void setStatus(MicroStepStatus status, String details) {
        this.status = status;
        if (this.getPlugInInvocationState() != null) {
            this.getPlugInInvocationState().setStatusDetails(details);
        } else {
            CfmUtil.myAssert(details == null);
        }
    }

    public MicroStepStatus getStatus() {
        if (this.status == null) {
            throw new Error("CfmMicroStepState.getStatus: unknown status of " + this.toString());
        }
        return this.status;
    }

    public boolean isStatus(MicroStepStatus status) throws CfwException {
        if (this.status == null) {
            throw new CfwException("CfmMicroStepState.isStatus: invalid (null) status");
        }
        return status.equals(this.getStatus());
    }

    public String getLocalizedStatusString() {
        return MessageFormat.format(this.getStatus().getLocalizedBriefString(), this.getPlugInID());
    }
}

