/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.core.ActionPerformer;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmActionPair;
import oracle.sysman.emCfg.core.CfmActionStepPair;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAggregateRefPair;
import oracle.sysman.emCfg.core.CfmAnyPair;
import oracle.sysman.emCfg.core.CfmArguments;
import oracle.sysman.emCfg.core.CfmCmdExec;
import oracle.sysman.emCfg.core.CfmMicroStep;
import oracle.sysman.emCfg.core.CfmMicroStepState;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.PerformMicroStep;
import oracle.sysman.emCfg.core.PlugInInvocationState;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;
import oracle.sysman.emCfg.types.StatusOrType;

class CfmMicroStepPair
extends CfmAnyPair {
    private final CfmActionStepPair stepPair;
    private boolean attached = false;
    private static final Comparator microStepPairComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return CfmMicroStepPair.compare(o1, o2);
        }
    };

    public CfmMicroStepPair(CfmAggregateHolder cfmAggregateHolder, CfmMicroStep cfmObject, CfmMicroStepState cfmObjectState, CfmActionStepPair stepPair) {
        super(cfmAggregateHolder, cfmObject, cfmObjectState);
        this.stepPair = stepPair;
        if (cfmObjectState.getFlavor().isPlugInInvocation()) {
            cfmObjectState.getPlugInInvocationState().setMicroStepPair(this);
        }
    }

    public CfmActionStepPair getStepPair() {
        return this.stepPair;
    }

    public CfmMicroStep getCfmMicroStep() {
        return (CfmMicroStep)this.getCfmObject();
    }

    public CfmMicroStepState getCfmMicroStepState() {
        return (CfmMicroStepState)this.getCfmObjectState();
    }

    public PlugInInvocationState getPlugInInvocationState() {
        return this.getCfmMicroStepState().getPlugInInvocationState();
    }

    public PlugInInvocationState getPlugInInvocationStateNoNull() throws CfwException {
        PlugInInvocationState result = this.getCfmMicroStepState().getPlugInInvocationState();
        if (result == null) {
            throw new CfwException("This MicroStep is not a PlugIn");
        }
        return result;
    }

    public int getIndex() {
        return this.getCfmMicroStep().getIndex();
    }

    public int getStepIndex() {
        return this.getCfmMicroStep().getStepIndex();
    }

    public String getOwningActionID() {
        return this.getCfmMicroStep().getActionStep().getActionID();
    }

    public CfmCmdExec getCmdExec(boolean nonSilentB) throws CfwException {
        return this.getCfmMicroStep().getCmdExec(nonSilentB);
    }

    public String getJavaClassMethod(boolean nonSilentB) throws CfwException {
        return this.getCfmMicroStep().getJavaClassMethod(nonSilentB);
    }

    public String getJavaClass(boolean nonSilentB) throws CfwException {
        return this.getCfmMicroStep().getJavaClass(nonSilentB);
    }

    public String getActionRef() {
        return this.getCfmMicroStepState().getActionRef();
    }

    public String getAggregateIdRef() {
        return this.getCfmMicroStep().getAggregateActionRef().getReferredOwner().getSelfID();
    }

    public AggregateVersion getActionInvocationVersionRef() {
        return this.getCfmMicroStepState().getAggregateActionInvocationState().getAggregateVersionRef();
    }

    public long getActionInvocationLabelRef() {
        return this.getCfmMicroStepState().getAggregateActionInvocationState().getAggregateInstanceLabelRef();
    }

    public String getNsRef() {
        return this.getCfmMicroStep().getAggregateActionRef().getReferredOwner().getNamespace();
    }

    public MicroStepFlavor getFlavor() {
        return this.getCfmMicroStepState().getFlavor();
    }

    public boolean isFlavor(MicroStepFlavor flavor) throws CfwException {
        return this.getCfmMicroStepState().isFlavor(flavor);
    }

    public void setStatus(MicroStepStatus status) {
        this.getCfmMicroStepState().setStatus(status);
    }

    public MicroStepStatus getMicroStepStatus() {
        return this.getCfmMicroStepState().getStatus();
    }

    CfmAggregateRefPair getAggregateRefPair() {
        CfwIdentifier ident = new CfwIdentifier(this.getAggregateIdRef(), this.getNsRef());
        CfmAggregateRefPair pair = this.getAggregateHolder().getAggregateRefPair(ident);
        if (pair != null) {
            return pair;
        }
        throw new Error("An invalid CfmMicroStepPair was created");
    }

    public boolean isActionAggregateAvailable() {
        return this.getCfmMicroStep().getAggregateActionRef().getActualReference() != null;
    }

    public boolean isActionAggregateActive() {
        return this.getAggregateRefPair().getCfmAggregateRefState().isActive();
    }

    CfmActionPair getReferredAction(ActionType actionType) {
        CfmActionPair referredAction;
        String actionID = this.getActionRef();
        if (this.getFlavor() == MicroStepFlavor.ACTION_REF) {
            try {
                referredAction = this.getAggregateHolder().getActionPairById(actionID);
            }
            catch (CfwException e) {
                throw new Error(this.toString() + " references Action id=" + actionID + ", which doesn't exist");
            }
        } else if (this.getFlavor() == MicroStepFlavor.AGGREGATE_ACTION_REF) {
            CfmAggregateHolder holder = this.getReferredAggregateHolderLatestInstance();
            if (holder == null) {
                return null;
            }
            try {
                referredAction = holder.getActionPair(actionID, actionType);
            }
            catch (CfwException e) {
                throw new Error(this.toString() + " references Aggregate " + holder.toString() + " but no Action for id=" + actionID + " type=" + actionType + " exists");
            }
        } else {
            throw new Error("CfmMicroStepPair.getReferredAction: invalid flavor " + this.getFlavor());
        }
        return referredAction;
    }

    public CfmAggregateHolder getReferredAggregateHolderLatestInstance() {
        if (this.getFlavor() != MicroStepFlavor.AGGREGATE_ACTION_REF) {
            throw new Error("CfmMicroStepPair.getReferredAggregateHolder: invalid flavor " + this.getFlavor());
        }
        return this.getAggregateRefPair().getReferredHolder();
    }

    boolean isAttached() {
        return this.attached;
    }

    void msInit(boolean isSilentlyB) throws CfwException {
        PlugInInvocationState pState = this.getPlugInInvocationState();
        if (pState == null) {
            CfmUtil.myAssert(this.getFlavor() == MicroStepFlavor.ACTION_REF || this.getFlavor() == MicroStepFlavor.AGGREGATE_ACTION_REF);
            return;
        }
        pState.init(this, isSilentlyB);
        this.attached = this.getCfmMicroStep().getPlugInInvocation().isAttached();
    }

    CfmArguments getCurrentArgs(boolean silentPlugins) throws CfwException {
        List args = this.getCfmMicroStep().getArg(!silentPlugins);
        return new CfmArguments(args, this.getAggregateHolder());
    }

    public boolean isRunOnce() throws CfwException {
        return !this.getCfmMicroStep().getPlugInInvocation().isReRunnable();
    }

    public PerformMicroStep getMicroStepPerformer(ActionPerformer ap, boolean isSilentlyB, ActionType actionType) throws CfwException {
        this.msInit(isSilentlyB);
        if (!this.getCfmMicroStep().getPlugInInvocation().getPlugInNoNull().isActive()) {
            this.getCfmMicroStepState().setStatus(MicroStepStatus.INACTIVE_PLUGIN);
            if (Cfm.isDebug()) {
                this.cfmLogger.log(Level.INFO, "CfmMicroStepPair.perform: not required: PlugIn is not Active");
            }
            return null;
        }
        if (!this.getCfmMicroStepState().getPlugInInvocationState().isActive()) {
            this.getCfmMicroStepState().setStatus(MicroStepStatus.INACTIVE_PLUGININVOCATION);
            if (Cfm.isDebug()) {
                this.cfmLogger.log(Level.INFO, "CfmMicroStepPair.perform: not required: PlugInInvocation is not Active");
            }
            return null;
        }
        if (this.getCfmMicroStepState().getStatus().skipDuringRetry() && this.isRunOnce()) {
            CfmUtil.myAssert("MicroStep should have already been filtered", false);
            return null;
        }
        return new PerformMicroStep(this, !isSilentlyB, actionType);
    }

    @Override
    public void save(StringBuffer sb) {
        MicroStepFlavor flavor = this.getFlavor();
        if (flavor == MicroStepFlavor.EXTERNAL_JAVA_INVOCATION || flavor == MicroStepFlavor.EXTERNAL_PROGRAM_INVOCATION || flavor == MicroStepFlavor.INTERNAL_INVOCATION) {
            this.getPlugInInvocationState().save(sb, this.getCfmMicroStepState().getStatus());
        } else if (flavor == MicroStepFlavor.ACTION_REF) {
            sb.append("\t\t\t<ins:ActionInvocation actionRef=\"").append(Formatter.escapeXMLSequences(this.getActionRef())).append("\" status=\"").append(Formatter.escapeXMLSequences(this.getCfmMicroStepState().getStatus().getIdent())).append("\" />\n");
        } else if (flavor == MicroStepFlavor.AGGREGATE_ACTION_REF) {
            AggregateVersion versionRef;
            sb.append("\t\t\t<ins:AggregateActionInvocation nsref=\"").append(Formatter.escapeXMLSequences(this.getNsRef())).append("\" aggregateFamilyRef=\"").append(Formatter.escapeXMLSequences(this.getCfmMicroStepState().getAggregateActionInvocationState().getAggregateFamilyNameRef())).append("\" aggregateIdRef=\"").append(Formatter.escapeXMLSequences(this.getAggregateIdRef())).append("\" ");
            String actionRef = this.getActionRef();
            if (actionRef != null) {
                sb.append("actionRef=\"" + Formatter.escapeXMLSequences(actionRef) + "\" ");
            }
            MicroStepStatus status = this.getCfmMicroStepState().getStatus();
            sb.append("status=\"" + Formatter.escapeXMLSequences(status.getIdent()) + "\" ");
            if (!status.equals(MicroStepStatus.AGGREGATE_NOT_AVAILABLE) && (versionRef = this.getActionInvocationVersionRef()) != null) {
                sb.append("aggregateVersionRef=\"" + versionRef + "\" ");
                sb.append("aggregateLabelRef=\"" + this.getActionInvocationLabelRef() + "\" ");
            }
            sb.append("/>\n");
        }
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null) {
            throw new Error("CfmActionStepPair.compare: invalid (null) o1");
        }
        if (!(o1 instanceof CfmMicroStepPair)) {
            throw new Error("CfmActionStepPair.compare: \"foreign\" o1 " + o1.getClass().getName());
        }
        if (o2 == null) {
            throw new Error("CfmActionStepPair.compare: invalid (null) o2");
        }
        if (!(o2 instanceof CfmMicroStepPair)) {
            throw new Error("CfmActionStepPair.compare: \"foreign\" o2 " + o2.getClass().getName());
        }
        CfmMicroStepPair msp1 = (CfmMicroStepPair)o1;
        CfmMicroStepPair msp2 = (CfmMicroStepPair)o2;
        int idx1 = msp1.getIndex();
        int idx2 = msp2.getIndex();
        return CfmUtil.intCompare(idx1, idx2);
    }

    public static Comparator getMicroStepPairComparator() {
        return microStepPairComparator;
    }

    @Override
    public String getSelfID() {
        return "" + this.getIndex();
    }

    public boolean filterForRetry(boolean retry) throws CfwException {
        return (retry || this.isRunOnce()) && this.getCfmMicroStepState().getStatus().skipDuringRetry();
    }

    public boolean filterForDetached(boolean skipDetached) throws CfwException {
        return skipDetached && !this.getCfmMicroStep().getPlugInInvocation().isAttached();
    }

    public boolean filterForRetryOrDetached(boolean retry, boolean skipDetached) throws CfwException {
        return this.filterForRetry(retry) || this.filterForDetached(skipDetached);
    }

    public String getStatusDetails() throws CfwException {
        return this.getPlugInInvocationStateNoNull().getStatusDetails();
    }

    @Override
    public String getSummary() throws CfwException {
        return this.getCfmMicroStepState().getSummary();
    }

    public String getCommand() throws CfwException {
        return this.getPlugInInvocationStateNoNull().getCommand();
    }

    public String getArg() throws CfwException {
        return this.getPlugInInvocationStateNoNull().getArg();
    }

    public IReference getReference() {
        return null;
    }

    public StatusOrType getStatus() throws CfwException {
        return this.getMicroStepStatus();
    }

    public IObject getParent() throws CfwException {
        return null;
    }

    @Override
    public String toString() {
        return ((CfmTaggedObject)this.getCfmObject()).getCfmIdentity().toString();
    }
}

