/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmActionRef;
import oracle.sysman.emCfg.core.CfmActionStep;
import oracle.sysman.emCfg.core.CfmCmdExec;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmOwnedAggregateActionRef;
import oracle.sysman.emCfg.core.CfmPlugInInvocation;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.PlugInInvocationState;
import oracle.sysman.emCfg.core.PlugInInvocationStateExternalJava;
import oracle.sysman.emCfg.core.PlugInInvocationStateExternalProgram;
import oracle.sysman.emCfg.core.PlugInInvocationStateInternal;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.MicroStepFlavor;

class CfmMicroStep
extends CfmTaggedObject {
    public static final CfmElementType elementType = CfmElementType.MICRO_STEP;
    private final CfmOwnedAggregateActionRef aggregateActionRef;
    private final CfmActionRef actionRef;
    private final CfmPlugInInvocation plugInInvocation;
    private final CfmActionStep actionStep;
    private final int microStepIndex;
    private MicroStepFlavor flavor = MicroStepFlavor.UNRESOLVED_FLAVOR;

    public int getIndex() {
        return this.microStepIndex;
    }

    public int getStepIndex() {
        return this.actionStep.getIndex();
    }

    public CfmMicroStep(DescriptionsLoader loader, CfmActionStep actionStep, CfmActionRef actionRef, int microStepIndex) {
        super(loader, null, elementType, "AS" + actionStep.getIndex() + ",MS" + microStepIndex, actionStep);
        this.actionStep = actionStep;
        this.microStepIndex = microStepIndex;
        this.aggregateActionRef = null;
        this.actionRef = actionRef;
        this.plugInInvocation = null;
    }

    public CfmMicroStep(DescriptionsLoader loader, CfmActionStep actionStep, CfmOwnedAggregateActionRef aggActionRef, int microStepIndex) {
        super(loader, null, elementType, Integer.toString(microStepIndex), actionStep);
        this.actionStep = actionStep;
        this.microStepIndex = microStepIndex;
        this.aggregateActionRef = aggActionRef;
        this.actionRef = null;
        this.plugInInvocation = null;
    }

    public CfmMicroStep(DescriptionsLoader loader, CfmActionStep actionStep, CfmPlugInInvocation plugInInvocation, int microStepIndex) {
        super(loader, null, elementType, Integer.toString(microStepIndex), actionStep);
        this.actionStep = actionStep;
        this.microStepIndex = microStepIndex;
        this.aggregateActionRef = null;
        this.actionRef = null;
        this.plugInInvocation = plugInInvocation;
    }

    private void determineFlavor() {
        if (!MicroStepFlavor.UNRESOLVED_FLAVOR.equals(this.flavor)) {
            return;
        }
        if (this.aggregateActionRef != null) {
            this.setFlavor(MicroStepFlavor.AGGREGATE_ACTION_REF);
        } else if (this.actionRef != null) {
            this.setFlavor(MicroStepFlavor.ACTION_REF);
        } else {
            try {
                if (this.plugInInvocation.isJava(false)) {
                    if (this.plugInInvocation.isInternal(false)) {
                        this.setFlavor(MicroStepFlavor.INTERNAL_INVOCATION);
                    } else {
                        this.setFlavor(MicroStepFlavor.EXTERNAL_JAVA_INVOCATION);
                    }
                } else {
                    this.setFlavor(MicroStepFlavor.EXTERNAL_PROGRAM_INVOCATION);
                }
            }
            catch (CfwException plugE) {
                this.setFlavor(MicroStepFlavor.UNRESOLVED_FLAVOR);
            }
        }
    }

    public CfmActionStep getActionStep() {
        return this.actionStep;
    }

    public CfmOwnedAggregateActionRef getAggregateActionRef() {
        return this.aggregateActionRef;
    }

    public CfmActionRef getActionRef() {
        return this.actionRef;
    }

    public CfmPlugInInvocation getPlugInInvocation() {
        return this.plugInInvocation;
    }

    public List getArg(boolean nonSilentB) throws CfwException {
        return this.getPlugInInvocation().getArg(nonSilentB);
    }

    public CfmCmdExec getCmdExec(boolean nonSilentB) throws CfwException {
        return this.getPlugInInvocation().getCmdExec(nonSilentB);
    }

    public String getJavaClassMethod(boolean nonSilentB) throws CfwException {
        return this.getPlugInInvocation().getJavaClassMethod(nonSilentB);
    }

    public String getJavaClass(boolean nonSilentB) throws CfwException {
        return this.getPlugInInvocation().getJavaClass(nonSilentB);
    }

    private void setFlavor(MicroStepFlavor flavor) {
        this.flavor = flavor;
    }

    public MicroStepFlavor getFlavor() {
        if (this.flavor.equals(MicroStepFlavor.UNRESOLVED_FLAVOR)) {
            this.determineFlavor();
        }
        if (this.flavor.equals(MicroStepFlavor.UNRESOLVED_FLAVOR)) {
            CfmUtil.myAssert(false);
            throw new Error("Unable to resolve plugin with id=" + this.getPlugInInvocation().getPlugInIdRef() + " in " + this.toString());
        }
        return this.flavor;
    }

    public PlugInInvocationState newPlugInInvocationState() {
        if (this.getFlavor() == MicroStepFlavor.INTERNAL_INVOCATION) {
            return new PlugInInvocationStateInternal();
        }
        if (this.getFlavor() == MicroStepFlavor.EXTERNAL_PROGRAM_INVOCATION) {
            return new PlugInInvocationStateExternalProgram();
        }
        if (this.getFlavor() == MicroStepFlavor.EXTERNAL_JAVA_INVOCATION) {
            return new PlugInInvocationStateExternalJava();
        }
        return null;
    }
}

