/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmWrapper;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.schema.descriptions.InheritanceT;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmInheritance
extends CfmWrapper {
    private final List includes;
    private final String ns;

    static CfmInheritance getInstance(DescriptionsLoader loader, InheritanceT inheritanceT) throws CfwException {
        String rawIncludes;
        String ns;
        if (inheritanceT == null) {
            ns = "common";
            rawIncludes = null;
        } else {
            ns = CfmUtil.noNull(inheritanceT.getNs(), "common");
            rawIncludes = inheritanceT.getIncludes();
        }
        List includes = CfmInheritance.parseIncludes(rawIncludes, ns);
        return new CfmInheritance(loader, inheritanceT, ns, includes);
    }

    private static List parseIncludes(String includes, String ns) throws CfwException {
        Vector<String> result = new Vector<String>();
        if (includes != null) {
            StringTokenizer st = new StringTokenizer(includes);
            while (st.hasMoreTokens()) {
                String curr = st.nextToken();
                if (result.contains(curr)) {
                    throw new CfwException("Duplicate namespace reference (" + curr + ") encountered while parsing includes");
                }
                result.add(curr);
            }
            if (result.contains(ns)) {
                throw new CfwException("The includes attribute should not contain the declared namespace " + ns);
            }
        }
        result.add(ns);
        return result;
    }

    private CfmInheritance(DescriptionsLoader loader, InheritanceT jaxbOrigin, String ns, List includes) {
        super(loader, jaxbOrigin);
        this.includes = includes;
        this.ns = ns;
        CfmUtil.myAssert(ns != null);
    }

    public String getNamespace() {
        return this.ns;
    }

    public boolean isWithinCurrentIncludes(String ns) {
        for (String curr : this.includes) {
            if (!curr.equals(ns)) continue;
            return true;
        }
        return false;
    }
}

