/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.List;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfmLoggerFactory;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;

public class CfmFactory {
    static CfmLogger cfmLogger = Cfm.getLogger();
    private Cfm cfm;
    private static CfmFactory _latestInstance = null;

    public static CfmFactory connect() throws CfwException {
        return CfmFactory.connect(false, null);
    }

    public static CfmFactory connect(boolean debugB) throws CfwException {
        return CfmFactory.connect(debugB, null);
    }

    public static CfmFactory connect(List aggregateIDsAsList) throws CfwException {
        return CfmFactory.connect(Constants.VERBOSE_OUTPUT, aggregateIDsAsList);
    }

    public static CfmFactory connect(boolean debugB, List aggregateIDsAsList) throws CfwException {
        return CfmFactory.connect(debugB, null, null, null, aggregateIDsAsList);
    }

    public static synchronized CfmFactory connect(boolean debugB, String oracleHome, String descriptionsBase, String instanceBase, List aggregateIDsAsList) throws CfwException {
        cfmLogger.log(Level.INFO, "CfmFactory.connect() was called");
        CfmFactory newInstance = new CfmFactory(debugB, oracleHome, descriptionsBase, instanceBase);
        cfmLogger.log(Level.INFO, "Creating new CFM connection");
        newInstance.getCfm().loadDescriptionsByAggregateID(aggregateIDsAsList);
        newInstance.getCfm().loadAssociatedInstancesAndCreateHolders();
        _latestInstance = newInstance;
        cfmLogger.log(Level.INFO, "Successfully returning from CfmFactory.connect()");
        return _latestInstance;
    }

    public static void reset() {
    }

    static Cfm getTheCfm() throws CfwException {
        if (null == _latestInstance) {
            throw new CfwException("Uninitialized factory");
        }
        return _latestInstance.getCfm();
    }

    private CfmFactory(boolean debugB, String oracleHome, String descriptionsBase, String instanceBase) throws CfwException {
        oracleHome = CfmUtil.trimmedNoNullOrEmptyString(oracleHome, Constants.DEFAULT_ORACLE_HOME);
        descriptionsBase = CfmUtil.trimmedNoNullOrEmptyString(descriptionsBase, Constants.DEFAULT_DESCRIPTIONS_PATH);
        instanceBase = CfmUtil.trimmedNoNullOrEmptyString(instanceBase, Constants.DEFAULT_INSTANCE_PATH);
        LoadLocation baseLoadLocation = LoadLocation.getInstance(oracleHome, descriptionsBase, instanceBase, cfmLogger);
        this.cfm = new Cfm(debugB, baseLoadLocation);
    }

    public static void disconnect() {
        CfmLoggerFactory.closeCfmFileHandlers();
    }

    Cfm getCfm() {
        return this.cfm;
    }
}

