/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmParameterPair;
import oracle.sysman.emCfg.core.CfmParameterRef;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.ParameterUsePolicy;
import oracle.sysman.emCfg.schema.descriptions.ExpandableString;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmExpandableString {
    private final List data = new Vector();

    public static CfmExpandableString getInstance(DescriptionsLoader loader, ExpandableString expStr, CfmTaggedObject owner, ParameterUsePolicy parameterUsePolicy) throws CfwException {
        if (expStr == null) {
            return new CfmExpandableString("");
        }
        String rawString = CfmUtil.noNull(expStr.getValue(), "");
        if (expStr.isExpand()) {
            return new CfmExpandableString(loader, rawString, owner, parameterUsePolicy);
        }
        return new CfmExpandableString(rawString);
    }

    public static CfmExpandableString getInstance(String constantString) {
        return new CfmExpandableString(CfmUtil.noNull(constantString, ""));
    }

    private void addData(Object o) {
        CfmUtil.myAssert(o != null);
        this.data.add(o);
    }

    private CfmExpandableString(String constantString) {
        this.addData(constantString);
    }

    private CfmExpandableString(DescriptionsLoader loader, String rawString, CfmTaggedObject owner, ParameterUsePolicy parameterUsePolicy) throws CfwException {
        int currPos = 0;
        while (true) {
            int currEscapeStart;
            if ((currEscapeStart = rawString.indexOf("${", currPos)) == -1) {
                this.addData(rawString.substring(currPos));
                return;
            }
            this.addData(rawString.substring(currPos, currEscapeStart));
            int currParameterNameStart = currEscapeStart + "${".length();
            int currParameterNameEnd = rawString.indexOf("}", currParameterNameStart);
            if (currParameterNameEnd == -1) {
                throw new CfwException("Ending escape sequence \"}\" required to end parameter: " + rawString.substring(currEscapeStart));
            }
            String parameterID = rawString.substring(currParameterNameStart, currParameterNameEnd);
            CfmParameterRef ref = new CfmParameterRef(loader, parameterID, owner, parameterUsePolicy);
            this.addData(ref);
            loader.getDescriptionResolver().addUnresolved(ref);
            currPos = currParameterNameEnd + "}".length();
        }
    }

    public String evaluate(CfmAggregateHolder aggregateHolder) throws CfwException {
        return this.evaluate(aggregateHolder, false, false);
    }

    public String evaluate(CfmAggregateHolder aggregateHolder, boolean transientToName, boolean uninitializedToName) throws CfwException {
        StringBuffer result = new StringBuffer();
        for (Object currPart : this.data) {
            if (currPart instanceof String) {
                result.append((String)currPart);
                continue;
            }
            CfmParameterRef ref = (CfmParameterRef)currPart;
            CfmParameterPair referredParameter = aggregateHolder.getParameterPair(ref.getIdref());
            if (transientToName && referredParameter.isTransient() || uninitializedToName && referredParameter.isUninitialized()) {
                result.append(referredParameter.asEmbeddedParameterName());
                continue;
            }
            result.append(referredParameter.getValueAsSimplestString());
        }
        return result.toString();
    }
}

