/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.CfwVersionedIdentifier;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmInheritance;
import oracle.sysman.emCfg.core.CfmParentObject;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.ICfmWrapper;
import oracle.sysman.emCfg.schema.descriptions.DescriptionsT;

class CfmDescriptions
extends CfmParentObject {
    private final String platform;
    private final CfmInheritance inheritance;

    static CfmDescriptions getInstance(DescriptionsLoader loader, DescriptionsT descriptionsT) throws CfwException {
        AggregateVersion version = AggregateVersion.versionFromString(descriptionsT.getVersion());
        CfmInheritance inheritanceObj = CfmInheritance.getInstance(loader, descriptionsT.getInheritance());
        String namespace = inheritanceObj.getNamespace();
        String platform = descriptionsT.getPlatform();
        CfwVersionedIdentifier owner = new CfwVersionedIdentifier("", version, namespace);
        return new CfmDescriptions(loader, descriptionsT, owner, platform, inheritanceObj);
    }

    private CfmDescriptions(DescriptionsLoader loader, DescriptionsT jaxbOrigin, CfwVersionedIdentifier owner, String platform, CfmInheritance inheritance) {
        super(loader, jaxbOrigin, owner);
        this.platform = platform;
        this.inheritance = inheritance;
        loader.getObjectFactory().addDescriptions(this);
    }

    public CfmInheritance getInheritance() {
        return this.inheritance;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getNS() {
        if (this.inheritance != null) {
            return this.inheritance.getNamespace();
        }
        return "common";
    }

    public CfwIdentifier getVersionlessIdentifier() {
        return new CfwIdentifier(null, this.getNS());
    }

    public Collection getAggregates() {
        LinkedList result = new LinkedList();
        Iterator memberIter = this.memberIterator();
        while (memberIter.hasNext()) {
            Object member = memberIter.next();
            if (!(member instanceof CfmAggregate)) continue;
            result.add(member);
        }
        return result;
    }

    public void addParameterModel(ICfmWrapper o) {
        this.addMember(o);
    }
}

