/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.ICondition;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAnyPair;
import oracle.sysman.emCfg.core.CfmCondition;
import oracle.sysman.emCfg.core.CfmConditionState;
import oracle.sysman.emCfg.core.CfmParameterPair;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.StatusOrType;

class CfmConditionPair
extends CfmAnyPair
implements ICondition {
    public CfmConditionPair(CfmAggregateHolder cfmAggregateHolder, CfmCondition cfmObject, CfmConditionState cfmObjectState) {
        super(cfmAggregateHolder, cfmObject, cfmObjectState);
    }

    public CfmCondition getCfmCondition() {
        return (CfmCondition)this.getCfmObject();
    }

    public CfmConditionState getCfmConditionState() {
        return (CfmConditionState)this.getCfmObjectState();
    }

    public String getConditionID() {
        return this.getCfmCondition().getSelfID();
    }

    @Override
    public void setValue(boolean value) {
        this.getCfmConditionState().setValue(value);
    }

    @Override
    public boolean getValue() {
        return this.getCfmConditionState().getValue();
    }

    @Override
    public void save(StringBuffer sb) {
        sb.append("\t<ins:Condition id=\"" + Formatter.escapeXMLSequences(this.getConditionID()) + "\" ");
        sb.append("value=\"" + this.getValue() + "\" />\n");
    }

    @Override
    public String getSelfID() {
        return this.getConditionID();
    }

    public static boolean isCondition(CfmAnyPair conditionOrParameterPair) {
        if (conditionOrParameterPair instanceof CfmConditionPair) {
            CfmConditionPair conditionPair = (CfmConditionPair)conditionOrParameterPair;
            return conditionPair.getCfmConditionState().getValue();
        }
        if (conditionOrParameterPair instanceof CfmParameterPair) {
            CfmParameterPair parameterPair = (CfmParameterPair)conditionOrParameterPair;
            try {
                try {
                    int iVal = parameterPair.getValueAsSimplestInt();
                    return iVal != 0;
                }
                catch (NumberFormatException iVal) {
                    return parameterPair.getValueAsSimplestBoolean();
                }
            }
            catch (CfwException cfme) {
                return false;
            }
        }
        return true;
    }

    @Override
    public IReference getReference() {
        return null;
    }

    @Override
    public StatusOrType getStatus() throws CfwException {
        throw new CfwException("ICondition objects do not have a Status to query");
    }

    @Override
    public IObject getParent() throws CfwException {
        return this.getAggregateHolder();
    }
}

