/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmExpandableString;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParameterPair;

class CfmArguments {
    private final List args;
    private final CfmAggregateHolder aggHolder;

    public CfmArguments(List args, CfmAggregateHolder aggHolder) {
        this.args = args;
        this.aggHolder = aggHolder;
    }

    public CfmArguments(CfmArguments base) {
        this.args = new LinkedList(base.args);
        this.aggHolder = base.aggHolder;
    }

    public CfmArguments prepend(String newArg) {
        this.args.add(0, CfmExpandableString.getInstance(newArg));
        return this;
    }

    public CfmArguments prepend(CfmExpandableString newArg) {
        this.args.add(0, newArg);
        return this;
    }

    public String[] expand(boolean transientToName, boolean uninitializedToName) throws CfwException {
        ArrayList elems = new ArrayList();
        Iterator a = this.args.iterator();
        while (a.hasNext()) {
            this.expandOneArgv(a.next(), elems, transientToName, uninitializedToName);
        }
        return elems.toArray(new String[0]);
    }

    public String[] expandNoException(boolean transientToName, boolean uninitializedToName) {
        ArrayList<String> elems = new ArrayList<String>();
        Iterator a = this.args.iterator();
        while (a.hasNext()) {
            try {
                this.expandOneArgv(a.next(), elems, transientToName, uninitializedToName);
            }
            catch (CfwException e) {
                elems.add("*failed to expand parameter*");
            }
        }
        return elems.toArray(new String[0]);
    }

    private void expandOneArgv(Object o, List elems, boolean transientToName, boolean uninitializedToName) throws CfwException {
        if (o instanceof CfmExpandableString) {
            String result = ((CfmExpandableString)o).evaluate(this.aggHolder, transientToName, uninitializedToName);
            elems.add(result);
        } else if (o instanceof CfmParameter) {
            CfmParameterPair parameterPair = this.aggHolder.getParameterPair(((CfmParameter)o).getSelfID());
            parameterPair.appendDataAsArgv(elems, transientToName, uninitializedToName);
        } else {
            throw new Error("invalid arg " + o.getClass().getName());
        }
    }

    public String[] expandForDisplay() {
        return this.expandNoException(true, true);
    }

    public String[] expandAsArgv() throws CfwException {
        return this.expand(false, false);
    }
}

