/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmObjectState;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.schema.instance.AggregateT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.AggregatePhase;
import oracle.sysman.emCfg.types.AggregateStatus;
import oracle.sysman.emCfg.types.AggregateType;

class CfmAggregateState
extends CfmObjectState {
    private final AggregateType type;
    private AggregatePhase phase;
    private AggregateStatus status;

    public CfmAggregateState(CfmAggregateInstance aggregateInstance, AggregateT aggregateT) throws CfwException {
        super(aggregateInstance, aggregateInstance.getAggID());
        String typeString = aggregateT.getType();
        AggregateType type = AggregateType.getType(typeString);
        if (type == null) {
            throw new CfwException("type is required for an ins:AggregateT");
        }
        this.type = type;
        String phaseS = aggregateT.getPhase();
        this.setPhase(AggregatePhase.getPhase(phaseS));
        String statusS = aggregateT.getStatus();
        this.setStatus(AggregateStatus.getStatus(statusS));
    }

    public CfmAggregateState(CfmAggregateInstance aggregateInstance, CfmAggregate aggregateDesc) throws CfwException {
        super(aggregateInstance, aggregateInstance.getAggID());
        this.type = aggregateDesc.getType();
        this.setPhase(AggregatePhase.N);
        this.setStatus(AggregateStatus.UNKNOWN);
    }

    @Override
    public CfmStateType getStateType() {
        return CfmStateType.AGGREGATE;
    }

    public AggregateType getType() {
        return this.type;
    }

    public void setPhase(AggregatePhase phase) throws IllegalArgumentException {
        CfmUtil.preconditionNotNull(phase, "phase");
        this.phase = phase;
    }

    public AggregatePhase getPhase() {
        return this.phase;
    }

    public void setStatus(AggregateStatus status) throws CfwException {
        CfmUtil.preconditionNotNull(status, "status");
        this.status = status;
    }

    public AggregateStatus getStatus() {
        return this.status;
    }
}

