/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmObjectState;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.schema.instance.AggregateRefT;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmAggregateRefState
extends CfmObjectState {
    private final Cfm cfm;
    private final String idRef;
    private final String nsRef;
    private final String familyNameRef;
    private boolean wasAvailable;
    private AggregateVersion versionRef;
    private long labelRef;
    private boolean activeB = true;

    public CfmAggregateRefState(Cfm cfm, CfmAggregateInstance aggregateInstance, AggregateRefT aggregateRefT) throws CfwException {
        super(aggregateInstance, aggregateRefT.getIdRef());
        CfmUtil.myAssert(aggregateRefT != null);
        this.cfm = cfm;
        this.idRef = aggregateRefT.getIdRef();
        this.nsRef = CfmUtil.noNull(aggregateRefT.getNsref(), "common");
        this.familyNameRef = aggregateInstance.getFamilyName();
        this.setActive(aggregateRefT.isIsActive());
        this.wasAvailable = aggregateRefT.isWasAvailable();
        if (this.wasAvailable()) {
            String versionRefString = aggregateRefT.getVersionRef();
            if (versionRefString == null) {
                throw new CfwException("An ins:AggregateRefT must contain a 'versionRef' since 'wasAvailable' is true");
            }
            this.versionRef = AggregateVersion.versionFromString(versionRefString);
            this.labelRef = aggregateRefT.getLabelRef();
        } else {
            this.versionRef = null;
            this.labelRef = -36L;
        }
        this.debugVerify();
    }

    public CfmAggregateRefState(Cfm cfm, CfmAggregateInstance aggregateInstance, CfmAggregateRef aggRef) throws CfwException {
        super(aggregateInstance, aggRef.getIdref());
        CfmUtil.myAssert(aggRef != null);
        this.cfm = cfm;
        this.idRef = aggRef.getIdref();
        this.nsRef = aggRef.getNsRef();
        this.familyNameRef = aggregateInstance.getFamilyName();
        this.setActive(true);
        this.updateRefState(aggRef);
        this.debugVerify();
    }

    void updateRefState(CfmAggregateRef aggRef) {
        CfmAggregate resolvedAggregate = aggRef.getAggregate();
        boolean bl = this.wasAvailable = resolvedAggregate != null;
        if (this.wasAvailable()) {
            this.versionRef = resolvedAggregate.getVersion();
            this.labelRef = this.determineInstanceLabel(resolvedAggregate.getIdentifierWithLocation(), this.getFamilyNameRef());
        } else {
            this.versionRef = null;
            this.labelRef = -36L;
        }
    }

    private long determineInstanceLabel(AggregateDescriptionIdentifierWithLocation agg, String familyName) {
        try {
            return this.cfm.getLatestInstanceLabel(agg, familyName);
        }
        catch (CfwException e) {
            return -9999L;
        }
    }

    private void debugVerify() {
        CfmUtil.myAssert(this.idRef != null);
    }

    public String getIdRef() {
        return this.idRef;
    }

    public String getNsRef() {
        return this.nsRef;
    }

    public String getFamilyNameRef() {
        return this.familyNameRef;
    }

    public boolean wasAvailable() {
        return this.wasAvailable;
    }

    public AggregateVersion getVersionRef() {
        return this.versionRef;
    }

    public long getLabelRef() {
        return this.labelRef;
    }

    public void setActive(boolean activeB) {
        this.activeB = activeB;
    }

    public boolean isActive() {
        return this.activeB;
    }

    @Override
    public CfmStateType getStateType() {
        return CfmStateType.REF;
    }
}

