/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmAggregateRefState;
import oracle.sysman.emCfg.core.CfmAnyPair;
import oracle.sysman.emCfg.support.Formatter;

class CfmAggregateRefPair
extends CfmAnyPair {
    public CfmAggregateRefPair(CfmAggregateHolder cfmAggregateHolder, CfmAggregateRef cfmObject, CfmAggregateRefState cfmObjectState) {
        super(cfmAggregateHolder, cfmObject, cfmObjectState);
    }

    public CfmAggregateRef getCfmAggregateRef() {
        return (CfmAggregateRef)this.getCfmObject();
    }

    public CfmAggregateRefState getCfmAggregateRefState() {
        return (CfmAggregateRefState)this.getCfmObjectState();
    }

    public CfwIdentifier getRefIdent() {
        return new CfwIdentifier(this.getIdRef(), this.getNsRef());
    }

    public String getIdRef() {
        return this.getCfmAggregateRef().getIdref();
    }

    public AggregateVersion getVersionRef() {
        return this.getCfmAggregateRefState().getVersionRef();
    }

    public String getNsRef() {
        return this.getCfmAggregateRefState().getNsRef();
    }

    public String getFamilyNameRef() {
        return this.getCfmAggregateRefState().getFamilyNameRef();
    }

    public long getLabelRef() {
        return this.getCfmAggregateRefState().getLabelRef();
    }

    public void setActive(boolean activeB) {
        this.getCfmAggregateRefState().setActive(activeB);
    }

    public boolean isActive() {
        return this.getCfmAggregateRefState().isActive();
    }

    public boolean isAvailable() {
        CfmAggregate aggregate = this.getCfmAggregateRef().getAggregate();
        return aggregate != null;
    }

    public long getCurrentLabelRef() {
        Cfm cfm = this.getAggregateHolder().getCfm();
        return cfm.getLatestInstanceLabelNoException(this.getCfmAggregateRef().getActualReferredAggregateIdentifierWithLocation(), this.getAggregateHolder().getFamilyName());
    }

    @Override
    public void save(StringBuffer sb) {
        this.getCfmAggregateRefState().updateRefState(this.getCfmAggregateRef());
        sb.append("\t<ins:AggregateRef  ");
        sb.append("wasAvailable=\"" + this.isAvailable() + "\" ");
        sb.append("nsref=\"" + Formatter.escapeXMLSequences(this.getNsRef()) + "\" ");
        sb.append("idRef=\"" + Formatter.escapeXMLSequences(this.getIdRef()) + "\" ");
        if (this.isAvailable()) {
            sb.append("versionRef=\"" + this.getVersionRef() + "\" ");
            sb.append("labelRef=\"" + this.getCurrentLabelRef() + "\" ");
        }
        sb.append("familyRef=\"" + Formatter.escapeXMLSequences(this.getFamilyNameRef()) + "\" ");
        sb.append("isActive=\"" + this.isActive() + "\" />\n");
    }

    @Override
    public String getSelfID() {
        return "" + this.getIdRef();
    }

    public CfmAggregateHolder getReferredHolder() {
        AggregateDescriptionIdentifierWithLocation ident = this.getCfmAggregateRef().getActualReferredAggregateIdentifierWithLocation();
        if (ident == null) {
            return null;
        }
        String familyNameRef = this.getAggregateHolder().getFamilyName();
        return this.getAggregateHolder().getCfm().getLatestInstance(ident, familyNameRef);
    }
}

