/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmReference;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.IdentifierIdNsLocation;
import oracle.sysman.emCfg.core.LoadAggregateRequest;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.descriptions.AggregateRefT;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmAggregateRef
extends CfmReference {
    private final LoadLocation referredLoadLocation;
    private final String ownership;
    private final boolean ohSpecified;
    private static final CfmElementType[] possibleReferredTypes = new CfmElementType[]{CfmElementType.AGGREGATE};

    public CfmAggregateRef(DescriptionsLoader loader, AggregateRefT aggregateRefT, AggregateDescriptionIdentifier referredAggregate) {
        super(loader, aggregateRefT, referredAggregate);
        String rawOh = aggregateRefT.getOh();
        String oh = CfmAggregateRef.parseOH(loader, rawOh);
        this.ohSpecified = rawOh != null;
        String desc_base = aggregateRefT.getDescriptionsBase();
        String inst_base = aggregateRefT.getInstanceBase();
        this.referredLoadLocation = loader.getCfm().getLoadLocation(oh, desc_base, inst_base);
        this.ownership = aggregateRefT.getOwnership();
    }

    private static String parseOH(DescriptionsLoader loader, String oh) {
        if (oh == null) {
            return loader.getCurrentAggregate().getOHAbs().toString();
        }
        return CfmUtil.evaluatePath(oh, loader.getCurrentAggregate().getOHAbs().toString());
    }

    public boolean isOhSpecified() {
        return this.ohSpecified;
    }

    public LoadLocation getReferredLoadLocationForLoading() {
        return this.referredLoadLocation;
    }

    public LoadAggregateRequest getLoadAggregateRequestForLoading() {
        return new LoadAggregateRequest(this.getAggRefIdentifier(), this.getReferredLoadLocationForLoading());
    }

    public String getOwnership() {
        return this.ownership;
    }

    public CfmAggregate getAggregate() {
        if (!this.isResolved()) {
            return null;
        }
        return (CfmAggregate)this.getCfmTaggedObject();
    }

    public CfwIdentifier getVersionlessAggRefIdentifier() {
        return new CfwIdentifier(this.getIdref(), this.getNsRef());
    }

    public AggregateDescriptionIdentifier getAggRefIdentifier() {
        return new AggregateDescriptionIdentifier(this.getIdref(), this.getVersionRef(), this.getNsRef());
    }

    public OHAbsolute getActualReferredLocation(CfmLogger logger) {
        String failureReason;
        OHAbsolute defaultReferredOH = this.getReferredLoadLocationForLoading().getOracleHome();
        if (this.getLoader().getObjectFactory().aggregateExistsInLocation(this.getVersionlessAggRefIdentifier(), defaultReferredOH)) {
            return defaultReferredOH;
        }
        if (!this.isOhSpecified()) {
            try {
                return this.getLoader().getObjectFactory().getUniqueAggregateLocation(this.getVersionlessAggRefIdentifier());
            }
            catch (CfwException e) {
                failureReason = e.getMessage();
            }
        } else {
            failureReason = "it could not be found in " + defaultReferredOH.toString();
        }
        if (logger != null) {
            logger.warning(this.getDisplayName() + " was marked unavailable: " + failureReason);
        }
        return null;
    }

    public OHAbsolute getActualReferredLocation() {
        return this.getActualReferredLocation(null);
    }

    public AggregateVersion getActualReferredVersion(CfmLogger logger) {
        CfmUtil.myAssert(this.getVersionRef() != null);
        if (this.getVersionRef() != AggregateVersion.LATEST) {
            return this.getVersionRef();
        }
        OHAbsolute referredOH = this.getActualReferredLocation(logger);
        if (referredOH == null) {
            return null;
        }
        return this.getLoader().getObjectFactory().getVersionOfAggregateLatestVersion(new IdentifierIdNsLocation(this.getIdref(), this.getNsRef(), referredOH));
    }

    public AggregateVersion getActualReferredVersion() {
        return this.getActualReferredVersion(null);
    }

    public AggregateDescriptionIdentifierWithLocation getActualReferredAggregateIdentifierWithLocation(CfmLogger logger) {
        AggregateVersion actualVersion = this.getActualReferredVersion(logger);
        if (actualVersion == null) {
            return null;
        }
        OHAbsolute actualOH = this.getActualReferredLocation(logger);
        if (actualOH == null) {
            return null;
        }
        return new AggregateDescriptionIdentifierWithLocation(this.getIdref(), actualVersion, this.getNsRef(), actualOH);
    }

    public AggregateDescriptionIdentifierWithLocation getActualReferredAggregateIdentifierWithLocation() {
        return this.getActualReferredAggregateIdentifierWithLocation(null);
    }

    @Override
    protected CfwIdentifier getVersionlessAggregateOwner() {
        return new CfwIdentifier(this.getIdref(), this.getNsRef());
    }

    @Override
    protected CfmElementType[] getPossibleReferredTypes() {
        return possibleReferredTypes;
    }

    @Override
    public boolean isRequired() {
        return false;
    }
}

