/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.emCfg.common.AggregateFamilyIdentifier;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.VersionedAggregateIdentifier;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamilies;
import oracle.sysman.emCfg.core.CfmTagInstance;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmAggregateInstanceFamily {
    private final Hashtable map = new Hashtable();
    private final CfmAggregateInstanceFamilies aggregateInstanceStorage;
    private final String familyName;

    CfmAggregateInstanceFamily(CfmAggregateInstanceFamilies aggregateInstanceStorage, String familyName) throws CfwException {
        this.familyName = familyName;
        this.aggregateInstanceStorage = aggregateInstanceStorage;
        this.aggregateInstanceStorage.add(this);
    }

    public String getAggID() {
        return this.aggregateInstanceStorage.getID();
    }

    public AggregateVersion getVersion() {
        return this.aggregateInstanceStorage.getVersion();
    }

    public String getNS() {
        return this.aggregateInstanceStorage.getNS();
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public AggregateFamilyIdentifier getFamilyIdentifier() {
        return new AggregateFamilyIdentifier(this.getAggID(), this.getNS(), this.getVersion(), this.getFamilyName(), this.aggregateInstanceStorage.getOH());
    }

    public VersionedAggregateIdentifier getVersionedAggregateIdentifier() {
        return new VersionedAggregateIdentifier(this.getAggID(), this.getVersion(), this.getNS());
    }

    public synchronized long[] labels() {
        if (this.getNumLabels() == 0) {
            return new long[0];
        }
        Vector<Long> labels = new Vector<Long>();
        Enumeration e = this.getInstances();
        while (e.hasMoreElements()) {
            CfmAggregateInstance aggregateInstance = (CfmAggregateInstance)e.nextElement();
            long label = aggregateInstance.getLabel();
            labels.add(new Long(label));
        }
        Collections.sort(labels);
        int size = labels.size();
        long[] sortedLabels = new long[size];
        for (int i = 0; i < size; ++i) {
            sortedLabels[i] = (Long)labels.get(i);
        }
        return sortedLabels;
    }

    public synchronized long firstLabel() throws CfwException {
        if (this.getNumLabels() == 0) {
            throw new CfwException("CfmAggregateInstanceFamily.firstLabel: there are no aggregate instances");
        }
        long minLabel = Long.MAX_VALUE;
        Enumeration e = this.getInstances();
        while (e.hasMoreElements()) {
            CfmAggregateInstance aggregateInstance = (CfmAggregateInstance)e.nextElement();
            long label = aggregateInstance.getLabel();
            if (label >= minLabel) continue;
            minLabel = label;
        }
        return minLabel;
    }

    public synchronized long lastLabel() {
        if (this.getNumLabels() == 0) {
            CfmUtil.myAssert(false);
        }
        long maxLabel = Long.MIN_VALUE;
        Enumeration e = this.getInstances();
        while (e.hasMoreElements()) {
            CfmAggregateInstance aggregateInstance = (CfmAggregateInstance)e.nextElement();
            long currLabel = aggregateInstance.getLabel();
            if (currLabel <= maxLabel) continue;
            maxLabel = currLabel;
        }
        return maxLabel;
    }

    public synchronized long previousLabel(long label) throws CfwException {
        if (label < 0L) {
            throw new CfwException("CfmAggregateInstanceFamily.previousLabel: invalid (negative) label=" + label);
        }
        if (this.getNumLabels() == 0) {
            throw new CfwException("CfmAggregateInstanceFamily.previousLabel: there are no aggregate instances");
        }
        long maxLabel = Long.MIN_VALUE;
        Enumeration e = this.getInstances();
        while (e.hasMoreElements()) {
            CfmAggregateInstance aggregateInstance = (CfmAggregateInstance)e.nextElement();
            long someLabel = aggregateInstance.getLabel();
            if (label <= someLabel || someLabel <= maxLabel) continue;
            maxLabel = someLabel;
        }
        if (maxLabel == Long.MIN_VALUE) {
            throw new CfwException("CfmAggregateInstanceFamily.previousLabel: there is no previous from the given label=" + label);
        }
        return maxLabel;
    }

    public synchronized long nextLabel(long label) throws CfwException {
        if (label < 0L) {
            throw new CfwException("CfmAggregateInstanceFamily.nextLabel: invalid (negative) label=" + label);
        }
        if (this.getNumLabels() == 0) {
            throw new CfwException("CfmAggregateInstanceFamily.nextLabel: there are no aggregate instances");
        }
        long minLabel = Long.MAX_VALUE;
        Enumeration e = this.getInstances();
        while (e.hasMoreElements()) {
            CfmAggregateInstance aggregateInstance = (CfmAggregateInstance)e.nextElement();
            long someLabel = aggregateInstance.getLabel();
            if (label >= someLabel || someLabel >= minLabel) continue;
            minLabel = someLabel;
        }
        if (minLabel == Long.MAX_VALUE) {
            throw new CfwException("CfmAggregateInstanceFamily.nextLabel: there is no next from the given label=" + label);
        }
        return minLabel;
    }

    public synchronized CfmAggregateInstance newAggregateInstance(LoadLocation loadLocation) throws CfwException {
        if (this.getNumLabels() == 0) {
            CfmAggregateInstance aggregateInstance = new CfmAggregateInstance(loadLocation, this, -1L);
            return aggregateInstance;
        }
        long maxLabel = 0L;
        Enumeration e = this.getInstances();
        while (e.hasMoreElements()) {
            CfmAggregateInstance aggregateInstance = (CfmAggregateInstance)e.nextElement();
            long label = aggregateInstance.getLabel();
            if (label <= maxLabel) continue;
            maxLabel = label;
        }
        if (maxLabel == Long.MAX_VALUE) {
            throw new Error("CfmAggregateInstanceFamily.newAggregateInstance: max allowed label number has been reached");
        }
        CfmAggregateInstance aggregateInstance = new CfmAggregateInstance(loadLocation, this, ++maxLabel);
        this.add(aggregateInstance);
        return aggregateInstance;
    }

    public synchronized void add(CfmAggregateInstance aggregateInstance) {
        if (aggregateInstance == null) {
            CfmUtil.myAssert(false);
            return;
        }
        if (this.map.containsValue(aggregateInstance)) {
            CfmUtil.myAssert(false);
            return;
        }
        this.map.put(aggregateInstance.getInstanceTag(), aggregateInstance);
    }

    public CfmAggregateInstance get(long label) {
        if (label < -1L) {
            return null;
        }
        CfmTagInstance cfmTag = new CfmTagInstance(label);
        return (CfmAggregateInstance)this.map.get(cfmTag);
    }

    public synchronized CfmAggregateInstance getLatestInstance() throws CfwException {
        return this.get(this.lastLabel());
    }

    public String toString() {
        return "\nCfmAggregateInstanceFamily: tag=\"" + this.getFamilyName() + "\", number of Aggregate Instances = " + this.getNumLabels() + " End-of-CfmAggregateInstanceFamily\n";
    }

    public synchronized void replace(CfmTagInstance oldCfmTag, CfmAggregateInstance newInstance) {
        this.map.remove(oldCfmTag);
        this.add(newInstance);
    }

    public int getNumLabels() {
        return this.map.size();
    }

    public Enumeration getTags() {
        return this.map.keys();
    }

    public Enumeration getInstances() {
        return this.map.elements();
    }
}

