/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateInstanceIdentifier;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregateDescription;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamily;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmAggregateInstanceFamilies {
    private final CfmAggregateDescription aggregateDescription;
    private final Hashtable map = new Hashtable();
    private static final Comparator familyNameComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return CfmAggregateInstanceFamilies.compareFamilyNames(((CfmAggregateHolder)o1).getFamilyName(), ((CfmAggregateHolder)o2).getFamilyName());
        }
    };

    CfmAggregateInstanceFamilies(Cfm cfm, CfmAggregateDescription aggDesc) {
        this.aggregateDescription = aggDesc;
        cfm.addAggregateInstanceStorage(this);
    }

    public static int familyNameIndex(String familyNameNumber) {
        if (familyNameNumber == null || (familyNameNumber = familyNameNumber.trim()).length() == 0) {
            throw new Error("CfmAggregateInstanceFamilies.familyNameNumber: invalid (null or empty) family name number");
        }
        if (familyNameNumber.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(familyNameNumber);
        }
        catch (NumberFormatException nfe) {
            throw new Error("CfmAggregateInstanceFamilies.familyNameIndex: invalid family name number " + familyNameNumber);
        }
    }

    public static String familyNameNumber(String familyName) {
        if (familyName == null || (familyName = familyName.trim()).length() == 0) {
            throw new Error("CfmAggregateInstanceFamilies.familyNameNumber: invalid (null or empty) family name");
        }
        if (familyName.equals("CFM")) {
            return "0";
        }
        String regexName = "[a-zA-Z_][a-zA-Z_]*";
        String regexNumber = "[0-9][0-9]*";
        if (!familyName.matches("[a-zA-Z_][a-zA-Z_]*[0-9][0-9]*")) {
            return "";
        }
        String[] splits = familyName.split("[a-zA-Z_][a-zA-Z_]*");
        if (splits.length != 2) {
            throw new Error("CfmAggregateInstanceFamilies.familyNameNumber: invalid (not splitable) family name " + familyName);
        }
        String number = splits[1];
        if (number.length() == 0) {
            return "";
        }
        try {
            Long.parseLong(number);
            return number;
        }
        catch (NumberFormatException nfe) {
            return "";
        }
    }

    public static int compareFamilyNames(Object o1, Object o2) {
        String i2;
        if (o1 == null || o2 == null) {
            throw new Error("CfmAggregateInstanceFamilies.compareFamilyNames: invalid (null) name(s)");
        }
        if (!(o1 instanceof String) || !(o2 instanceof String)) {
            throw new Error("CfmAggregateInstanceFamilies.compareFamilyNames: invalid (not string) name(s)");
        }
        if (((String)o1).length() <= 0 || ((String)o2).length() <= 0) {
            throw new Error("CfmAggregateInstanceFamilies.compareFamilyNames: invalid (empty) name(s)");
        }
        String s1 = (String)o1;
        String s2 = (String)o2;
        String i1 = CfmAggregateInstanceFamilies.familyNameNumber(s1);
        if (i1.length() >= 0 && (i2 = CfmAggregateInstanceFamilies.familyNameNumber(s2)).length() >= 0) {
            String n2;
            String n1 = i1.equals("0") ? s1 : s1.substring(0, s1.indexOf(i1));
            String string = n2 = i2.equals("0") ? s2 : s2.substring(0, s2.indexOf(i2));
            if (!n1.equals(n2)) {
                if (n1.equals("CFM")) {
                    return -1;
                }
                if (n2.equals("CFM")) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
            return CfmAggregateInstanceFamilies.familyNameIndex(i1) - CfmAggregateInstanceFamilies.familyNameIndex(i2);
        }
        return s1.compareTo(s2);
    }

    public static Comparator getFamilyNameComparator() {
        return familyNameComparator;
    }

    public CfmAggregateDescription getAggregateDescription() {
        return this.aggregateDescription;
    }

    public AggregateDescriptionIdentifierWithLocation getAggregateDescriptionIdentifier() {
        return this.getAggregateDescription().getIdentifier();
    }

    public String getID() {
        return this.getAggregateDescriptionIdentifier().getSelfID();
    }

    public AggregateVersion getVersion() {
        return this.getAggregateDescriptionIdentifier().getVersion();
    }

    public String getNS() {
        return this.getAggregateDescriptionIdentifier().getNamespace();
    }

    public OHAbsolute getOH() {
        return this.getAggregateDescription().getLoadLocation().getOracleHome();
    }

    void add(CfmAggregateInstanceFamily family) throws CfwException {
        if (family == null) {
            throw new CfwException("CfmAggregateInstanceFamilies.add: invalid (null) aggregateInstance");
        }
        String key = family.getFamilyName();
        if (this.map.containsKey(key)) {
            throw new CfwException("CfmAggregateInstanceFamilies.add: aggregateInstanceFamily with familyName=\"" + key + "\" already exist");
        }
        this.map.put(key, family);
    }

    CfmAggregateInstanceFamily get(String familyName) {
        CfmUtil.myAssert(familyName != null);
        familyName = familyName.trim();
        CfmUtil.myAssert(familyName.length() != 0);
        return (CfmAggregateInstanceFamily)this.map.get(familyName);
    }

    CfmAggregateInstanceFamily getOrCreate(String familyName) throws CfwException {
        CfmAggregateInstanceFamily family = this.get(familyName);
        if (family == null) {
            family = new CfmAggregateInstanceFamily(this, familyName);
        }
        return family;
    }

    public String toString() {
        return "\nCfmAggregateInstanceStorage: tag=" + this.getAggregateDescriptionIdentifier() + ", number of families = " + this.map.size() + " End-of-CfmAggregateInstanceFamilies\n";
    }

    CfmAggregateInstance newAggregateInstance(LoadLocation loadLocation, String familyName) throws CfwException {
        CfmAggregateInstanceFamily family = this.get(familyName);
        if (family == null) {
            family = new CfmAggregateInstanceFamily(this, familyName);
        }
        return family.newAggregateInstance(loadLocation);
    }

    List getAggregateInstances() {
        LinkedList<AggregateInstanceIdentifier> result = new LinkedList<AggregateInstanceIdentifier>();
        for (CfmAggregateInstanceFamily family : this.map.values()) {
            long[] labels = family.labels();
            for (int i = 0; i < labels.length; ++i) {
                result.add(new AggregateInstanceIdentifier(family.getFamilyIdentifier(), labels[i]));
            }
        }
        return result;
    }
}

