/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import oracle.sysman.emCfg.common.AggregateInstanceIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.core.CfmActionState;
import oracle.sysman.emCfg.core.CfmActionStepState;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamily;
import oracle.sysman.emCfg.core.CfmAggregateRefState;
import oracle.sysman.emCfg.core.CfmConditionState;
import oracle.sysman.emCfg.core.CfmMicroStepState;
import oracle.sysman.emCfg.core.CfmParameterState;
import oracle.sysman.emCfg.core.CfmPlugInState;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.core.CfmTagInstance;
import oracle.sysman.emCfg.core.ICfmObjectState;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.support.Formatter;

class CfmAggregateInstance {
    public static final long FRESH_LABEL = -1L;
    public static final long UNAVAILABLE_LABEL = -9999L;
    private HashSet objectStates = new HashSet();
    private final CfmAggregateInstanceFamily aggregateInstanceFamily;
    private CfmTagInstance instanceTag;
    private String fileName;
    private long timestamp;
    private final LoadLocation location;
    private AggregateVersion baseVersion = null;
    private long baseLabel;
    private long count = 0L;

    CfmAggregateInstance(LoadLocation loadLocation, CfmAggregateInstanceFamily aggregateInstanceFamily, long label) throws CfwException {
        this(loadLocation, aggregateInstanceFamily, label, null, -1L);
    }

    CfmAggregateInstance(LoadLocation loadLocation, CfmAggregateInstanceFamily aggregateInstanceFamily, long label, String fileName, long timestamp) throws CfwException {
        this.location = loadLocation;
        this.aggregateInstanceFamily = aggregateInstanceFamily;
        this.instanceTag = new CfmTagInstance(label);
        this.fileName = fileName;
        this.timestamp = timestamp < 0L ? new Date().getTime() : timestamp;
        aggregateInstanceFamily.add(this);
    }

    public void incrementLabel() {
        long newLabel = this.getLabel() + 1L;
        CfmTagInstance oldTag = this.instanceTag;
        this.instanceTag = new CfmTagInstance(newLabel);
        this.getAggregateInstanceFamily().replace(oldTag, this);
    }

    public AggregateInstanceIdentifierWithLocation getInstanceIdentifier() {
        return new AggregateInstanceIdentifierWithLocation(this.aggregateInstanceFamily.getFamilyIdentifier(), this.getLabel());
    }

    public CfmTagInstance getInstanceTag() {
        return this.instanceTag;
    }

    public CfmAggregateInstanceFamily getAggregateInstanceFamily() {
        return this.aggregateInstanceFamily;
    }

    public String getAggID() {
        return this.getAggregateInstanceFamily().getAggID();
    }

    public AggregateVersion getVersion() {
        return this.getAggregateInstanceFamily().getVersion();
    }

    public String getNS() {
        return this.getAggregateInstanceFamily().getNS();
    }

    public String getFamilyName() {
        return this.getAggregateInstanceFamily().getFamilyName();
    }

    public long getLabel() {
        return this.getInstanceTag().getLabel();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    LoadLocation getLoadLocation() {
        return this.location;
    }

    public long getCount() {
        return this.count;
    }

    void setCount(long count) {
        this.count = count;
    }

    public void add(ICfmObjectState state) throws CfwException {
        if (state == null) {
            throw new CfwException("CfmAggregateInstance.add: invalid (null) state");
        }
        this.objectStates.add(state);
    }

    public String toString() {
        return "CfmAggregateInstance: " + this.getInstanceIdentifier().toString();
    }

    ICfmObjectState getAggregateState() {
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            if (!cfmObjectState.getStateType().equals(CfmStateType.AGGREGATE)) continue;
            return cfmObjectState;
        }
        throw new Error("CfmAggregateInstance.getAggregateState: nothing has been found");
    }

    void setPreviousInstance(AggregateVersion version, long label) {
        this.baseVersion = version;
        this.baseLabel = label;
    }

    CfmAggregateRefState getAggregateRefState(IAggregateReference aggRef) throws CfwException {
        return this.getAggregateRefStatePrivate(aggRef.getSelfID(), AggregateVersion.versionFromString(aggRef.getVersionID()), aggRef.getNameSpace());
    }

    CfmAggregateRefState getAggregateRefState(CfwIdentifier aggRefIdent) {
        try {
            return this.getAggregateRefStatePrivate(aggRefIdent.getSelfID(), null, aggRefIdent.getNamespace());
        }
        catch (CfwException e) {
            throw new Error("This should not happen: " + e, e);
        }
    }

    private CfmAggregateRefState getAggregateRefStatePrivate(String idRef, AggregateVersion versionRef, String nsRef) throws CfwException {
        if (versionRef == AggregateVersion.LATEST) {
            versionRef = null;
        }
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmAggregateRefState aggregateState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.REF) || !(aggregateState = (CfmAggregateRefState)cfmObjectState).getIdRef().equals(idRef) || !aggregateState.getNsRef().equals(nsRef) || versionRef != null && !versionRef.equals(aggregateState.getVersionRef())) continue;
            return aggregateState;
        }
        throw new CfwException("CfmAggregateInstance.getAggregateRefState: nothing has been found for idRef=" + idRef + ", versionRef=" + versionRef + ", nsRef=" + nsRef);
    }

    CfmPlugInState getPlugInState(String id) throws CfwException {
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmPlugInState plugInState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.PLUGIN) || !(plugInState = (CfmPlugInState)cfmObjectState).getSelfID().equals(id)) continue;
            return plugInState;
        }
        throw new CfwException("CfmAggregateInstance.getPlugInState: nothing has been found for Plugin id=" + id);
    }

    CfmParameterState getParameterState(String id) throws CfwException {
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmParameterState parameterState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.PARAMETER) || !(parameterState = (CfmParameterState)cfmObjectState).getSelfID().equals(id)) continue;
            return parameterState;
        }
        throw new CfwException("CfmAggregateInstance.getParameterState: nothing has been found for Parameter id=" + id);
    }

    CfmConditionState getConditionState(String id) throws CfwException {
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmConditionState conditionState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.CONDITION) || !(conditionState = (CfmConditionState)cfmObjectState).getSelfID().equals(id)) continue;
            return conditionState;
        }
        throw new CfwException("CfmAggregateInstance.getConditionState: nothing has been found for Condition id=" + id);
    }

    CfmActionState getActionState(String id) {
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmActionState actionState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.ACTION) || !(actionState = (CfmActionState)cfmObjectState).getSelfID().equals(id)) continue;
            return actionState;
        }
        throw new Error("CfmAggregateInstance.getActionState: nothing has been found for action id=" + id);
    }

    CfmActionStepState getActionStepState(long selfIndex, String actionID) {
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmActionStepState actionStepState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.STEP) || !(actionStepState = (CfmActionStepState)cfmObjectState).getActionID().equals(actionID) || actionStepState.getStepIndex() != selfIndex) continue;
            return actionStepState;
        }
        throw new Error("CfmAggregateInstance.getActionStepState: nothing has been found for action id=" + actionID + ", selfIndex=" + selfIndex);
    }

    CfmActionStepState[] getActionStepStates(String actionID) {
        LinkedList<CfmActionStepState> result = new LinkedList<CfmActionStepState>();
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmActionStepState actionStepState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.STEP) || !(actionStepState = (CfmActionStepState)cfmObjectState).getActionID().equals(actionID)) continue;
            result.add(actionStepState);
        }
        return result.toArray(new CfmActionStepState[0]);
    }

    ICfmObjectState getMicroStepState(int msIndex, long stepIndex, String actionID) {
        for (ICfmObjectState cfmObjectState : this.objectStates) {
            CfmMicroStepState microStepState;
            if (!cfmObjectState.getStateType().equals(CfmStateType.MICRO) || !(microStepState = (CfmMicroStepState)cfmObjectState).getActionID().equals(actionID) || microStepState.getStepIndex() != stepIndex || microStepState.getMsIndex() != msIndex) continue;
            return cfmObjectState;
        }
        throw new Error("CfmAggregateInstance.getMicroStepState: nothing has been found for action id=" + actionID + ", selfIndex=" + stepIndex + ", msIndex=" + msIndex);
    }

    void saveHeaderAttributes(StringBuffer buf) {
        buf.append("\nfamily=\"" + Formatter.escapeXMLSequences(this.getFamilyName()));
        this.timestamp = new Date().getTime();
        buf.append("\"\ntimestamp=\"" + this.getTimestamp());
        buf.append("\"\nversion=\"" + this.getVersion());
        buf.append("\"\nlabel=\"" + this.getLabel());
        if (this.baseVersion != null) {
            buf.append("\"\npreviousVersion=\"" + this.baseVersion);
            buf.append("\"\npreviousLabel=\"" + this.baseLabel);
        }
    }
}

