/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmIdentity;
import oracle.sysman.emCfg.support.CfmUtil;

class CfmAggregateIdentifier
extends CfmIdentity {
    final AggregateVersion version;
    final String namespace;
    final String aggregateId;
    final String location;

    CfmAggregateIdentifier(String aggID, CfmIdentity parentDesc) {
        this.aggregateId = aggID;
        this.version = parentDesc.getVersion();
        this.namespace = parentDesc.getNamespace();
        this.location = parentDesc.getLocation();
        CfmUtil.myAssert(this.location != null);
    }

    public String toString() {
        return "{" + this.getType() + ":" + this.aggregateId + ":" + this.version + ":" + this.namespace + "}";
    }

    @Override
    public String getSelfID() {
        return this.aggregateId;
    }

    @Override
    public String getAggregateID() {
        return this.aggregateId;
    }

    @Override
    public AggregateVersion getVersion() {
        return this.version;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public CfmElementType getType() {
        return CfmElementType.AGGREGATE;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CfmAggregateIdentifier)) {
            return false;
        }
        CfmAggregateIdentifier rhs = (CfmAggregateIdentifier)o;
        return this.getSelfID().equals(rhs.getSelfID()) && this.getNamespace().equals(rhs.getNamespace()) && this.getVersion().equals(rhs.getVersion()) && this.getLocation().equals(rhs.getLocation());
    }
}

