/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateFamilyIdentifier;
import oracle.sysman.emCfg.common.AggregateInstanceIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.Environment;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.ICondition;
import oracle.sysman.emCfg.common.IConditionReference;
import oracle.sysman.emCfg.common.IInstanceLabel;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugIn;
import oracle.sysman.emCfg.common.IPlugInReference;
import oracle.sysman.emCfg.common.IProgressMonitor;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.ActionReference;
import oracle.sysman.emCfg.core.AggregateReference;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAction;
import oracle.sysman.emCfg.core.CfmActionPair;
import oracle.sysman.emCfg.core.CfmActionState;
import oracle.sysman.emCfg.core.CfmActionStep;
import oracle.sysman.emCfg.core.CfmActionStepPair;
import oracle.sysman.emCfg.core.CfmActionStepState;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateDescription;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamilies;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamily;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmAggregateRefPair;
import oracle.sysman.emCfg.core.CfmAggregateRefState;
import oracle.sysman.emCfg.core.CfmAggregateState;
import oracle.sysman.emCfg.core.CfmAnyPair;
import oracle.sysman.emCfg.core.CfmCondition;
import oracle.sysman.emCfg.core.CfmConditionPair;
import oracle.sysman.emCfg.core.CfmConditionState;
import oracle.sysman.emCfg.core.CfmHolderTag;
import oracle.sysman.emCfg.core.CfmMicroStep;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.CfmMicroStepState;
import oracle.sysman.emCfg.core.CfmOwnedParameterRef;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParameterPair;
import oracle.sysman.emCfg.core.CfmParameterState;
import oracle.sysman.emCfg.core.CfmPlugIn;
import oracle.sysman.emCfg.core.CfmPlugInState;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.ConditionReference;
import oracle.sysman.emCfg.core.ICfmObjectState;
import oracle.sysman.emCfg.core.IdentifierIdNsLocation;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.core.ParameterReference;
import oracle.sysman.emCfg.core.PlugInReference;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Filer;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.AggregatePhase;
import oracle.sysman.emCfg.types.AggregateStatus;
import oracle.sysman.emCfg.types.AggregateType;
import oracle.sysman.emCfg.types.StatusOrType;

class CfmAggregateHolder
implements IAggregate,
IInstanceLabel {
    private final HashMap hashParameterPair = new HashMap();
    private final HashMap hashConditionPair = new HashMap();
    private final HashMap hashActionPair = new HashMap();
    private final HashMap hashActionStepPair = new HashMap();
    private final HashMap hashMicroStepPair = new HashMap();
    private final HashMap hashAggregateRefPair = new HashMap();
    private final CfmAggregateDescription description;
    private final CfmAggregateInstance instance;
    private final transient CfmAggregateState _aggregateState;
    private transient AggregateReference _selfAggregateRef = null;
    private static final String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ins:AggregateInstance\nxmlns:ins=\"http://www.oracle.com/sysman/emCfg/AggregateInstance\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://www.oracle.com/sysman/emCfg/AggregateInstance oracle/sysman/emCfg/main/AggregateInstance.xsd\"\nschemaVersion=\"1.0.0\"";

    public CfmAggregateHolder(CfmAggregateDescription description, CfmAggregateInstance instance) {
        this.description = description;
        this.instance = instance;
        this._aggregateState = (CfmAggregateState)instance.getAggregateState();
        try {
            this.collectPairs(instance);
        }
        catch (Throwable t) {
            throw new Error("Unable to correctly load instance data for description=" + description.getID() + " from file=" + instance.getFileName() + ": " + t, t);
        }
    }

    public AggregateFamilyIdentifier getFamilyIdentifier() {
        return new AggregateFamilyIdentifier(this.getSelfID(), this.getNS(), this.getVersion(), this.getFamilyName(), this.getOracleHomeAbs());
    }

    public AggregateInstanceIdentifierWithLocation getInstanceIdentifier() {
        return this.getAggregateInstance().getInstanceIdentifier();
    }

    public AggregateVersion getVersion() {
        return this.getAggregateInstance().getVersion();
    }

    public String getNS() {
        return this.getAggregateInstance().getNS();
    }

    public String getFamilyName() {
        return this.getAggregateInstance().getFamilyName();
    }

    public long getLabel() {
        return this.getAggregateInstance().getLabel();
    }

    public String toString() {
        return this.getInstanceIdentifier().toString();
    }

    public CfmAggregateInstance getAggregateInstance() {
        if (this.instance == null) {
            // empty if block
        }
        return this.instance;
    }

    public CfmAggregateState getAggregateState() {
        return this._aggregateState;
    }

    public AggregateReference getSelfReference() {
        if (this._selfAggregateRef == null) {
            this._selfAggregateRef = new AggregateReference(this.getFamilyIdentifier(), true);
        }
        return this._selfAggregateRef;
    }

    public List getMicroStepPairs(int stepIndex, String actionID) {
        Vector<CfmMicroStepPair> microStepPairs = new Vector<CfmMicroStepPair>();
        for (CfmMicroStepPair microStepPair : this.hashMicroStepPair.values()) {
            if (microStepPair.getStepIndex() != stepIndex || !microStepPair.getOwningActionID().equals(actionID)) continue;
            microStepPairs.add(microStepPair);
        }
        Collections.sort(microStepPairs, CfmMicroStepPair.getMicroStepPairComparator());
        return microStepPairs;
    }

    public CfmMicroStepPair getMicroStepPair(String actionID, int stepIndex, int msIdx) throws CfwException {
        CfmHolderTag pairCfmTag = new CfmHolderTag(actionID, stepIndex, msIdx);
        CfmMicroStepPair pair = (CfmMicroStepPair)this.hashMicroStepPair.get(pairCfmTag);
        if (pair == null) {
            throw new CfwException("getMicroStepPair: Action=" + actionID + " stepIndex=" + stepIndex + " microIndex=" + msIdx + " was not found.");
        }
        return pair;
    }

    public CfmConditionPair getConditionPair(String conditionID) throws CfwException {
        CfmConditionPair pair = (CfmConditionPair)this.hashConditionPair.get(conditionID);
        if (pair == null) {
            throw new CfwException("getConditionPair: Condition=" + conditionID + " was not found.");
        }
        return pair;
    }

    public List getActionStepPairs(String actionID) {
        Vector<CfmActionStepPair> stepPairs = new Vector<CfmActionStepPair>();
        for (CfmActionStepPair actionStepPair : this.hashActionStepPair.values()) {
            if (!actionStepPair.getActionID().equals(actionID)) continue;
            int index = actionStepPair.getIndex();
            if (index >= stepPairs.size()) {
                stepPairs.setSize(index + 1);
            }
            stepPairs.set(index, actionStepPair);
        }
        return stepPairs;
    }

    public CfmActionStepPair getActionStepPair(String actionID, int stepIdx) throws CfwException {
        CfmHolderTag pairCfmTag = new CfmHolderTag(actionID, stepIdx);
        CfmActionStepPair pair = (CfmActionStepPair)this.hashActionStepPair.get(pairCfmTag);
        if (pair == null) {
            throw new CfwException("There is no ActionStep for Action=" + actionID + ":step=" + stepIdx + " in " + this.toString());
        }
        return pair;
    }

    public CfmActionPair getActionPairByType(ActionType type) throws CfwException {
        CfmAction action = this.getCfmAggregate().getUniqueAction(type);
        if (action == null) {
            return null;
        }
        return this.getActionPairById(action.getActionID());
    }

    CfmActionPair getActionPair(String actionID, ActionType type) throws CfwException {
        CfmUtil.myAssert(type != null);
        if (actionID != null) {
            return this.getActionPairById(actionID);
        }
        return this.getActionPairByType(type);
    }

    public CfmActionPair getActionPairById(String actionID) throws CfwException {
        CfmUtil.myAssert(actionID != null);
        CfmActionPair pair = (CfmActionPair)this.hashActionPair.get(actionID);
        if (pair == null) {
            throw new CfwException("CfmAggregateHolder.getActionPair: there is no action pair with ID=\"" + actionID + "\"");
        }
        return pair;
    }

    CfmAnyPair getConditionOrParameterPair(CfmTaggedObject condition) throws CfwException {
        if (condition instanceof CfmCondition) {
            return this.getConditionPair(condition.getSelfID());
        }
        if (condition instanceof CfmParameter) {
            return this.getParameterPair(condition.getSelfID());
        }
        throw new CfwException(condition + " couldn't be found in " + this.toString());
    }

    CfmParameterPair getParameterPair(String parameterID) throws CfwException {
        CfmParameterPair pair = (CfmParameterPair)this.hashParameterPair.get(parameterID);
        if (pair == null) {
            throw new CfwException("Parameter id=" + parameterID + " was not found in aggregate " + this.toString());
        }
        return pair;
    }

    CfmParameterPair getReferredParameterPair(CfmOwnedParameterRef parameterRef) throws CfwException {
        CfmAggregateHolder referredHolder = this.getReferredAggregateHolder(parameterRef.getReferredOwner());
        if (referredHolder == null) {
            throw new CfwException("Parameter owner=" + parameterRef.getReferredOwner() + " is not available.");
        }
        return referredHolder.getParameterPair(parameterRef.getIdRef());
    }

    public CfmAggregateHolder getReferredAggregateHolder(CfwIdentifier refIdent) {
        if (this.getCfwIdentifier().equals(refIdent)) {
            return this;
        }
        CfmAggregateRefPair aggRefPair = this.getAggregateRefPair(refIdent);
        if (aggRefPair == null) {
            return null;
        }
        return aggRefPair.getReferredHolder();
    }

    public CfmAggregateRefPair getAggregateRefPair(CfwIdentifier refIdent) {
        CfmAggregateRefPair pair = (CfmAggregateRefPair)this.hashAggregateRefPair.get(refIdent);
        return pair;
    }

    public boolean containsAggregateRefPair(CfwIdentifier refIdent) {
        return this.hashAggregateRefPair.containsKey(refIdent);
    }

    public CfmAggregateDescription getAggregateDescription() {
        return this.description;
    }

    public CfmAggregate getCfmAggregate() {
        return this.getAggregateDescription().getCfmAggregate();
    }

    private void collectPairs(CfmAggregateInstance instance) throws CfwException {
        boolean aggregateB = false;
        Iterator iter = this.description.getMembers();
        while (iter.hasNext()) {
            CfmTaggedObject cfmObject = (CfmTaggedObject)iter.next();
            if (cfmObject instanceof CfmAggregate) {
                aggregateB = true;
                continue;
            }
            if (cfmObject instanceof CfmParameter) {
                CfmParameter parameter = (CfmParameter)cfmObject;
                this.collectParameterPair(parameter);
                continue;
            }
            if (cfmObject instanceof CfmCondition) {
                CfmCondition condition = (CfmCondition)cfmObject;
                this.collectConditionPair(condition);
                continue;
            }
            if (cfmObject instanceof CfmAction) {
                CfmAction action = (CfmAction)cfmObject;
                this.collectActionPair(action);
                continue;
            }
            if (!(cfmObject instanceof CfmPlugIn)) continue;
            CfmPlugIn plugIn = (CfmPlugIn)cfmObject;
            this.setPlugInActive(plugIn);
        }
        iter = this.description.getAggregateReferences();
        while (iter.hasNext()) {
            CfmAggregateRef cfmAggRef = (CfmAggregateRef)iter.next();
            this.collectAggregateRefPair(cfmAggRef);
        }
        if (!aggregateB) {
            throw new CfwException("CfmAggregateHolder.collectPairs: There are no aggregates in the description " + this.description.getIdentifier());
        }
    }

    private void setPlugInActive(CfmPlugIn plugIn) throws CfwException {
        CfmPlugInState plugInState = this.instance.getPlugInState(plugIn.getSelfID());
        plugIn.setActive(plugInState.isActive());
    }

    private void collectParameterPair(CfmParameter parameter) throws CfwException {
        CfmParameterState parameterState = parameter.isTransient() ? new CfmParameterState(this.instance, parameter) : this.instance.getParameterState(parameter.getSelfID());
        CfmParameterPair pair = new CfmParameterPair(this, parameter, parameterState);
        this.hashParameterPair.put(pair.getParameterID(), pair);
    }

    private void collectConditionPair(CfmCondition condition) throws CfwException {
        CfmConditionState conditionState = this.instance.getConditionState(condition.getSelfID());
        CfmConditionPair pair = new CfmConditionPair(this, condition, conditionState);
        this.hashConditionPair.put(pair.getConditionID(), pair);
    }

    private void collectActionPair(CfmAction action) throws CfwException {
        CfmActionState actionState = this.instance.getActionState(action.getSelfID());
        CfmActionPair pair = new CfmActionPair(this, action, (ICfmObjectState)actionState);
        this.hashActionPair.put(pair.getActionID(), pair);
        List allSteps = action.getActionSteps();
        for (CfmActionStep actionStep : allSteps) {
            if (!actionStep.getActionID().equals(action.getSelfID())) continue;
            CfmActionStepState actionStepState = this.instance.getActionStepState(actionStep.getIndex(), actionStep.getActionID());
            CfmActionStepPair stepPair = new CfmActionStepPair(this, actionStep, actionStepState);
            CfmHolderTag stepPairCfmTag = new CfmHolderTag(stepPair.getActionID(), stepPair.getIndex());
            this.hashActionStepPair.put(stepPairCfmTag, stepPair);
            for (CfmMicroStep microStep : actionStep.getMicroSteps()) {
                if (!microStep.getActionStep().equals(actionStep)) continue;
                CfmMicroStepState microStepState = (CfmMicroStepState)this.instance.getMicroStepState(microStep.getIndex(), microStep.getStepIndex(), microStep.getActionStep().getActionID());
                CfmMicroStepPair microPair = new CfmMicroStepPair(this, microStep, microStepState, stepPair);
                CfmHolderTag microPairCfmTag = new CfmHolderTag(microPair.getOwningActionID(), microPair.getStepIndex(), microPair.getIndex());
                this.hashMicroStepPair.put(microPairCfmTag, microPair);
            }
        }
    }

    private void collectAggregateRefPair(CfmAggregateRef aggregateRef) {
        CfwIdentifier ident = aggregateRef.getVersionlessAggRefIdentifier();
        CfmAggregateRefState aggregateRefState = this.instance.getAggregateRefState(ident);
        CfmAggregateRefPair refPair = new CfmAggregateRefPair(this, aggregateRef, aggregateRefState);
        this.hashAggregateRefPair.put(ident, refPair);
    }

    Cfm getCfm() {
        return this.getCfmAggregate().getLoader().getCfm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save() throws CfwException {
        CfmAggregateInstance instance = this.getAggregateInstance();
        CfmAggregateInstanceFamily cfmAggregateInstanceFamily = instance.getAggregateInstanceFamily();
        synchronized (cfmAggregateInstanceFamily) {
            AggregateInstanceIdentifierWithLocation oldIdent = instance.getInstanceIdentifier();
            instance.incrementLabel();
            StringBuffer buf = new StringBuffer();
            buf.append(header);
            instance.saveHeaderAttributes(buf);
            buf.append("\">\n");
            this.saveAggregateState(buf);
            this.savePlugInState(buf);
            this.savePairs(buf);
            buf.append("</ins:AggregateInstance>");
            this.getCfm().unloadHolder(oldIdent);
            this.getCfm().addAggregateHolder(this);
            instance.setFileName(instance.getLoadLocation().getInstancesLoadLocation().getInstancePath() + File.separator + this.getInstanceIdentifier().toFilenameString());
            if (Cfm.isDebug()) {
                Cfm.getLogger().log(Level.INFO, "CfmAggregateInstance:save:Snapshot is placed into File=" + instance.getLoadLocation() + "\n" + buf.toString());
            }
            try {
                Filer.createSecureFile(new File(instance.getFileName()));
                Filer.writeToFileUTF8(buf.toString(), instance.getFileName(), true);
            }
            catch (Exception e) {
                throw new CfwException("Unable to save the aggregate instance!", e);
            }
            return instance.getFileName();
        }
    }

    private void saveAggregateState(StringBuffer sb) {
        sb.append("\t<ins:Aggregate id=\"" + Formatter.escapeXMLSequences(this.getSelfID()) + "\" ");
        sb.append("phase=\"" + this.getPhase().getIdent() + "\" ");
        sb.append("type=\"" + this.getType().getIdent() + "\" ");
        sb.append("status=\"" + this.getAggregateStatus().getIdent() + "\" />\n");
    }

    private void savePlugInState(StringBuffer sb) {
        for (CfmPlugIn plug : this.getCfmAggregate().getPlugIns()) {
            sb.append("\t<ins:PlugIn id=\"" + Formatter.escapeXMLSequences(plug.getSelfID()) + "\" ");
            sb.append("isActive=\"" + plug.isActive() + "\" />\n");
        }
    }

    private void savePairs(StringBuffer buf) {
        for (CfmAnyPair pair : this.hashParameterPair.values()) {
            ((CfmParameterPair)pair).save(buf);
        }
        for (CfmAnyPair pair : this.hashConditionPair.values()) {
            ((CfmConditionPair)pair).save(buf);
        }
        for (CfmAnyPair pair : this.hashAggregateRefPair.values()) {
            ((CfmAggregateRefPair)pair).save(buf);
        }
        for (CfmAnyPair pair : this.hashActionPair.values()) {
            ((CfmActionPair)pair).save(buf);
        }
    }

    private IAggregateReference[] getReferredAggregateReferencesPrivate(boolean includeAvailable, boolean includeUnavailable) throws CfwException {
        CfmAggregate housingAggregate = this.getAggregateDescription().getCfmAggregate();
        CfmAggregateInstance instance = this.getAggregateInstance();
        Cfm cfm = this.getCfm();
        Vector<AggregateReference> refs = new Vector<AggregateReference>();
        for (CfmAggregateRef ref : housingAggregate.getAggregateRefs()) {
            CfmAggregateInstanceFamily instanceFamily;
            AggregateDescriptionIdentifierWithLocation ident = ref.getActualReferredAggregateIdentifierWithLocation();
            if (ident == null) {
                if (!includeUnavailable) continue;
                AggregateFamilyIdentifier family = new AggregateFamilyIdentifier(ref.getAggRefIdentifier(), this.getFamilyName(), OHAbsolute.UNAVAILABLE);
                refs.add(new AggregateReference(family, false));
                continue;
            }
            CfmAggregateInstanceFamilies instanceFamilies = cfm.getAggregateInstanceFamilies(ident);
            AggregateFamilyIdentifier family = new AggregateFamilyIdentifier(ident, this.getFamilyName());
            if (instanceFamilies == null) {
                if (!includeUnavailable) continue;
                refs.add(new AggregateReference(family, false));
                continue;
            }
            if (includeAvailable) {
                refs.add(new AggregateReference(family, true));
            }
            CfmUtil.myAssert((instanceFamily = instanceFamilies.get(instance.getFamilyName())) != null);
            CfmAggregateInstance referredInstance = instanceFamily.get(instanceFamily.lastLabel());
            CfmUtil.myAssert(referredInstance != null);
            CfmUtil.myAssert(referredInstance.getInstanceIdentifier().getFamilyIdentWithLocation().equals(family));
        }
        return refs.toArray(new IAggregateReference[0]);
    }

    @Override
    public IAggregateReference[] getReferredAggregateReferences() throws CfwException {
        return this.getReferredAggregateReferencesPrivate(true, false);
    }

    @Override
    public IAggregateReference[] getAllReferredAggregateReferences() throws CfwException {
        return this.getReferredAggregateReferencesPrivate(true, true);
    }

    @Override
    public IAggregateReference[] getUnavailableReferredAggregateReferences() throws CfwException {
        return this.getReferredAggregateReferencesPrivate(false, true);
    }

    @Override
    public IActionReference[] getActionReferences() throws CfwException {
        Set actionIds = this.hashActionPair.keySet();
        int count = actionIds.size();
        Iterator iter = actionIds.iterator();
        IActionReference[] result = new IActionReference[count];
        for (int i = 0; i < count; ++i) {
            String currId = (String)iter.next();
            result[i] = new ActionReference(currId, this.getFamilyIdentifier());
        }
        return result;
    }

    @Override
    public IActionReference[] getActionReferences(ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        Collection actions = this.getCfmAggregate().getActions(actionType);
        IActionReference[] result = new IActionReference[actions.size()];
        int index = 0;
        for (CfmAction action : actions) {
            result[index++] = action.getReference(this.getFamilyIdentifier());
        }
        return result;
    }

    @Override
    public IActionReference getActionReference(String actionID) throws CfwException {
        CfmUtil.preconditionNotNull(actionID, "actionID");
        CfmActionPair actionPair = this.getActionPairById(actionID);
        return actionPair.getCfmAction().getReference(this.getFamilyIdentifier());
    }

    @Override
    public void performAction(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, IMicroStepStateReference[] selectedMSRefs, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        try {
            CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
            actionPair.perform(blocking, isSilently, retry, skipDetached, selectedMSRefs, actionType);
        }
        catch (CfwException e) {
            throw new CfwException("performAction failed: " + e, e);
        }
    }

    @Override
    public void performAction(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        this.performAction(blocking, isSilently, retry, skipDetached, null, actionType);
    }

    @Override
    public void performActionRecommended(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        this.performActionRecommended(blocking, isSilently, retry, skipDetached, false, actionType);
    }

    @Override
    public void performActionRecommended(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, boolean skipOptional, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        try {
            CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
            actionPair.performRecommended(blocking, isSilently, retry, skipDetached, skipOptional, actionType);
        }
        catch (CfwException e) {
            throw new CfwException("performActionRecommended failed: " + e, e);
        }
    }

    @Override
    public void performActionOptional(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        try {
            CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
            actionPair.performOptional(blocking, isSilently, retry, skipDetached, actionType);
        }
        catch (CfwException e) {
            throw new CfwException("performActionOptional failed: " + e, e);
        }
    }

    @Override
    public void performActionDetached(boolean blocking, boolean isSilently, boolean retry, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        try {
            CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
            actionPair.performDetached(blocking, isSilently, retry, actionType);
        }
        catch (CfwException e) {
            throw new CfwException("performActionDetached failed: " + e, e);
        }
    }

    @Override
    public IMicroStepStateReference[] listTools(boolean isRecommended, boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
        return actionPair.listTools(isRecommended, isSilently, retry, skipDetached, actionType);
    }

    @Override
    public IMicroStepStateReference[] listOptionalTools(boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
        return actionPair.listOptionalTools(isSilently, retry, skipDetached, false, actionType);
    }

    @Override
    public IMicroStepStateReference[] listOptionalTools(boolean isSilently, boolean retry, boolean skipDetached, boolean includeInactive, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
        return actionPair.listOptionalTools(isSilently, retry, skipDetached, includeInactive, actionType);
    }

    @Override
    public IMicroStepStateReference[] listDetachedTools(boolean isSilently, boolean retry, ActionType actionType) throws CfwException {
        CfmUtil.preconditionNotNull(actionType, "actionType");
        CfmActionPair actionPair = this.getUniqueActionOrPassToPrevious(actionType);
        return actionPair.listDetachedTools(isSilently, retry, actionType);
    }

    public CfmActionPair getUniqueActionOrPassToPrevious(ActionType actionType) throws CfwException {
        CfmActionPair actionPair = this.getActionPairByType(actionType);
        if (actionPair != null) {
            return actionPair;
        }
        Cfm cfm = this.getCfm();
        CfmAggregateDescription aggregate = cfm.getAggregateDescription(this.getCfmAggregate().getIdentifier(), this.getOracleHomeAbs());
        LoadLocation location = aggregate.getLoadLocation();
        AggregateDescriptionIdentifier previousAggIdent = location.getDescriptionsLoadLocation().getAggregateDescriptionsPrevious(aggregate.getIdentifier());
        if (previousAggIdent == null) {
            throw new CfwException("Aggregate=" + this.toString() + " contains no Actions of type=" + actionType);
        }
        try {
            cfm.ensureLoaded(previousAggIdent, location);
            CfmAggregateHolder cfmPrevAggInst = cfm.getLatestInstance(previousAggIdent, this.getFamilyName(), this.getOracleHomeAbs());
            return cfmPrevAggInst.getUniqueActionOrPassToPrevious(actionType);
        }
        catch (CfwException e) {
            throw new CfwException("Aggregate=" + this.toString() + " contains no Actions of type=" + actionType + " and we are unable to load a previous version: ", e);
        }
    }

    void verifyReferenceInstance(IReference reference) throws CfwException {
        CfmUtil.preconditionNotNull(reference, "reference");
        AggregateFamilyIdentifier refFamily = reference.getOwnerFamily();
        AggregateFamilyIdentifier thisFamily = this.getFamilyIdentifier();
        if (!thisFamily.equals(refFamily)) {
            throw new CfwException("A reference for family=" + refFamily + " cannot be used for an aggregate of family=" + thisFamily);
        }
    }

    @Override
    public IAction getAction(IActionReference reference) throws CfwException {
        this.verifyReferenceInstance(reference);
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public IPlugInReference[] getPlugInReferences() throws CfwException {
        Vector<PlugInReference> plugs = new Vector<PlugInReference>();
        for (CfmPlugIn plug : this.getCfmAggregate().getPlugIns()) {
            plugs.add(new PlugInReference(plug.getSelfID(), this.getFamilyIdentifier()));
        }
        return plugs.toArray(new IPlugInReference[0]);
    }

    @Override
    public IPlugIn getPlugIn(IPlugInReference ref) throws CfwException {
        this.verifyReferenceInstance(ref);
        return this.getPlugIn(ref.getSelfID());
    }

    @Override
    public IPlugIn getPlugIn(String plugInID) throws CfwException {
        return this.getCfmAggregate().getPlugInNoNull(plugInID);
    }

    @Override
    public IParameterReference[] getParameterReferences() throws CfwException {
        Set parameterIds = this.hashParameterPair.keySet();
        int count = parameterIds.size();
        Iterator iter = parameterIds.iterator();
        IParameterReference[] result = new IParameterReference[count];
        for (int i = 0; i < count; ++i) {
            String currId = (String)iter.next();
            result[i] = new ParameterReference(currId, this.getFamilyIdentifier());
        }
        return result;
    }

    @Override
    public IParameterReference getParameterReference(String id) throws CfwException {
        CfmParameterPair parameterPair = this.getParameterPair(id);
        return new ParameterReference(parameterPair.getParameterID(), this.getFamilyIdentifier());
    }

    @Override
    public IParameter getParameter(IParameterReference reference) throws CfwException {
        this.verifyReferenceInstance(reference);
        String id = reference.getSelfID();
        this.getParameterPair(id);
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public IConditionReference[] getConditionReferences() throws CfwException {
        Set conditionIds = this.hashConditionPair.keySet();
        int count = conditionIds.size();
        Iterator iter = conditionIds.iterator();
        IConditionReference[] result = new IConditionReference[count];
        for (int i = 0; i < count; ++i) {
            String currId = (String)iter.next();
            result[i] = new ConditionReference(currId, this.getFamilyIdentifier());
        }
        return result;
    }

    @Override
    public ICondition getCondition(IConditionReference reference) throws CfwException {
        this.verifyReferenceInstance(reference);
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public IAggregate getReferredAggregate(IAggregateReference reference) throws CfwException {
        if (!this.containsAggregateRefPair(reference.getOwnerFamily().getVersionlessIdentifier())) {
            throw new CfwException("The specified aggregate reference " + reference + " is not a member of aggregate " + this.toString());
        }
        return this.getCfm().getAggregate(reference);
    }

    @Override
    public boolean isActive(IAggregateReference referredAggregate) throws CfwException {
        CfmUtil.preconditionNotNull(referredAggregate, "referredAggregate");
        CfmAggregateRefState aggRefState = this.instance.getAggregateRefState(referredAggregate);
        return aggRefState.isActive();
    }

    @Override
    public void setActive(boolean isActive, IAggregateReference referredAggregate) throws CfwException {
        CfmUtil.preconditionNotNull(referredAggregate, "referredAggregate");
        CfmAggregateRefState aggRefState = this.instance.getAggregateRefState(referredAggregate);
        aggRefState.setActive(isActive);
    }

    @Override
    public void addProgressListener(IProgressMonitor listener) throws CfwException {
        CfmUtil.preconditionNotNull(listener, "listener");
        this.getCfmAggregate().addProgressListener(listener);
    }

    @Override
    public void removeProgressListener(IProgressMonitor listener) throws CfwException {
        CfmUtil.preconditionNotNull(listener, "listener");
        this.getCfmAggregate().removeProgressListener(listener);
    }

    @Override
    public IInstanceLabel[] getAvailableInstanceLabels() {
        CfmAggregateInstanceFamily aif = this.instance.getAggregateInstanceFamily();
        Vector<CfmAggregateInstance> allLabels = new Vector<CfmAggregateInstance>();
        long[] labels = aif.labels();
        for (int i = 0; i < labels.length; ++i) {
            CfmAggregateInstance ai = aif.get(labels[i]);
            allLabels.add(ai);
        }
        IInstanceLabel[] newArray = new IInstanceLabel[allLabels.size()];
        return allLabels.toArray(newArray);
    }

    @Override
    public IInstanceLabel getLastKnownInstanceLabel() throws CfwException {
        CfmAggregateInstanceFamily aif = this.instance.getAggregateInstanceFamily();
        return (IInstanceLabel)((Object)aif.get(aif.lastLabel()));
    }

    @Override
    public IInstanceLabel getFirstKnownInstanceLabel() throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public void reverseParametersToLabel(boolean blocking, IInstanceLabel targetInstanceLabel) throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public void reverseActionsToLabel(boolean blocking, IInstanceLabel targetInstanceLabel) throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public void reverseToLabel(boolean blocking, IInstanceLabel targetInstanceLabel) throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public AggregateType getType() {
        return this.getCfmAggregate().getType();
    }

    @Override
    public boolean isType(AggregateType type) throws CfwException, IllegalArgumentException {
        CfmUtil.preconditionNotNull(type, "type");
        return this.getType().equals(type);
    }

    @Override
    public void setPhase(AggregatePhase newPhase) throws IllegalArgumentException {
        this.getAggregateState().setPhase(newPhase);
    }

    @Override
    public AggregatePhase getPhase() {
        return this.getAggregateState().getPhase();
    }

    @Override
    public String getDesc() throws CfwException {
        return this.getCfmAggregate().getDesc();
    }

    @Override
    public IReference getReference() {
        return new AggregateReference(this.getFamilyIdentifier(), true);
    }

    @Override
    public String getSelfID() {
        return this.getAggregateInstance().getAggID();
    }

    @Override
    public String getSummary() {
        return this.getAggregateState().getSummary();
    }

    @Override
    public StatusOrType getStatus() {
        return this.getAggregateStatus();
    }

    public AggregateStatus getAggregateStatus() {
        return this.getAggregateState().getStatus();
    }

    @Override
    public IObject getParent() throws CfwException {
        return null;
    }

    @Override
    public IObject getOriginator() throws CfwException {
        return null;
    }

    @Override
    public String getOracleHome() {
        return this.getOracleHomeAbs().toString();
    }

    public OHAbsolute getOracleHomeAbs() {
        return this.getCfmAggregate().getOHAbs();
    }

    @Override
    public Date getDate() throws CfwException {
        return new Date(this.getAggregateInstance().getTimestamp());
    }

    @Override
    public IInstanceLabel first() throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public IInstanceLabel last() throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public IInstanceLabel previous() throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public IInstanceLabel next() throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    @Override
    public IInstanceLabel previous(IInstanceLabel label) throws CfwException {
        return this.previous();
    }

    @Override
    public IInstanceLabel next(IInstanceLabel label) throws CfwException {
        return this.next();
    }

    @Override
    public boolean equal(IInstanceLabel label) throws CfwException {
        throw new Error("UNIMPLEMENTED");
    }

    Environment getOracleHomeEnvironmentVariables() {
        String filename = CfmUtil.evaluatePath(this.getCfm().getSessionPropertyEnvVarsFile(), this.getOracleHome());
        try {
            FileInputStream iS = new FileInputStream(filename);
            return new Environment(iS);
        }
        catch (Exception e) {
            Cfm.getLogger().log(Level.WARNING, "Failed to read environment variable file " + filename + ": " + e.toString());
            return new Environment();
        }
    }

    public CfwIdentifier getCfwIdentifier() {
        return new CfwIdentifier(this.getSelfID(), this.getNS());
    }

    public IdentifierIdNsLocation getVersionlessIdentifier() {
        return new IdentifierIdNsLocation(this.getSelfID(), this.getNS(), this.getOracleHomeAbs());
    }
}

