/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.types.AggregateType;

class CfmAggregateDescription {
    private final CfmAggregate cfmAggregate;
    private final List elements = new Vector();
    private final Hashtable aggRefMap = new Hashtable();

    CfmAggregateDescription(Cfm cfm, CfmAggregate aggregate) {
        this.cfmAggregate = aggregate;
        this.addMember(aggregate);
        cfm.addAggregateDescription(this);
    }

    public void addMember(CfmTaggedObject cfmObject) {
        this.elements.add(cfmObject);
    }

    public Iterator getMembers() {
        return this.elements.iterator();
    }

    public void addAggregateRef(CfmAggregateRef cfmAggRef) throws CfwException {
        CfwIdentifier versionlessIdent = cfmAggRef.getVersionlessAggRefIdentifier();
        CfmAggregateRef previous = this.aggRefMap.put(versionlessIdent, cfmAggRef);
        if (previous != null) {
            throw new CfwException("Multiple aggregate references to " + versionlessIdent + " were found in " + this.getCfmAggregate().toString());
        }
    }

    public Iterator getAggregateReferences() {
        return this.aggRefMap.values().iterator();
    }

    public CfmAggregate getCfmAggregate() {
        return this.cfmAggregate;
    }

    public LoadLocation getLoadLocation() {
        return this.getCfmAggregate().getElementLoadLocation();
    }

    public AggregateDescriptionIdentifierWithLocation getIdentifier() {
        return this.getCfmAggregate().getIdentifierWithLocation();
    }

    public String getID() {
        return this.getIdentifier().getSelfID();
    }

    public AggregateVersion getVersion() {
        return this.getIdentifier().getVersion();
    }

    public String getNS() {
        return this.getIdentifier().getNamespace();
    }

    public String toString() {
        return "CfmAggregateDescription: tag=" + this.getIdentifier() + ", size=>" + this.elements.size() + " End-of-CfmAggregateDescription\n";
    }

    public boolean isType(AggregateType type) throws CfwException {
        if (type == null) {
            throw new CfwException("CfmAggregateDescription.isType: invalid (null) type");
        }
        return type.equals(this.getCfmAggregate().getType());
    }
}

