/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IProgressMonitor;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.ActionStateReference;
import oracle.sysman.emCfg.core.ActionStepStateReference;
import oracle.sysman.emCfg.core.CfmAction;
import oracle.sysman.emCfg.core.CfmActionPair;
import oracle.sysman.emCfg.core.CfmActionStepPair;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmAnyPair;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.CfmParentObject;
import oracle.sysman.emCfg.core.CfmPlugIn;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.IdentifierIdNsLocation;
import oracle.sysman.emCfg.core.MicroStepStateReference;
import oracle.sysman.emCfg.core.ProgressEvent;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.schema.descriptions.ArrayAggregateT;
import oracle.sysman.emCfg.schema.descriptions.ComplexAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimpleAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimpleArrayAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimplestAggregateT;
import oracle.sysman.emCfg.schema.descriptions.SimplestArrayAggregateT;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.AggregateType;

class CfmAggregate
extends CfmParentObject {
    private static final CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private final Set listeners = new LinkedHashSet();
    private final int count;
    private final AggregateType aggregateType;

    public static CfmAggregate getInstance(DescriptionsLoader loader, SimplestAggregateT aggT, CfmParentObject owner) {
        return new CfmAggregate(loader, AggregateType.SIMPLEST, aggT, aggT.getId(), owner, 0L);
    }

    public static CfmAggregate getInstance(DescriptionsLoader loader, SimpleAggregateT aggT, CfmParentObject owner) {
        return new CfmAggregate(loader, AggregateType.SIMPLE, aggT, aggT.getId(), owner, 0L);
    }

    public static CfmAggregate getInstance(DescriptionsLoader loader, ComplexAggregateT aggT, CfmParentObject owner) {
        return new CfmAggregate(loader, AggregateType.COMPLEX, aggT, aggT.getId(), owner, 0L);
    }

    public static CfmAggregate getInstance(DescriptionsLoader loader, SimplestArrayAggregateT aggT, CfmParentObject owner) {
        return new CfmAggregate(loader, AggregateType.SIMPLEST_ARRAY, aggT, aggT.getId(), owner, aggT.getCount());
    }

    public static CfmAggregate getInstance(DescriptionsLoader loader, SimpleArrayAggregateT aggT, CfmParentObject owner) {
        return new CfmAggregate(loader, AggregateType.SIMPLE_ARRAY, aggT, aggT.getId(), owner, aggT.getCount());
    }

    public static CfmAggregate getInstance(DescriptionsLoader loader, ArrayAggregateT aggT, CfmParentObject owner) {
        return new CfmAggregate(loader, AggregateType.ARRAY, aggT, aggT.getId(), owner, aggT.getCount());
    }

    protected CfmAggregate(DescriptionsLoader loader, AggregateType type, Object jaxbOrigin, String aggId, CfmParentObject owner, long count) {
        super(loader, jaxbOrigin, aggId, owner);
        this.count = (int)count;
        this.aggregateType = type;
        loader.getObjectFactory().addAggregate(this);
    }

    public AggregateDescriptionIdentifier getIdentifier() {
        return new AggregateDescriptionIdentifier(this.getSelfID(), this.getVersion(), this.getNamespace());
    }

    public AggregateDescriptionIdentifierWithLocation getIdentifierWithLocation() {
        return new AggregateDescriptionIdentifierWithLocation(this.getIdentifier(), this.getOHAbs());
    }

    public int getCount() {
        return this.count;
    }

    public CfwIdentifier getVersionlessIdentifier() {
        return CfwIdentifier.get(this.getSelfID(), this.getNamespace());
    }

    public IdentifierIdNsLocation getVersionlessIdentifierWithLocation() {
        return new IdentifierIdNsLocation(this.getSelfID(), this.getNamespace(), this.getOHAbs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(IProgressMonitor mon) {
        Set set = this.listeners;
        synchronized (set) {
            if (!this.listeners.add(mon)) {
                return;
            }
        }
        for (CfmAggregateRef ref : this.getAggregateRefs()) {
            CfmAggregate refAgg = ref.getAggregate();
            if (refAgg == null) continue;
            refAgg.addProgressListener(mon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(IProgressMonitor mon) {
        Set set = this.listeners;
        synchronized (set) {
            if (!this.listeners.remove(mon)) {
                return;
            }
        }
        for (CfmAggregateRef ref : this.getAggregateRefs()) {
            CfmAggregate refAgg = ref.getAggregate();
            if (refAgg == null) continue;
            refAgg.removeProgressListener(mon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportActionStartEvent(CfmActionPair pair, List actionSteps) {
        IProgressMonitor[] currentListeners;
        Object sPair2;
        ActionStateReference aref = new ActionStateReference(pair);
        IActionStepStateReference[] allStepRefs = new IActionStepStateReference[actionSteps.size()];
        int idx = 0;
        for (Object sPair2 : actionSteps) {
            allStepRefs[idx++] = new ActionStepStateReference((CfmActionStepPair)sPair2);
        }
        sPair2 = this.listeners;
        synchronized (sPair2) {
            currentListeners = new IProgressMonitor[this.listeners.size()];
            this.listeners.toArray(currentListeners);
        }
        for (int i = 0; i < currentListeners.length; ++i) {
            IProgressMonitor listener = currentListeners[i];
            try {
                listener.actionStart(aref, allStepRefs);
                continue;
            }
            catch (Throwable t) {
                cfmLogger.log(Level.WARNING, "Progress monitor " + listener.getClass().toString() + ".actionStart(" + aref + ", {array size=" + allStepRefs.length + "}) threw exception: " + t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportEvent(ProgressEvent event, CfmAnyPair pair, ActionType actionType) {
        IProgressMonitor[] currentListeners;
        Set set = this.listeners;
        synchronized (set) {
            currentListeners = new IProgressMonitor[this.listeners.size()];
            this.listeners.toArray(currentListeners);
        }
        for (int i = 0; i < currentListeners.length; ++i) {
            MicroStepStateReference refState;
            IProgressMonitor listener = currentListeners[i];
            if (event == ProgressEvent.PLUGIN_START) {
                refState = new MicroStepStateReference((CfmMicroStepPair)pair);
                try {
                    listener.plugInStart(refState);
                }
                catch (Throwable t) {
                    cfmLogger.log(Level.WARNING, "Progress monitor " + listener.getClass().toString() + ".plugInStart(" + refState + ") threw exception: " + t);
                }
                continue;
            }
            if (event == ProgressEvent.PLUGIN_END) {
                refState = new MicroStepStateReference((CfmMicroStepPair)pair);
                try {
                    listener.plugInEnd(refState);
                }
                catch (Throwable t) {
                    cfmLogger.log(Level.WARNING, "Progress monitor " + listener.getClass().toString() + ".plugInEnd(" + refState + ") threw exception: " + t);
                }
                continue;
            }
            if (event == ProgressEvent.ACTION_END) {
                ActionStateReference aref = new ActionStateReference((CfmActionPair)pair);
                try {
                    listener.actionEnd(aref);
                }
                catch (Throwable t) {
                    cfmLogger.log(Level.WARNING, "Progress monitor " + listener.getClass().toString() + ".actionEnd(" + aref + ") threw exception: " + t);
                }
                continue;
            }
            if (event == ProgressEvent.ACTION_PROGRESS) {
                CfmActionStepPair sPair = (CfmActionStepPair)pair;
                ActionStepStateReference sref = new ActionStepStateReference((CfmActionStepPair)pair);
                CfmActionPair aPair = sPair.getActionPair();
                ActionStateReference aref = new ActionStateReference(aPair);
                int stepIndex = (int)sPair.getCfmActionStepState().getStepIndex();
                boolean msIndex = false;
                try {
                    listener.actionProgress(aref, sref, stepIndex, 0);
                }
                catch (Throwable t) {
                    cfmLogger.log(Level.WARNING, "Progress monitor " + listener.getClass().toString() + ".actionProgress(" + aref + ", " + sref + ", " + stepIndex + ", " + 0 + ") threw exception: " + t);
                }
                continue;
            }
            if (event != ProgressEvent.PARAMETER_CHANGED) continue;
            IParameterReference parameterRef = null;
            try {
                listener.parameterChange(parameterRef);
                continue;
            }
            catch (Throwable t) {
                cfmLogger.log(Level.WARNING, "Progress monitor " + listener.getClass().toString() + ".parameterChange(" + parameterRef + ") threw exception: " + t);
            }
        }
    }

    public Collection getActions(ActionType actionType) {
        Vector<CfmAction> result = new Vector<CfmAction>();
        for (CfmAction action : this.getActions()) {
            if (!action.isType(actionType)) continue;
            result.add(action);
        }
        return result;
    }

    public Collection getActions() {
        LinkedList result = new LinkedList();
        Iterator memberIter = this.memberIterator();
        while (memberIter.hasNext()) {
            Object member = memberIter.next();
            if (!(member instanceof CfmAction)) continue;
            result.add(member);
        }
        return result;
    }

    public Collection getPlugIns() {
        LinkedList result = new LinkedList();
        Iterator memberIter = this.memberIterator();
        while (memberIter.hasNext()) {
            Object member = memberIter.next();
            if (!(member instanceof CfmPlugIn)) continue;
            result.add(member);
        }
        return result;
    }

    public CfmPlugIn getPlugInNoNull(String id) throws CfwException {
        Iterator memberIter = this.memberIterator();
        while (memberIter.hasNext()) {
            CfmPlugIn plugIn;
            Object member = memberIter.next();
            if (!(member instanceof CfmPlugIn) || !(plugIn = (CfmPlugIn)member).getSelfID().equals(id)) continue;
            return plugIn;
        }
        throw new CfwException("The aggregate " + this.toString() + " does not contain a PlugIn with id=" + id);
    }

    public void addAggregateRef(CfmAggregateRef aggregateRef) {
        this.addMember(aggregateRef);
    }

    public Collection getAggregateRefs() {
        LinkedList result = new LinkedList();
        Iterator memberIter = this.memberIterator();
        while (memberIter.hasNext()) {
            Object member = memberIter.next();
            if (!(member instanceof CfmAggregateRef)) continue;
            result.add(member);
        }
        return result;
    }

    public CfmAction getUniqueAction(ActionType actionType) throws CfwException {
        Collection cfmActions = this.getActions(actionType);
        if (cfmActions.size() > 1) {
            throw new CfwException("Aggregate " + this + " contained " + cfmActions.size() + " actions of type " + actionType + " (there must be only 1 Action of any type)");
        }
        if (cfmActions.size() == 0) {
            return null;
        }
        return (CfmAction)cfmActions.iterator().next();
    }

    public AggregateType getType() {
        return this.aggregateType;
    }

    public AggregateVersion getVersionOfReferredAggregateResolving(CfwIdentifier referredAggregateIdent) {
        if (this.getVersionlessIdentifier().equals(referredAggregateIdent)) {
            return this.getVersion();
        }
        return this.getReferredAggregateRefResolving(referredAggregateIdent).getActualReferredVersion();
    }

    public OHAbsolute getLocationOfReferredAggregateResolving(CfwIdentifier referredAggregateIdent) {
        if (this.getVersionlessIdentifier().equals(referredAggregateIdent)) {
            return this.getOHAbs();
        }
        return this.getReferredAggregateRefResolving(referredAggregateIdent).getActualReferredLocation();
    }

    private CfmAggregateRef getReferredAggregateRefResolving(CfwIdentifier referredAggregateIdent) {
        for (CfmAggregateRef possibleAggRef : this.getAggregateRefs()) {
            if (!possibleAggRef.getVersionlessAggRefIdentifier().equals(referredAggregateIdent)) continue;
            return possibleAggRef;
        }
        return null;
    }
}

