/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmActionStep;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.core.CfmStepState;
import oracle.sysman.emCfg.schema.instance.ActionStepT;
import oracle.sysman.emCfg.types.ActionStepStatus;

class CfmActionStepState
extends CfmStepState {
    private int priority;
    private ActionStepStatus status;
    private int failedMicroStepIndex = -1;
    private int weight = 0;

    public CfmActionStepState(CfmAggregateInstance aggregateInstance, ActionStepT actionStepT, long selfIndex, String actionID) throws CfwException {
        super(aggregateInstance, actionStepT, 0, selfIndex, actionID);
        this.priority = actionStepT.getPriority();
        String statusS = actionStepT.getStatus();
        this.setStatus(ActionStepStatus.getStatus(statusS));
    }

    public CfmActionStepState(CfmAggregateInstance aggregateInstance, CfmActionStep cfmActionStep) {
        super(aggregateInstance, null, cfmActionStep.getIndex(), cfmActionStep.getIndex(), cfmActionStep.getActionID());
        this.priority = cfmActionStep.getPriority();
        this.setStatus(ActionStepStatus.NOT_PERFORMED);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int pri) {
        this.priority = pri;
    }

    @Override
    public CfmStateType getStateType() {
        return CfmStateType.STEP;
    }

    public void setStatus(ActionStepStatus status) {
        this.status = status;
    }

    public ActionStepStatus getStatus() {
        if (this.status == null) {
            throw new Error("CfmActionStepState.getStatus: unknown status of " + this.toString());
        }
        return this.status;
    }

    public boolean isStatus(ActionStepStatus status) throws CfwException {
        if (this.status == null) {
            throw new CfwException("CfmActionStepState.isStatus: invalid (null) status");
        }
        return status.equals(this.getStatus());
    }

    public int getFailedMicroStepIndex() {
        return this.failedMicroStepIndex;
    }

    public void setFailedMicroStepIndex(int failedMicroStepIndex) {
        this.failedMicroStepIndex = failedMicroStepIndex;
    }

    public void addWeight(int chunk) {
        if (this.weight < chunk) {
            this.weight = chunk;
        }
    }

    public void resetWeight() {
        this.weight = 0;
    }

    public int getWeight() {
        return this.weight;
    }
}

