/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IObjectState;
import oracle.sysman.emCfg.common.IStateReference;
import oracle.sysman.emCfg.core.ActionStepStateReference;
import oracle.sysman.emCfg.core.CfmActionPair;
import oracle.sysman.emCfg.core.CfmActionStep;
import oracle.sysman.emCfg.core.CfmActionStepState;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAnyPair;
import oracle.sysman.emCfg.core.CfmConditionPair;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.MicroStepStateReference;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.ActionStepStatus;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.MicroStepStatus;

class CfmActionStepPair
extends CfmAnyPair
implements IActionStepState {
    private static final Comparator actionStepPairComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return CfmActionStepPair.compare(o1, o2);
        }
    };

    public CfmActionStepPair(CfmAggregateHolder cfmAggregateHolder, CfmActionStep cfmObject, CfmActionStepState cfmObjectState) {
        super(cfmAggregateHolder, cfmObject, cfmObjectState);
    }

    @Override
    public String toString() {
        return "{" + super.toString() + " priority=" + this.getPriority() + "}";
    }

    public CfmActionStep getCfmActionStep() {
        return (CfmActionStep)this.getCfmObject();
    }

    public CfmActionStepState getCfmActionStepState() {
        return (CfmActionStepState)this.getCfmObjectState();
    }

    public String getActionID() {
        return this.getCfmActionStep().getActionID();
    }

    public int getPriority() {
        return this.getCfmActionStepState().getPriority();
    }

    public int getIndex() {
        return this.getCfmActionStep().getIndex();
    }

    public void setStatusFailed() {
        if (this.isRequired()) {
            this.getCfmActionStepState().setStatus(ActionStepStatus.PERFORMED_FAILED);
        } else {
            this.getCfmActionStepState().setStatus(ActionStepStatus.FAILED_NOTREQUIRED);
        }
    }

    CfmAnyPair getConditionPair() throws CfwException {
        return this.getAggregateHolder().getConditionOrParameterPair(this.getCfmActionStep().getCondition());
    }

    CfmAnyPair getConditionPairOrNull() {
        try {
            return this.getConditionPair();
        }
        catch (CfwException e) {
            return null;
        }
    }

    public boolean isCondition() {
        CfmAnyPair anyPair;
        try {
            anyPair = this.getConditionPair();
        }
        catch (CfwException e) {
            return true;
        }
        return CfmConditionPair.isCondition(anyPair);
    }

    public IMicroStepStateReference[] getCfmMicroStepStateReferences() throws CfwException {
        List microStepPairs = this.getMicroSteps();
        int size = microStepPairs.size();
        IMicroStepStateReference[] result = new IMicroStepStateReference[size];
        Iterator iter = microStepPairs.iterator();
        for (int i = 0; i < size; ++i) {
            CfmMicroStepPair microStepPair = (CfmMicroStepPair)iter.next();
            result[i] = new MicroStepStateReference(microStepPair);
        }
        return result;
    }

    public IMicroStepStateReference getCfmMicroStepStateReference(int microStepIndex) throws CfwException {
        CfmMicroStepPair microStepPair = this.getCfmMicroStepPair(microStepIndex);
        return new MicroStepStateReference(microStepPair);
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null) {
            throw new Error("CfmActionStepPair.compare: invalid (null) o1");
        }
        if (!(o1 instanceof CfmActionStepPair)) {
            throw new Error("CfmActionStepPair.compare: \"foreign\" o1 " + o1.getClass().getName());
        }
        if (o2 == null) {
            throw new Error("CfmActionStepPair.compare: invalid (null) o2");
        }
        if (!(o2 instanceof CfmActionStepPair)) {
            throw new Error("CfmActionStepPair.compare: \"foreign\" o2 " + o2.getClass().getName());
        }
        CfmActionStepPair s1 = (CfmActionStepPair)o1;
        CfmActionStepPair s2 = (CfmActionStepPair)o2;
        int pri1 = s1.getPriority();
        int pri2 = s2.getPriority();
        int result = CfmUtil.intCompare(pri2, pri1);
        if (result != 0) {
            return result;
        }
        int idx1 = s1.getIndex();
        int idx2 = s2.getIndex();
        return CfmUtil.intCompare(idx1, idx2);
    }

    public List getMicroSteps() {
        return this.getAggregateHolder().getMicroStepPairs(this.getIndex(), this.getActionID());
    }

    public CfmMicroStepPair getCfmMicroStepPair(int microStepIndex) throws CfwException {
        List microStepPairs = this.getMicroSteps();
        for (CfmMicroStepPair microStepPair : microStepPairs) {
            if (microStepPair.getIndex() != microStepIndex) continue;
            return microStepPair;
        }
        throw new CfwException("CfmActionStepState:IMicroStepStateReference:invalid micro-stepIndex = " + microStepIndex);
    }

    public void setAllMicroStepStates(MicroStepStatus status) {
        List microStepPairs = this.getMicroSteps();
        for (CfmMicroStepPair microStepPair : microStepPairs) {
            microStepPair.setStatus(status);
        }
    }

    @Override
    public void save(StringBuffer sb) {
        sb.append("\t\t<ins:ActionStep status=\"" + Formatter.escapeXMLSequences(this.getCfmActionStepState().getStatus().getIdent()) + "\" ");
        sb.append("index=\"" + this.getCfmActionStepState().getStepIndex() + "\" ");
        sb.append("priority=\"" + this.getCfmActionStepState().getPriority() + "\" >\n");
        for (CfmMicroStepPair microStepPair : this.getMicroSteps()) {
            microStepPair.save(sb);
        }
        sb.append("\t\t</ins:ActionStep>\n");
    }

    public static Comparator getActionStepPairComparator() {
        return actionStepPairComparator;
    }

    @Override
    public String getSelfID() {
        return "" + this.getIndex();
    }

    public CfmActionPair getActionPair() {
        CfmAggregateHolder holder = this.getAggregateHolder();
        try {
            return holder.getActionPairById(this.getActionID());
        }
        catch (CfwException e) {
            throw new Error("Critical error");
        }
    }

    @Override
    public boolean isRequired() {
        return this.getCfmActionStep().isRequired();
    }

    @Override
    public int getFailedMicroStepIndex() {
        return this.getCfmActionStepState().getFailedMicroStepIndex();
    }

    @Override
    public IMicroStepState[] getMicroStepStates() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public IMicroStepState getMicroStepState(int msIdx) throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public IMicroStepState getFailedMicroStepState() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public int getWeight() throws CfwException {
        return this.getCfmActionStepState().getWeight();
    }

    @Override
    public ActionStepStatus getActionStepStatus() throws CfwException {
        return this.getCfmActionStepState().getStatus();
    }

    @Override
    public IStateReference getReference() {
        return new ActionStepStateReference(this);
    }

    @Override
    public String getSummary() throws CfwException {
        return this.getCfmActionStepState().getSummary();
    }

    @Override
    public IStatus getStatus() throws CfwException {
        return this.getActionStepStatus();
    }

    @Override
    public IObjectState getParent() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public IObject getOriginator() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    public void setStatus(ActionStepStatus actionStepStatus) {
        this.getCfmActionStepState().setStatus(actionStepStatus);
    }
}

