/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.Vector;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmAction;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmCondition;
import oracle.sysman.emCfg.core.CfmConditionRef;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParentObject;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.schema.descriptions.ActionStepT;

class CfmActionStep
extends CfmParentObject {
    private Vector microSteps = new Vector();
    private CfmConditionRef conditionRef;
    private final int index;
    private final int priority;
    private final boolean standAloneOnlyB;
    private final boolean requiredB;
    public static final CfmElementType elementType = CfmElementType.ACTION_STEP;

    public CfmActionStep(DescriptionsLoader loader, CfmAction action, ActionStepT actionStepT, int index) {
        super(loader, actionStepT, elementType, Integer.toString(index), action);
        this.index = index;
        this.priority = actionStepT.getPriority();
        this.standAloneOnlyB = actionStepT.isStandaloneonly();
        this.requiredB = actionStepT.isRequired();
    }

    public void setMicroSteps(Vector microSteps) {
        this.microSteps = microSteps;
    }

    public CfmAggregate getActionAggregate() throws CfwException {
        return this.getAction().getParentAggregate();
    }

    public String getActionAggregateID() {
        return this.getAction().getAggregateID();
    }

    public String getActionID() {
        return this.getAction().getSelfID();
    }

    public String getCurrentNS() {
        return this.getAction().getNamespace();
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isStandAloneOnly() {
        return this.standAloneOnlyB;
    }

    public boolean isRequired() {
        return this.requiredB;
    }

    public void setConditionRef(CfmConditionRef conditionRef) {
        this.conditionRef = conditionRef;
    }

    public CfmConditionRef getConditionRef() {
        return this.conditionRef;
    }

    public CfmTaggedObject getCondition() {
        if (this.conditionRef == null) {
            return null;
        }
        CfmTaggedObject o = this.conditionRef.getCondition();
        if (o != null && (o instanceof CfmCondition || o instanceof CfmParameter)) {
            return o;
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public Vector getMicroSteps() {
        return this.microSteps;
    }

    public CfmAction getAction() {
        return (CfmAction)this.getParentObject();
    }
}

