/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.core.ActionInvocationState;
import oracle.sysman.emCfg.core.ActionRequest;
import oracle.sysman.emCfg.core.ActionRequestDetached;
import oracle.sysman.emCfg.core.ActionRequestNormal;
import oracle.sysman.emCfg.core.ActionRequestRecommended;
import oracle.sysman.emCfg.core.ActionRequestSelected;
import oracle.sysman.emCfg.core.ActionStepStateReference;
import oracle.sysman.emCfg.core.AggregateActionInvocationState;
import oracle.sysman.emCfg.core.CfmAction;
import oracle.sysman.emCfg.core.CfmActionStep;
import oracle.sysman.emCfg.core.CfmActionStepPair;
import oracle.sysman.emCfg.core.CfmActionStepState;
import oracle.sysman.emCfg.core.CfmAggregateActionRef;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmMicroStep;
import oracle.sysman.emCfg.core.CfmMicroStepState;
import oracle.sysman.emCfg.core.CfmObjectState;
import oracle.sysman.emCfg.core.CfmStateType;
import oracle.sysman.emCfg.schema.instance.ActionT;
import oracle.sysman.emCfg.schema.instance.DetachedRequestT;
import oracle.sysman.emCfg.schema.instance.NormalRequestT;
import oracle.sysman.emCfg.schema.instance.RecommendedRequestT;
import oracle.sysman.emCfg.schema.instance.SelectedRequestT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

class CfmActionState
extends CfmObjectState {
    private ActionRequest request;
    private int failedStepStateIndex = -1;
    private ActionStatus status;

    CfmActionState(CfmAggregateInstance aggregateInstance, ActionT actionT, String id) throws CfwException {
        super(aggregateInstance, id);
        SelectedRequestT selectedRequestT;
        DetachedRequestT detachedRequestT;
        RecommendedRequestT recommendedRequestT;
        CfmUtil.myAssert(actionT != null);
        String statusS = actionT.getStatus();
        this.setStatus(ActionStatus.getStatus(statusS));
        NormalRequestT normalRequestT = actionT.getNormalRequest();
        ActionRequest actionRequest = normalRequestT != null ? new ActionRequestNormal(normalRequestT) : ((recommendedRequestT = actionT.getRecommendedRequest()) != null ? new ActionRequestRecommended(recommendedRequestT) : ((detachedRequestT = actionT.getDetachedRequest()) != null ? new ActionRequestDetached(detachedRequestT) : ((selectedRequestT = actionT.getSelectedRequest()) != null ? new ActionRequestSelected(selectedRequestT) : null)));
        this.setRequest(actionRequest);
    }

    CfmActionState(CfmAggregateInstance aggregateInstance, CfmAction action) throws CfwException {
        super(aggregateInstance, action.getSelfID());
        this.setStatus(ActionStatus.NOT_PERFORMED);
        List allSteps = action.getActionSteps();
        for (CfmActionStep actionStep : allSteps) {
            if (!actionStep.getActionID().equals(action.getSelfID())) {
                CfmUtil.myAssert(false);
                continue;
            }
            new CfmActionStepState(aggregateInstance, actionStep);
            for (CfmMicroStep microStep : actionStep.getMicroSteps()) {
                if (!microStep.getActionStep().equals(actionStep)) continue;
                CfmMicroStepState microStepState = new CfmMicroStepState(aggregateInstance, microStep);
                if (microStep.getFlavor().equals(MicroStepFlavor.ACTION_REF)) {
                    microStepState.setActionInvocationState(new ActionInvocationState(microStep.getActionRef()));
                    microStepState.setStatus(MicroStepStatus.NOT_PERFORMED);
                    continue;
                }
                if (microStep.getFlavor().equals(MicroStepFlavor.AGGREGATE_ACTION_REF)) {
                    CfmAggregateActionRef ref = microStep.getAggregateActionRef().getActualReference();
                    if (ref == null) {
                        microStepState.setActionInvocationState(new AggregateActionInvocationState(microStep.getAggregateActionRef(), aggregateInstance.getFamilyName()));
                    } else {
                        microStepState.setActionInvocationState(new AggregateActionInvocationState(ref, aggregateInstance.getFamilyName(), -1L));
                        CfmUtil.myAssert(CfmUtil.nullOrEqual(ref.getIdref(), microStep.getAggregateActionRef().getIdRef()));
                    }
                    microStepState.setStatus(MicroStepStatus.NOT_PERFORMED);
                    continue;
                }
                microStepState.setStatus(MicroStepStatus.NOT_PERFORMED);
            }
        }
    }

    void setRequest(ActionRequest request) {
        this.request = request;
    }

    ActionRequest getRequest() {
        return this.request;
    }

    public IActionStepStateReference[] getActionStepStateReferences2(CfmAggregateHolder holder) throws CfwException {
        return this.getAllActionStepStateReferences(holder).toArray(new ActionStepStateReference[0]);
    }

    public List getAllActionStepStateReferences(CfmAggregateHolder holder) throws CfwException {
        List result = holder.getActionStepPairs(this.getSelfID());
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, ((CfmActionStepPair)result.get(i)).getReference());
        }
        return result;
    }

    public IActionStepStateReference getCfmActionStepStateReference2(int stepIndex, CfmAggregateHolder holder) throws CfwException {
        List actionStepStateRefs = this.getAllActionStepStateReferences(holder);
        if (stepIndex < 0 || stepIndex >= actionStepStateRefs.size()) {
            throw new CfwException("invalid stepIndex = " + stepIndex);
        }
        return (IActionStepStateReference)actionStepStateRefs.get(stepIndex);
    }

    public int getFailedStepStateIndex() {
        return this.failedStepStateIndex;
    }

    public void setFailedStepStateIndex(int failedStepStateIndex) {
        this.failedStepStateIndex = failedStepStateIndex;
    }

    @Override
    public CfmStateType getStateType() {
        return CfmStateType.ACTION;
    }

    public void setStatus(ActionStatus status) {
        this.status = status;
    }

    public ActionStatus getActionStatus() {
        if (this.status == null) {
            throw new Error("CfmActionState.getStatus: unknown status of " + this.toString());
        }
        return this.status;
    }

    public IStatus getStatus() {
        return this.getActionStatus();
    }

    public boolean isStatus(ActionStatus status) throws CfwException {
        if (this.status == null) {
            throw new CfwException("CfmActionState.isStatus: invalid (null) status");
        }
        return status.equals(this.getActionStatus());
    }
}

