/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStateReference;
import oracle.sysman.emCfg.common.IConditionReference;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.core.ActionPerformer;
import oracle.sysman.emCfg.core.ActionReference;
import oracle.sysman.emCfg.core.ActionRequest;
import oracle.sysman.emCfg.core.ActionRequestDetached;
import oracle.sysman.emCfg.core.ActionRequestNormal;
import oracle.sysman.emCfg.core.ActionRequestOptional;
import oracle.sysman.emCfg.core.ActionRequestRecommended;
import oracle.sysman.emCfg.core.ActionRequestSelected;
import oracle.sysman.emCfg.core.ActionStateReference;
import oracle.sysman.emCfg.core.CfmAction;
import oracle.sysman.emCfg.core.CfmActionState;
import oracle.sysman.emCfg.core.CfmActionStepPair;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAnyPair;
import oracle.sysman.emCfg.core.CfmConditionPair;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.ConditionReference;
import oracle.sysman.emCfg.core.ICfmObjectState;
import oracle.sysman.emCfg.core.MicroStepStateReference;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.ActionStepStatus;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;
import oracle.sysman.emCfg.types.StatusOrType;

class CfmActionPair
extends CfmAnyPair
implements IAction {
    private final Vector outstandingPerformers = new Vector();

    CfmActionPair(CfmAggregateHolder cfmAggregateHolder, CfmAction cfmObject, ICfmObjectState cfmObjectState) {
        super(cfmAggregateHolder, cfmObject, cfmObjectState);
    }

    CfmAction getCfmAction() {
        return (CfmAction)this.getCfmObject();
    }

    CfmActionState getCfmActionState() {
        return (CfmActionState)this.getCfmObjectState();
    }

    IActionStateReference getCfmActionStateReference() {
        return new ActionStateReference(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPerformer(ActionPerformer ap) {
        Vector vector = this.outstandingPerformers;
        synchronized (vector) {
            this.outstandingPerformers.add(ap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePerformer(ActionPerformer ap) {
        Vector vector = this.outstandingPerformers;
        synchronized (vector) {
            this.outstandingPerformers.remove(ap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOutstandingPerformers() {
        Vector vector = this.outstandingPerformers;
        synchronized (vector) {
            return (List)this.outstandingPerformers.clone();
        }
    }

    void actionComplete(ActionPerformer actionPerformer) {
        this.removePerformer(actionPerformer);
    }

    String getActionID() {
        return this.getCfmAction().getSelfID();
    }

    @Override
    public ActionType[] getTypes() throws CfwException {
        return this.getCfmAction().getTypes();
    }

    @Override
    public boolean isType(ActionType type) throws CfwException {
        return this.getCfmAction().isType(type);
    }

    @Override
    public boolean isWithinTypes(ActionType[] types) throws CfwException {
        return this.getCfmAction().isWithinTypes(types);
    }

    @Override
    public int getStepCount() throws CfwException {
        return this.getCfmAction().getStepCount();
    }

    private CfmAnyPair getConditionPair() throws CfwException {
        return this.getAggregateHolder().getConditionOrParameterPair(this.getCfmAction().getCondition());
    }

    public boolean isCondition() {
        CfmAnyPair anyPair;
        try {
            anyPair = this.getConditionPair();
        }
        catch (CfwException e) {
            return true;
        }
        return CfmConditionPair.isCondition(anyPair);
    }

    ConditionReference getCfmActionConditionRef() throws CfwException {
        CfmAnyPair conditionPair = this.getConditionPair();
        return new ConditionReference(conditionPair.getCfmObject().getSelfID(), this.getAggregateHolder().getFamilyIdentifier());
    }

    ConditionReference getCfmActionStepConditionRef(int stepIdx) throws CfwException {
        CfmAnyPair conditionPair = this.getActionStepPair(stepIdx).getConditionPair();
        return new ConditionReference(conditionPair.getCfmObject().getSelfID(), this.getAggregateHolder().getFamilyIdentifier());
    }

    List getActionStepPairs() {
        return this.getAggregateHolder().getActionStepPairs(this.getActionID());
    }

    CfmActionStepPair getActionStepPair(int index) throws CfwException {
        return this.getAggregateHolder().getActionStepPair(this.getActionID(), index);
    }

    public void setAllStepStates(ActionStepStatus actionStepStatus, MicroStepStatus microStepStatus) {
        List actionStepPairs = this.getActionStepPairs();
        for (CfmActionStepPair actionStepPair : actionStepPairs) {
            actionStepPair.setStatus(actionStepStatus);
            actionStepPair.setAllMicroStepStates(microStepStatus);
        }
    }

    List getSelectedStep(int actionStepIndex, int microStepIndex) {
        List actionSteps = this.getActionStepPairs();
        Iterator i = actionSteps.iterator();
        while (i.hasNext()) {
            CfmActionStepPair asp = (CfmActionStepPair)i.next();
            if (asp.getIndex() != actionStepIndex) {
                i.remove();
                continue;
            }
            List msp = asp.getMicroSteps();
            Iterator mspi = msp.iterator();
            while (mspi.hasNext()) {
                CfmMicroStepPair microPair = (CfmMicroStepPair)mspi.next();
                if (microPair.getFlavor().isPlugInInvocation() && microPair.getIndex() == microStepIndex) continue;
                mspi.remove();
            }
        }
        return actionSteps;
    }

    List getActionSteps(boolean retry, boolean skipDetached, IMicroStepStateReference[] selectedMSRefs) throws CfwException {
        List actionSteps = this.getActionStepPairs();
        Iterator actionStepIter = actionSteps.iterator();
        while (actionStepIter.hasNext()) {
            CfmActionStepPair asp = (CfmActionStepPair)actionStepIter.next();
            List microSteps = asp.getMicroSteps();
            Iterator microStepIter = microSteps.iterator();
            while (microStepIter.hasNext()) {
                CfmMicroStepPair microPair = (CfmMicroStepPair)microStepIter.next();
                if (!microPair.getFlavor().isPlugInInvocation()) continue;
                if (microPair.filterForRetryOrDetached(retry, skipDetached)) {
                    microStepIter.remove();
                    continue;
                }
                if (selectedMSRefs == null || selectedMSRefs.length <= 0 || this.isMicroPairSelected(microPair, selectedMSRefs)) continue;
                microStepIter.remove();
            }
            if (microSteps.size() != 0) continue;
            actionStepIter.remove();
        }
        Collections.sort(actionSteps, CfmActionStepPair.getActionStepPairComparator());
        return actionSteps;
    }

    List getActionSteps(boolean retry, boolean skipDetached) throws CfwException {
        return this.getActionSteps(retry, skipDetached, null);
    }

    private boolean isMicroPairSelected(CfmMicroStepPair microPair, IMicroStepStateReference[] selectedMSRefs) throws CfwException {
        boolean isSelected = false;
        for (int i = 0; i < selectedMSRefs.length; ++i) {
            IMicroStepStateReference msRef = selectedMSRefs[i];
            if (!microPair.getAggregateHolder().getSelfID().equals(msRef.getAggregateID()) || !microPair.getOracleHome().equals(msRef.getOH()) || !microPair.getOwningActionID().equals(msRef.getActionID()) || microPair.getStepIndex() != msRef.getStepIndex() || microPair.getIndex() != msRef.getMicroStepIndex()) continue;
            isSelected = true;
            break;
        }
        return isSelected;
    }

    void addStepsCommands(CommandListResult result, CfmActionPair actionPair, CfmActionStepPair stepPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, ActionType actionType) throws CfwException {
        this.addStepsCommands(result, actionPair, stepPair, isSilently, retry, skipDetached, recommended, chkConditions, false, actionType, true);
    }

    void addStepsCommands(CommandListResult result, CfmActionPair actionPair, CfmActionStepPair stepPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, boolean includeInactive, ActionType actionType) throws CfwException {
        this.addStepsCommands(result, actionPair, stepPair, isSilently, retry, skipDetached, recommended, chkConditions, includeInactive, actionType, true);
    }

    void addStepsCommands(CommandListResult result, CfmActionPair actionPair, CfmActionStepPair stepPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, ActionType actionType, boolean deep) throws CfwException {
        this.addStepsCommands(result, actionPair, stepPair, isSilently, retry, skipDetached, recommended, chkConditions, false, actionType, deep);
    }

    void addStepsCommands(CommandListResult result, CfmActionPair actionPair, CfmActionStepPair stepPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, boolean includeInactive, ActionType actionType, boolean deep) throws CfwException {
        List msp = stepPair.getAggregateHolder().getMicroStepPairs(stepPair.getIndex(), actionPair.getActionID());
        for (CfmMicroStepPair microPair : msp) {
            CfmActionPair refPair;
            microPair.msInit(isSilently);
            MicroStepFlavor flavor = microPair.getFlavor();
            if (flavor.isPlugInInvocation()) {
                if (!includeInactive && (!microPair.getCfmMicroStep().getPlugInInvocation().getPlugInNoNull().isActive() || !microPair.getPlugInInvocationState().isActive()) || microPair.filterForRetryOrDetached(retry, skipDetached)) continue;
                boolean isActionStepRequired = microPair.getCfmMicroStep().getActionStep().isRequired();
                if (recommended && !isActionStepRequired) continue;
                result.commands.add(microPair);
                continue;
            }
            if (!deep || flavor != MicroStepFlavor.ACTION_REF && flavor != MicroStepFlavor.AGGREGATE_ACTION_REF || flavor == MicroStepFlavor.AGGREGATE_ACTION_REF && !includeInactive && !microPair.isActionAggregateActive() || (refPair = microPair.getReferredAction(actionType)) == null) continue;
            this.addActionCommands(result, refPair, isSilently, retry, skipDetached, recommended, chkConditions, includeInactive, actionType);
        }
    }

    void addActionCommands(CommandListResult result, CfmActionPair actionPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, ActionType actionType) throws CfwException {
        this.addActionCommands(result, actionPair, isSilently, retry, skipDetached, recommended, chkConditions, false, actionType, true);
    }

    void addActionCommands(CommandListResult result, CfmActionPair actionPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, boolean includeInactive, ActionType actionType) throws CfwException {
        this.addActionCommands(result, actionPair, isSilently, retry, skipDetached, recommended, chkConditions, includeInactive, actionType, true);
    }

    void addActionCommands(CommandListResult result, CfmActionPair actionPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, ActionType actionType, boolean deep) throws CfwException {
        this.addActionCommands(result, actionPair, isSilently, retry, skipDetached, recommended, chkConditions, false, actionType, deep);
    }

    void addActionCommands(CommandListResult result, CfmActionPair actionPair, boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, boolean chkConditions, boolean includeInactive, ActionType actionType, boolean deep) throws CfwException {
        if (actionPair == null) {
            return;
        }
        if (chkConditions && !actionPair.isCondition()) {
            return;
        }
        if (actionPair.getCfmAction().isIgnoreDuplicateReferences() && result.actions.contains(actionPair)) {
            return;
        }
        result.actions.add(actionPair);
        List actionStepPairs = actionPair.getActionSteps(retry, skipDetached);
        for (CfmActionStepPair stepPair : actionStepPairs) {
            if (chkConditions && !stepPair.isCondition()) continue;
            this.addStepsCommands(result, actionPair, stepPair, isSilently, retry, skipDetached, recommended, chkConditions, includeInactive, actionType, deep);
        }
    }

    List getOrderedCommands(boolean isSilently, boolean retry, boolean skipDetached, boolean recommended, ActionType actionType, boolean deep) throws CfwException {
        CommandListResult result = new CommandListResult();
        this.addActionCommands(result, this, isSilently, retry, skipDetached, recommended, true, actionType, deep);
        return result.commands;
    }

    List getOptionalCommands(boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        return this.getOptionalCommands(isSilently, retry, skipDetached, false, actionType);
    }

    List getOptionalCommands(boolean isSilently, boolean retry, boolean skipDetached, boolean includeInactive, ActionType actionType) throws CfwException {
        CommandListResult result = new CommandListResult();
        this.addActionCommands(result, this, isSilently, retry, skipDetached, false, true, includeInactive, actionType);
        List commands = result.commands;
        Iterator itr = commands.iterator();
        while (itr.hasNext()) {
            CfmMicroStepPair microPair = (CfmMicroStepPair)itr.next();
            if (!microPair.getCfmMicroStep().getActionStep().isRequired()) continue;
            itr.remove();
        }
        return commands;
    }

    List getDetachedCommands(boolean isSilently, boolean retry, ActionType actionType) throws CfwException {
        CommandListResult result = new CommandListResult();
        this.addActionCommands(result, this, isSilently, retry, false, false, true, actionType);
        List commands = result.commands;
        Iterator itr = commands.iterator();
        while (itr.hasNext()) {
            CfmMicroStepPair microPair = (CfmMicroStepPair)itr.next();
            if (!microPair.getCfmMicroStep().getPlugInInvocation().isAttached()) continue;
            itr.remove();
        }
        return commands;
    }

    void setActive(boolean isActive, ActionType actionType) throws CfwException {
        CommandListResult result = new CommandListResult();
        this.addActionCommands(result, this, false, false, false, false, false, actionType);
        List all = result.commands;
        for (CfmMicroStepPair microPair : all) {
            microPair.getCfmMicroStepState().getPlugInInvocationState().setActive(isActive);
        }
    }

    public void perform(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, IMicroStepStateReference[] selectedMSRefs, ActionType type) throws CfwException {
        this.cfmLogger.log(Level.INFO, "IAction.perform() was called on " + this.toString());
        ActionRequestNormal request = new ActionRequestNormal(blocking, isSilently, retry, skipDetached, type);
        this.getCfmActionState().setRequest(request);
        ActionPerformer actionPerformer = new ActionPerformer(this, false, false, blocking, isSilently, retry, skipDetached, selectedMSRefs, type);
        actionPerformer.startAction();
    }

    @Override
    public void perform(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, ActionType type) throws CfwException {
        this.perform(blocking, isSilently, retry, skipDetached, null, type);
    }

    @Override
    public void perform(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached) throws CfwException {
        this.perform(blocking, isSilently, retry, skipDetached, ActionType.UNKNOWN);
    }

    List getRecommendedActionSteps(boolean retry, boolean skipDetached, boolean skipOptional) throws CfwException {
        List actionStepPairs = this.getActionStepPairs();
        Iterator i = actionStepPairs.iterator();
        while (i.hasNext()) {
            CfmActionStepPair sp = (CfmActionStepPair)i.next();
            List mSteps = sp.getMicroSteps();
            Iterator msi = mSteps.iterator();
            while (msi.hasNext()) {
                CfmMicroStepPair microPair = (CfmMicroStepPair)msi.next();
                if (!microPair.getFlavor().isPlugInInvocation() || !microPair.filterForRetryOrDetached(retry, skipDetached)) continue;
                msi.remove();
            }
            if (mSteps.size() != 0) continue;
            i.remove();
        }
        ArrayList<CfmActionStepPair> requiredActionSteps = new ArrayList<CfmActionStepPair>();
        ArrayList<CfmActionStepPair> optionalActionSteps = new ArrayList<CfmActionStepPair>();
        for (CfmActionStepPair sp : actionStepPairs) {
            if (sp.getCfmActionStep().isRequired()) {
                requiredActionSteps.add(sp);
                continue;
            }
            optionalActionSteps.add(sp);
        }
        Collections.sort(requiredActionSteps, CfmActionStepPair.getActionStepPairComparator());
        if (!skipOptional) {
            Collections.sort(optionalActionSteps, CfmActionStepPair.getActionStepPairComparator());
            requiredActionSteps.addAll(optionalActionSteps);
        } else {
            Iterator i2 = optionalActionSteps.iterator();
            while (i2.hasNext()) {
                CfmActionStepPair sp;
                sp = (CfmActionStepPair)i2.next();
                List mSteps = sp.getMicroSteps();
                Iterator msi = mSteps.iterator();
                while (msi.hasNext()) {
                    CfmMicroStepPair microPair = (CfmMicroStepPair)msi.next();
                    if (!microPair.getFlavor().isPlugInInvocation() || sp.getCfmActionStep().isRequired()) continue;
                    msi.remove();
                }
                if (mSteps.size() != 0) continue;
                i2.remove();
            }
            requiredActionSteps.addAll(optionalActionSteps);
        }
        return requiredActionSteps;
    }

    List getOptionalActionSteps(boolean retry, boolean skipDetached) throws CfwException {
        List actionStepPairs = this.getActionStepPairs();
        Iterator i = actionStepPairs.iterator();
        while (i.hasNext()) {
            CfmActionStepPair sp = (CfmActionStepPair)i.next();
            List mSteps = sp.getMicroSteps();
            Iterator msi = mSteps.iterator();
            while (msi.hasNext()) {
                CfmMicroStepPair microPair = (CfmMicroStepPair)msi.next();
                if (!microPair.getFlavor().isPlugInInvocation() || !sp.getCfmActionStep().isRequired() && !microPair.filterForRetryOrDetached(retry, skipDetached)) continue;
                msi.remove();
            }
            if (mSteps.size() != 0) continue;
            i.remove();
        }
        Collections.sort(actionStepPairs, CfmActionStepPair.getActionStepPairComparator());
        return actionStepPairs;
    }

    @Override
    public void performRecommended(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, boolean skipOptional, ActionType type) throws CfwException {
        this.cfmLogger.log(Level.INFO, "IAction.performRecommended() was called on " + this.toString());
        ActionRequestRecommended request = new ActionRequestRecommended(blocking, isSilently, retry, skipDetached, skipOptional, type);
        this.getCfmActionState().setRequest(request);
        ActionPerformer actionPerformer = new ActionPerformer(this, true, false, blocking, isSilently, retry, skipDetached, type);
        actionPerformer.startAction();
    }

    @Override
    public void performRecommended(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, boolean skipOptional) throws CfwException {
        this.performRecommended(blocking, isSilently, retry, skipDetached, skipOptional, ActionType.UNKNOWN);
    }

    @Override
    public void performRecommended(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, ActionType type) throws CfwException {
        this.performRecommended(blocking, isSilently, retry, skipDetached, false, type);
    }

    @Override
    public void performRecommended(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached) throws CfwException {
        this.performRecommended(blocking, isSilently, retry, skipDetached, false, ActionType.UNKNOWN);
    }

    @Override
    public void performOptional(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached, ActionType type) throws CfwException {
        this.cfmLogger.log(Level.INFO, "IAction.performOptional() was called on " + this.toString());
        ActionRequestOptional request = new ActionRequestOptional(blocking, isSilently, retry, skipDetached, type);
        this.getCfmActionState().setRequest(request);
        ActionPerformer actionPerformer = new ActionPerformer(this, false, true, blocking, isSilently, retry, skipDetached, type);
        actionPerformer.startAction();
    }

    @Override
    public void performOptional(boolean blocking, boolean isSilently, boolean retry, boolean skipDetached) throws CfwException {
        this.performOptional(blocking, isSilently, retry, skipDetached, ActionType.UNKNOWN);
    }

    List getDetachedActionSteps(boolean retry) throws CfwException {
        List actionSteps = this.getActionStepPairs();
        Iterator i = actionSteps.iterator();
        while (i.hasNext()) {
            CfmActionStepPair sp = (CfmActionStepPair)i.next();
            List mSteps = sp.getMicroSteps();
            Iterator msi = mSteps.iterator();
            while (msi.hasNext()) {
                CfmMicroStepPair microPair = (CfmMicroStepPair)msi.next();
                if (!microPair.getFlavor().isPlugInInvocation()) continue;
                if (microPair.getCfmMicroStep().getPlugInInvocation().isAttached()) {
                    msi.remove();
                    continue;
                }
                if (!microPair.filterForRetry(retry)) continue;
                msi.remove();
            }
            if (mSteps.size() != 0) continue;
            i.remove();
        }
        Collections.sort(actionSteps, CfmActionStepPair.getActionStepPairComparator());
        return actionSteps;
    }

    @Override
    public void performDetached(boolean blocking, boolean isSilently, boolean retry, ActionType type) throws CfwException {
        this.cfmLogger.log(Level.INFO, "IAction.performDetached() was called on " + this.toString());
        ActionRequestDetached request = new ActionRequestDetached(blocking, isSilently, retry, type);
        this.getCfmActionState().setRequest(request);
        ActionPerformer actionPerformer = new ActionPerformer(this, blocking, isSilently, retry, type);
        actionPerformer.startAction();
    }

    @Override
    public void performDetached(boolean blocking, boolean isSilently, boolean retry) throws CfwException {
        this.performDetached(blocking, isSilently, retry, ActionType.UNKNOWN);
    }

    @Override
    public void performSelectedStep(boolean blocking, int actionStepIndex, int microStepIndex) throws CfwException {
        this.cfmLogger.log(Level.INFO, "IAction.performSelectedStep() was called on " + this.toString());
        ActionRequestSelected request = new ActionRequestSelected(blocking, actionStepIndex, microStepIndex);
        this.getCfmActionState().setRequest(request);
        ActionPerformer actionPerformer = new ActionPerformer(this, blocking, actionStepIndex, microStepIndex, ActionType.UNKNOWN);
        actionPerformer.startAction();
    }

    @Override
    public void cancel(boolean blocking) throws CfwException {
        List performersToCancel = this.getOutstandingPerformers();
        for (ActionPerformer curr : performersToCancel) {
            curr.abort();
        }
        if (blocking) {
            performersToCancel.retainAll(this.getOutstandingPerformers());
            while (performersToCancel.size() > 0) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                performersToCancel.retainAll(this.getOutstandingPerformers());
            }
        }
    }

    List getAllActionSteps() {
        List actionSteps = this.getActionStepPairs();
        Collections.sort(actionSteps, CfmActionStepPair.getActionStepPairComparator());
        return actionSteps;
    }

    @Override
    public void setPriority(int stepIndex, int priorityValue) throws CfwException {
        List steps = this.getAllActionSteps();
        if (stepIndex < 0 || stepIndex > steps.size()) {
            throw new CfwException("stepIndex is out of bounds");
        }
        for (CfmActionStepPair actionStepPair : steps) {
            if (actionStepPair.getIndex() != stepIndex) continue;
            actionStepPair.getCfmActionStepState().setPriority(priorityValue);
            return;
        }
        throw new CfwException("stepIndex is not found!");
    }

    @Override
    public int getPriority(int stepIndex) throws CfwException {
        List steps = this.getAllActionSteps();
        if (stepIndex < 0 || stepIndex > steps.size()) {
            throw new CfwException("stepIndex is out of bounds");
        }
        for (CfmActionStepPair actionStepPair : steps) {
            if (actionStepPair.getIndex() != stepIndex) continue;
            return actionStepPair.getPriority();
        }
        throw new CfwException("stepIndex is not found!");
    }

    @Override
    public void save(StringBuffer sb) {
        List actionStepPairs;
        sb.append("\t<ins:Action id=\"" + Formatter.escapeXMLSequences(this.getCfmAction().getSelfID()) + "\" ");
        sb.append("status=\"" + Formatter.escapeXMLSequences(this.getCfmActionState().getActionStatus().getIdent()) + "\" >\n");
        ActionRequest request = this.getCfmActionState().getRequest();
        if (request == null) {
            actionStepPairs = this.getAllActionSteps();
        } else {
            request.save(sb);
            actionStepPairs = this.getAllActionSteps();
        }
        for (CfmActionStepPair actionStepPair : actionStepPairs) {
            actionStepPair.save(sb);
        }
        sb.append("\t</ins:Action>\n");
    }

    void setStatusAndSummary(ActionStatus status) {
        this.getCfmActionState().setStatus(status);
        this.getCfmActionState().setSummary("Action=" + this.getActionID() + " " + status);
    }

    @Override
    public void setActive(boolean isActive) throws CfwException {
        this.setActive(isActive, ActionType.UNKNOWN);
    }

    @Override
    public String getSelfID() {
        return this.getActionID();
    }

    private IMicroStepStateReference[] listTools(boolean isRecommended, boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType, boolean deep) throws CfwException {
        List allCommands = this.getOrderedCommands(isSilently, retry, skipDetached, isRecommended, actionType, deep);
        IMicroStepStateReference[] refs = new IMicroStepStateReference[allCommands.size()];
        int idx = 0;
        for (CfmMicroStepPair microPair : allCommands) {
            refs[idx++] = new MicroStepStateReference(microPair);
        }
        return refs;
    }

    @Override
    public IMicroStepStateReference[] listTools(boolean isRecommended, boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        return this.listTools(isRecommended, isSilently, retry, skipDetached, actionType, true);
    }

    @Override
    public IMicroStepStateReference[] listTools(boolean isRecommended, boolean isSilently, boolean retry, boolean skipDetached) throws CfwException {
        return this.listTools(isRecommended, isSilently, retry, skipDetached, ActionType.UNKNOWN, true);
    }

    @Override
    public IMicroStepStateReference[] listToolsInAggregate(boolean isRecommended, boolean isSilently, boolean retry, boolean skipDetached) throws CfwException {
        return this.listTools(isRecommended, isSilently, retry, skipDetached, ActionType.UNKNOWN, false);
    }

    @Override
    public IMicroStepStateReference[] listOptionalTools(boolean isSilently, boolean retry, boolean skipDetached, ActionType actionType) throws CfwException {
        return this.listOptionalTools(isSilently, retry, skipDetached, false, actionType);
    }

    @Override
    public IMicroStepStateReference[] listOptionalTools(boolean isSilently, boolean retry, boolean skipDetached, boolean includeInactive) throws CfwException {
        return this.listOptionalTools(isSilently, retry, skipDetached, includeInactive, ActionType.UNKNOWN);
    }

    @Override
    public IMicroStepStateReference[] listOptionalTools(boolean isSilently, boolean retry, boolean skipDetached) throws CfwException {
        return this.listOptionalTools(isSilently, retry, skipDetached, false, ActionType.UNKNOWN);
    }

    @Override
    public IMicroStepStateReference[] listOptionalTools(boolean isSilently, boolean retry, boolean skipDetached, boolean includeInactive, ActionType actionType) throws CfwException {
        List allCommands = this.getOptionalCommands(isSilently, retry, skipDetached, includeInactive, actionType);
        IMicroStepStateReference[] refs = new IMicroStepStateReference[allCommands.size()];
        int idx = 0;
        for (CfmMicroStepPair microPair : allCommands) {
            refs[idx++] = new MicroStepStateReference(microPair);
        }
        return refs;
    }

    @Override
    public IMicroStepStateReference[] listDetachedTools(boolean isSilently, boolean retry, ActionType actionType) throws CfwException {
        List allCommands = this.getDetachedCommands(isSilently, retry, actionType);
        IMicroStepStateReference[] refs = new IMicroStepStateReference[allCommands.size()];
        int idx = 0;
        for (CfmMicroStepPair microPair : allCommands) {
            refs[idx++] = new MicroStepStateReference(microPair);
        }
        return refs;
    }

    @Override
    public IMicroStepStateReference[] listDetachedTools(boolean isSilently, boolean retry) throws CfwException {
        return this.listDetachedTools(isSilently, retry, ActionType.UNKNOWN);
    }

    @Override
    public String getDesc() throws CfwException {
        return this.getCfmAction().getDesc();
    }

    @Override
    public IReference getReference() {
        return new ActionReference(this.getSelfID(), this.getAggregateHolder().getFamilyIdentifier());
    }

    @Override
    public IObject getParent() throws CfwException {
        return this.getAggregateHolder();
    }

    @Override
    public IObject getOriginator() throws CfwException {
        return null;
    }

    @Override
    public String getOracleHome() throws CfwException {
        return this.getAggregateHolder().getOracleHome();
    }

    @Override
    public IConditionReference getCondition(int stepIndex) throws CfwException {
        throw new CfwException("Unimplemented");
    }

    @Override
    public IConditionReference getCondition() throws CfwException {
        throw new CfwException("Unimplemented");
    }

    @Override
    public IActionState getActionState() throws CfwException {
        throw new CfwException("Unimplemented");
    }

    @Override
    public void backtrack(boolean blocking) throws CfwException {
        throw new CfwException("Unimplemented");
    }

    @Override
    public StatusOrType getStatus() throws CfwException {
        return this.getActionState().getActionStatus();
    }

    static class CommandListResult {
        final List commands = new Vector();
        final Set actions = new HashSet();

        CommandListResult() {
        }
    }
}

