/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.common.AggregateFamilyIdentifier;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.ActionReference;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmCondition;
import oracle.sysman.emCfg.core.CfmConditionRef;
import oracle.sysman.emCfg.core.CfmElementType;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParentObject;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.schema.descriptions.Action;
import oracle.sysman.emCfg.schema.descriptions.ConditionRefT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.ActionType;

class CfmAction
extends CfmParentObject {
    private final ActionType[] allTypes;
    private final CfmConditionRef conditionRef;
    private final boolean ignoreDuplicateReferences;
    private List actionSteps = new Vector();
    public static final CfmElementType elementType = CfmElementType.ACTION;

    public CfmAction(DescriptionsLoader loader, Action jaxbOrigin, CfmAggregate parentAggregate) throws CfwException {
        super(loader, jaxbOrigin, elementType, jaxbOrigin.getId(), parentAggregate);
        this.allTypes = CfmAction.parseActionTypes(jaxbOrigin.getTypes());
        ConditionRefT conditionRefT = jaxbOrigin.getConditionRef();
        if (conditionRefT != null) {
            CfmConditionRef conditionRef;
            this.conditionRef = conditionRef = CfmConditionRef.getInstance(loader, conditionRefT, parentAggregate);
            loader.getCfm().getDescriptionResolver().addUnresolved(conditionRef);
        } else {
            this.conditionRef = null;
        }
        this.ignoreDuplicateReferences = jaxbOrigin.isIgnoreDuplicateReferences();
    }

    private static ActionType[] parseActionTypes(String types) throws CfwException {
        Vector<ActionType> supportedTypes = new Vector<ActionType>();
        if (types != null) {
            String[] myTypes = types.split(" ");
            for (int i = 0; i < myTypes.length; ++i) {
                ActionType thisType = ActionType.getType(myTypes[i]);
                supportedTypes.add(thisType);
            }
        }
        if (supportedTypes.size() == 0) {
            supportedTypes.add(ActionType.UNKNOWN);
        }
        return supportedTypes.toArray(new ActionType[0]);
    }

    public CfmAggregate getParentAggregate() {
        return (CfmAggregate)this.getParentObject();
    }

    public CfmConditionRef getConditionRef() {
        return this.conditionRef;
    }

    public CfmTaggedObject getCondition() {
        if (this.conditionRef == null) {
            return null;
        }
        CfmTaggedObject o = this.conditionRef.getCondition();
        CfmUtil.myAssert(o instanceof CfmCondition || o instanceof CfmParameter);
        return o;
    }

    public boolean isIgnoreDuplicateReferences() {
        return this.ignoreDuplicateReferences;
    }

    public void setActionSteps(Vector actionSteps) {
        this.actionSteps = actionSteps;
    }

    public List getActionSteps(boolean isSilently, boolean retry, boolean detachedOnly) {
        return this.getActionSteps();
    }

    public List getActionSteps(boolean isSilently, boolean retry) {
        return this.getActionSteps();
    }

    public List getActionSteps() {
        return this.actionSteps;
    }

    public ActionType[] getTypes() throws CfwException {
        return this.allTypes;
    }

    public boolean isType(ActionType type) {
        return type.within(this.allTypes);
    }

    public boolean isWithinTypes(ActionType[] types) throws CfwException {
        for (int i = 0; i < types.length; ++i) {
            if (!this.isType(types[i])) continue;
            return true;
        }
        return false;
    }

    public int getStepCount() throws CfwException {
        List steps = this.getActionSteps();
        return steps.size();
    }

    public String getActionID() {
        return this.getSelfID();
    }

    public String getAggregateID() {
        return this.getParentObject().getSelfID();
    }

    public ActionReference getReference(AggregateFamilyIdentifier familyIdent) {
        return new ActionReference(this.getSelfID(), familyIdent);
    }
}

