/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifier;
import oracle.sysman.emCfg.common.AggregateDescriptionIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateFamilyIdentifier;
import oracle.sysman.emCfg.common.AggregateInstanceIdentifier;
import oracle.sysman.emCfg.common.AggregateInstanceIdentifierWithLocation;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IActionReference;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IActionStepStateReference;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IAggregateReference;
import oracle.sysman.emCfg.common.ICfw;
import oracle.sysman.emCfg.common.ICondition;
import oracle.sysman.emCfg.common.IConditionReference;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IParameter;
import oracle.sysman.emCfg.common.IParameterReference;
import oracle.sysman.emCfg.common.IPlugIn;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.common.IPlugInReference;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.AggregateReference;
import oracle.sysman.emCfg.core.CfmAction;
import oracle.sysman.emCfg.core.CfmActionState;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateDescription;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmAggregateInstance;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamilies;
import oracle.sysman.emCfg.core.CfmAggregateInstanceFamily;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.CfmAggregateRefPair;
import oracle.sysman.emCfg.core.CfmAggregateRefState;
import oracle.sysman.emCfg.core.CfmAggregateState;
import oracle.sysman.emCfg.core.CfmAggregateVersions;
import oracle.sysman.emCfg.core.CfmCondition;
import oracle.sysman.emCfg.core.CfmConditionState;
import oracle.sysman.emCfg.core.CfmParameter;
import oracle.sysman.emCfg.core.CfmParameterPair;
import oracle.sysman.emCfg.core.CfmParameterState;
import oracle.sysman.emCfg.core.CfmPlugIn;
import oracle.sysman.emCfg.core.CfmPlugInState;
import oracle.sysman.emCfg.core.CfmTaggedObject;
import oracle.sysman.emCfg.core.CfmTaggedObjectFactory;
import oracle.sysman.emCfg.core.CoreConstants;
import oracle.sysman.emCfg.core.DescriptionsLoader;
import oracle.sysman.emCfg.core.ICfm;
import oracle.sysman.emCfg.core.IdentifierIdNsLocation;
import oracle.sysman.emCfg.core.InstanceLoader;
import oracle.sysman.emCfg.core.LoadAggregateRequest;
import oracle.sysman.emCfg.core.LoadLocation;
import oracle.sysman.emCfg.core.LoadLocationDescriptions;
import oracle.sysman.emCfg.core.LoadLocationInstances;
import oracle.sysman.emCfg.core.Reference;
import oracle.sysman.emCfg.core.Resolver;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.schemavalidator.XSDValidator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class Cfm
implements ICfm,
ICfw {
    private static boolean debugB = Constants.VERBOSE_OUTPUT;
    private static final CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private PrintStream cfmout = null;
    private PrintStream cfmerr = null;
    private String envVarFileRelOrAbs = "install/envVars.properties";
    private DescriptionsLoader descriptionsLoader;
    private InstanceLoader instancesLoader;
    private final LoadLocation baseLoadLocation;
    private transient Unmarshaller descriptionsUnmarshaller;
    private transient Unmarshaller instancesUnmarshaller;
    String currentlyUnmarshalling;
    StringBuffer currentUnmarshallErrorString;
    private XSDValidator validator;
    final StringBuffer semanticErrors = new StringBuffer();
    public final String propertyDescriptionsSchemaClassName = "descriptions.schema.class.name";
    public final String defaultDescriptionsSchemaClassName = "oracle.sysman.emCfg.schema.descriptions.Descriptions";
    public final String propertyInstanceSchemaClassName = "instances.schema.class.name";
    public final String defaultInstanceSchemaClassName = "oracle.sysman.emCfg.schema.instance.AggregateInstance";
    private String descriptionsSchemaClassName = "oracle.sysman.emCfg.schema.descriptions.Descriptions";
    private Class descriptionsSchemaClass;
    private String instancesSchemaClassName = "oracle.sysman.emCfg.schema.instance.AggregateInstance";
    private Class instancesSchemaClass;
    private Resolver descriptionResolver = new Resolver();
    private final Stack unpairedAggregateDescriptions = new Stack();
    private Hashtable loadedAggregateDescriptions = new Hashtable();
    private Hashtable loadedAggregateDescriptionsVersions = new Hashtable();
    private Hashtable aggregateInstanceFamilies = new Hashtable();
    private Hashtable aggregateHolders = new Hashtable();
    private final ValidationEventHandler descriptionsValidationEventHandler = new ValidationEventHandler(){

        public boolean handleEvent(ValidationEvent event) {
            ValidationEventLocator locator = event.getLocator();
            Cfm.this.reportValidationEvent(event.getMessage(), locator.getLineNumber(), locator.getColumnNumber(), CfmUtil.severityToString(event));
            return true;
        }
    };
    private final ErrorHandler descriptionsValidationErrorHandler = new ErrorHandler(){

        @Override
        public void error(SAXParseException arg0) throws SAXException {
            this.report(arg0, "SAXParse:ERROR");
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
            this.report(arg0, "SAXParse:FATAL ERROR");
        }

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
            this.report(arg0, "SAXParse:WARNING");
        }

        private void report(SAXParseException e, String severity) {
            Cfm.this.reportValidationEvent(e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber(), severity);
        }
    };
    private final HashSet loadedDescriptionFiles = new HashSet();

    public Cfm(boolean debugB, LoadLocation baseLoadLocation) throws CfwException {
        String logDir = baseLoadLocation.getOracleHome() + File.separator + CfmLogger.LOG_DIR_RELATIVE_PATH;
        cfmLogger.addCfmFileHandler(logDir, null, null, CfmLogger.TIMESTAMPED_LOG_FILES);
        Cfm.debugB = debugB;
        this.baseLoadLocation = baseLoadLocation;
        this.descriptionsLoader = new DescriptionsLoader(this, new CfmTaggedObjectFactory());
        this.instancesLoader = new InstanceLoader(this);
        this.setDescriptionsSchemaClassName();
        this.setInstancesSchemaClassName();
        CfmUtil.setDebug(debugB);
    }

    @Override
    public IAggregateReference[] getAggregateReferences(String nameSpace) throws CfwException {
        if (nameSpace == null) {
            nameSpace = "common";
        }
        List aggregateHolders = this.getNamedHolders(nameSpace);
        Vector<AggregateReference> aggRefs = new Vector<AggregateReference>();
        for (CfmAggregateHolder holder : aggregateHolders) {
            AggregateReference ref = new AggregateReference(holder.getFamilyIdentifier(), true);
            aggRefs.add(ref);
        }
        return aggRefs.toArray(new IAggregateReference[0]);
    }

    @Override
    public IAggregateReference getAggregateReference(CfwIdentifier aggregateIdentifier) throws CfwException {
        CfmUtil.preconditionNotNull(aggregateIdentifier, "aggregateIdentifier");
        OHAbsolute oh = this.descriptionsLoader.getObjectFactory().getUniqueAggregateLocation(aggregateIdentifier);
        CfmAggregateDescription aggDesc = this.getLatestVersionOfAggregate(aggregateIdentifier, oh);
        if (aggDesc == null) {
            throw new CfwException("The requested aggregate (" + aggregateIdentifier + ") has not been loaded");
        }
        AggregateFamilyIdentifier family = new AggregateFamilyIdentifier(aggDesc.getIdentifier(), "CFM", oh);
        boolean isAvailable = this.isAggregateFamilyLoaded(family);
        return new AggregateReference(family, isAvailable);
    }

    @Override
    public IAggregate getAggregate(IAggregateReference reference) throws CfwException {
        CfmUtil.preconditionNotNull(reference, "reference");
        CfmAggregateHolder aggregate = this.getAggregateHolderLatestLabel(reference.getOwnerFamily());
        if (aggregate == null) {
            throw new CfwException("Referred aggregate " + reference.toString() + " is unavailable");
        }
        return aggregate;
    }

    @Override
    public String[] save() throws CfwException {
        cfmLogger.log(Level.INFO, "Cfm.save() was called");
        ArrayList<String> files = new ArrayList<String>();
        Stack holdersToSave = new Stack();
        Enumeration holders = this.getAggregateHolders();
        while (holders.hasMoreElements()) {
            holdersToSave.push(holders.nextElement());
        }
        while (!holdersToSave.isEmpty()) {
            CfmAggregateHolder holder = (CfmAggregateHolder)holdersToSave.pop();
            files.add(holder.save());
        }
        cfmLogger.log(Level.INFO, "Cfm.save(): " + files.size() + " aggregate instances saved");
        return files.toArray(new String[0]);
    }

    @Override
    public void registerStreams(PrintStream out, PrintStream err) throws CfwException {
        this.cfmout = out;
        this.cfmerr = err;
    }

    @Override
    public void registerLogDir(String logDir) throws CfwException {
        Enumeration<String> enumLogNames = LogManager.getLogManager().getLoggerNames();
        while (enumLogNames.hasMoreElements()) {
            String loggerName = enumLogNames.nextElement();
            Logger logger = Logger.getLogger(loggerName);
            if (logger.getName().equals("CfmDefaultLogger") || !(logger instanceof CfmLogger)) continue;
            CfmLogger cfmLogger = (CfmLogger)logger;
            cfmLogger.addCfmFileHandler(logDir, null, null, CfmLogger.TIMESTAMPED_LOG_FILES);
        }
    }

    public PrintStream getCfmout() {
        return this.cfmout;
    }

    public PrintStream getCfmerr() {
        return this.cfmerr;
    }

    public void loadDescriptionByAggregateID(String aggregateID) throws CfwException {
        if (aggregateID == null) {
            throw new CfwException("Invalid (null) aggregate ID");
        }
        Vector<String> aggregateIDs = new Vector<String>();
        aggregateIDs.add(aggregateID);
        this.loadDescriptionsByAggregateID(aggregateIDs);
    }

    public void loadDescriptionsByAggregateID(List aggregateIDs) throws CfwException {
        if (aggregateIDs == null || aggregateIDs.size() == 0) {
            throw new CfwException("Invalid (null) list of aggregate IDs");
        }
        Vector<AggregateDescriptionIdentifier> aggregateDescriptionIdentifiers = new Vector<AggregateDescriptionIdentifier>();
        Iterator iter = aggregateIDs.iterator();
        while (iter.hasNext()) {
            try {
                String currAggID = (String)iter.next();
                aggregateDescriptionIdentifiers.add(new AggregateDescriptionIdentifier(currAggID, AggregateVersion.LATEST, "common"));
            }
            catch (ClassCastException e) {
                throw new CfwException("Invalid list of aggregate IDs (contained an element other than a String)", e);
            }
        }
        this.loadDescriptionsByIdentity(aggregateDescriptionIdentifiers);
    }

    public void loadDescriptionsByIdentity(List aggregateDescriptionIdentifiers) throws CfwException {
        if (aggregateDescriptionIdentifiers == null || aggregateDescriptionIdentifiers.size() == 0) {
            throw new CfwException("Invalid (null) list of aggregate description identifiers");
        }
        ArrayList<LoadAggregateRequest> loadRequests = new ArrayList<LoadAggregateRequest>();
        for (AggregateDescriptionIdentifier aggIdent : aggregateDescriptionIdentifiers) {
            loadRequests.add(new LoadAggregateRequest(aggIdent, this.baseLoadLocation));
        }
        this.loadDescriptions(loadRequests);
    }

    public void loadDescription(LoadAggregateRequest loadAggregateRequest) throws CfwException {
        ArrayList<LoadAggregateRequest> loadRequests = new ArrayList<LoadAggregateRequest>(1);
        loadRequests.add(loadAggregateRequest);
        this.loadDescriptions(loadRequests);
    }

    public String[] getUnresolvedList() {
        List unresolvedObjs = this.descriptionResolver.getUnresolvedList();
        unresolvedObjs.addAll(this.descriptionResolver.getUnresolvedReferences());
        String[] result = new String[unresolvedObjs.size()];
        int index = 0;
        Iterator i = unresolvedObjs.iterator();
        while (i.hasNext()) {
            result[index] = i.next().toString();
            ++index;
        }
        return result;
    }

    private void setDescriptionsSchemaClassName() throws CfwException {
        try {
            this.setDescriptionsSchemaClassNamePrivate(this.descriptionsSchemaClassName);
        }
        catch (Exception e) {
            throw new CfwException(e);
        }
    }

    private void setInstancesSchemaClassName() throws CfwException {
        try {
            this.setInstancesSchemaClassNamePrivate(this.instancesSchemaClassName);
        }
        catch (Exception e) {
            throw new CfwException(e);
        }
    }

    public LoadLocation getBaseLoadLocation() {
        return this.baseLoadLocation;
    }

    void addAggregateDescription(CfmAggregateDescription aggregateDescription) {
        AggregateDescriptionIdentifierWithLocation ident = aggregateDescription.getIdentifier();
        cfmLogger.log(Level.INFO, "Aggregate Description " + ident + " successfully loaded");
        this.addDescriptionToVersionsHelper(aggregateDescription);
        CfmAggregateDescription previous = this.loadedAggregateDescriptions.put(ident, aggregateDescription);
        if (previous != null) {
            return;
        }
        this.unpairedAggregateDescriptions.add(aggregateDescription);
    }

    boolean removeAggregateDescription(CfmAggregateDescription aggregateDescription) {
        AggregateDescriptionIdentifierWithLocation ident = aggregateDescription.getIdentifier();
        cfmLogger.log(Level.FINEST, "Cfm:removeAggregateDescription: Removing AggregateDescription with tag=" + ident);
        boolean removed1 = this.removeDescriptionFromVersionsHelper(aggregateDescription);
        Object removed2 = this.loadedAggregateDescriptions.remove(ident);
        this.unpairedAggregateDescriptions.remove(aggregateDescription);
        CfmUtil.myAssert(removed1 == (removed2 != null));
        return removed1;
    }

    CfmAggregateDescription getAggregateDescription(AggregateDescriptionIdentifierWithLocation ident) {
        return (CfmAggregateDescription)this.loadedAggregateDescriptions.get(ident);
    }

    CfmAggregateDescription getAggregateDescription(AggregateDescriptionIdentifier ident, OHAbsolute oh) {
        return this.getAggregateDescription(new AggregateDescriptionIdentifierWithLocation(ident, oh));
    }

    private void addDescriptionToVersionsHelper(CfmAggregateDescription desc) {
        IdentifierIdNsLocation ident = new IdentifierIdNsLocation(desc.getIdentifier());
        CfmAggregateVersions versions = (CfmAggregateVersions)this.loadedAggregateDescriptionsVersions.get(ident);
        if (versions == null) {
            versions = new CfmAggregateVersions();
            this.loadedAggregateDescriptionsVersions.put(ident, versions);
        }
        versions.add(desc.getVersion());
    }

    private boolean removeDescriptionFromVersionsHelper(CfmAggregateDescription desc) {
        IdentifierIdNsLocation ident = new IdentifierIdNsLocation(desc.getIdentifier());
        CfmAggregateVersions versions = (CfmAggregateVersions)this.loadedAggregateDescriptionsVersions.get(ident);
        if (versions == null) {
            return false;
        }
        return versions.remove(desc.getVersion());
    }

    CfmAggregateDescription getLatestVersionOfAggregate(IdentifierIdNsLocation ident) {
        AggregateVersion version = this.getVersionOfLatestVersionOfAggregate(ident);
        if (version == null) {
            return null;
        }
        return this.getAggregateDescription(ident.asAggregateDescriptionIdentifierWithLocation(version));
    }

    CfmAggregateDescription getLatestVersionOfAggregate(CfwIdentifier aggregateIdentifier, OHAbsolute oh) {
        return this.getLatestVersionOfAggregate(new IdentifierIdNsLocation(aggregateIdentifier, oh));
    }

    AggregateVersion getVersionOfLatestVersionOfAggregate(IdentifierIdNsLocation ident) {
        CfmAggregateVersions versions = (CfmAggregateVersions)this.loadedAggregateDescriptionsVersions.get(ident);
        if (versions == null) {
            return null;
        }
        return versions.getLatest();
    }

    Enumeration getAggregateHolders() {
        return this.aggregateHolders.elements();
    }

    int aggregateHolderCount() {
        return this.aggregateHolders.size();
    }

    void unloadHolder(AggregateInstanceIdentifierWithLocation ident) {
        Object previous = this.aggregateHolders.remove(ident.getFamilyIdentWithLocation());
        CfmUtil.myAssert(previous != null);
    }

    void addAggregateHolder(CfmAggregateHolder aggregateHolder) {
        CfmAggregateHolder previous = this.aggregateHolders.put(aggregateHolder.getFamilyIdentifier(), aggregateHolder);
        CfmUtil.myAssert(previous == null);
    }

    public CfmAggregateHolder getAggregateHolderLatestLabel(AggregateFamilyIdentifier ident) {
        return (CfmAggregateHolder)this.aggregateHolders.get(ident);
    }

    public CfmAggregateHolder getAggregateHolderLatestLabelNoNull(AggregateFamilyIdentifier ident) throws CfwException {
        CfmAggregateHolder result = this.getAggregateHolderLatestLabel(ident);
        if (result == null) {
            throw new CfwException("The aggregate family " + ident + " has no loaded labels.");
        }
        return result;
    }

    public boolean isAggregateFamilyLoaded(AggregateFamilyIdentifier familyIdent) {
        return this.getAggregateInstanceFamily(familyIdent) != null;
    }

    public CfmAggregateInstanceFamily getAggregateInstanceFamily(AggregateFamilyIdentifier familyIdent) {
        CfmAggregateInstanceFamilies families = this.getAggregateInstanceFamilies(familyIdent.getAggregateDescriptionIdentifierWithLocation());
        if (families == null) {
            return null;
        }
        return families.get(familyIdent.getFamily());
    }

    public Enumeration getAggregateInstanceStorageTags() {
        return this.aggregateInstanceFamilies.keys();
    }

    public int aggregateInstanceStorageCount() {
        return this.aggregateInstanceFamilies.size();
    }

    public void addAggregateInstanceStorage(CfmAggregateInstanceFamilies aggregateInstanceStorage) {
        this.aggregateInstanceFamilies.put(aggregateInstanceStorage.getAggregateDescriptionIdentifier(), aggregateInstanceStorage);
    }

    public CfmAggregateInstanceFamilies getAggregateInstanceFamilies(AggregateDescriptionIdentifierWithLocation ident) {
        return (CfmAggregateInstanceFamilies)this.aggregateInstanceFamilies.get(ident);
    }

    public CfmAggregateInstanceFamilies getAggregateInstanceFamilies(AggregateDescriptionIdentifier ident, OHAbsolute oh) {
        return this.getAggregateInstanceFamilies(new AggregateDescriptionIdentifierWithLocation(ident, oh));
    }

    public CfmAggregateInstanceFamilies removeAggregateInstanceFamilies(AggregateDescriptionIdentifierWithLocation ident) {
        return (CfmAggregateInstanceFamilies)this.aggregateInstanceFamilies.remove(ident);
    }

    public CfmAggregateInstanceFamilies removeAggregateInstanceFamilies(AggregateDescriptionIdentifier ident, OHAbsolute oh) {
        return this.removeAggregateInstanceFamilies(new AggregateDescriptionIdentifierWithLocation(ident, oh));
    }

    public CfmAggregateInstanceFamilies getOrCreateAggregateInstanceFamilies(CfmAggregateDescription aggDesc) {
        CfmAggregateInstanceFamilies families = this.getAggregateInstanceFamilies(aggDesc.getIdentifier());
        if (families == null) {
            families = new CfmAggregateInstanceFamilies(this, aggDesc);
        }
        return families;
    }

    long getLatestInstanceLabel(AggregateDescriptionIdentifierWithLocation descIdent, String familyName) throws CfwException {
        CfmAggregateInstanceFamilies families = this.getAggregateInstanceFamilies(descIdent);
        if (families == null) {
            throw new CfwException("The requested aggregate description " + descIdent + " has no families");
        }
        CfmAggregateInstanceFamily family = families.get(familyName);
        if (family == null) {
            throw new CfwException("The requested aggregate family" + familyName + " has no instances");
        }
        return family.lastLabel();
    }

    long getLatestInstanceLabelNoException(AggregateDescriptionIdentifierWithLocation descIdent, String familyName) {
        try {
            return this.getLatestInstanceLabel(descIdent, familyName);
        }
        catch (CfwException e) {
            throw new Error("Framework is in an invalid state: " + e, e);
        }
    }

    CfmAggregateHolder getLatestInstance(AggregateDescriptionIdentifierWithLocation descIdent, String familyName) {
        return this.getAggregateHolderLatestLabel(new AggregateFamilyIdentifier(descIdent, familyName));
    }

    CfmAggregateHolder getLatestInstance(AggregateDescriptionIdentifier descIdent, String familyName, OHAbsolute oh) {
        return this.getAggregateHolderLatestLabel(new AggregateFamilyIdentifier(descIdent, familyName, oh));
    }

    public static boolean isDebug() {
        return debugB;
    }

    public static CfmLogger getLogger() {
        return cfmLogger;
    }

    LoadLocation getLoadLocation(String oh, String desc_base, String inst_base) {
        if (oh == null) {
            oh = this.getBaseLoadLocation().getOracleHome().toString();
        }
        if (desc_base == null) {
            desc_base = this.getBaseLoadLocation().getDescriptionsBase();
        }
        if (inst_base == null) {
            inst_base = this.getBaseLoadLocation().getInstanceBase();
        }
        return LoadLocation.getInstance(oh, desc_base, inst_base, cfmLogger);
    }

    List getAggregateHolders(String id, AggregateVersion version, String ns) {
        Vector<CfmAggregateHolder> holders = new Vector<CfmAggregateHolder>();
        Enumeration h = this.getAggregateHolders();
        while (h.hasMoreElements()) {
            CfmAggregateHolder holder = (CfmAggregateHolder)h.nextElement();
            if (!holder.getSelfID().equals(id) || !holder.getVersion().equals(version) || !holder.getNS().equals(ns)) continue;
            holders.add(holder);
        }
        if (holders.size() == 0) {
            return null;
        }
        Collections.sort(holders, CfmAggregateInstanceFamilies.getFamilyNameComparator());
        return holders;
    }

    Resolver getDescriptionResolver() {
        return this.descriptionResolver;
    }

    private List getNamedHolders(String thisNameSpace) {
        Vector<CfmAggregateHolder> result = new Vector<CfmAggregateHolder>();
        Enumeration holders = this.getAggregateHolders();
        while (holders.hasMoreElements()) {
            CfmAggregateHolder holder = (CfmAggregateHolder)holders.nextElement();
            if (!holder.getNS().equals(thisNameSpace)) continue;
            AggregateVersion latestVersion = this.getVersionOfLatestVersionOfAggregate(holder.getVersionlessIdentifier());
            if (latestVersion != null) {
                if (!latestVersion.equals(holder.getVersion())) continue;
                CfmUtil.myAssert(!result.contains(holder));
                result.add(holder);
                continue;
            }
            CfmUtil.myAssert(false);
        }
        return result;
    }

    private void setDescriptionsSchemaClassNamePrivate(String descriptionsSchemaClassNameX) throws Exception {
        this.descriptionsSchemaClass = Class.forName(descriptionsSchemaClassNameX);
        String schemaPackageName = this.descriptionsSchemaClass.getPackage().getName();
        if (debugB) {
            cfmLogger.log(Level.FINEST, "Cfm.setDescriptionsSchemaClassNamePrivate: creating context for " + schemaPackageName);
        }
        JAXBContext jc = JAXBContext.newInstance((String)schemaPackageName);
        this.descriptionsUnmarshaller = jc.createUnmarshaller();
        if (!CoreConstants.VALIDATE_DESCRIPTIONS && !CoreConstants.VALIDATE_DESCRIPTIONS_EXTERNAL) {
            cfmLogger.log(Level.INFO, "Validation of XML schema is disabled via constants/properties");
        } else if (ClassLoader.getSystemResource("oracle/sysman/emCfg/main/AggregateDescriptions.xsd") == null) {
            cfmLogger.log(Level.WARNING, "Validation of XML schema is disabled because AggregateDescriptions.xsd could not be found");
        } else {
            if (CoreConstants.VALIDATE_DESCRIPTIONS) {
                try {
                    this.descriptionsUnmarshaller.setValidating(true);
                    this.descriptionsUnmarshaller.setEventHandler(this.descriptionsValidationEventHandler);
                }
                catch (JAXBException e) {
                    cfmLogger.log(Level.WARNING, "Unable enable JAXB validation of XML schema; input validation will be disabled: " + (Object)((Object)e));
                }
            }
            if (CoreConstants.VALIDATE_DESCRIPTIONS_EXTERNAL) {
                try {
                    this.validator = new XSDValidator();
                    XSDBuilder builder = new XSDBuilder();
                    URL url = ClassLoader.getSystemResource("oracle/sysman/emCfg/main/AggregateDescriptions.xsd");
                    XMLSchema schemadoc = builder.build(url);
                    this.validator.setSchema(schemadoc);
                    XMLError xmlError = new XMLError();
                    xmlError.setErrorHandler(this.descriptionsValidationErrorHandler);
                    this.validator.setError(xmlError);
                }
                catch (Exception e) {
                    cfmLogger.log(Level.WARNING, "Unable enable SAX validation of XML schema; input validation will be disabled: " + e);
                }
            }
        }
        if (debugB) {
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.descriptionsLoader.setMarshaller(m);
        }
    }

    void reportValidationEvent(String message, int line, int col, String severity) {
        if (this.currentUnmarshallErrorString == null) {
            this.currentUnmarshallErrorString = new StringBuffer();
        }
        this.currentUnmarshallErrorString.append("Validation problem: ").append(this.currentlyUnmarshalling).append(CfmUtil.locationToString(line, col)).append(": [").append(severity).append("]: ").append(message).append("\n");
    }

    private void setInstancesSchemaClassNamePrivate(String instancesSchemaClassNameX) throws Exception {
        this.instancesSchemaClass = Class.forName(instancesSchemaClassNameX);
        String schemaPackageName = this.instancesSchemaClass.getPackage().getName();
        if (debugB) {
            cfmLogger.log(Level.FINEST, "Cfm.setInstancesSchemaClassNamePrivate: creating context for " + schemaPackageName);
        }
        JAXBContext jc = JAXBContext.newInstance((String)schemaPackageName);
        this.instancesUnmarshaller = jc.createUnmarshaller();
        if (debugB) {
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.instancesLoader.setMarshaller(m);
        }
    }

    private void loadDescriptions(List loadAggregateRequests) throws CfwException {
        String errors = this.loadDescriptions2(loadAggregateRequests);
        if (errors.length() != 0) {
            throw new CfwException("There were errors loading the aggregates:\n" + errors);
        }
        this.descriptionResolver.resolve();
        this.descriptionResolver.verifyAllRequiredResolved();
        this.descriptionsLoader.createAggregateDescriptions();
        String semanticErrors = this.semanticErrors.toString();
        if (!semanticErrors.equals("")) {
            throw new CfwException("Semantic check failed:" + semanticErrors);
        }
    }

    /*
     * Exception decompiling
     */
    private String loadDescriptions2(List loadAggregateRequests) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 14[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadAssociatedInstanceAndCreateHolder(CfmAggregateDescription aggregateDescription) throws CfwException {
        AggregateDescriptionIdentifierWithLocation ident = aggregateDescription.getIdentifier();
        LoadLocation loadLocation = aggregateDescription.getLoadLocation();
        LoadLocationInstances instancesLocation = loadLocation.getInstancesLoadLocation();
        instancesLocation.ensureUsable();
        Hashtable familiesToLabelListsMap = instancesLocation.getAggregateInstanceFamilies(ident);
        if (familiesToLabelListsMap == null) {
            String familyName = "CFM";
            if (debugB) {
                cfmLogger.log(Level.FINEST, "Initializing a fresh instance for " + aggregateDescription.toString());
            }
            CfmAggregateInstanceFamilies newFamiliesStorage = new CfmAggregateInstanceFamilies(this, aggregateDescription);
            CfmAggregateInstance instance = newFamiliesStorage.newAggregateInstance(aggregateDescription.getLoadLocation(), "CFM");
            CfmAggregateHolder holderToImportFrom = this.getPreviousVersionLatestInstance(loadLocation, aggregateDescription.getIdentifier(), "CFM");
            if (holderToImportFrom != null) {
                this.importAggregateInstance(instance, aggregateDescription, holderToImportFrom);
            } else {
                this.initializeAggregateInstance(instance, aggregateDescription);
            }
            CfmAggregateHolder newHolder = new CfmAggregateHolder(aggregateDescription, instance);
            this.addAggregateHolder(newHolder);
        } else {
            Enumeration f = familiesToLabelListsMap.keys();
            while (f.hasMoreElements()) {
                String familyName = (String)f.nextElement();
                List familyLabels = (List)familiesToLabelListsMap.get(familyName);
                long latestLabel = (Long)familyLabels.get(0);
                CfmAggregateInstanceFamilies families = this.getOrCreateAggregateInstanceFamilies(aggregateDescription);
                CfmAggregateInstanceFamily family = families.getOrCreate(familyName);
                try {
                    CfmAggregateInstance instance = this.loadInstance(loadLocation, family, latestLabel);
                    CfmAggregateHolder newHolder = new CfmAggregateHolder(aggregateDescription, instance);
                    this.addAggregateHolder(newHolder);
                }
                catch (Exception e) {
                    cfmLogger.log(Level.WARNING, "Cfm.loadAssociatedInstances: aggregate " + ident + ", family=" + familyName + ", label=" + latestLabel + " caused " + e);
                    throw new CfwException("Fatal error while loading instance XML: " + e, e);
                }
            }
        }
    }

    void loadAssociatedInstancesAndCreateHolders() throws CfwException {
        while (!this.unpairedAggregateDescriptions.isEmpty()) {
            CfmAggregateDescription aggregateDescription = (CfmAggregateDescription)this.unpairedAggregateDescriptions.pop();
            if (this.getAggregateInstanceFamilies(aggregateDescription.getIdentifier()) != null) continue;
            this.loadAssociatedInstanceAndCreateHolder(aggregateDescription);
        }
    }

    CfmAggregateHolder getPreviousVersionLatestInstance(LoadLocation location, AggregateDescriptionIdentifier aggDescIdent, String familyName) throws CfwException {
        AggregateDescriptionIdentifier previousAggIdent = location.getDescriptionsLoadLocation().getAggregateDescriptionsPrevious(aggDescIdent);
        if (previousAggIdent == null) {
            return null;
        }
        try {
            this.ensureLoaded(previousAggIdent, location);
            CfmAggregateHolder cfmPrevAggInst = this.getLatestInstance(previousAggIdent, familyName, location.getOracleHome());
            return cfmPrevAggInst;
        }
        catch (CfwException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CfmAggregateInstance loadInstance(LoadLocation descriptionFrom, CfmAggregateInstanceFamily family, long label) throws CfwException {
        Object unmarshaledXmlAsObj;
        AggregateInstanceIdentifier instanceID = new AggregateInstanceIdentifier(family.getAggID(), family.getNS(), family.getVersion(), family.getFamilyName(), label);
        File dirtyXmlFile = descriptionFrom.getInstancesLoadLocation().getAggregateInstanceFilePath(instanceID);
        if (dirtyXmlFile == null) {
            throw new CfwException("Cfm.loadInstance: Unable to resolve a file based on \"" + instanceID.toString() + "\"");
        }
        try {
            FileInputStream inputStream = new FileInputStream(dirtyXmlFile);
            try {
                unmarshaledXmlAsObj = this.instancesUnmarshaller.unmarshal((InputStream)inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            throw new CfwException("Unable to unmarshal instance xml=" + dirtyXmlFile + ": " + e, e);
        }
        if (unmarshaledXmlAsObj == null) {
            throw new CfwException("Cfm.loadInstance: Unable to unmarshall " + dirtyXmlFile + " for " + this.instancesSchemaClass.getName());
        }
        if (!this.instancesSchemaClass.isInstance(unmarshaledXmlAsObj)) {
            throw new CfwException(this.instancesSchemaClass.getName() + " could not be unmarshalled from " + dirtyXmlFile);
        }
        try {
            CfmAggregateInstance instance = this.instancesLoader.createAggregateInstance(descriptionFrom, family, dirtyXmlFile.getAbsolutePath(), unmarshaledXmlAsObj);
            if (debugB) {
                cfmLogger.log(Level.FINEST, "Cfm.loadInstance: Done.");
            }
            return instance;
        }
        catch (Throwable e) {
            throw new CfwException("Unable to load instance xml=" + dirtyXmlFile + ": " + e, e);
        }
    }

    private void initializeAggregateInstance(CfmAggregateInstance instance, CfmAggregateDescription description) throws CfwException {
        CfmTaggedObject cfmObject;
        boolean aggregateFound = false;
        Iterator iter = description.getMembers();
        while (iter.hasNext()) {
            cfmObject = (CfmTaggedObject)iter.next();
            if (!(cfmObject instanceof CfmAggregate)) continue;
            new CfmAggregateState(instance, (CfmAggregate)cfmObject);
            aggregateFound = true;
            break;
        }
        if (!aggregateFound) {
            throw new CfwException("Cfm.initializeAggregateInstance: There are no aggregates in the description " + description.getIdentifier());
        }
        iter = description.getMembers();
        while (iter.hasNext()) {
            cfmObject = (CfmTaggedObject)iter.next();
            if (cfmObject instanceof CfmParameter) {
                new CfmParameterState(instance, (CfmParameter)cfmObject);
                continue;
            }
            if (cfmObject instanceof CfmCondition) {
                new CfmConditionState(instance, (CfmCondition)cfmObject);
                continue;
            }
            if (cfmObject instanceof CfmAction) {
                new CfmActionState(instance, (CfmAction)cfmObject);
                continue;
            }
            if (!(cfmObject instanceof CfmPlugIn)) continue;
            new CfmPlugInState(instance, (CfmPlugIn)cfmObject);
        }
        iter = description.getAggregateReferences();
        while (iter.hasNext()) {
            CfmAggregateRef aggregateRef = (CfmAggregateRef)iter.next();
            new CfmAggregateRefState(this, instance, aggregateRef);
        }
    }

    private void importAggregateInstance(CfmAggregateInstance instance, CfmAggregateDescription description, CfmAggregateHolder previousHolder) throws CfwException {
        CfmTaggedObject cfmObject;
        boolean aggregateFound = false;
        Iterator iter = description.getMembers();
        while (iter.hasNext()) {
            cfmObject = (CfmTaggedObject)iter.next();
            if (!(cfmObject instanceof CfmAggregate)) continue;
            CfmAggregate aggregate = (CfmAggregate)cfmObject;
            new CfmAggregateState(instance, aggregate);
            aggregateFound = true;
            break;
        }
        if (!aggregateFound) {
            throw new CfwException("Cfm.initializeAggregateInstance: There are no aggregates in the description " + description.getIdentifier());
        }
        instance.setPreviousInstance(previousHolder.getVersion(), previousHolder.getLabel());
        iter = description.getMembers();
        while (iter.hasNext()) {
            cfmObject = (CfmTaggedObject)iter.next();
            if (cfmObject instanceof CfmParameter) {
                CfmParameter parameter = (CfmParameter)cfmObject;
                try {
                    CfmParameterPair prevParamPair = previousHolder.getParameterPair(parameter.getSelfID());
                    new CfmParameterState(instance, parameter, prevParamPair);
                }
                catch (CfwException e) {
                    new CfmParameterState(instance, parameter);
                }
                continue;
            }
            if (cfmObject instanceof CfmCondition) {
                new CfmConditionState(instance, (CfmCondition)cfmObject);
                continue;
            }
            if (cfmObject instanceof CfmAction) {
                new CfmActionState(instance, (CfmAction)cfmObject);
                continue;
            }
            if (!(cfmObject instanceof CfmPlugIn)) continue;
            new CfmPlugInState(instance, (CfmPlugIn)cfmObject);
        }
        iter = description.getAggregateReferences();
        while (iter.hasNext()) {
            CfmAggregateRef aggregateRef = (CfmAggregateRef)iter.next();
            new CfmAggregateRefState(this, instance, aggregateRef);
        }
    }

    public void ensureLoaded(AggregateDescriptionIdentifier ident, LoadLocation location) throws CfwException {
        CfmAggregateInstanceFamilies families = this.getAggregateInstanceFamilies(ident, location.getOracleHome());
        if (families != null) {
            return;
        }
        this.loadDescription(new LoadAggregateRequest(ident, location));
        CfmAggregateDescription aggregateDescription = this.getAggregateDescription(ident, location.getOracleHome());
        this.loadAssociatedInstanceAndCreateHolder(aggregateDescription);
    }

    @Override
    public void setActiveGlobal(CfwIdentifier referredAggregate, boolean isActive) throws CfwException {
        Enumeration holders = this.getAggregateHolders();
        while (holders.hasMoreElements()) {
            CfmAggregateHolder holder = (CfmAggregateHolder)holders.nextElement();
            CfmAggregateRefPair aggRefPair = holder.getAggregateRefPair(referredAggregate);
            if (aggRefPair == null) continue;
            aggRefPair.getCfmAggregateRefState().setActive(isActive);
        }
    }

    @Override
    public String[] purgeInstances(CfwIdentifier aggregateIdentifier, String oracleHome, String instancePath) throws CfwException {
        CfmUtil.preconditionNotNull(aggregateIdentifier, "aggregateIdentifier");
        OHAbsolute absOH = new OHAbsolute(CfmUtil.trimmedNoNullOrEmptyString(oracleHome, this.baseLoadLocation.getOracleHome().toString()), Cfm.getLogger());
        this.unloadAggregate(aggregateIdentifier, absOH);
        instancePath = CfmUtil.trimmedNoNullOrEmptyString(instancePath, this.baseLoadLocation.getInstanceBase());
        LoadLocationInstances location = LoadLocationInstances.getInstance(absOH, instancePath);
        List removedFiles = location.deleteAllInstances(aggregateIdentifier);
        String[] result = new String[removedFiles.size()];
        return removedFiles.toArray(result);
    }

    private void unloadAggregate(CfwIdentifier aggregateIdentifier, OHAbsolute oh) throws CfwException {
        CfmAggregateDescription aggDesc = this.getLatestVersionOfAggregate(aggregateIdentifier, oh);
        if (aggDesc == null) {
            return;
        }
        this.unloadAggregate(aggDesc);
    }

    private void unloadAggregate(CfmAggregateDescription aggDesc) throws CfwException {
        this.unloadAggregateHelper(aggDesc);
        LoadLocationDescriptions location = aggDesc.getLoadLocation().getDescriptionsLoadLocation();
        location.invalidateInventory();
    }

    private void unloadAggregateHelper(CfmAggregateDescription aggDesc) throws CfwException {
        LoadLocation location = aggDesc.getLoadLocation();
        AggregateDescriptionIdentifierWithLocation ident = aggDesc.getIdentifier();
        OHAbsolute thisOH = location.getOracleHome();
        try {
            CfmAggregateDescription prev;
            AggregateDescriptionIdentifier previousAggIdent = location.getDescriptionsLoadLocation().getAggregateDescriptionsPrevious(ident);
            if (previousAggIdent != null && (prev = this.getAggregateDescription(previousAggIdent, thisOH)) != null) {
                this.unloadAggregateHelper(prev);
            }
        }
        catch (CfwException e) {
            throw new CfwException("Unable to determine if previous versions exist", e);
        }
        boolean result = this.removeAggregateDescription(aggDesc);
        CfmUtil.myAssert(result);
        CfmAggregateInstanceFamilies families = this.removeAggregateInstanceFamilies(ident, thisOH);
        if (families != null) {
            List instanceIdents = families.getAggregateInstances();
            for (AggregateInstanceIdentifier currIdent : instanceIdents) {
                Object result2 = this.aggregateHolders.remove(currIdent.getFamilyIdent(thisOH));
                CfmUtil.myAssert(result2 != null);
            }
        }
    }

    @Override
    public void setSessionPropertyEnvVarsFile(String newFilename) throws CfwException {
        this.envVarFileRelOrAbs = newFilename == null ? "install/envVars.properties" : newFilename;
    }

    public String getSessionPropertyEnvVarsFile() {
        return this.envVarFileRelOrAbs;
    }

    @Override
    public ICfw getCfw() {
        return this;
    }

    @Override
    public IObject getObject(IReference ref) throws CfwException {
        return ((Reference)ref).getReferredObject(this);
    }

    @Override
    public IAction getAction(IActionReference ref) throws CfwException {
        return this.getAggregateHolderLatestLabelNoNull(ref.getOwnerFamily()).getActionPairById(ref.getSelfID());
    }

    @Override
    public ICondition getCondition(IConditionReference ref) throws CfwException {
        return this.getAggregateHolderLatestLabelNoNull(ref.getOwnerFamily()).getConditionPair(ref.getSelfID());
    }

    @Override
    public IParameter getParameter(IParameterReference ref) throws CfwException {
        return this.getAggregateHolderLatestLabelNoNull(ref.getOwnerFamily()).getParameterPair(ref.getSelfID());
    }

    @Override
    public IPlugIn getPlugIn(IPlugInReference ref) throws CfwException {
        return this.getAggregateHolderLatestLabelNoNull(ref.getOwnerFamily()).getPlugIn(ref);
    }

    @Override
    public IActionStepState getActionStepState(IActionStepStateReference ref) throws CfwException {
        return this.getAggregateHolderLatestLabelNoNull(ref.getOwnerFamily()).getActionStepPair(ref.getActionID(), ref.getStepIndex());
    }

    @Override
    public IPlugInInvocationState getPlugInInvocationState(IMicroStepStateReference ref) throws CfwException {
        return this.getAggregateHolderLatestLabelNoNull(ref.getOwnerFamily()).getMicroStepPair(ref.getActionID(), ref.getStepIndex(), ref.getMicroStepIndex()).getPlugInInvocationStateNoNull();
    }
}

