/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.ActionInvocationStateBase;
import oracle.sysman.emCfg.core.CfmAggregateActionRef;
import oracle.sysman.emCfg.core.CfmOwnedAggregateActionRef;
import oracle.sysman.emCfg.schema.instance.AggregateActionInvocationT;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.MicroStepFlavor;

class AggregateActionInvocationState
extends ActionInvocationStateBase {
    private static final String IS_REQUIRED = " is required in an ins:AggregateActionInvocation";
    private final AggregateVersion aggregateVersionRef;
    private final String aggregateFamilyNameRef;
    private final long aggregateInstanceLabelRef;

    public AggregateActionInvocationState(AggregateActionInvocationT jaxbOrigin) throws CfwException {
        super(jaxbOrigin, jaxbOrigin.getActionRef());
        String versionString = jaxbOrigin.getAggregateVersionRef();
        this.aggregateVersionRef = versionString == null ? null : AggregateVersion.versionFromString(versionString);
        this.aggregateFamilyNameRef = jaxbOrigin.getAggregateFamilyRef();
        this.aggregateInstanceLabelRef = jaxbOrigin.getAggregateLabelRef();
        this.semanticCheck();
    }

    public AggregateActionInvocationState(CfmAggregateActionRef ref, String familyName, long label) {
        super(null, ref.getIdref());
        this.aggregateVersionRef = ref.getVersionRef();
        this.aggregateFamilyNameRef = familyName;
        this.aggregateInstanceLabelRef = label;
        try {
            this.semanticCheck();
        }
        catch (CfwException e) {
            CfmUtil.myAssert(false);
        }
    }

    public AggregateActionInvocationState(CfmOwnedAggregateActionRef unresolvedRef, String familyName) {
        super(null, unresolvedRef.getIdRef());
        this.aggregateVersionRef = null;
        this.aggregateFamilyNameRef = familyName;
        this.aggregateInstanceLabelRef = -9999L;
        try {
            this.semanticCheck();
        }
        catch (CfwException e) {
            CfmUtil.myAssert(false);
        }
    }

    private void semanticCheck() throws CfwException {
        if (this.aggregateFamilyNameRef == null) {
            throw new CfwException("aggregateFamilyNameRef is required in an ins:AggregateActionInvocation");
        }
    }

    public AggregateVersion getAggregateVersionRef() {
        return this.aggregateVersionRef;
    }

    public String getAggregateFamilyNameRef() {
        return this.aggregateFamilyNameRef;
    }

    public long getAggregateInstanceLabelRef() {
        return this.aggregateInstanceLabelRef;
    }

    @Override
    public MicroStepFlavor getFlavor() {
        return MicroStepFlavor.AGGREGATE_ACTION_REF;
    }
}

