/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.ActionType;

abstract class ActionRequest {
    private final boolean blocking;
    private final boolean silently;
    private final boolean retry;
    private final ActionType actionType;

    protected ActionRequest(boolean blocking, boolean silently, boolean retry, ActionType actionType) {
        this.blocking = blocking;
        this.silently = silently;
        this.retry = retry;
        this.actionType = actionType;
    }

    protected ActionRequest(boolean blocking, boolean silently, boolean retry) {
        this(blocking, silently, retry, ActionType.UNKNOWN);
    }

    boolean isBlocking() {
        return this.blocking;
    }

    boolean isSilently() {
        return this.silently;
    }

    boolean isRetry() {
        return this.retry;
    }

    ActionType getActionType() {
        return this.actionType;
    }

    abstract boolean isSkipDetached();

    abstract boolean isSkipOptional();

    abstract void save(StringBuffer var1);

    protected void saveCommonAttributes(StringBuffer sb) {
        sb.append("blocking=\"" + this.isBlocking() + "\" ");
        sb.append("isSilently=\"" + this.isSilently() + "\" ");
        sb.append("retry=\"" + this.isRetry() + "\" ");
        sb.append("actionType=\"" + Formatter.escapeXMLSequences(this.getActionType().toString()) + "\" ");
    }
}

