/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.core.AggregateActionInvocationState;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmActionPair;
import oracle.sysman.emCfg.core.CfmActionStepPair;
import oracle.sysman.emCfg.core.CfmAggregate;
import oracle.sysman.emCfg.core.CfmAggregateActionRef;
import oracle.sysman.emCfg.core.CfmAggregateHolder;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.PerformMicroStep;
import oracle.sysman.emCfg.core.ProgressEvent;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.ActionStatus;
import oracle.sysman.emCfg.types.ActionStepStatus;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

class ActionPerformer
implements Runnable {
    static boolean debug = Cfm.isDebug();
    static CfmLogger cfmLogger = Cfm.getLogger();
    final CfmActionPair actionInstance;
    private final boolean recommended;
    private final boolean optional;
    final boolean detachedOnly;
    final boolean selectedB;
    final int actionStepIndex;
    final int microStepIndex;
    private boolean aborted = false;
    private Thread performThread = null;
    IMicroStepStateReference[] selectedMSRefs;
    final List performedActionPairs = Collections.synchronizedList(new ArrayList());
    private final List pmsList = new Vector();

    ActionPerformer(CfmActionPair originator, boolean recommended, boolean optional, boolean blockingB, boolean isSilently, boolean retry, boolean skipDetached, IMicroStepStateReference[] selectedMSRefs, ActionType type) {
        this.actionInstance = originator;
        this.recommended = recommended;
        this.optional = optional;
        this.detachedOnly = false;
        this.selectedB = false;
        this.actionStepIndex = -36;
        this.microStepIndex = -36;
        this.selectedMSRefs = selectedMSRefs;
        originator.addPerformer(this);
        this.debugAssert();
    }

    ActionPerformer(CfmActionPair originator, boolean recommended, boolean optional, boolean blockingB, boolean isSilently, boolean retry, boolean skipDetached, ActionType type) {
        this.actionInstance = originator;
        this.recommended = recommended;
        this.optional = optional;
        this.detachedOnly = false;
        this.selectedB = false;
        this.actionStepIndex = -36;
        this.microStepIndex = -36;
        this.selectedMSRefs = null;
        originator.addPerformer(this);
        this.debugAssert();
    }

    ActionPerformer(CfmActionPair originator, boolean blockingB, boolean isSilently, boolean retry, ActionType type) {
        this.actionInstance = originator;
        this.recommended = false;
        this.optional = false;
        this.detachedOnly = true;
        this.selectedB = false;
        this.actionStepIndex = -36;
        this.microStepIndex = -36;
        this.selectedMSRefs = null;
        originator.addPerformer(this);
        this.debugAssert();
    }

    ActionPerformer(CfmActionPair originator, boolean blockingB, int actionStepIndex, int microStepIndex, ActionType type) {
        this.actionInstance = originator;
        this.recommended = false;
        this.optional = false;
        this.detachedOnly = false;
        this.actionStepIndex = actionStepIndex;
        this.microStepIndex = microStepIndex;
        this.selectedB = true;
        this.selectedMSRefs = null;
        originator.addPerformer(this);
        this.debugAssert();
    }

    private void debugAssert() {
        CfmUtil.myAssert(!this.detachedOnly || !this.selectedB);
    }

    boolean isBlocking() {
        return this.actionInstance.getCfmActionState().getRequest().isBlocking();
    }

    boolean isSilently() {
        return this.actionInstance.getCfmActionState().getRequest().isSilently();
    }

    boolean isRetry() {
        return this.actionInstance.getCfmActionState().getRequest().isRetry();
    }

    boolean isSkipDetached() {
        return this.actionInstance.getCfmActionState().getRequest().isSkipDetached();
    }

    boolean isSkipOptional() {
        return this.actionInstance.getCfmActionState().getRequest().isSkipOptional();
    }

    ActionType getActionType() {
        return this.actionInstance.getCfmActionState().getRequest().getActionType();
    }

    boolean isAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startAction() throws CfwException {
        try {
            ActionPerformer actionPerformer = this;
            synchronized (actionPerformer) {
                this.performThread = new Thread(this);
                this.performThread.start();
                if (this.isBlocking()) {
                    String timestamp = CfmUtil.getTimestamp();
                    cfmLogger.log(Level.INFO, "Framework waiting for Action to complete at " + timestamp);
                    this.wait();
                    cfmLogger.log(Level.INFO, "done waiting for Action from " + timestamp);
                }
            }
        }
        catch (InterruptedException io) {
            throw new CfwException("ActionPerformer:startAction:Interrupted Exception=" + io.toString());
        }
        if (debug && this.isBlocking()) {
            cfmLogger.log(Level.INFO, "ActionPerformer.startAction: Wait is over, returning.");
        }
    }

    @Override
    public void run() {
        try {
            this.performAction(this.actionInstance);
        }
        catch (Throwable t) {
            cfmLogger.log(Level.WARNING, "ActionPerformer Thread terminating with exception: " + t.toString());
        }
    }

    private List getOrderedSteps(CfmActionPair actionInstance) throws CfwException {
        if (this.selectedB) {
            return actionInstance.getSelectedStep(this.actionStepIndex, this.microStepIndex);
        }
        if (this.detachedOnly) {
            return actionInstance.getDetachedActionSteps(this.isRetry());
        }
        if (this.recommended) {
            return actionInstance.getRecommendedActionSteps(this.isRetry(), this.isSkipDetached(), this.isSkipOptional());
        }
        if (this.optional) {
            return actionInstance.getOptionalActionSteps(this.isRetry(), this.isSkipDetached());
        }
        return actionInstance.getActionSteps(this.isRetry(), this.isSkipDetached(), this.selectedMSRefs);
    }

    void performAction(CfmActionPair actionInstance) throws CfwException {
        this.performAction(actionInstance, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performAction(CfmActionPair actionInstance, boolean isReferred) {
        if (actionInstance == null) {
            CfmUtil.myAssert(false);
            return;
        }
        int failedStepIndex = -1;
        actionInstance.getCfmActionState().setFailedStepStateIndex(failedStepIndex);
        CfmAggregate aggr = actionInstance.getCfmAction().getParentAggregate();
        try {
            List orderedSteps;
            try {
                orderedSteps = this.getOrderedSteps(actionInstance);
            }
            catch (CfwException e) {
                actionInstance.setStatusAndSummary(ActionStatus.UNRESOLVED_PLUGIN);
                CfmUtil.myAssert(false);
                if (debug) {
                    cfmLogger.log(Level.INFO, "ActionPerformer.performAction: Done with Status=" + actionInstance.getCfmActionState().getActionStatus());
                }
                if (!isReferred) {
                    aggr.reportEvent(ProgressEvent.ACTION_END, actionInstance, this.getActionType());
                    this.actionInstance.actionComplete(this);
                    if (this.isBlocking()) {
                        ActionPerformer actionPerformer = this;
                        synchronized (actionPerformer) {
                            this.notify();
                        }
                        if (debug) {
                            cfmLogger.log(Level.INFO, "ActionPerformer.performAction: Complete. Notificaiton is made");
                        }
                    }
                }
                return;
            }
            actionInstance.setStatusAndSummary(ActionStatus.IS_PERFORMING);
            if (!isReferred) {
                aggr.reportActionStartEvent(actionInstance, orderedSteps);
            }
            if (!actionInstance.isCondition()) {
                actionInstance.setStatusAndSummary(ActionStatus.PREVENT_CONDITION_FALSE);
                actionInstance.setAllStepStates(ActionStepStatus.NOT_PERFORMED, MicroStepStatus.NOT_PERFORMED);
                return;
            }
            boolean actuallyAborted = false;
            boolean actuallyFailed = false;
            Iterator orderedStepIterator = orderedSteps.iterator();
            while (orderedStepIterator.hasNext() && !actuallyFailed && !this.aborted) {
                ActionStepStatus finalStatus;
                CfmActionStepPair actionStepPair = (CfmActionStepPair)orderedStepIterator.next();
                if (debug) {
                    cfmLogger.log(Level.FINE, "About to perform " + actionStepPair.toString());
                }
                actionInstance.getCfmActionState().setFailedStepStateIndex(++failedStepIndex);
                if (!actionStepPair.isCondition()) {
                    actionStepPair.getCfmActionStepState().setStatus(ActionStepStatus.PREVENT_CONDITION_FALSE);
                    actionStepPair.setAllMicroStepStates(MicroStepStatus.NOT_PERFORMED);
                    finalStatus = ActionStepStatus.PREVENT_CONDITION_FALSE;
                    if (!debug) continue;
                    cfmLogger.log(Level.FINE, "ConditionRef evaluated to false, skipping " + actionStepPair.toString());
                    continue;
                }
                actionStepPair.getCfmActionStepState().setStatus(ActionStepStatus.IS_PERFORMING);
                if (!isReferred) {
                    aggr.reportEvent(ProgressEvent.ACTION_PROGRESS, actionStepPair, this.getActionType());
                }
                try {
                    this.performStep(actionStepPair);
                }
                catch (CfwException e) {
                    CfmUtil.myAssert(false);
                }
                finalStatus = actionStepPair.getCfmActionStepState().getStatus();
                if (finalStatus == ActionStepStatus.PERFORMED_SUCCESS) {
                    if (!debug) continue;
                    cfmLogger.log(Level.FINE, "Successfully performed " + actionStepPair.toString());
                    continue;
                }
                if (finalStatus == ActionStepStatus.WAS_ABORTED) {
                    actuallyAborted = true;
                    this.aborted = true;
                    if (!debug) continue;
                    cfmLogger.log(Level.FINE, "Aborted " + actionStepPair.toString());
                    continue;
                }
                if (actionStepPair.getCfmActionStep().isRequired()) {
                    actuallyFailed = true;
                }
                if (!debug) continue;
                cfmLogger.log(Level.FINE, "Failed: " + actionStepPair.toString());
            }
            if (actuallyAborted) {
                actionInstance.setStatusAndSummary(ActionStatus.WAS_ABORTED);
            } else if (actuallyFailed) {
                actionInstance.setStatusAndSummary(ActionStatus.PERFORMED_FAILED);
            } else if (!orderedStepIterator.hasNext()) {
                actionInstance.getCfmActionState().setFailedStepStateIndex(-1);
                actionInstance.setStatusAndSummary(ActionStatus.PERFORMED_SUCCESS);
            } else {
                actionInstance.setStatusAndSummary(ActionStatus.WAS_ABORTED);
            }
        }
        finally {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.performAction: Done with Status=" + actionInstance.getCfmActionState().getActionStatus());
            }
            if (!isReferred) {
                aggr.reportEvent(ProgressEvent.ACTION_END, actionInstance, this.getActionType());
                this.actionInstance.actionComplete(this);
                if (this.isBlocking()) {
                    ActionPerformer actionPerformer = this;
                    synchronized (actionPerformer) {
                        this.notify();
                    }
                    if (debug) {
                        cfmLogger.log(Level.INFO, "ActionPerformer.performAction: Complete. Notificaiton is made");
                    }
                }
            }
        }
    }

    void abort() {
        this.aborted = true;
        this.stopMicroSteps();
    }

    void performStep(CfmActionStepPair actionStepInstance) throws CfwException {
        if (actionStepInstance == null) {
            CfmUtil.myAssert(false);
            return;
        }
        Set microStepGroups = this.analyseStep(actionStepInstance);
        if (microStepGroups == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.performStep: no groups");
            }
            return;
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.performStep: " + microStepGroups.size() + " groups identified");
        }
        Performer[] performers = new Performer[microStepGroups.size()];
        int i = 0;
        for (Set microStepGroup : microStepGroups) {
            if (microStepGroup == null) {
                if (!debug) continue;
                cfmLogger.log(Level.INFO, "ActionPerformer.performStep: no group");
                continue;
            }
            performers[i] = new Performer(microStepGroup);
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.performStep: performer[" + i + "]is about to start " + performers[i]);
            }
            actionStepInstance.getCfmActionStepState().setFailedMicroStepIndex(-1);
            actionStepInstance.getCfmActionStepState().resetWeight();
            performers[i].start();
            ++i;
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.performStep: " + performers.length + " performers got started");
        }
        boolean anyAborted = false;
        boolean anyFailed = false;
        for (i = 0; i < performers.length; ++i) {
            try {
                Performer curr = performers[i];
                curr.join();
                if (curr.wasAborted()) {
                    anyAborted = true;
                    continue;
                }
                if (curr.getCompletionStatus()) continue;
                anyFailed = true;
                continue;
            }
            catch (InterruptedException ie) {
                cfmLogger.log(Level.WARNING, "ActionPerformer.performStep: InterruptedException while waiting for Thread to complete. " + actionStepInstance + " may have an inaccurate status.");
            }
        }
        if (anyAborted) {
            actionStepInstance.getCfmActionStepState().setStatus(ActionStepStatus.WAS_ABORTED);
        } else if (anyFailed) {
            actionStepInstance.setStatusFailed();
        } else if (actionStepInstance.getCfmActionStepState().getStatus() == ActionStepStatus.IS_PERFORMING) {
            actionStepInstance.getCfmActionStepState().setStatus(ActionStepStatus.PERFORMED_SUCCESS);
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.performStep: Done with Status=" + actionStepInstance.getCfmActionStepState().getStatus());
        }
    }

    Set analyseStep(CfmActionStepPair s) throws CfwException {
        boolean startOver;
        if (s == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: step is null");
            }
            return null;
        }
        List microSteps = s.getMicroSteps();
        this.filterMicrosteps(microSteps);
        if (microSteps == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: no micro steps");
            }
            return null;
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: building initial combined micro steps");
        }
        Vector<MicroStepCombination> combinedMicroSteps = new Vector<MicroStepCombination>();
        for (CfmMicroStepPair mS : microSteps) {
            if (mS == null) {
                if (!debug) continue;
                cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: no micro step");
                continue;
            }
            HashSet microStepAggregates = new HashSet();
            this.processMicroStep(microStepAggregates, mS);
            combinedMicroSteps.add(new MicroStepCombination(mS, microStepAggregates));
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: initial combined micro steps:\n" + combinedMicroSteps);
        }
        do {
            startOver = false;
            for (int i = 0; !startOver && i < combinedMicroSteps.size(); ++i) {
                MicroStepCombination microStepCombinationI = (MicroStepCombination)combinedMicroSteps.get(i);
                Set microStepsI = microStepCombinationI.getMicroSteps();
                Set microStepAggregatesI = microStepCombinationI.getMicroStepAggregates();
                for (int j = i + 1; !startOver && j < combinedMicroSteps.size(); ++j) {
                    MicroStepCombination microStepCombinationJ = (MicroStepCombination)combinedMicroSteps.get(j);
                    Set microStepsJ = microStepCombinationJ.getMicroSteps();
                    Set microStepAggregatesJ = microStepCombinationJ.getMicroStepAggregates();
                    if (!CfmUtil.intersect(microStepAggregatesI, microStepAggregatesJ)) continue;
                    Set joinedMicroSteps = CfmUtil.union(microStepsI, microStepsJ);
                    Set joinedAggregates = CfmUtil.union(microStepAggregatesI, microStepAggregatesJ);
                    combinedMicroSteps.remove(j);
                    combinedMicroSteps.remove(i);
                    combinedMicroSteps.add(new MicroStepCombination(joinedMicroSteps, joinedAggregates));
                    if (debug) {
                        cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: altered combined micro steps:\n" + combinedMicroSteps);
                    }
                    startOver = true;
                }
            }
        } while (startOver);
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: final combined micro steps:\n" + combinedMicroSteps);
        }
        HashSet<Set> isolatedMicroSteps = new HashSet<Set>();
        for (int k = 0; k < combinedMicroSteps.size(); ++k) {
            MicroStepCombination microStepCombinationK = (MicroStepCombination)combinedMicroSteps.get(k);
            isolatedMicroSteps.add(microStepCombinationK.getMicroSteps());
        }
        if (isolatedMicroSteps == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: no isolated micro steps groups");
            }
            return null;
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: isolated micro steps groups:");
        }
        for (Set group : isolatedMicroSteps) {
            if (group == null) {
                if (!debug) continue;
                cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: no group");
                continue;
            }
            if (group.size() == 0) {
                if (!debug) continue;
                cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: empty group");
                continue;
            }
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.analyseStep: group:");
            }
            for (CfmMicroStepPair mS : group) {
                if (!debug) continue;
                cfmLogger.log(Level.INFO, mS.toString());
            }
        }
        return isolatedMicroSteps;
    }

    void processMicroStep(Set aggregates, CfmMicroStepPair mS) throws CfwException {
        if (mS == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: micro step is null");
            }
            return;
        }
        if (aggregates == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: aggregates is a null set");
            }
            return;
        }
        MicroStepFlavor flavor = mS.getFlavor();
        if (flavor == MicroStepFlavor.EXTERNAL_JAVA_INVOCATION) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: ext. (java) micro step");
            }
        } else if (flavor == MicroStepFlavor.EXTERNAL_PROGRAM_INVOCATION) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: ext. (cmd) micro step");
            }
        } else if (flavor == MicroStepFlavor.INTERNAL_INVOCATION) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: int. micro step");
            }
            aggregates.add(mS.getAggregateHolder());
        } else if (mS.getFlavor() == MicroStepFlavor.ACTION_REF) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: action ref micro step");
            }
            this.processAction(aggregates, mS.getReferredAction(this.getActionType()));
        } else if (mS.getFlavor() == MicroStepFlavor.AGGREGATE_ACTION_REF) {
            CfmAggregateHolder refHolder = mS.getReferredAggregateHolderLatestInstance();
            if (refHolder == null) {
                if (debug) {
                    cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: Referred aggregate is inactive, skipping!");
                }
                return;
            }
            CfmActionPair referredAction = mS.getReferredAction(this.getActionType());
            if (referredAction == null) {
                if (debug) {
                    cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: There is no action for type=" + this.getActionType().toString() + " in aggregate=" + refHolder.toString());
                }
                return;
            }
            CfmAggregateHolder tmpholder = referredAction.getAggregateHolder();
            CfmUtil.myAssert(refHolder == tmpholder);
            this.processAction(aggregates, mS.getReferredAction(this.getActionType()));
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.processMicroStep: Done.");
        }
    }

    void processAction(Set aggregates, CfmActionPair a) throws CfwException {
        if (a == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processAction: action is null");
            }
            return;
        }
        List actionSteps = this.getOrderedSteps(a);
        if (actionSteps == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processAction: action has no steps");
            }
            return;
        }
        for (CfmActionStepPair s : actionSteps) {
            this.processStep(aggregates, s);
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.processAction: Done.");
        }
    }

    void processStep(Set aggregates, CfmActionStepPair s) throws CfwException {
        if (s == null) {
            if (debug) {
                cfmLogger.log(Level.INFO, "ActionPerformer.processStep: step is null");
            }
            return;
        }
        List microSteps = s.getMicroSteps();
        this.filterMicrosteps(microSteps);
        if (microSteps == null) {
            CfmUtil.myAssert(false);
            return;
        }
        for (CfmMicroStepPair ms : microSteps) {
            this.processMicroStep(aggregates, ms);
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "ActionPerformer.processStep: Done.");
        }
    }

    void filterMicrosteps(List microSteps) throws CfwException {
        if (this.selectedB) {
            Iterator mspi = microSteps.iterator();
            while (mspi.hasNext()) {
                CfmMicroStepPair microPair = (CfmMicroStepPair)mspi.next();
                if (microPair.getFlavor().isPlugInInvocation() && microPair.getIndex() == this.microStepIndex) continue;
                mspi.remove();
            }
        } else {
            Iterator msi = microSteps.iterator();
            while (msi.hasNext()) {
                CfmMicroStepPair microPair = (CfmMicroStepPair)msi.next();
                MicroStepFlavor flavor = microPair.getFlavor();
                if (!flavor.isPlugInInvocation()) continue;
                if (microPair.getCfmMicroStep().getPlugInInvocation().isAttached()) {
                    if (this.detachedOnly) {
                        msi.remove();
                        continue;
                    }
                } else if (this.isSkipDetached()) {
                    msi.remove();
                    continue;
                }
                if (!microPair.filterForRetry(this.isRetry())) continue;
                msi.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerMicroStepPerformer(PerformMicroStep ps) {
        List list = this.pmsList;
        synchronized (list) {
            if (this.aborted) {
                return false;
            }
            this.pmsList.add(ps);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterMicroStepPerformer(PerformMicroStep ps) {
        List list = this.pmsList;
        synchronized (list) {
            this.pmsList.remove(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMicroSteps() {
        List list = this.pmsList;
        synchronized (list) {
            Iterator i = this.pmsList.iterator();
            while (i.hasNext()) {
                try {
                    PerformMicroStep pms = (PerformMicroStep)i.next();
                    pms.abortDetached();
                }
                catch (Exception e) {
                    cfmLogger.log(Level.WARNING, "Failed to cancel " + this.toString() + ": " + e.toString());
                }
            }
        }
    }

    void performMicroStep(CfmMicroStepPair mS) {
        block16: {
            MicroStepFlavor flavor = mS.getFlavor();
            if (debug) {
                cfmLogger.log(Level.INFO, "Performer.performMicroStep: mS flavor=" + flavor);
            }
            if (flavor.isPlugInInvocation()) {
                try {
                    PerformMicroStep pms = mS.getMicroStepPerformer(this, this.isSilently(), this.getActionType());
                    if (pms == null) break block16;
                    if (this.registerMicroStepPerformer(pms)) {
                        pms.executeMicroStep();
                        this.unregisterMicroStepPerformer(pms);
                        break block16;
                    }
                    mS.getCfmMicroStepState().setStatus(MicroStepStatus.WAS_ABORTED);
                }
                catch (Throwable e) {
                    cfmLogger.log(Level.SEVERE, "An internal error occurred while attempting to perform " + mS.toString() + ": " + e.toString() + "\n" + CfmUtil.throwableToStackTrace(e));
                    mS.getCfmMicroStepState().setStatus(MicroStepStatus.UNSPECIFIED_ERROR, e.toString());
                }
            } else if (flavor == MicroStepFlavor.ACTION_REF) {
                CfmActionPair referredAction = mS.getReferredAction(this.getActionType());
                this.performActionRef(mS, referredAction);
            } else if (flavor == MicroStepFlavor.AGGREGATE_ACTION_REF) {
                if (!mS.isActionAggregateActive()) {
                    mS.getCfmMicroStepState().setStatus(MicroStepStatus.AGGREGATE_INACTIVE);
                } else if (!mS.isActionAggregateAvailable()) {
                    mS.getCfmMicroStepState().setStatus(MicroStepStatus.AGGREGATE_NOT_AVAILABLE);
                } else {
                    CfmAggregateActionRef ref = mS.getCfmMicroStep().getAggregateActionRef().getActualReference();
                    CfmUtil.myAssert(ref != null);
                    CfmUtil.myAssert(CfmUtil.nullOrEqual(ref.getIdref(), mS.getCfmMicroStep().getAggregateActionRef().getIdRef()));
                    CfmAggregateHolder referredHolder = mS.getReferredAggregateHolderLatestInstance();
                    long labelRef = referredHolder == null ? -9999L : referredHolder.getLabel() + 1L;
                    mS.getCfmMicroStepState().setActionInvocationState(new AggregateActionInvocationState(ref, referredHolder.getFamilyName(), labelRef));
                    CfmActionPair referredAction = mS.getReferredAction(this.getActionType());
                    if (referredAction == null) {
                        mS.getCfmMicroStepState().setStatus(MicroStepStatus.ACTION_NOT_FOUND);
                    } else {
                        this.performActionRef(mS, referredAction);
                    }
                }
            }
        }
        if (debug) {
            cfmLogger.log(Level.INFO, "Performer.performMicroStep: Done.");
        }
    }

    private void performActionRef(CfmMicroStepPair mS, CfmActionPair referredAction) {
        if (this.performedActionPairs.contains(referredAction)) {
            mS.getCfmMicroStepState().setStatus(MicroStepStatus.ACTION_ALREADY_REFERENCED);
        } else {
            this.performedActionPairs.add(referredAction);
            mS.getCfmMicroStepState().setStatus(MicroStepStatus.IS_PERFORMING);
            this.performAction(referredAction, true);
            ActionStatus completedActionStatus = referredAction.getCfmActionState().getActionStatus();
            mS.getCfmMicroStepState().setStatus(completedActionStatus.getStatusForReferringMicroStep());
        }
    }

    class Performer
    extends Thread {
        private Set microStepGroup;
        private boolean success = true;
        private boolean groupAborted = false;

        Performer(Set microStepGroup) {
            this.microStepGroup = microStepGroup;
        }

        boolean getCompletionStatus() {
            return this.success;
        }

        boolean wasAborted() {
            return this.groupAborted;
        }

        @Override
        public void run() {
            if (this.microStepGroup == null) {
                if (debug) {
                    cfmLogger.log(Level.INFO, "Performer.run: no micro step group");
                }
                return;
            }
            for (CfmMicroStepPair mS : this.microStepGroup) {
                if (debug) {
                    cfmLogger.log(Level.INFO, "Performer.run: about to do performMicroStep on " + mS);
                }
                ActionPerformer.this.performMicroStep(mS);
                MicroStepStatus mss = mS.getCfmMicroStepState().getStatus();
                if (mss == MicroStepStatus.WAS_ABORTED) {
                    this.groupAborted = true;
                }
                if (!mss.isFatalFailure()) continue;
                this.success = false;
                int currMicroStepIndex = mS.getIndex();
                mS.getStepPair().getCfmActionStepState().setFailedMicroStepIndex(currMicroStepIndex);
                if (!mS.getCfmMicroStep().getActionStep().isRequired()) continue;
                break;
            }
            if (debug) {
                cfmLogger.log(Level.INFO, "Performer.run: Done.");
            }
        }
    }

    class MicroStepCombination {
        final Set microSteps;
        final Set microStepAggregates;

        MicroStepCombination(Set microSteps, Set microStepAggregates) {
            this.microSteps = microSteps;
            this.microStepAggregates = microStepAggregates;
        }

        MicroStepCombination(CfmMicroStepPair microStep, Set microStepAggregates) {
            this.microSteps = new HashSet();
            this.microSteps.add(microStep);
            this.microStepAggregates = microStepAggregates;
        }

        Set getMicroSteps() {
            return this.microSteps;
        }

        Set getMicroStepAggregates() {
            return this.microStepAggregates;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.microSteps == null) {
                sb.append("<null> ");
            } else if (this.microSteps.size() == 0) {
                sb.append("<> ");
            } else {
                sb.append("<");
                for (CfmMicroStepPair microStep : this.microSteps) {
                    sb.append(" (" + microStep.getFlavor() + ")[" + microStep.getIndex() + "] ");
                }
                sb.append("> ");
            }
            if (this.microStepAggregates == null) {
                sb.append("<null>");
            } else if (this.microStepAggregates.size() == 0) {
                sb.append("<>");
            } else {
                sb.append("<");
                for (CfmAggregateHolder aggregate : this.microStepAggregates) {
                    sb.append(" (" + aggregate.getSelfID() + ") ");
                }
                sb.append(">");
            }
            return sb.toString();
        }
    }
}

